<?php

$lang = $_GET['lang'] ?? 'hu';
if ($lang === 'en') :
?>
<strong>Installing kitchen cabinets – How to install kitchen furniture?</strong>
<strong>Assembling kitchen furniture at home</strong>
Installing kitchen cabinets is not a particularly complicated task, <strong>but it requires a high degree of precision</strong> and the
use of the right <strong>tools </strong>. This is the only way to achieve <strong>aesthetic </strong>and
<strong>durable </strong>results. How do we do it, and what will we need? Here is some advice from the experts.

<strong>How to prepare for installing kitchen furniture?</strong>
Planning the installation is one of the most important steps, allowing the process to be quick and problem-free.
First:
• Measure the room and the furniture to be installed.
• Prepare a layout plan, taking into account the <strong>electrical </strong><strong>and plumbing
    outlets</strong> and the location of <strong>household appliances </strong>.
Obtain the following tools:
<ul>
    <li>measuring tape</li>
    <li>spirit level</li>
    <li>drill</li>
    <li>screwdriver</li>
    <li>brackets</li>
    <li>clamp</li>
    <li>wrench</li>
    <li>hammer</li>
    <li><strong>construction adhesive</strong></li>
</ul>
Before you begin, read the manufacturer's instructions and prepare the accessories recommended in them.

Tips for assembling kitchen furniture
Before starting work, plan the sequence of tasks, always starting with the lower cabinets. When aligning the elements,
 use a spirit level and check that the furniture is <strong>level </strong>with the floor
and walls.
The <strong>elements next to the worktop </strong>(e.g., cover strips, closing panels) are fixed with adhesive, so it is important to
choose the right adhesive. Bostik High Tack H785 hybrid adhesive is perfect for this, as it is a single-component,
<strong>ultra-strong </strong>and <strong>flexible, providing immediate adhesion </strong>without support. It is suitable for stone,
concrete, wood, and metal.
When assembling cabinets, <strong>Bostik H910 Supergrip Fast Cure instant adhesive</strong> is also useful, as it
dries extremely quickly, making it ideal for furniture assembly and decoration.

Installing lower and upper kitchen cabinets
First, assemble the standing (lower) cabinets according to the manufacturer's instructions. Secure the legs with adhesive (e.g., Bostik
assembly adhesive).
Then start placing the cabinets, starting from the corner, always ensuring <strong>precise
    leveling</strong>. <strong>Clamp</strong> the cabinets together and
use <strong>brackets</strong>. Mark the position of the brackets on the wall with a pencil.
To install the <strong>upper cabinets</strong>:
<ol>
    <li>Measure the desired distance from the top of the lower cabinet.
    <li>Mark the position of the bottom of the upper cabinet. </li>
    <li>Use a spirit level to draw the top line of the upper cabinets.
    <li>Mark the mounting points for the brackets according to the instructions, then install them.
    <li>The cabinets can then be hung immediately.
</ol>

<strong>Fastening elements around the worktop and countertop</strong>
The kitchen worktop<strong> must be cut to size so that it</strong> protrudes approx. <strong>3–5 cm </strong>beyond
the edges of the cabinets. Do not forget to cut out the openings for the sink and other appliances. Smooth the edges with sandpaper.

To glue the kitchen worktop elements together, use Bostik H785 High Tack adhesive, which provides immediate adhesion without the need for support.
 You can then secure the worktop to the cabinet with <strong>wood screws </strong>, ensuring
maximum stability.
For an aesthetic appearance, attach the cover strips and closing elements as well. These prevent dirt
from getting into hard-to-clean gaps. To do this, use <strong>H910 quick-drying adhesive </strong>– apply the product to the back of the strips
and then press them against the wall.
Important: all elements must be <strong>precisely cut to size </strong>– if necessary, cut them to size.

<strong>Simple and reliable installation with professional products</strong>
Mounting kitchen cabinets on the wall may seem complicated – but in reality it is not. The key to success is
<strong>precision </strong>and <strong>following the manufacturer's instructions. </strong>In addition, attaching the cabinet to the wall
can be made much easier with the right tools and <strong>Bostik adhesives.
With the help of Bostik products, various materials can be bonded <strong>quickly and efficiently </strong>. Look for them
in construction supply stores and wholesalers – this way you can be sure that your furniture will be <strong>stable and durable
</strong>.
<?php
else :
?>
<strong>Konyhaszekrények felszerelése – Hogyan szereljük fel a konyhabútort?</strong>
<strong>Konyhabútorok összeszerelése házilag</strong>
A konyhaszekrények felszerelése nem különösebben bonyolult feladat, <strong>de nagyfokú precizitást</strong> és a
megfelelő <strong>szerszámok </strong>használatát igényli. Csak így érhetünk el <strong>esztétikus </strong>és
<strong>tartós </strong>eredményt. Hogyan csináljuk, és mire lesz szükségünk? Íme a szakértők tanácsai.

<strong>Hogyan készüljünk fel a konyhabútor szerelésére?</strong>
A szerelés tervezése az egyik legfontosabb lépés, amely lehetővé teszi, hogy a folyamat gyors és problémamentes legyen.
Elsőként:
• Mérjük le a helyiséget és a beépítendő bútorokat.
• Készítsünk elrendezési tervet, figyelembe véve az <strong>elektromos </strong><strong>és vízvezeték
    kiállásokat</strong>, valamint a <strong>háztartási gépek </strong>helyét.
Szerezzük be az alábbi szerszámokat:
<ul>
    <li>mérőszalag</li>
    <li>vízmérték</li>
    <li>fúrógép</li>
    <li>csavarhúzó</li>
    <li>konzolok</li>
    <li>szorító</li>
    <li>dugókulcs</li>
    <li>kalapács</li>
    <li><strong>szerelőragasztó</strong></li>
</ul>
Mielőtt elkezdjük, olvassuk el a gyártó által mellékelt útmutatót, és készítsük elő a benne javasolt kiegészítőket.

Tanácsok a konyhabútor szereléséhez
A munka megkezdése előtt tervezzük meg a munkafolyamat sorrendjét, mindig az alsó szekrényekkel kezdve. Az elemek
igazításakor használjunk vízmértéket, és ellenőrizzük, hogy a bútorok <strong>vízszintesen </strong>állnak e a padlóhoz
és falakhoz képest.
A <strong>munkapult melletti elemek </strong>(pl. takarólécek, zárópanelek) ragasztással rögzülnek, ezért fontos a
megfelelő ragasztó kiválasztása. Erre tökéletes a Bostik High Tack H785 hibrid ragasztó, amely egykomponensű,
<strong>ultraerős </strong>és <strong>rugalmas, azonnali tapadást biztosít </strong>alátámasztás nélkül. Alkalmas kőhöz,
betonhoz, fához és fémhez is.
A szekrények szerelésénél jól jöhet még a <strong>Bostik H910 Supergrip Fast Cure gyorsragasztó</strong>, amely
<strong>extrém gyorsan szárad</strong> - ideális bútorszereléshez és dekorációhoz.

Alsó és felső konyhaszekrények felszerelése
Először az álló (alsó) szekrényeket szereljük össze a gyártói útmutató alapján. A lábakat ragasztóval (pl. Bostik
szerelési ragasztóval) rögzítsük.
Ezután kezdjük el a szekrények elhelyezését a sarokból kiindulva, mindig ügyelve a <strong>pontos
    vízszintezésre</strong>. Az egymás melletti szekrényeket <strong>szorítóval fogjuk össze</strong>, és
<strong>konzolokat</strong> is használjunk. A konzolok helyét ceruzával jelöljük meg a falon.
A <strong>felső szekrények</strong> felszereléséhez:
<ol>
    <li>Mérjük le az alsó szekrény tetejétől a kívánt távolságot.</li>
    <li>Jelöljük be a felső szekrény aljának helyét.</li>
    <li>Vízmértékkel húzzuk meg a felső szekrények felső vonalát.</li>
    <li>Az útmutató alapján jelöljük be a konzolok rögzítési pontját, majd szereljük fel őket.</li>
    <li>Ezután a szekrények azonnal felakaszthatók.</li>
</ol>

<strong>Munkapult és munkalap körüli elemek rögzítése</strong>
A konhyai munkapultot<strong> méretre kell vágni, úgy</strong>, hogy kb. <strong>3–5 cm-rel túllógjon </strong>a
szekrények élén. Ne feledkezz meg a mosogató és egyéb berendezések helyének kivágásairól. A széleket csiszolópapírral
simítsd el.
A konyhai munkapult elemeinek összeragasztásához használj Bostik H785 High Tack ragasztót, amely alátámasztás nélkül is
azonnali tapadást biztosít. Ezután <strong>facsavarokkal </strong>rögzítheted a munkalapot a szekrényhez, így garantálva
a maximális stabilitást.
Az esztétikus megjelenés érdekében rögzítsd a takaróléceket és záróelemeket is. Ezek megakadályozzák, hogy szennyeződés
jusson a nehezen tisztítható résekbe. Ehhez használj <strong>H910 gyorsragasztót </strong>– vidd fel a terméket a lécek
hátuljára, majd nyomd őket a falhoz.
Fontos: minden elem legyen <strong>precízen méretre szabva </strong>– ha kell, vágd őket pontosan méretre.

<strong>Egyszerű és megbízható szerelés profi termékekkel</strong>
A konyhaszekrények falra szerelése bonyolultnak tűnhet – a valóságban viszont nem az. A siker kulcsa a
<strong>precizitás </strong>és a <strong>gyártói utasítások betartása. </strong>Emellett a szekrény falra való rögzítése
jelentősen megkönnyíthető a megfelelő szerszámokkal és <strong>Bostik ragasztókkal.</strong>
A Bostik termékek segítségével különféle anyagok <strong>gyorsan és hatékonyan </strong>ragaszthatók. Keresd őket
építőipari szaküzletekben és nagykereskedésekben – így biztos lehetsz benne, hogy a bútorod <strong>stabil és tartós
</strong>lesz.<?php
endif;
?>

