<?php
$lang = $_GET['lang'] ?? 'hu';

if ($lang === 'en'):
	?>
	<p>The facade of our house reveals more about us than we might initially think, even if that sounds strange. Because our
		decisions truly define us. Since we rarely change the facade of our home, this decision is guaranteed to last a long
		time — it represents a kind of commitment in every person's life that expresses their personality. Besides our
		personality, it is also worth creating harmony with our environment.</p>
	<p>In this article, we aim to provide guidance on <strong>how to choose facade colors from Ceresit's Colours of Nature
			palette, which contains more than 500 shades.</strong></p>
	<figure> <img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-1.webp" alt=""> </figure>
	<p><strong>In harmony with our environment.</strong> This phrase is especially important to us, in every sense of the
		word. Being in harmony with our surroundings means creating our inner peace, then aligning this feeling with design
		elements we love, and finally adapting to the nature that surrounds us. We know this is a serious task, sometimes a
		very long journey before everything comes together inside us, but here at Ceresit, we trust that we can lend a
		helping hand. Imagine walking down a street, spotting a house you have never seen before, then noticing someone you
		barely know. In this imaginary walk, we bet the imagined person has a very specific house and style in mind — with
		facade colors that fit that person's personality. This example also clearly shows that our house’s facade tells more
		about us than we might initially think, even if it sounds odd.</p>
	<p>Many architectural trends put people and nature in focus. <strong>We selected the most diverse trends to inspire you
			with great designs that — regardless of their appearance — can positively affect you and your
			environment.</strong> Allow us to introduce them to you now!</p>
	<figure> <img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-2.webp" alt=""> </figure>
	<p>Before achieving these styles, definitely consult your architect first! We did so too, and here is the general advice
		they gave us regarding the four selected facade trends:</p>
	<p><strong>Natural Harmony</strong></p>
	<p>Let the context guide you. Take a look at the vegetation around the house. Is it dense or sparse? Coniferous or
		deciduous? Let the context, your environment, lead you. If there is one or two solitary trees, consider adding 2-3
		more. Also emphasize your connection with nature by using subtle bronze or green shades from the Ceresit Colours of
		Nature palette on the facade. Use wood textures to highlight the natural connection, or concrete, which creates a
		contrast and enhances the natural style elements. Both textures perfectly fit if the facade is partially covered
		with plants. If you want to learn more about this style, <a
			href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/termeszetes-harmonia'); ?>"
			target="_blank">click here</a>!</p>
	<figure> <img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-3.webp" alt=""> </figure>
	<p><strong>Hi-tech</strong></p>
	<p>Unite your house with technology. While you have no control over the colors of PV panels, solar roof tiles, heat
		pumps, and other equipment, you can choose a facade color that visually complements them. We selected a wide palette
		of light and dark grays as well as blue shades for you, which can be contrasted with white and beige colors,
		together creating a great context for technological solutions. With Ceresit VISAGE solutions, you can easily achieve
		this harmony or even break the tech-focused look with the Africa Ebony wood texture. If you want to learn more about
		this style, <a href="https://www.ceresit-coloursofnature.hu/hi-tech" target="_blank">click here</a>!</p>
	<figure> <img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-4.webp" alt=""> </figure>
	<p><strong>Naturally Minimalist</strong></p>
	<p>Minimalism often makes us think of cold white shades or deep black, but try <strong>breaking up the design with
			warmer brown, beige, or even beige-pink tones! With Ceresit VISAGE solutions, you can balance organic and
			minimalist elements in your facade design.</strong> Choose wood effect or brick texture with sandy colors to
		make your house more inviting, or stick to concrete for a more minimalist appearance. Small additions can make a big
		difference. Complete your facade design with mosaic plasters inspired by Himalaya or Granada! Remember, you don’t
		have to limit mosaics to the base only: they also look great applied as vertical stripes along the house corners. If
		you want to learn more about this style, <a
			href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/termeszetesen-minimalista'); ?>"
			target="_blank">click here</a>!</p>
	<figure> <img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-5.webp" alt=""> </figure>
	<p><strong>Modern Classic</strong></p>
	<p>Use the heritage of the past! If you’ve already put a lot of effort into reusing previous materials and elements,
		don’t let them get lost in your facade design — rather, <strong>create contrast</strong> to highlight them!</p>
	<p><strong>To highlight recycled bricks, use gray or subtle beige shades in their environment.</strong> You can also
		combine them with Ceresit Visage wood-effect textures. Use Ceresit Visage to combine different structures with each
		other, or to complement the structure on the house if some recycled materials are missing. An impressive facade
		comes from the coherence of every detail. That’s why even the base, the smallest element in the space, must fit with
		the rest of the design. If you want to learn more about this style, <a
			href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/modern-klasszikus'); ?>" target="_blank">click
			here</a>!</p>
	<figure> <img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-6.webp" alt=""> </figure>
	<p>For more inspiration, watch our <a href="<?php echo withUTM('https://www.youtube.com/watch?v=RmYQApartp4'); ?>"
			target="_blank">video</a>, download our <a
			href="<?php echo withUTM('https://dm.henkel-dam.com/is/content/henkel/Ceresit-homlokzati-szintrendek-brosura-HU-lq'); ?>"
			target="_blank">brochure</a>, or see which <a
			href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/szintrendek'); ?>" target="_blank">Ceresit
			products we recommend</a> for the houses shown in the stunning photos of each color trend!</p>
	<?php
else:
	?>
	<p>A házunk homlokzata többet árul el rólunk, mint azt először gondolnánk, még ha ez furcsán is hangzik. Mert a
		döntéseink valóban meghatároznak minket. Mivel otthonunk homlokzatát ritkán változtatjuk meg, így ezen döntés
		garantáltan hosszú időre szól – minden ember életében egyfajta elköteleződést jelent, ami kifejezi a személyiségét.
		Személyiségünk mellett a környezetünkkel is érdemes összhangot kialakítani.</p>

	<p>Cikkünkben igyekszünk támpontot adni ahhoz, hogy <strong>hogyan érdemes homlokzati színeket választani a Ceresit
			több, mint 500 féle árnyalatból álló Colours of Nature palettájáról.</strong></p>
	<figure>
		<img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-1.webp" alt="">
	</figure>

	<p><strong>Összhangban a környezetünkkel.</strong> Nekünk ez a mondat különösen fontos, a szó minden értelmében. Mert
		összhangban lenni a környezetünkkel egyet jelent azzal, hogy megteremtjük a belső békénket, majd összehangoljuk ezt
		az érzést a számunkra kedves dizájn elemekkel és végül mindeközben még alkalmazkodunk a minket körülölelő
		természethez is. Tisztában vagyunk azzal, hogy ez egy komoly feladat, sőt olykor egy rendkívül hosszú út, mire
		minden össze tud bennünk érni, de mi itt a Ceresitnél bízunk abban, hogy ehhez segítő kezet tudunk nyújtani. Hiszen
		képzelje csak el, hogy sétál az úton, megpillant egy házat, amelyet még sosem látott korábban, majd meglát valakit,
		akit alig ismer. Ebben a képzeletbeli sétában is le merjük fogadni, hogy az elképzelt személyhez egy nagyon konkrét
		házat és stílust képzelt el, jellegzetesen, ahhoz az emberhez, annak személyiségéhez passzoló homlokzatszínekkel. Ez
		a példa is jól mutatja azt, hogy házunk homlokzata többet árul el rólunk, mint azt először gondolnánk, még ha ez
		furcsán is hangzik. </p>
	<p>Számos építészeti trend helyezi fókuszba az embert és a természetet. <strong>A legváltozatosabbakat választottuk ki
			az irányzatok közül, hogy olyan nagyszerű dizájnokkal adjunk inspirációt, amelyek – megjelenésüktől függetlenül
			– jó hatással lehetnek Önre és környezetére.</strong> Engedje meg, hogy most bemutassuk Önnek ezeket! </p>

	<figure>
		<img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-2.webp" alt="">
	</figure>

	<p>Ezen stílusok eléréshez mindenképp konzultáljunk először építészünkkel! Mi is ezt tettük, és lássuk, mit tanácsolt
		nekünk általánosan a négy kiválasztott homlokzati trenddel kapcsolatban:</p>
	<p><strong>Természetes harmónia</strong></p>
	<p>Hagyjuk, hogy a kontextus mutasson irányt. Csak vessünk egy pillantást a házat körülvevő növényzetre. Sűrű vagy
		ritka? Tűlevelű vagy lombhullató? Hagyjuk, hogy a kontextus, a környezetünk vezessen. Ha van 1-1 különálló fa,
		érdemes még 2-3 fát hozzáadni. Emellett hangsúlyozzuk a természettel való kapcsolatot úgy, hogy a Ceresit Colors of
		Nature színeiből finom bronz vagy zöld árnyalatokat használunk a ház homlokzatán. Használjon famintázatokat a
		természettel való kapcsolat hangsúlyozására, vagy betont, ami kontrasztot adva emeli ki a természetes stílusú
		elemeket. Mindkét struktúrához tökéletesen illeszkedik, ha a homlokzatot részben betakarjuk növényekkel. Amennyiben
		többet szeretne tudni az adott stílusról <a
			href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/termeszetes-harmonia'); ?>"
			target="_blank">kattintson ide</a>!</p>

	<figure>
		<img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-3.webp" alt="">
	</figure>

	<p><strong>Hi-tech</strong></p>
	<p>Egyesítse házát a technológiával. A PV panelek, napelemes tetőcserepek, hőszivattyúk és egyéb berendezések színére
		nincs ráhatásunk, de választhatunk olyan homlokzati színt, amely vizuálisan kiegészíti őket. Világos és sötét
		szürke, valamint kék árnyalatok széles palettáját választottuk ki Önnek, ezekkel kontrasztba állítható fehér és bézs
		színekkel, amelyek így együtt nagyszerű kontextust teremtenek a technológiai megoldásokhoz. A Ceresit VISAGE
		megoldásokkal könnyedén elérheti ezt az összhangot, vagy akár eggyel tovább is léphet és megtörheti a techfókuszú
		megjelenést az Africa Ebony famintázattal. Amennyiben többet szeretne tudni az adott stílusról <a
			href="https://www.ceresit-coloursofnature.hu/hi-tech" target="_blank">kattintson ide</a>!</p>

	<figure>
		<img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-4.webp" alt="">
	</figure>

	<p><strong>Természetesen minimalista</strong></p>
	<p>A minimalizmusról gyakran a hideg fehér árnyalatokra vagy a mélyfeketére asszociálunk, de próbáljuk csak
		meg <strong>megbontani a dizájnt melegebb barnás, bézs vagy akár bézs-rózsaszín tónusokkal! A Ceresit
			VISAGE megoldásokkal egyensúlyba hozhatja a homlokzati dizájn organikus és minimalista elemeit.</strong>
		Válasszon fahatást vagy téglatextúrát homokszerű színnel, hogy hívogatóbbá tegye házát, vagy ragaszkodjon a betonhoz
		a minimalisztikusabb megjelenés érdekében. A kis kiegészítések jelentős hatást válthatnak ki. Fejezze be homlokzati
		dizájn kialakítását Himalaya vagy Granada ihlette mozaikvakolattal! Ne feledje, hogy nem kell kizárólag a lábazatban
		gondolkodnia: a mozaikok jól mutathatnak a ház sarkai mentén függőleges csíkokban felhordva. Amennyiben többet
		szeretne tudni az adott stílusról <a
			href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/termeszetesen-minimalista'); ?>"
			target="_blank">kattintson ide</a>!</p>
	</p>

	<figure>
		<img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-5.webp" alt="">
	</figure>

	<p><strong>Modern klasszikus</strong></p>
	<p>Használja fel a múlt örökségét! Ha már sok gondot fordított arra, hogy újra felhasználjon korábbi anyagokat,
		elemeket, ne hagyja, hogy elvesszenek a homlokzati dizájnban – inkább <strong>hozzon létre kontrasztot</strong>,
		hogy kiemelje őket!</p>
	<p><strong>Az újrahasznosított téglák kiemeléséhez használjon a környezetükben szürke vagy finom bézs
			árnyalatokat.</strong> Vagy kombinálhatja Ceresit Visage fahatású textúrákkal. Használhatja a Ceresit Visage-t a
		különböző szerkezetek egymással kombinálására, vagy a házon az adott struktúra kiegészítésére is, hogy kipótolja, ha
		hiányzik valamennyi az újrahasznosított anyagokból. A lenyűgöző homlokzat az összes részlet koherenciájából jön
		létre. Éppen ezért még egy olyan lábazatnak is, amely a térben a legkisebb elem, illeszkednie kell a dizájn többi
		részéhez. Amennyiben többet szeretne tudni az adott stílusról <a
			href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/modern-klasszikus'); ?>"
			target="_blank">kattintson ide</a>!</p>
	<figure>
		<img src="files/ceresit/homlokzati-szintrendek-a-ceresittol-6.webp" alt="">
	</figure>


	<p>További inspirációért nézze meg <a href="<?php echo withUTM('https://www.youtube.com/watch?v=RmYQApartp4'); ?>"
			target="_blank">videónkat</a>, töltse le <a
			href="<?php echo withUTM('https://dm.henkel-dam.com/is/content/henkel/Ceresit-homlokzati-szintrendek-brosura-HU-lq'); ?>"
			target="_blank">brosúránkat</a>, vagy tekintse meg, hogy az egyes színtrendek lenyűgöző fotóin látható házakhoz
		<a href="<?php echo withUTM('https://www.ceresit-coloursofnature.hu/szintrendek'); ?>" target="_blank">mely Ceresit
			termékeket ajánljuk</a>!</p>

	<?php
endif;
?>