<?php
$lang = $_GET['lang'] ?? 'hu';
if ($lang === 'en') :
?>
<p><strong>– Reliable surface leveling compound for floors and walls, suitable for outdoor use</strong></p>

<p>When installing coverings, it's often necessary not just to create an even, smooth horizontal surface, but also to form slopes or even level differences on vertical walls.</p>
<p><img style="float:right;margin-left:1rem;" src="files/ceresit/ceresit-megjelent-az-uj-ceresit-cn-39-1.webp" alt="">The newly launched <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/padloburkolas/aljzatkiegyenlites/aljzatkiegyenlito-egyeb/termekek.html/ceresit-cn-39/SAP_0201TCC013Y8.html'); ?>" target="_blank">Ceresit CN 39</a> is a special <strong>fast-setting</strong>, cement-based leveling compound <strong>with trass additive</strong> that performs this task quickly and efficiently. It can be used <strong>both indoors and outdoors</strong>, and works excellently not only on horizontal but also on <strong>vertical surfaces</strong>. This makes it suitable for preparing showers, bathrooms, terraces, balconies or even wall surfaces, especially when slopes need to be created or level differences compensated.</p>
<p>The biggest advantage of Ceresit CN 39 is that it's not self-leveling, so it's <strong>easy to shape</strong>, which is particularly useful for <a href="<?php echo withUTM('https://www.ceresit.hu/termektamogatas/alkalmazasi-utmutatok/utmutatok-burkolas/felulet-elokeszites-burkolas-elott.html'); ?>" target="_blank">creating slopes</a>, such as when forming water drainage. The leveling compound can be applied in layers from minimum 3 mm to maximum 30 mm thickness. It sets quickly, with the surface becoming <strong>walkable and ready for covering in about 2-4 hours</strong>.</p>
<p>Another major advantage is that it's <strong>frost-resistant</strong>, making it a durable solution for outdoor areas too.</p>
<p>Ceresit CN 39 complies with EN 13813 standard class CT-C5-F2, guaranteeing the required <strong>compressive and flexural strength</strong>. The product also doesn't shrink, ensuring particularly safe and <strong>crack-free results</strong>.</p>
<figure>
<img src="files/ceresit/ceresit-megjelent-az-uj-ceresit-cn-39-2.webp" alt="">
</figure>

<p>Before applying CN 39, proper surface preparation is essential for good adhesion and long durability - for strongly or weakly absorbent substrates we recommend <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/padloburkolas/alapozo/termekek.html/ceresit-padlopon-diszperzis/SAP_0201TNC015F0.html'); ?>" target="_blank">Ceresit Padlopon Dispersive primer</a> or <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/padloburkolas/alapozo/termekek.html/ceresit-padlopon-tunoprn/SAP_0201TNC015F1.html'); ?>" target="_blank">Ceresit Padlopon Tunoprene primer</a>, while for non-absorbent surfaces we suggest <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/hidegburkolas/hidegburkolati-alapozo/termekek.html/ceresit-ct-19/SAP_0201SOC014F8.html'); ?>" target="_blank">Ceresit CT 19</a> adhesion bridge. The leveling compound itself can be worked with hand tools, a smoothing trowel or screed rail. For larger areas, it's recommended to create working joints about every 1.5 meters. For thin layers, spray with water (without puddling) to prevent rapid drying! After the short setting time, surfaces with 10 mm thickness become walkable in about 2 hours. For 20 mm this takes 2-3 hours, while 30 mm layers require about 4 hours before work or covering can continue.</p>
<p>In summary: Ceresit CN 39 leveling compound offers an effective solution for those seeking <strong>fast, durable and shapeable leveling, whether on walls or floors</strong>. It's perfectly suitable for creating slopes, thicker substrates and special environments. The fast setting time enables efficient work, while the water- and frost-resistant properties guarantee long-term performance. CN 39 is a reliable choice in all situations where professional and precise execution is essential.</p>

<p>For more information, please visit the <a href="<?php echo withUTM('https://www.ceresit.hu/'); ?>" target="_blank">Ceresit website</a>!</p>
<?php
else :
?>
<p><strong>– Megbízható aljzatkiegyenlítő padlóra és falra, kültéren is</strong></p>

<p>A burkolatok kialakításánál gyakran előfordul, hogy nem csupán egyenletes, sima vízszintes felületre van szükség, hanem lejtésképzésre vagy akár oldalfalon szintkülönbség kiegyenlítésre is.</p>
<p><img style="float:right;margin-left:1rem;" src="files/ceresit/ceresit-megjelent-az-uj-ceresit-cn-39-1.webp" alt="">A hazai piacon most megjelenő <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/padloburkolas/aljzatkiegyenlites/aljzatkiegyenlito-egyeb/termekek.html/ceresit-cn-39/SAP_0201TCC013Y8.html'); ?>" target="_blank">Ceresit CN 39</a> olyan speciális, <strong>gyorskötésű</strong>, cementbázisú kiegyenlítőhabarcs <strong>trasszadalékkal</strong>, amely ezt a feladatot gyorsan és hatékonyan látja el. Alkalmazása <strong>bel- és kültéren egyaránt</strong> lehetséges, és nemcsak vízszintes, hanem <strong>függőleges felületeken is</strong> kiválóan használható. Ezáltal alkalmas például zuhanyzók, fürdőszobák, teraszok, erkélyek vagy akár falfelületek előkészítésére is, különösen, ha lejtést kell kialakítani vagy szintkülönbséget szükséges pótolni.</p>
<p>A Ceresit CN 39 legnagyobb előnye, hogy nem önterülő, így <strong>könnyedén formázható</strong>, ami különösen hasznos <a href="<?php echo withUTM('https://www.ceresit.hu/termektamogatas/alkalmazasi-utmutatok/utmutatok-burkolas/felulet-elokeszites-burkolas-elott.html'); ?>" target="_blank">lejtésképzés esetén</a>, például vízelvezetés kialakításakor. A kiegyenlítő minimum 3 mm, maximum 30 mm rétegvastagságig alkalmazható. A szilárdulási idő rövid, <strong>kb. 2-4 óra múlva járható, burkolható a felület</strong>.</p>
<p>A termék másik nagy előnye, hogy <strong>fagyálló</strong>, így tartós megoldást jelent külső terekben is. </p>
<p>A Ceresit CN 39 megfelel az EN 13813 szabvány CT-C5-F2 osztályának, amely garantálja az elvárt <strong>nyomó- és hajlítószilárdságot</strong>. A termék jellemzője még, hogy nem zsugorodik, így különösen biztonságos és <strong>repedésmentes végeredményt</strong> biztosít. </p>
<figure>
<img  src="files/ceresit/ceresit-megjelent-az-uj-ceresit-cn-39-2.webp" alt="">
</figure>

<p>A CN 39 alkalmazása előtt fontos a megfelelő alapfelület biztosítása, a jó tapadás és a hosszú élettartam érdekében az alapozás elengedhetetlen – ehhez erősen vagy gyengén szívó aljzatok esetén a <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/padloburkolas/alapozo/termekek.html/ceresit-padlopon-diszperzis/SAP_0201TNC015F0.html'); ?>" target="_blank">Ceresit Padlopon Diszperziós alapozót</a> vagy <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/padloburkolas/alapozo/termekek.html/ceresit-padlopon-tunoprn/SAP_0201TNC015F1.html'); ?>" target="_blank">Ceresit Padlopon Tunoprén alapozót</a>, míg nem nedvszívó felületeken a <a href="<?php echo withUTM('https://www.ceresit.hu/termekek/hidegburkolas/hidegburkolati-alapozo/termekek.html/ceresit-ct-19/SAP_0201SOC014F8.html'); ?>" target="_blank">Ceresit CT 19</a> tapadóhidat javasoljuk. Magát a kiegyenlítőhabarcsot kézi szerszámmal, simítólapáttal vagy lehúzóval lehet bedolgozni. Használata során nagyobb felületek esetén javasolt munkahézagokat kialakítani, körülbelül 1,5 méterenként. Vékony rétegvastagságoknál a habarcs gyors kiszáradásának elkerülésére vízzel permetezzük, tócsaképződés nélkül! A rövid kötési időt követően 10 mm-es rétegvastagság esetén a felület már körülbelül 2 óra múlva járható. 20 mm-nél ez 2-3 óra, míg 30 mm esetén körülbelül 4 óra múlva lehet a felületen dolgozni, ill. burkolni.</p>
<p>Összegezve: a Ceresit CN 39 kiegyenlítőhabarcs azok számára kínál hatékony megoldást, <strong>akik gyors, tartós és formázható kiegyenlítést keresnek, akár falon, akár padlón</strong>. Lejtésképzéshez, vastagabb aljzatokhoz és speciális környezetekhez is tökéletesen alkalmazható. A gyors kötési idő lehetővé teszi a hatékony munkavégzést, a víz- és fagyálló tulajdonság pedig garantálja a hosszú távú működést. A CN 39 megbízható választás minden olyan helyzetben, ahol a szakszerű és precíz kivitelezés alapfeltétel.</p>

<p>További információkért, kérjük, keresse fel a <a href="<?php echo withUTM('https://www.ceresit.hu/'); ?>" target="_blank">Ceresit weboldalát</a>!</p>
<?php
endif;
?>