
<?php
$lang = $_GET['lang'] ?? 'hu';

if ($lang === 'en') :
?>
<h3 style="margin-top:-1rem">&ndash; Professional Terrace Renovation</h3>

<p><strong>Utilized rooftops, along with terraces and balconies, often present interesting outcomes, as most residents’ interest lasts only as long as their chosen surface looks as they imagined. Unfortunately, this mindset persists even if such “miracle” solutions ruin the lives of others. First and foremost, it must be emphasized that glazed ceramic tiles and the grout materials used are not watertight solutions and have never been considered waterproofing layers.</strong></p>

<p><strong>Common Mistakes</strong></p>
<p>A frequent error is that residents overlay a new covering on an old, water-damaged surface. As mentioned earlier, this does not solve the problem but merely wastes money, and during proper renovation these layers are among the first to be removed. Therefore, waterproofing must be installed beneath the surface! For balcony slabs (i.e., where there is no living space underneath), liquid-applied waterproofing membranes are allowed, and a skilled tiler can assist with this. However, bear in mind that partial application of liquid waterproofing is not a solution either. The system must be continuous, covering the entire surface, and all structural connections must be properly executed! This includes waterproofing window and door frames, drip edges, and railing base collars, which are essential tasks. In the case of terraces (with living space below), current national guidelines require full, membrane-type waterproofing, which may be bitumen-based with a correct layer build-up; however, due to better connection possibilities and flexibility, PVC membranes such as Fatrafol 810/V provide a reliable long-term solution.</p>

<div class="hstack">
  <figure>
    <img src="files/fatraizolfa/fatrafol-darazsfeszek-a-csempe-alatt-1.webp" alt="">
    <figcaption>Mechanical systems installed on pedestals over PVC waterproofing</figcaption>
  </figure>
  <figure>
    <img src="files/fatraizolfa/fatrafol-darazsfeszek-a-csempe-alatt-2.webp" alt="">
    <figcaption>Improper cable penetration through bitumen waterproofing</figcaption>
  </figure>
</div>

<p><strong>The Maze of Options</strong></p>
<p>There are many alternative ways to construct a terrace, often leading to misunderstandings rather than improvements. Therefore, it is advisable to consult a professional to design the appropriate layer build-up, depending on what you want to see beneath your feet in the end. Remember that a terrace is essentially a utilized flat roof, requiring a sufficiently robust vapor control layer, correctly dimensioned thermal insulation, slope formation, and professionally installed rainwater waterproofing. Drainage design is also critical: with internal drainage systems, a tray waterproofing layer is created, extending the waterproofing up every wall section 30 cm above the walking surface. For external drainage, appropriate drip edges and a well-dimensioned gutter system are required. Regardless of the system chosen, ensure that rainwater is directed off every surface and every layer! For tiled surfaces, this applies to the tile top surface, the liquid membrane level, and the sheet membrane level, which requires special drip edges and careful attention at the eaves line.</p>

<p>Based on current experience, the most reliable solution is a tray waterproofing system combined with open-joint tile coverings, which even under southern exposure—with extreme winter and summer heat loads—offer a flexible, easy-to-maintain layer build-up and an elegant finish.</p>

<figure>
  <img src="files/fatraizolfa/fatrafol-darazsfeszek-a-csempe-alatt-3.webp" alt="">
  <figcaption>Open-joint tile installation on crushed gravel bed with supplementary spacers over Fatrafol waterproofing</figcaption>
</figure>

<p><strong>In Detail</strong></p>
<p>In such cases, the Fatrafol 810/V PVC waterproofing is terminated 30 cm above the walking surface on a metal drip flashing, with all joints sealed using PU-based sealants. For plastic window and door frames, we create stable, hot-air welded seams on the frame extensions to ensure joint stability. For aluminum or wooden frames, metal flashing is applied, ensuring at least a 5 cm water stop threshold. At railing bases, pre-manufactured, custom-sized waterproof collars are used, allowing for later installation of coping stones or two-piece wall caps. On top of the Fatrafol 810/V membrane, WPC decking sleepers or tile spacer pads can be installed directly. For continuous, active use, it is advisable to install a surface drainage layer and lay tiles on a gravel bed. This also ensures that curved tile edges or inward-bent tiles receive full support, preventing damage or breakage. An important advantage of open-joint systems is that rainwater immediately reaches the waterproofing membrane level, meaning drainage and water removal must be handled only at this layer! Drain channels within the tile plane are only justified directly in front of windows and doors.</p>

<p>– Zsolt Jámbor / <a href="https://www.fatrafol.hu/" target="_blank" rel="noopener noreferrer">fatrafol.hu</a></p>

<?php
else :
?>
<h3 style="margin-top:-1rem">&ndash; Teraszfelújítás szakszerűen</h3>

<p><strong>A hasznosított tetők és velük együtt a teraszok, erkélyek kivitelezése igen érdekes eredményeket vetít a szemünk elé, hiszen a lakók többségének érdeklődése addig tart, amíg az általuk választott burkolat olyan, amilyennek maguk megálmodták. Sajnos ez a szemlélet akkor is él, ha csoda megoldás minden más lakó életét tönkre teszi. Mindenek előtt le kell szögezzük, a mázas kerámia lapok, az alkalmazott fugázó anyagok nem számítanak vízzáró megoldásnak és soha nem is tekintettük ezeket vízhatlan szigetelésnek. </strong></p>

<p><strong>Gyakori hibák</strong></p>
<p>Gyakran látott tévedés, hogy a lakók a régi átázott burkolatra újra ráburkolnak, vagy ráburkoltatnak. Ahogy erre fentebb is kitértem, a hiba attól nem oldódik meg, hogy ismételten elkövetjük, csak a pénzt szórjuk ki az ablakon és amint sor kerül a szakszerű felújításra ezeket a rétegeket elsők között bontják el. Tehát a burkolat alá szigetelés kell! Erkély lemezek esetén (tehát ha nincs lakótér alatta), megengedett a kenhető szigetelések alkalmazása, ebben pedig egy felkészült burkoló is a segítségünkre lehet. Figyeljünk oda ugyanakkor, hogy a kenhető szigetelések lokális alkalmazása szintén nem megoldás. Rendszerben, teljes felületben kell gondolkodnunk és a szerkezeti csatlakozásokat is ki kell alakítanunk! Tehát a nyílászárók, cseppentő lemezek, korlátláb szigetelő gallérok elhelyezése megkerülhetetlen feladat. A teraszok esetében (ha lakótér van a födém alatt) már a hazai irányelvek is leples, teljes értékű szigetelést írnak elő, amely megfelelő rétegrendi kialakításban lehet bitumenes lemez is, ugyanakkor a csatlakoztathatóság és a rugalmasság miatt a PVC szigetelések, mint a Fatrafol 810/V hosszabbtávon jelentenek megbízható megoldást.</p>
<div class="hstack">
<figure>
	<img src="files/fatraizolfa/fatrafol-darazsfeszek-a-csempe-alatt-1.webp" alt="">
	<figcaption>Lábakra állított gépészet PVC szigetelés felett</figcaption>
</figure>
<figure>
	<img src="files/fatraizolfa/fatrafol-darazsfeszek-a-csempe-alatt-2.webp" alt="">
	<figcaption>Szakszerűtlen kábelátvezetés Bitumenes szigetelésen</figcaption>
</figure>
</div>


<p><strong>Lehetőségek útvesztője</strong></p>
<p>A terasz kialakításának rengeteg alternatív módja adódik, amely jellemzően inkább félreértésekhez vezet, mintsem, előre mozdítaná a helyzetünket. Éppen ezért javasolt szakember segítségét kikérni a megfelelő rétegrend összeállításában, annak függvényében, hogy mit is szeretnénk látni végül a lábunk alatt. Ne felejtsük el, hogy a terasz lényegében egy hasznosított lapos tető, tehát megfelelően masszív páratechnikai rétegre, méretezett hőszigetelésre, lejtésképzésre és szakszerűen kialakított csapadékvíz szigetelésre is szükségünk van. Szintén kiemelt szempont a vízelvezetés megválasztása, belső rendszer esetén teknőszigetelést hozunk létre, minden falszakaszon a járósík felett 30 cm magasságig felvezetve a szigetelést, míg külső vízelvezetés esetén megfelelő cseppentő lemezekre lesz szükségünk és egy jól méretezett függő ereszcsatornára. Függetlenül attól, hogy melyikre tesszük le a voksunkat, gondoskodjunk róla, hogy minden síkról, minden rétegről levezessük a csapadékot! Hidegburkolat esetén ez a burkolat felső síkját, a kenhető szigetelés síkját és a leples szigetelés síkját is érinti, amely már speciális cseppentőket és komoly odafigyelést kíván az eresz vonalán!</p>

<p>Az aktuális tapasztalatok alapján a legmegbízhatóbb megoldás a teknőszigetelés és a nyitott fugás burkolati rendszerek alkalmazása, amely akár a déli tájolás esetén is – tehát kiemelkedő téli-nyári hőterhelés mellett is – rugalmas és könnyen karbantartható rétegrendet, elegáns burkolati megoldást tesz lehetővé. </p>


<figure>
	<img src="files/fatraizolfa/fatrafol-darazsfeszek-a-csempe-alatt-3.webp" alt="">
	<figcaption>Nyitott fugás burkolat készítése zúzott kavics ágyon, kiegészítő távtartókkal Fatrafol szigetelésen</figcaption>
</figure>
<p><strong>Részleteiben</strong></p>
<p>Ilyenkor a Fatrafol 810/V PVC szigetelésünket a járósík felett 30 cm-el fóliabádog viharlécen zárjuk, a csomópontokat PU bázisú tömítőkittel tömítjük. Műanyag nyílászárók esetén a toktoldókon stabil, forrólevegővel hegesztett varratokat hozunk létre ezzel is biztosítva a csomópont stabilitását. Alumínium illetve fa nyílászárók esetén fóliabádogot alkalmazunk, legalább 5 cm vízküszöb biztosítása mellett. A korlátlábak esetén előre gyártott, méretpontos szigetelő gallérokat alkalmazunk, lehetővé téve, hogy a későbbiekben akár fedőkő, vagy kétvízorros fallefedés készülhessen. A Fatrafol 810/V lemez tetejére ezt követően közvetlenül is elhelyezhetjük a WPC rendszerek párnafáit, vagy a burkoló lapok távtartó tappancsait. Abban az esetben, ha folyamatos, aktív használatra készülünk, érdemes egy felületszivárgó beiktatásával kavics zúzalék ágyba fektetni a burkoló lapokat. Ez arra is lehetőséget biztosít, hogy az íves lapszélek, esetleg beforduló lapok teljes felületi alátámasztást kapjanak elkerülve ezzel a lapok sérülését, törését. Fontos előny, hogy a nyitott fugás rendszerek esetében a csapadék azonnal a vízszigetelés síkjára kerül, tehát egyedül innen kell a kicsöppentést, vízelvezetést megoldanunk! Folyókák beépítése a burkolat síkjában csak a nyílászárók előtt lehet indokolt.</p>
<p>– Jámbor Zsolt / <a href="<?php echo withUTM('https://www.fatrafol.hu/'); ?>" target="_blank">fatrafol.hu</a></p>

<?php
endif;
?>
