
<?php
$lang = $_GET['lang'] ?? 'hu';

if ($lang === 'en') :
?>
<h3 style="margin-top:-1rem">&ndash; Drainage Issues</h3>

<p><strong>One of the most critical junctions of rainwater insulation is around the downpipe and, in the case of external drainage, the eaves line, where large amounts of rainwater accumulate and—hopefully—drain away. Failures here can cause facade or riser leaks, which can make residents’ lives miserable even several floors below, for example, by causing the entire bathroom ceiling to collapse on them… That’s why it’s crucial to thoroughly inspect these junctions and warn owners and property management that if they want to save money, it should not be at the expense of the drains.</strong></p>

<p><strong>National Overview – "Make it work somehow"</strong></p>
<p>Whether in Sopron or Békéscsaba, the treatment of drains during renovations has resulted in some very “colorful” solutions. Custom-made sheet metal parts, bituminous sheets stuffed into coils, modified bathroom drains—these are just a few examples of the horrors uncovered during demolition, which have made owners’ lives miserable for decades. Therefore, it’s important to highlight that whenever rainwater insulation is renovated, it’s worth opening the inlet funnels and, if necessary, installing new drains directly connected to the downpipe on the roof, thus avoiding further reduction in cross-section and uncertain sealing. If demolition is not an option, after cleaning the funnels, use drains that integrate well with existing solutions and provide proper sealing even in cases of blockages or cloudbursts, so that backflow water drains onto the roof surface and eventually seeps away, rather than into the structure.</p>

<figure>
  <img src="files/fatraizolfa/fatrafol-kritikus-csomopont-nagyito-alatt-1.webp" alt="">
  <figcaption>Corroded drains uncovered during bituminous insulation renovation</figcaption>
</figure>

<p><strong>Professional Guidelines</strong></p>
<p>Regarding drains involved in rainwater drainage—whether for roof or terrace insulation—clear and accessible professional guidelines exist, maintained by ÉMSZ, covering the proper cross-sections, installation, and fixing of drains, as well as their connection and construction. On the manufacturer side, it’s worth noting that important developments have taken place over recent decades, and roof drains have become a well-regulated and traceable product group, specifically available to insulation professionals. Under Fatra Izolfa Zrt.’s care, this product line is called TOPWET, featuring UV-stable PA6 polyamide drains with integrated sealing collars, side outlets, and technical penetrations, risers, and vent pipes. The portfolio includes roof, terrace, and balcony drains, some factory-equipped with heating cables and sealing rings for socket connection to appropriate downpipes, ready to perform immediately. There is also a renovation drain with a lamellar, conical seal that ensures good sealing even on poorly maintained inlets. The system also includes a control element that artificially retains rainwater, preventing overloading of drainage pipes. Detailed Hungarian-language information is available at <a href="https://www.topwet.hu/" target="_blank" rel="noopener noreferrer">www.topwet.hu</a>.</p>

<figure>
  <img src="files/fatraizolfa/fatrafol-kritikus-csomopont-nagyito-alatt-2.webp" alt="">
  <figcaption>Installation of TOPWET renovation drain into an existing funnel</figcaption>
</figure>

<p><strong>External Drainage</strong></p>
<p>Professionally, it is perhaps well-known that for single-layer warm roofs internal drainage is preferred, while for double-layer cold roofs external drainage is favored, to avoid excessive icing and the formation of icicle-like stalactites during winter. However, with proper insulation, more clients increasingly opt for external drainage even on warm roofs due to various structural or economic reasons, or because of increased insulation thicknesses or functional changes. With Fatrafol systems, this is perfectly feasible, as the junction sheet metal is custom-made to the size and profile needed by customers, and accessories—such as railings, snow guards, and snow cutters—are connected watertight within the system.</p>

<p><strong>And what’s left out…</strong></p>
<p>The construction industry’s tasks are too diverse to cover everything in a few lines. Numerous unique cases arise that require personal involvement, and as always, we remain at the disposal of our valued customers. Roof and terrace condition assessments and renovation proposals continue to be free of charge.</p>

<p>– Zsolt Jámbor / <a href="https://www.fatrafol.hu/" target="_blank" rel="noopener noreferrer">fatrafol.hu</a></p>

<?php
else :
?>
<h3 style="margin-top:-1rem">&ndash; Vízelvezetési kérdések</h3>
<p><strong>A csapadékvíz szigetelések egyik, hanem legkritikusabb csomópontja az ejtő cső és környéke, illetve külső vízelvezetés esetén az eresz vonal, ahol a csapadékvíz nagymennyiségben összegyűlik és – remélhetőleg -távozik. Meghibásodásuk esetén homlokzati vagy strang ázás alakulhat ki, amely akár több szinttel lejjebb is megkeserítheti a lakók életét, akár az által, hogy a teljes fürdőszobai plafont a nyakukba ejti… Éppen ezért fontos, hogy részleteiben is megvizsgáljuk ezeket a csomópontokat és felhívjuk a tulajdonosok, illetve közös képviseletek figyelmét arra, hogy ha spórolni kívánnak, annak ne az összefolyók lássák a kárát.</strong></p>

<p><strong>Országos körkép – „oldják meg valahogy”</strong></p>
<p>Bárhol is lát felújításhoz az ember Soprontól-Békéscsabáig elmondható, hogy az összefolyók kezelése igen „színes” megoldásokat eredményezett. Egyedileg készített bádogos elemek, tekercsbe gyömöszölt bitumenes lemez, átalakított fürdőszoba összefolyó és ez még csak néhány példa a bontások során feltárt borzalmakból, amelyek akár évtizedes távlatban keserítették meg a tulajdonosok életét. Ezért is fontos kiemelni, hogy minden esetben, ha a csapadékvíz szigetelés felújítására kerül a sor, érdemes a beömlő garatokat felbontani és adott esetben új, az ejtőcsőhöz közvetlenül csatlakozó összefolyót elhelyezni a tetőben, amellyel elkerülhetjük a keresztmetszetek további csökkenését és a tömítettség bizonytalanságát. Ha a bontásra nincsen mód, a garatok megtisztítását követően alkalmazzunk olyan összefolyókat, amelyek jól integrálhatóak a meglévő megoldásokba és megfelelő tömítettséget tudnak biztosítani még dugulás, vagy felhőszakadás esetén is, így a visszatorlódó víz nem a rétegrendbe, hanem a tető felületére kerül és idővel elszivárog.</p>

<figure>
	<img src="files/fatraizolfa/fatrafol-kritikus-csomopont-nagyito-alatt-1.webp" alt="">
	<figcaption>Bitumenes szigetelés felújítása során kibontott, korrodált összefolyók</figcaption>
</figure>

<p><strong>Szakmai irányelvek</strong></p>
<p>A csapadékvíz elvezetésében érintett összefolyókkal kapcsolatban, legyen szó tető vagy terasz szigeteléséről, jól érthető és mindenki számára elérhető szakmai irányelvekkel találkozhatunk az ÉMSZ gondozásában, amely kitér a megfelelő keresztmetszetre, az összefolyók beépítésére és rögzítésére, továbbá azok csatlakozására és kialakítására is. Gyártói oldalon elmondható, hogy ezeket az irányelveket figyelem előtt tartva fontos fejlesztések történtek az elmúlt évtizedekben és a tetőösszefolyók egy nagyon jól szabályozott és nyomon követhető termékkörré nőtték ki magukat, melyek specifikusan a rendelkezésére állnak a szigetelő szakmának. A Fatra Izolfa Zrt. gondozásában ez a TOPWET névre keresztelt termékkör, amely UV stabil PA6-os poliamidból készített, integrált szigetelőgallérral ellátott összefolyókat, oldalkifolyókat és gépészeti átvezetőket, strang és páraszellőzőket jelent. A portfólióban található tető, terasz és balkon összefolyó is, amely akár fűtőszállal gyárilag felszerelve, tömítőgyűrűvel tokosan csatlakoztatható a megfelelő ejtőcsövekhez azonnal ellátja a feladatát, illetve olyan felújítási összefolyó is, amely a lamellás, kúpos tömítésének köszönhetően a rosszabb állapotú beömlőkhöz is megfelelő tömítettség mellett csatlakoztatható. A rendszerhez elérhető olyan szabályozó elem is, amely mesterséges módon visszatartja a csapadékot, így megakadályozható a vízelvezető csövek túlterhelése. A termékkörről részletes magyar nyelvű tájékoztatás található a <a href="<?php echo withUTM('https://www.topwet.hu/'); ?>" target="_blank">www.topwet.hu</a> weboldalon. </p>


<figure>
	<img src="files/fatraizolfa/fatrafol-kritikus-csomopont-nagyito-alatt-2.webp" alt="">
	<figcaption>TOPWET felújítási összefolyó beépítése meglévő garatba</figcaption>
</figure>

<p><strong>Külső vízelvezetés</strong></p>
<p>Szakmai oldalon talán nem ismeretlen a logika, miszerint egyhéjú meleg tetők esetében belső, kéthéjú hidegtetők esetén külső vízelvezetést preferálunk, elkerülendő az ereszvonal túlzott jegesedését és cseppkő méretű jégcsapok kialakulását a téli időszakban. Megfelelő szigetelés mellett azonban egyre gyakoribb, hogy a meleg tetők esetében is külső vízelvezetés mellett döntenek a megrendelők különféle szerkezeti vagy gazdasági okból kifolyólag, esetleg a megnövekedett vastagságok vagy funkcióváltás miatt erre a megoldásra állnak át. A Fatrafol rendszerei mellett ez gond nélkül kivitelezhető, hiszen a csomóponti fóliabádogot olyan méretre és profilra hajtjuk megrendelőink számára, amilyenre szükségük van, a kiegészítők pedig – korlátlábak, hófogók, hóvágók – rendszeren belül is vízhatlan módon csatlakoztathatók.</p>
<p><strong>És ami kimaradt…</strong></p>
<p>Az építőipar feladatai szerteágazóbbak annál, hogy néhány sorban mindenre kitérjünk. Számtalan egyedi esettel találkozhatunk, amely személyes részvételt igényel, ebben pedig – ahogy mindeddig – állunk a tisztelt megrendelők rendelkezésére. A tetők, teraszok állapot felmérése és a felújítási javaslat elkészítése továbbra is ingyenes. </p>
<p>– Jámbor Zsolt / <a href="<?php echo withUTM('https://www.fatrafol.hu/'); ?>" target="_blank">fatrafol.hu</a></p>

<?php
endif;
?>
