<?php
$lang = $_GET['lang'] ?? 'hu';
echo '<!-- lang: ' . htmlspecialchars($lang) . ' -->';

if ($lang === 'en') :
?>
<p><strong>Festool celebrates 100 years</strong></p>
<p>Perfection is our tradition.</p>
<p>Our passion for high-quality power tools has remained unbroken for exactly 100 years. We share this passion with our users and fans. Our tools make the work of professional craftsmen easier, helping them achieve perfect results faster and more efficiently. We always think in terms of systems, and most importantly: we do so without compromise, down to the smallest detail.</p>

<p><strong>Woodworking and Carpentry</strong></p>
<p>Whether it's sawing, routing, sanding, or planing — Festool offers optimal power tools for any application requiring absolute precision when working with wood.</p>

<p><strong>Interior Wood Construction and Timber Framing</strong></p>
<p>Roofers build for eternity — roofs, wooden houses, staircases, and facades. Festool offers the ideal solution for nearly every application, whether it’s cutting, drilling, screwing, planing, mortising, or grooving. We offer a range of robust, powerful, and efficient tools – also available in cordless 18V versions.</p>

<p><strong>Painting</strong></p>
<p>From rapid material removal to perfect surface preparation on various substrates – whether it’s renovation, drywall, insulation, or installation – Festool provides the right tool with high-quality accessories and abrasives perfectly coordinated for the job.</p>

<p><strong>Flooring</strong></p>
<p>Stubborn old coatings and dust clouds are a thing of the past. With Festool tools developed specifically for flooring challenges, your daily work becomes faster and easier.</p>

<p><a href="<?php echo withUTM('https://www.festool.hu/v%C3%A1llalat/a-v%C3%A1llalat-toert%C3%A9nete#1925-49'); ?>" target="_blank">Our company history &rarr;</a></p>
<?php
else :
?>
<p><strong>100 éves a Festool</strong></p>
<p>A tökéletességnek nálunk hagyománya van. </p>
<p>Minőségi elektromos kéziszerszámok iránti szenvedélyünk idén pontosan 100 éve, hogy töretlen. Ezt a szenvedélyt osztjuk meg felhasználóinkkal és rajongóinkkal. Gépeinkkel megkönnyítjük a professzionális szakemberek munkáját, segítve nekik abban, hogy gyorsabban és hatékonyabban elérjék a tökéletes eredményt. Ennek során mindig rendszerben gondolkodunk és ami nagyon fontos: mindig a legkisebb részletekbe menően, kompromisszumok nélkül.</p>
<p><strong>Famegmunkálás és asztalosmunkák</strong></p>
<p>Legyen szó akár vágásról, marásról, csiszolásról vagy gyalulásról. A Festool optimális elektromos kéziszerszámokat kínál minden olyan alkalmazáshoz, amely abszolút precizitást igényel a fa alapanyaggal való munkafolyamatok során.</p>
<p><strong>Fa belsőépítészet és ácsmunkák</strong></p>
<p>Az ács szakma az örökkévalóság számára készíti a tetőket, faházakat, lépcsőket és homlokzatokat. A Festool szinte minden alkalmazáshoz ideális megoldást nyújt, akár vágásról, fúrásról, csavarozásról, gyalulásról, csapozásról vagy hornyolásról van szó. Robusztus kialakítású, erőteljes és hatékony gépek palettáját kínáljuk – igény esetén akkus változatban – 18 V-os rendszerünkben. </p>
<p><strong>Festés</strong></p>
<p>A gyors lemunkálástól a különböző aljzatok tökéletes előkészítéséig – akár renoválásról, szárazépítésről, hőszigetelésről, akár szerelésről van szó – a Festool a megfelelő gépet kínálja a legjobb minőségben a tökéletesen egyeztetett rendszertartozékokkal és minőségi csiszolóanyagokkal.</p>
<p><strong>Padlóépítés</strong></p>
<p>Makacs régi bevonatok és porfelhők – ez már a múlté. A Festool gépekkel, amelyeket a padlóburkolás során felmerülő kihívásoknak megfelelően fejlesztettünk, a hétköznapi munkát még gyorsabban és még egyszerűbben elvégezheti. 
<p><a href="<?php echo withUTM('https://www.festool.hu/v%C3%A1llalat/a-v%C3%A1llalat-toert%C3%A9nete#1925-49'); ?>" target="_blank">Cégtörténetünk &rarr;</a> </p>
<?php
endif;
?>
