<?php
define( 'DOCUMENT_ROOT', '/home/dasl1/homeinfo.hu/public_html' ); 		
define( 'SITE_URL', 'https://www.homeinfo.hu/' ); 	
if ( ! defined("ASSETS_PATH")  ) {
	define( 'ASSETS_PATH', DOCUMENT_ROOT . '/assets/homeinfo2017' );
	define( 'ASSETS_URL', SITE_URL . 'assets/homeinfo2017' );	
}
date_default_timezone_set('Europe/Budapest');
if (session_status() == PHP_SESSION_NONE) 
    session_start();

require_once __DIR__ . '/lang/i18n.php';

if ( empty($_SESSION['HTTP_REFERER']) AND isset($_SERVER['HTTP_REFERER']) )
	$_SESSION['HTTP_REFERER'] = $_SERVER['HTTP_REFERER'];
	
if ( ! isset($_SESSION['utm_source'])) $_SESSION['utm_source'] = '';
if ( ! isset($_SESSION['utm_medium'])) $_SESSION['utm_medium'] = '';
if ( ! isset($_SESSION['utm_term'])) $_SESSION['utm_term'] = '';
if ( ! isset($_SESSION['utm_content'])) $_SESSION['utm_content'] = '';
if ( ! isset($_SESSION['utm_campaign'])) $_SESSION['utm_campaign'] = '';

if (!empty($_GET['utm_source']))
	$_SESSION['utm_source'] = $_GET['utm_source'];		
if (!empty($_GET['utm_medium']))
	$_SESSION['utm_medium'] = $_GET['utm_medium'];		
if (!empty($_GET['utm_term']))
	$_SESSION['utm_term'] = $_GET['utm_term'];		
if (!empty($_GET['utm_content']))
	$_SESSION['utm_content'] = $_GET['utm_content'];		
if (!empty($_GET['utm_campaign']))
	$_SESSION['utm_campaign'] = $_GET['utm_campaign'];

	
$JEGYVASARLAS_LINK = 'https://www.homeinfo.hu/jegyvasarlas/?'; 
if ( ! empty($_SERVER['QUERY_STRING']))  
	$JEGYVASARLAS_LINK .= $_SERVER['QUERY_STRING'].'&'; 
$JEGYVASARLAS_LINK .= 'event=emw';

define('SITEURL', 'https://www.homeinfo.hu/emw/');
$title = __('event_title');
$description =  __('event_desc');
@ob_clean();
@flush();	
?>
<!DOCTYPE html>
<html lang="<?php echo $_GET['lang'] ?? 'hu'; ?>" prefix="og://ogp.me/ns#">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="referrer" content="unsafe-url">

    <meta name="description" content="<?php echo $description; ?>">
	<meta name="keywords" content="emw, émw,Építőipari és Asztalosipari Mester Workshow, bok csarnok, október 18">	  
    <title><?php echo $title; ?></title>
	
	<link rel="apple-touch-icon" sizes="180x180" href="<?php echo SITEURL; ?>apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="<?php echo SITEURL; ?>favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="<?php echo SITEURL; ?>favicon-16x16.png">
	<link rel="manifest" href="<?php echo SITEURL; ?>site.webmanifest">	
	
	<script type="application/ld+json">
	{
	  "@context": "https://schema.org",
	  "@type": "Event",
	  "name": "<?php echo $title; ?>",
	  "startDate": "2025-10-18",
	  "endDate": "2025-10-18",
	  "eventAttendanceMode": "https://schema.org/OfflineEventAttendanceMode",
	  "location": {
		"@type": "Place",
		"name": "BOK (SYMA) csarnok",
		"address": {
		  "@type": "PostalAddress",
		  "streetAddress": "Dózsa György út 1", 
		  "addressLocality": "Budapest",
		  "postalCode": "1146",
		  "addressRegion": "",
		  "addressCountry": "HU"
		}
	  },
	  "image": [
		"<?php echo SITEURL; ?>assets/emw2025_fejlec.webp"
	   ],
	  "description": "<?php echo $description; ?>"
	}
	</script>	
	
    <meta property="og:type" content="website"> 
	<meta property="og:title" content="<?php echo $title; ?>"> 
	<meta property="og:description" content="<?php echo $description; ?>"> 
	<meta property="og:url" content="<?php echo SITEURL; ?>"> 
	<meta property="og:image" content="<?php echo SITEURL; ?>assets/social_emw_2025_1200x628_v2.jpg">
	<meta property="og:image:width" content="1200">
	<meta property="og:image:height" content="628">	

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Barlow%20Condensed:100,400,900&display=swap" rel="stylesheet">
	<script src="https://code.jquery.com/jquery-2.2.4.min.js"></script>
	
    <link rel="stylesheet" href="style.css?<?php echo microtime(true); ?>" type="text/css">
    <link rel="stylesheet" href="standterkep.css?<?php echo microtime(true); ?>" type="text/css">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
	<script src="https://cdn.tailwindcss.com?plugins=typography"></script>
	<script>
		tailwind.config = {
			theme: {
				extend: {
					colors: {
						emwblue: '#03379a',
					}
				}
			}
		}
	</script>	
		
	<?php include(ASSETS_PATH . '/homeinfo.google-analytics.php'); /*+pinterest*/ ?>		
	<?php include(ASSETS_PATH . '/homeinfo.facebook-pixel.php'); ?>	
	<?php include(ASSETS_PATH . '/homeinfo.tiktok-pixel.php'); ?>	

</head>
<body>

	<?php include(ASSETS_PATH . '/homeinfo.cookie.consent.php'); ?>	
	<div style="position:absolute;right:10px;top:15px;z-index:15;"><nav style="display:flex; margin: 0 auto; gap: 10px;background: rgba(0, 0, 0, .5);    color: #fff;   padding: 0px 5px;    font-size: 12px;    font-weight: 900;"><?php echo language_switcher_links(); ?></nav></div>
	<figure class="fejleckep">
		<a href="https://www.homeinfo.hu/emw/?lang=<?php echo $_GET['lang'] ?? 'hu'; ?>">
		<img class="fejleckep__img fejleckep__img--desktop" src="assets/emw2025_fejlec_kiallitoknak_<?php echo $_GET['lang'] ?? 'hu'; ?>.webp?1" alt="">
		<img class="fejleckep__img fejleckep__img--mobil" src="assets/emw2025_fejlec_kiallitoknak_mobil_<?php echo $_GET['lang'] ?? 'hu'; ?>.webp?1" alt="">		
		</a>
    </figure>
