<?php echo '<!-- lang: ' . htmlspecialchars($lang) . ' -->'; ?>
<?php 

require_once('data.php');

if (empty($_GET['slug']) OR empty($cegek[$_GET['slug']]))
{	
	echo 'empty';
	exit;
}	

$slug = $_GET['slug'];
$item = $cegek[$slug];

ob_clean();
flush();
?>
<?php echo '<!-- lang: ' . htmlspecialchars($lang) . ' -->'; ?>
<div class="popup__content">
	<div class="popup__content__header">
		<div class="popup__content__header__banner"><img src="../emw/assets/banner-<?php echo $slug; ?>.webp?<?php echo microtime(TRUE); ?>" alt=""></div>
		<div class="popup__content__header__brand">
			<div class="popup__content__header__brand__logo"><img src="/cegkereso/files/logo/<?php echo $slug; ?>.png?<?php echo microtime(TRUE); ?>" alt=""></div>
			<h2 class="popup__content__header__brand__title"><?php echo $item['name']; ?></h2>
		</div>	
	</div>
	
	<div class="popup__content__contact">
		<div class="popup__content__contact__group">
			<?php if ( ! empty( $item['sales'])) : ?>
				<?php $item['sales'] = ( ! isset($item['sales']['name'])) ? $item['sales'] : array($item['sales']); ?>				
				<?php foreach ($item['sales'] AS $sales) : ?>			
				<div class="popup__content__contact__group__item"><i class="bi bi-person-fill"></i> <?php echo $sales['name']; ?></div>
				<div class="popup__content__contact__group__item"><i class="bi bi-telephone-forward"></i> <a href="tel:<?php echo str_replace(' ','',$sales['tel']); ?>"><?php echo $sales['tel']; ?></a></div>
				<div class="popup__content__contact__group__item"><i class="bi bi-envelope-at"></i> <a href="mailto:<?php echo $sales['email']; ?>"><?php echo $sales['email']; ?></a></div>				
				<?php endforeach; ?>
			<?php endif; ?>
			
			<?php if ( ! empty( $item['tel'])) : ?>
			<?php $item['tel'] = (is_array($item['tel'])) ? $item['tel'] : array($item['tel']); ?>
				<?php foreach ($item['tel'] AS $tel) : ?>
				<div class="popup__content__contact__group__item"><i class="bi bi-telephone-forward"></i> <a href="tel:<?php echo str_replace(' ','',$tel); ?>"><?php echo $tel; ?></a></div>
				<?php endforeach; ?>
			<?php endif; ?>		
			
			<?php if ( ! empty( $item['email'])) : ?>
			<?php $item['email'] = (is_array($item['email'])) ? $item['email'] : array($item['email']); ?>
				<?php foreach ($item['email'] AS $email) : ?>
				<div class="popup__content__contact__group__item"><i class="bi bi-envelope-at"></i> <a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></div>
				<?php endforeach; ?>
			<?php endif; ?>			
			
			<?php if ( ! empty( $item['web'])) : ?>
			<?php $item['web'] = (is_array($item['web'])) ? $item['web'] : array($item['web']); ?>
				<?php foreach ($item['web'] AS $web) : ?>
				<div class="popup__content__contact__group__item"><i class="bi bi-globe2"></i> <a href="<?php echo withUTM($web); ?>" target="_blank"><?php echo parse_url($web, PHP_URL_HOST); ?></a></div>
				<?php endforeach; ?>
			<?php endif; ?>
			
			<?php if ( ! empty( $item['pdf'])) : ?>
				<?php foreach ($item['pdf'] AS $i => $pdf_title) : ?>
				<?php ++$i; ?>
				<div class="popup__content__contact__group__item"><i class="bi bi-filetype-pdf"></i> <a href="https://www.homeinfo.hu/emw/files/<?php echo $slug; ?>/<?php echo $slug; ?>-<?php echo $i; ?>.pdf?v2024" target="blank"><?php echo $pdf_title; ?></a></div>
				<?php endforeach; ?>
			<?php endif; ?>	
			
		</div>					
		<div class="popup__content__contact__group popup__content__contact__group--social">
			<?php 
				$social = array(); 
				if ( ! empty($item['facebook'])) $social['facebook'] =  $item['facebook'];
				if ( ! empty($item['instagram'])) $social['instagram'] =  $item['instagram'];
				if ( ! empty($item['linkedin'])) $social['linkedin'] =  $item['linkedin'];
				if ( ! empty($item['pinterest'])) $social['pinterest'] =  $item['pinterest'];
				if ( ! empty($item['tiktok'])) $social['tiktok'] =  $item['tiktok'];
				if ( ! empty($item['youtube'])) $social['youtube'] =  $item['youtube'];				
			?>		
			<?php if ( ! empty( $social )) : ?>				
			<?php foreach ($social AS $socialName => $socialData) : ?>
			<?php if ( ! empty( $socialData )) : ?>			
				<?php $socialData = (is_array($socialData)) ? $socialData : array($socialData); ?>
				<?php foreach ($socialData AS $val) : ?>
				<div class="popup__content__contact__group__item"><a href="<?php echo withUTM('https://www.'.$socialName.'.com/'.$val.'/'); ?>" target="_blank"><i class="bi bi-<?php echo $socialName; ?>"></i></a></div>
				<?php endforeach; ?>
			<?php endif; ?>
			<?php endforeach; ?>
			<?php endif; ?>
		</div>
	</div>
		<?php /*
	<div class="popup__content__standterkep">
		<div class="popup__content__standterkep__title">Standtérkép</div>
		<div id="standok">          
			<img src="../emw/assets/standterkep-alap.png" alt=""> 
			<?php $standNoVolt = array(); ?>
			<?php foreach ($standok AS $standData) : ?>
			<?php if ( in_array($standData['standNo'], $standNoVolt) ) continue; ?>
			<?php $standNoVolt[] = $standData['standNo']; ?>
			<?php list($w,$h) = explode('x',$standData['size']); ?>
			<div style="cursor:default;" class="stand w<?php echo $w; ?> h<?php echo $h; ?> <?php echo (empty($standData['slug'])) ? 'empty' : ''?> <?php echo ( isset($item['stand']) AND $item['stand']['no'] == $standData['standNo']) ? '' : 'off'?>" id="stand<?php echo $standData['standNo']; ?>"><?php echo $standData['standNo']; ?></div>
			<?php endforeach; ?>							   
		</div>	
	</div>		
	*/ ?>
	
	<?php if ( $slug == 'ravak' ) : ?>
	<style>
		.popup__content__ravak {display:flex;flex-direction:column;    background: #eee;    }
		.popup__content__ravak img {display: block;  width: 100%;  height: auto;  aspect-ratio: 580 / 300;}
		.popup__content__ravak div {padding: 1rem;display:flex;flex-direction:column;gap:1rem;}
		@media (min-width: 768px) {
			.popup__content__ravak {flex-direction:row;}
			.popup__content__ravak div {width:50%;}
			.popup__content__ravak figure {width:50%;align-self: center;}
			.popup__content__ravak p {font-size:89%;}
		}
	</style>
	<div class="popup__content__ravak">		
				<figure>          
					<a href="https://www.homeinfo.hu/emw/ravak-kepzes.php" target="_blank"><img src="../emw/files/ravak/kepzes-banner2.webp" alt=""></a> 
				</figure>	
				<div>	
					<h3>Időpontfoglalás RAVAK Fürdőszoba Mester képzésre</h3>
					<p>Az Építőipari Mester Workshown lehetőség van a látogatók számára regisztrációra a RAVAK standhoz, ahol a márkaszervies csapat bemutatja a szakszerű RAVAK kád és zuhanykabin telepítés legfontosabb mozzanatait. A helyszínen alkalom van a 2 napos RAVAK Fürdőszoba Mester képzésre is jelentkezni.</p>	
					<a class="btn" href="https://www.homeinfo.hu/emw/ravak-kepzes.php" target="_blank">Időpontfoglalás</a>
				</div>
	</div>	
	<?php endif; ?>	
	
	<?php if ( $slug == 'sika') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Ismerd meg a Sika kiemelt termékeinek kínálatát!</div>
		<a href="https://hun.sika.com/dam/dms/hucon/v/Sika%20Top%2040_2024.pdf" target="_blank"><img src="../emw/files/sika/sika-top40.webp" alt=""></a>
	</div>	
	<?php endif; ?>	
	
	
	<?php if ( ! empty($item['brands'])) : ?>
	<div class="popup__content__brands">
		<?php foreach ($item['brands'] AS $brand) : ?>
		<div>
			<?php if (isset($cegek[$brand]['web'])) : ?>
			<a href="#<?php echo $brand; ?>-adatok" title="<?php echo $cegek[$brand]['name']; ?>">			
			<?php endif; ?>
			<img src="/cegkereso/files/logo/<?php echo $brand; ?>.png?<?php echo microtime(true); ?>" alt="">
			<?php if (isset($cegek[$brand]['web'])) : ?>
			</a>
			<?php endif; ?>			
		</div>
		<?php endforeach; ?>
	</div>
	<?php endif; ?>	
	
	<?php if ( in_array($slug, $programokCegek) ) : ?>
	<div class="popup__content__programok">
		<div class="popup__content__programok__title">Programok</div>	
		<table class="tableProgramok">
		<?php foreach ($programok AS $eloadas) : ?>
		<?php if ( ! is_array($eloadas['slug']))  $eloadas['slug'] = array($eloadas['slug']); ?>
		<?php if ( ! in_array($slug, $eloadas['slug']) ) continue; ?>
		<tr><th><?php echo $eloadas['idopont']; ?></th><td><?php echo $eloadas['title']; ?></td></tr>
		<?php endforeach; ?>
		</table>				
	</div>
	<?php endif; ?>	
	
	<?php if ( in_array($slug, ['cemix','knaufinsulation']) ) : ?>
	<div class="popup__content__programok">
		<div class="popup__content__programok__title">Programok</div>	
		<p>2 óránként vakolható homlokzati kőzetgyapot rendszer bemutató szakkommentárral.</p>				
		<table class="tableProgramok">		
		<tr><th>péntek 09.00</th><td>Hőszigetelés az ÚJ, bevonatos KNAUF ásványgyapottal</td></tr>				
		<tr><th>péntek 11.00</th><td>Hőszigetelés az ÚJ, bevonatos KNAUF ásványgyapottal</td></tr>				
		<tr><th>péntek 13.00</th><td>Hőszigetelés az ÚJ, bevonatos KNAUF ásványgyapottal</td></tr>				
		<tr><th>péntek 15.00</th><td>Hőszigetelés az ÚJ, bevonatos KNAUF ásványgyapottal</td></tr>				
		<tr><th>szombat 09.00</th><td>Hőszigetelés az ÚJ, bevonatos KNAUF ásványgyapottal</td></tr>				
		<tr><th>szombat 11.00</th><td>Hőszigetelés az ÚJ, bevonatos KNAUF ásványgyapottal</td></tr>				
		<tr><th>szombat 13.00</th><td>Hőszigetelés az ÚJ, bevonatos KNAUF ásványgyapottal</td></tr>			
		</table>
		<p style="margin-top:1rem;">Az előadások között az ásványgyapot hőszigetelő táblák dübelezése lesz megtekinthető és kipróbálható workshop jelleggel az EJOT Hungária Kft képviselőjével közösen.</p>				
		<?php if ( $slug == 'cemix' ) : ?>
		<p style="margin-top:1rem;">A kiállítás teljes ideje alatt kipróbálható az új 4611 Durva agyag alapvakolat, mely nem csak falazásra, de vakolatok kialakítására is alkalmas. A workshop keretében személyes tapasztalatot szerezhetnek a résztvevők az anyag felhordásával és bedolgozásával kapcsolatban.</p>				
		<?php endif; ?>		
	</div>
	<?php endif; ?>		
	
	<?php if ( in_array($slug, ['polymatrix']) ) : ?>
	<div class="popup__content__programok">
		<div class="popup__content__programok__title">Programok</div>				
		<table class="tableProgramok">		
		<tr><th>(péntek) 10.00-10.30</th><td>Gyorskötésű padlógyanta rendszer gyakorlati bemutatása mintadarabon</td></tr>				
		<tr><th>(péntek) 11.00-11.30</th><td>Padlófelületek javítóanyagainak bemutatása</td></tr>				
		<tr><th>(péntek) 13.00-13.30</th><td>Víztiszta, UV-álló teraszbevonó rendszer bemutatása</td></tr>				
		<tr><th>(péntek) 14.30-14.45</th><td>Nano-molekuláris impregnáló bemutatása kőfelületen</td></tr>				
		<tr><th>(szombat) 10.00-10.30</th><td>Gyorskötésű padlógyanta rendszer gyakorlati bemutatása mintadarabon</td></tr>				
		<tr><th>(szombat) 11.00-11.30</th><td>Padlófelületek javítóanyagainak bemutatása</td></tr>				
		<tr><th>(szombat) 13.00-13.30</th><td>Víztiszta, UV-álló teraszbevonó rendszer bemutatása</td></tr>			
		<tr><th>(szombat) 14.30-14.45</th><td>Nano-molekuláris impregnáló bemutatása kőfelületen</td></tr>			
		</table>		
	</div>
	<?php endif; ?>		

	
	<?php if ( $slug == 'wienerberger') : ?>
	<div class="popup__content__programok">
		<div class="popup__content__programok__title">Programok</div>	
		<table class="tableProgramok">		
		<tr><th>10.00-10.30</th><td>Porotherm Rapid falazási technológia kiegészítők alkalmazásával, tartja: Gál József/Szabó Zoltán Alkalmazástechnikus</td></tr>		
		<tr><th>11.00-11.40</th><td>Nagy lapokkal könnyű a munka – Semmelrock nagy lapok, térkövek, kerítés elemek beépítése könnyen, gyorsan - Gál József/Szabó Zoltán Alkalmazástechnikus</td></tr>		
		<tr><th>14.00-14.30</th><td>Gál József/Szabó Zoltán Alkalmazástechnikus: Porotherm Rapid falazási technológia kiegészítők alkalmazásával</td></tr>		
		<tr><th>15.00-15.40</th><td>Nagy lapokkal könnyű a munka – Semmelrock nagy lapok, térkövek, kerítés elemek beépítése könnyen, gyorsan - Gál József/Szabó Zoltán Alkalmazástechnikus</td></tr>		
		</table>				
	</div>
	<?php endif; ?>	
	
	<?php if ( $slug == 'xella') : ?>
	<div class="popup__content__programok">
		<div class="popup__content__programok__title">Programok</div>	
		<table class="tableProgramok" style="width: 50%;   margin-left: 0;   font-size: .85rem;">		
			<tr><th style="width:30px;">9:00</th><td>Multipor</td></tr>
			<tr><th>10:00</th><td>Ytong lépcső</td></tr>
			<tr><th>11:00</th><td>Multipor</td></tr>
			<tr><th>12:00</th><td>Ytong lépcső</td></tr>
			<tr><th>13:00</th><td>Multipor</td></tr>
			<tr><th>14:00</th><td>Ytong lépcső</td></tr>
			<tr><th>15:00</th><td>Multipor</td></tr>
			<tr><th>16:00</th><td>Ytong lépcső
			<tr><th>17:00</th><td>Multipor</td></tr>		
		</table>		
	</div>
	<?php endif; ?>	
	
	<?php if ( $slug == 'chromos') : ?>
	<div class="popup__content__programok">
		<div class="popup__content__programok__title">Programok</div>	
		<table class="tableProgramok">		
		<tr><th>Péntek - 09:30</th><td>Dekorációs festés a falakon - egyszerűen</td></tr>		
		<tr><th>Szombat - 10.00</th><td>Dekorációs festés a falakon - egyszerűen</td></tr>		
		</table>				
	</div>
	<p>A bemutatót megnézők ajándékot kapnak.</p>	
	<?php endif; ?>
	
	<?php if ( $slug == 'remmers') : ?>
	<div class="popup__content__cikkek">		
		<div class="cikkek-list cikkek-list--3fr">
		
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://www.remmers.hu/hu/epitoiparpadlo/epitesi-vizszigeteles-es-helyreallitas///mb-1k-rapid/p/000000000000085105'); ?>" target="_blank"><img src="../emw/files/remmers/1.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://www.remmers.hu/hu/epitoiparpadlo/epitesi-vizszigeteles-es-helyreallitas///mb-1k-rapid/p/000000000000085105'); ?>"  target="_blank">MB 1K Rapid</a></h4>			
			</div>				
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://www.remmers.hu/hu/epitesi-vizszigeteles-es-helyreallitas/uj-epueletek-szigetelese/kuelso-szigeteles/mb-2k/p/000000000000301408'); ?>" target="_blank"><img src="../emw/files/remmers/2.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://www.remmers.hu/hu/epitesi-vizszigeteles-es-helyreallitas/uj-epueletek-szigetelese/kuelso-szigeteles/mb-2k/p/000000000000301408'); ?>"  target="_blank">MB 2K</a></h4>			
			</div>				
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://www.remmers.hu/hu/epitoiparpadlo/epitesi-vizszigeteles-es-helyreallitas///mb-fl-2k/p/000000000000300106'); ?>" target="_blank"><img src="../emw/files/remmers/3.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://www.remmers.hu/hu/epitoiparpadlo/epitesi-vizszigeteles-es-helyreallitas///mb-fl-2k/p/000000000000300106'); ?>"  target="_blank">MB FL 2K</a></h4>			
			</div>			
		
		</div>	
	</div>	
	<?php endif; ?>		
	
	<?php if ( $slug == 'sika') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Modern beton megjelenés a falra - Sikawall®-550 Magic</div>		
		<figure>
			<img src="../emw/files/sika/sikawall.webp" alt="">
		</figure>
		<p>
			<strong>Dizájn és látszóbeton felületek falakon történő kialakításához alkalmazható felületkiegyenlítő habarcs</strong></p>		
			<p>A beton már régóta bevált módszer a belső terek kialakításában. Nemcsak a középületek és irodaházak, hanem a magánlakások belsőépítészetében is egyre nagyobb népszerűségnek örvend. Segítségével gyorsan és könnyedén átalakíthatja a falakat modern látszóbeton falakká.
			<br>
			<br><strong>Sika Wall®-550 Magic termékelőnyök:</strong>
		</p>
		<ul>
			<li>Látszóbetonra hasonlító időtlen, elegáns megjelenés</li>
			<li>Gyors és egyszerű feldolgozás</li>
			<li>Természetes betonszín és pórusképzés</li>
			<li>Magas szilárdságú, szálerősített és páraáteresztő képesség</li>
		</ul>
	</div>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Teljes hidegburkolási rendszerek a Sikától</div>
		<p><strong>Ismered a biztonságos vízszigetelés, tartós burkolás és tömítés titkát?</strong></p>
		<p>Többféle Sika vízszigetelés-technológiai megoldás közül választhat úgy, hogy döntését nem csak a magas szintű műszaki paraméterek, hanem további fontos szempontok befolyásolhatják, úgy, mint a felhasználóbarát alkalmazhatóság, a gyors kötésidők, az egymással kompatibilis anyagrendszerek és a komplexitás.</p>
		<p><strong>Fürdőszoba és vizes helyiségek</strong></p>
		<figure class="spots spots--sika1">
			<img src="../emw/files/sika/tablazat-1.webp?v2" alt="">
			<a style="left:2%;top:86%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/padlobevonati-rendszerek/termekcsoportok-szerint/alapozok-impregnalok/sikafloor-01-primer.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">1</span></a>
			<a style="left:8%;top:76%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/webinars/gyorsan-koet_-belteri-vizszigetel-folia-vizes-helyisegekhez.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">2</span></a>
			<a style="left:14%;top:76%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/webinars/gyorsan-koet_-belteri-vizszigetel-folia-vizes-helyisegekhez.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">2</span></a>
			<a style="left:19%;top:71%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/ragasztas/sikaceram-225.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">3</span></a>
			<a style="left:19%;top:54%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/webinars/professzionalis-fugazoanyagok.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">4</span></a>
			<a style="left:19%;top:62%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/rugalmas-hezagtoemites/schoenox-es.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">5</span></a>
			
			<a style="left:76%;top:87%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/padlobevonati-rendszerek/termekcsoportok-szerint/alapozok-impregnalok/sikafloor-01-primer.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">1</span></a>
			<a style="left:68%;top:80%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/vizszigeteles/schoenox-ifix.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">2</span></a>
			<a style="left:76%;top:74%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/dms/getdocument.get/d8cb9116-e8ca-4755-8518-4e3b18ff5549/Sika_vizszigeteles_20210721.pdf'); ?>"><span class="spot-ring"></span><span class="spot-circle">2</span></a>
			<a style="left:78%;top:62%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/ragasztas/sikaceram-225.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">3</span></a>
			<a style="left:84%;top:59%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/webinars/professzionalis-fugazoanyagok.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">4</span></a>
			<a style="left:85%;top:71%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/rugalmas-hezagtoemites/schoenox-es.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">5</span></a>
		</figure>		
		<p><strong>Terasz és erkély</strong></p>
		<figure class="spots spots--sika1">
			<img src="../emw/files/sika/tablazat-2.webp?v2" alt="">
			<a style="left:13%;top:78%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/padlobevonati-rendszerek/termekcsoportok-szerint/alapozok-impregnalok/sikafloor-01-primer.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">1</span></a>
			<a style="left:19%;top:70%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/vizszigeteles/teraszszigetelesek/hidegburkolat-alattikentszigeteles/sikalastic-1k.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">2</span></a>			
			<a style="left:24%;top:66%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/ragasztas/sikaceram-225.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">3</span></a>
			<a style="left:29%;top:61%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/webinars/professzionalis-fugazoanyagok.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">4</span></a>
			<a style="left:9%;top:62%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/rugalmas-hezagtoemites/schoenox-es.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">5</span></a>
			<a style="left:4%;top:73%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/vizszigeteles/schoenox-d-8-15-213565.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">6</span></a>
			
			<a style="left:82%;top:89%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/padlobevonati-rendszerek/termekcsoportok-szerint/alapozok-impregnalok/sikafloor-01-primer.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">1</span></a>
			<a style="left:90%;top:82%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/dms/getdocument.get/d8cb9116-e8ca-4755-8518-4e3b18ff5549/Sika_vizszigeteles_20210721.pdf'); ?>"><span class="spot-ring"></span><span class="spot-circle">2</span></a>			
			<a style="left:88%;top:65%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/ragasztas/sikaceram-225.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">3</span></a>
			<a style="left:93%;top:61%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/webinars/professzionalis-fugazoanyagok.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">4</span></a>
			<a style="left:74%;top:61%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/rugalmas-hezagtoemites/schoenox-es.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">5</span></a>
			<a style="left:69%;top:73%;" target="_blank" href="<?php echo withUTM('https://hun.sika.com/hu/epitoipar/burkolatragasztas/hidegburkolati-ragasztorendszerek/vizszigeteles/schoenox-d-8-15-213565.html'); ?>"><span class="spot-ring"></span><span class="spot-circle">6</span></a>
		</figure>
	</div>
	
	<div class="popup__content__cikkek">
		<div class="popup__content__cikkek__title">Szeretnél időt, pénzt megtakarítani a Sika megoldásokkal?</div>
		<div class="cikkek-list cikkek-list--homeinfo">
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://hun.sika.com/hu/webinars/ipari-ragasztok-tudnivalok.html'); ?>" target="_blank"><img src="../emw/files/sika/cikk-6.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://hun.sika.com/hu/webinars/ipari-ragasztok-tudnivalok.html'); ?>"  target="_blank">Bivalyerős ragasztó, szinte azonnali tapadással – Sikaflex® -118 Extreme Grab</a></h4>			
			</div>		
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://hun.sika.com/dms/getdocument.get/30081429-d8b2-4fda-8236-867af795c871/Sika_AnchorFix_Sikadur_2021_web.pdf'); ?>" target="_blank"><img src="../emw/files/sika/cikk-8.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://hun.sika.com/dms/getdocument.get/30081429-d8b2-4fda-8236-867af795c871/Sika_AnchorFix_Sikadur_2021_web.pdf'); ?>"  target="_blank">Betonjavítás, ragasztás, tőcsavar ragasztás szakszerűen - Sika AnchorFix®-1</a></h4>			
			</div>				
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://hun.sika.com/hu/webinars/alepitmeny-vizszigeteles-bitumen-emulzio.html'); ?>" target="_blank"><img src="../emw/files/sika/cikk-1.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://hun.sika.com/hu/webinars/alepitmeny-vizszigeteles-bitumen-emulzio.html'); ?>"  target="_blank">Az egy munkamenetben vízszigetelő és hőszigetelő lap ragasztó -  Sika®Igolflex®-101</a></h4>			
			</div>			
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://hun.sika.com/hu/webinars/betonjavitas/sikadur31.html'); ?>" target="_blank"><img src="../emw/files/sika/cikk-2.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://hun.sika.com/hu/webinars/betonjavitas/sikadur31.html'); ?>"  target="_blank">Sikadur®-31+, Betonhibákra jobb orvosságot nem talál! Sikadur®-31+</a></h4>			
			</div>		

		
		</div>	
	</div>		
	
	<div class="popup__content__cikkek">
		<div class="popup__content__cikkek__title">és ismered a Sika további praktikus megoldásait?</div>
		<div class="cikkek-list cikkek-list--homeinfo">
		
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://hun.sika.com/hu/distribution/praktikus-megoldasok/falnedvesseg-megallitasa.html'); ?>" target="_blank"><img src="../emw/files/sika/cikk-4.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://hun.sika.com/hu/distribution/praktikus-megoldasok/falnedvesseg-megallitasa.html'); ?>"  target="_blank">Állítsd meg a talajnedvesség felszívódását szakszerűen - SikaMur® InjectoCream-100</a></h4>			
			</div>			
			<div class="cikkek-list-item">
				<div><a href="https://hun.sika.com/dms/getdocument.get/519bae15-da46-4138-9308-8802aa2471ac/Sikagard-850_anti-graffiti.pdf" target="_blank"><img src="../emw/files/sika/cikk-5.webp" alt=""></a></div>
				<h4><a href="https://hun.sika.com/dms/getdocument.get/519bae15-da46-4138-9308-8802aa2471ac/Sikagard-850_anti-graffiti.pdf"  target="_blank">Tartós, átlátszó antigraffiti és plakát ragasztás nehezítő bevonat – Sikagard® -850</a></h4>			
			</div>		
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://www.proidea.hu/termekujdonsagok-1/uj-sikashield-w-vizszigetelo-lemezrendszer-21878.shtml'); ?>" target="_blank"><img src="../emw/files/sika/cikk-3.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://www.proidea.hu/termekujdonsagok-1/uj-sikashield-w-vizszigetelo-lemezrendszer-21878.shtml'); ?>"  target="_blank">Az új bitumenes szigetelőlemez - SikaShield® W1</a></h4>			
			</div>
			<div class="cikkek-list-item">
				<div><a href="<?php echo withUTM('https://hun.sika.com/hu/purform/sikaflex-11fc-purform.html'); ?>" target="_blank"><img src="../emw/files/sika/cikk-7.webp" alt=""></a></div>
				<h4><a href="<?php echo withUTM('https://hun.sika.com/hu/purform/sikaflex-11fc-purform.html'); ?>"  target="_blank">A legjobb univerzális ragasztó-tömítő a Sikaflex® -11FC purform</a></h4>			
			</div>
		
		</div>	
	</div>			
	<?php endif; ?>		

	
	<?php if ( $slug == 'vedofelszerelesek') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Nyereményjáték kiírás!</div>
		<p>
			Ha a Védőfelszerelések.hu <strong>TIK-TOK</strong> követője vagy és meg is tudod mutatni 
			nekünk a kiállítás helyszínén, akkor részt veszel egy nyereménysorsoláson, ahol 
			<strong style="color:#f00;">50.000 Ft-os vásárlási utalványt nyerhetsz!</strong>
			<br>
			<br><strong style="color:#f00;">Ezen felül kisorsolunk még 3db SPARCO kulcstartót</strong> is a kiállításon résztvevő
			követőinknek!
			<br>
			<br>Gyere csatlakozz hozzánk  a <strong>TIK-TOK</strong>-on, és Nyerj!
			<br>
			<br><strong style="color:#f00;">Nyereményjáték feltétele: A védőfelszerelések.hu TIK-TOK oldal
			követője legyél és meg tudd mutatni nekünk a kiállítás helyszínén!</strong>
			<br>
			<br><strong style="color:#4caf50;">A sorsolást élőben történik a  TIK-TOK oldalunkon</strong>
			<br><strong style="color:#4caf50;">2023 október 8-án !</strong>
			<br>
			<br><strong>Figyelj és Kövess minket !</strong>
		</p>		
	</div>
	<?php endif; ?>			
	
	<?php if ( $slug == 'atlas') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Programok a standon</div>
		<img src="../emw/files/atlas/atlas-szerencsekerek.webp">
		<p>1. Hőszigetelő táskakészlet kupakkal, ruletttel és zseblámpával</p>
		<p>2. Professzionális szerszámszíj</p>
		<p>3. Szerencsekerék garantált nyereményekkel</p>
		<ul style="gap: .5rem;">
			<li>(hőszigetelő táskakészlet sapkával, ruletttel és zseblámpával)</li>
			<li>mérőszalag és műszaki ceruza</li>
			<li>sapka</li>
			<li>póló</li>
			<li>kesztyű</li>
			<li>rulett</li>
			<li>a zseblámpa</li>
		</ul>
		<p>4. Termékek tesztelése</p>
		<ul style="gap: .5rem;">
			<li>ATLAS Grunt NKP multifunkcionális alapozó</li>
			<li>ATLAS Woder E folyékony vízszigetelés</li>
			<li>FOX Kalahari dekorfesték</li>
			<li>FOX Snow Dust dekorfesték</li>
		</ul>				
	</div>
	<?php endif; ?>		
	
	<?php if ( $slug == 'tesa') : ?>
	<style>
		@media (max-width: 600px) {
			.hstack--tesa {flex-direction:column;}
		}		
	</style>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Látogassa meg a tesa® standját, próbáljon szerencsét és nyerjen!</div>
		<div class="hstack hstack--tesa">
			<figure><img src="../emw/files/tesa/tesa-szerencsekerek.webp"></figure>
			<div>
				<p>Válaszoljon néhány egyszerű kérdésre kollégáinknál, amennyiben helyesen válaszolt, megpörgetheti szerencsekerekünket, mellyel az alábbi kategóriák közül nyerhet:</p>
				<ul style="gap: .5rem;">
					<li>kupon (kedvezményes vásárlás partnereinknél)</li>
					<li>tesa ajándéktárgy (tesa logóval ellátott hasznos eszközök)</li>
					<li>tesa termék</li>
				</ul>		
			</div>
		</div>
	</div>
	<?php endif; ?>		
	
	<?php if ( $slug == 'wattbolt') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Helyszíni kedvezmény:</div>
		<p>Standnál történő vásárlási szándék jelzése esetén, elektromos munkagépeink mellé <strong>50% kedvezményt</strong> biztosítunk 1 db választható, géphez tartozó adapterre.  </p>		
	</div>
	<?php endif; ?>		
	
	
	<?php if ( in_array($slug, array_keys($ujdonsagok)) ) : ?>
	<div class="popup__content__ujdonsagok">
		<?php if ( $slug == 'butorvonal') : ?>		
		<div class="popup__content__description__title">Termékek és újdonságok</div>
		<p style="margin:1rem 0;">
			A Bútor Vonal Kft. az idei Homeinfo Építő és Asztalos Workshow keretében mutatja be először Magyarországon a Hettich két újdonságát: a világítással ellátott AvanTech YOU fiókrendszert, valamint a formabontó FurnSpin bútortechnológiát. Emellett bemutatásra kerülnek a már jól ismert, de továbbfejlesztett TopLine tolóajtó- és WingLine harmonikaajtó-megoldások is. A német Kesseböhmer újdonságai közül pedig a FREEslim flap-vasalat és a professzionális használatra tervezett ChefsTable rendszer lesz látható.
		</p>					
		<?php elseif ( $slug == 'festool' ) : ?>
		<div class="popup__content__ujdonsagok__title">A standunkon bemutatott Festool termékek mindegyike kipróbálható!</div>		
		<?php else: ?>
		<div class="popup__content__ujdonsagok__title">Termékek, innovációk, amiket kipróbálhatsz, megtekinthetsz</div>		
		<?php endif; ?>
		<?php if ( $slug == 'klimaexpress' ) : ?>
		<p style="margin: -1rem 0 1rem;">A kiállítás ideje alatt minden termékünkre <strong>20% kedvezményt</strong> adunk!</p>
		<?php endif; ?>
		<div class="ujdonsag-list">         
			<?php foreach ($ujdonsagok[$slug] AS $i => $item) : ?>			
			<?php $src = (isset($item['file'])) ? $item['file'] : '../emw/assets/ujdonsagok-'.$slug.'-'.++$i.'.webp'; ?>
			<div class="ujdonsag-list-item"> 
				<figure>						
					<a title="<?php echo htmlEntities($item['title'], ENT_QUOTES); ?>" href="<?php echo ( ! empty($item['link'])) ? withUTM($item['link']) : '#ujdonsag-'.$slug.'-'.$i; ?>" <?php if ( ! empty($item['link'])) echo 'target="_blank"'; ?> >
						<img loading="lazy" class="product-photo" src="<?php echo $src; ?>?1" width="385" height="252" alt=""> 
					</a>
				</figure>  				
				<h2><?php echo $item['title']; ?></h2>         				
			</div> <!-- .ujdonsag-list-item -->      
			<?php endforeach; ?>				
		</div> <!-- .ujdonsag-list -->
		<?php if ( $slug == 'butorvonal') : ?>
		<p style="margin-top:1rem;"><strong>Összegzés</strong>			
			<br>A Homeinfo Workshow tökéletes alkalmat kínál arra, hogy a magyar szakmai közönség élőben is megismerkedjen ezekkel a legújabb nemzetközi fejlesztésekkel. A bemutatott termékek nem csupán esztétikai szempontból kiemelkedők, hanem technológiailag is a legmagasabb szintet képviselik, a jövő bútorgyártásának és belsőépítészetének irányait jelölve ki.
			<br>
			<br>A Bútor Vonal Kft. standjánál szakértő kollégáink a helyszínen részletes tájékoztatást nyújtanak, és gyakorlati bemutatókkal is készülnek az érdeklődő szakemberek számára.
		</p>
		<?php endif; ?>
	</div>			
	<?php endif; ?>
	
	<?php if ( $slug == 'butorvonal') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Kedvezmények</div>
		<p>A standunknál lehetőség van helyszíni regisztrációra (név, telefonszám, e-mail cím, cégnév megadásával). Azon partnereink, akik a rendezvényen regisztrálnak, és 2025. október 31-ig rendelést adnak le, további 10% kedvezményre jogosultak a vásárolt termékek végösszegéből. A kedvezmény kizárólag új regisztrációhoz kötött, egyszeri alkalommal vehető igénybe. </p>		
	</div>	
	<div class="popup__content__description">
		<div class="popup__content__description__title">Helyszíni nyeremények</div>
		<p>A rendezvény során fiók-összeszerelő versenyt szervezünk, amelyen a résztvevőknek meghatározott időn belül kell összeszerelniük egy AvanTech YOU fiókot. A verseny eredményeit egyedi, helyszínen kihelyezett ranglistán követhetik nyomon a látogatók. Azok a szakemberek, akik az előírt időn belül szakszerűen és hibamentesen teljesítik a feladatot, ajándék Hettich mellényt kapnak elismerésként.</p>		
	</div>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Helyszíni előadások</div>
		<p>A rendezvényen Kévés János, a Hettich magyarországi képviseletének szakmai vezetője tart előadást a márka termék portfóliójáról, kiemelten az új fejlesztésekről és bevezetés alatt álló innovációkról. Előadása során részletesen bemutatja az AvanTech YOU világítós rendszerét, a FurnSpin megoldást, valamint a toló- és harmonikaajtó rendszereket. A bemutatót követően a teljes Bútor Vonal csapata személyesen is rendelkezésre áll minden érdeklődő számára, szakmai kérdésekben készséggel nyújt segítséget, legyen szó műszaki specifikációról, beépítési lehetőségekről vagy alkalmazástechnikai tanácsadásról.</p>		
	</div>
	<?php endif; ?>			
	
	
	<?php if ( in_array($slug, $nyeremenyekCegek) ) : ?>
	<div class="popup__content__nyeremenyek">
		<div class="popup__content__nyeremenyek__title">Helyszíni nyeremények</div>
		<?php if ( in_array($slug, ['ravak']) ) : ?> <p>2 óránként sorsolás!</p> <?php endif; ?>
		<div class="felajanlas-list">
		<?php foreach ($nyeremenyek[$slug] AS $i => $item) : ?>
		<?php $logo = ( ! empty($item['logo'])) ? $item['logo'] : $slug; ?>
		<?php $num = ( ! empty($item['filename'])) ? $item['filename'] : $i+1; ?>
			<div class="felajanlas-item">
				<div style="position:relative;">
					<img class="company-logo" src="../emw/assets/logo-<?php echo $logo; ?>.png?<?php echo microtime(true); ?>" width="140" height="140" alt="">
					<a href="#nyeremeny-<?php echo $slug; ?>-<?php echo $i; ?>"><img class="product-photo" src="../emw/assets/tombola-<?php echo $slug; ?>-<?php echo $num; ?>.webp?<?php echo microtime(true); ?>" alt=""></a>
				</div>
				<h4><span><?php echo $item['title']; ?></span><span><?php echo $item['price']; ?></span></h4>					
				<div>
					<?php /*if(is_array($item['desc'])): ?>
					<ul>
						<?php foreach ($item['desc'] AS $listItem) : ?>
						<li><?php echo $listItem; ?></li>
						<?php endforeach; ?>
					</ul>
					<?php else: ?>
					<p><?php echo $item['desc']; ?></p>
					<?php endif;*/ ?>
				</div>				
			</div> <!-- /felajanlas-item -->		
		<?php endforeach; ?>
		</div>	
	</div>	
	<?php endif; ?>		
	
	<?php if ( in_array($slug, $nyeremenyekStandonCegek) ) : ?>
	<div class="popup__content__nyeremenyek">
		<div class="popup__content__nyeremenyek__title">Nyeremények a standon</div>		
		<div class="felajanlas-list">
		<?php foreach ($nyeremenyekStandon[$slug] AS $i => $item) : ?>
		<?php $logo = ( ! empty($item['logo'])) ? $item['logo'] : $slug; ?>
			<div class="felajanlas-item">
				<div style="position:relative;">
					<img class="company-logo" src="../emw/assets/logo-<?php echo $logo; ?>.png?<?php echo microtime(true); ?>" width="140" height="140" alt="">
					<a href="#nyeremeny-<?php echo $slug; ?>-<?php echo ++$i; ?>"><img src="../emw/assets/tombola-standon-<?php echo $slug; ?>-<?php echo $i; ?>.webp?<?php echo microtime(true); ?>" alt=""></a>
				</div>
				<h4><span><?php echo $item['title']; ?></span><span><?php echo $item['price']; ?></span></h4>					
				<div>
					<?php /*if(is_array($item['desc'])): ?>
					<ul>
						<?php foreach ($item['desc'] AS $listItem) : ?>
						<li><?php echo $listItem; ?></li>
						<?php endforeach; ?>
					</ul>
					<?php else: ?>
					<p><?php echo $item['desc']; ?></p>
					<?php endif;*/ ?>
				</div>				
			</div> <!-- /felajanlas-item -->		
		<?php endforeach; ?>
		</div>	
	</div>	
	<?php endif; ?>			
	

	
	<?php if ( ! empty( $item['image'])) : ?>
	<div class="popup__content__image">
		<img src="../emw/assets/image-<?php echo $slug; ?>.webp?<?php echo microtime(true); ?>" alt="">
	</div>
	<?php endif; ?>		
	
	
	<?php if ( ! empty($gallery[$slug]) ) : ?>
	<?php if ( ! is_array($gallery[$slug]) ) : ?>
	<div class="popup__content__gallery">
		<div class="popup__content__description__title">Galéria</div>
		<div class="popup__content__gallery__wrap">
			<div class="bwgallery__scroll bwgallery__scroll--left"><i class="bi bi-chevron-compact-left"></i></div>
			<div class="popup__content__gallery__list">
				<?php for ($i = 1; $i <= $gallery[$slug]; $i++) : ?>
				<figure>
					<img src="../emw/files/gallery/thumb-<?php echo $slug; ?>-<?php echo $i; ?>.webp?<?php echo microtime(true); ?>" alt="">
				</figure>
				<?php endfor; ?>	
			</div>
			<div class="bwgallery__scroll bwgallery__scroll--right"><i class="bi bi-chevron-compact-right"></i></div>
		</div>
	</div>						
	<?php else: ?>		
	<div class="popup__content__gallery">
		<div class="popup__content__description__title">Galéria</div>
		<div class="popup__content__gallery__wrap">
			<div class="bwgallery__scroll bwgallery__scroll--left"><i class="bi bi-chevron-compact-left"></i></div>
			<div class="popup__content__gallery__list">
				<?php foreach ($gallery[$slug] AS $src) : ?>
				<figure>
					<img src="<?php echo $src; ?>" alt="">
				</figure>
				<?php endforeach; ?>	
			</div>
			<div class="bwgallery__scroll bwgallery__scroll--right"><i class="bi bi-chevron-compact-right"></i></div>
		</div>
	</div>
	<?php endif; ?>		
	<?php endif; ?>		
	
	<?php /*if ( $slug == 'baumit') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title">Baumit nyereményjáték</div>
		<p>A Baumit hőszigetelő rendszereivel most triplán jól jár!</p>
		<ol>
		<li>Csökkentheti a rezsiköltségeket</li>
		<li>25+5 év rendszergarancia a teljes Baumit hőszigetelő rendszerekre</li>
		<li>30 000 Ft értékű MediaMarkt ajándékkártya a teljes Baumit rendszerekre</li>
		</ol>
		<p>Vásároljon teljes <strong>Baumit hőszigetelő rendszert</strong>, regisztráljon a <strong>30 000 Ft értékű MediaMarkt ajándékkártyáért</strong> a vásárlást igazoló számlával a <strong>baumitajandek.hu</strong> oldalon!</p>
		<div class="btnset"><a class="cta cta--baumit" href="<?php echo withUTM('https://baumitajandek.hu/'); ?>" target="_blank">JÁTSSZON VELÜNK</a></div>
	</div>
	<?php endif;*/ ?>	
	
	<?php if ( in_array($slug, $cikkekCegek) ) : ?>
	<div class="popup__content__cikkek">
		<div class="popup__content__cikkek__title">Termékekről bővebben</div>
		<div class="cikkek-list">
		<?php foreach ($cikkek[$slug] AS $i => $item) : ?>
			<div class="cikkek-list-item">
				<div><a href="#<?php echo $item['id']; ?>-cikk"><img src="../emw/files/<?php echo $slug; ?>/<?php echo $item['id']; ?>-thumb.webp?<?php echo microtime(true); ?>" alt=""></a></div>
				<h4><a href="#<?php echo $item['id']; ?>-cikk"><?php echo $item['title']; ?></a></h4>			
			</div> <!-- /cikkek-item -->				
		<?php endforeach; ?>
		</div>	
	</div>	
	<?php endif; ?>		
	
	<?php if ( ! empty($cikkekHomeinfon[$slug]) ) : ?>
	<div class="popup__content__cikkek">
		<?php if ( $slug != 'schuller') : ?>
		<div class="popup__content__cikkek__title">Termékekről bővebben</div>
		<?php endif; ?>
		<div class="cikkek-list cikkek-list--homeinfo">
		<?php foreach ($cikkekHomeinfon[$slug] AS $item) : ?>
			<div class="cikkek-list-item">
				<div><?php if ( ! is_array($item['url'])) : ?><a href="<?php echo $item['url']; ?>" target="_blank"><?php endif; ?>	<img src="<?php echo $item['thumb']; ?>?<?php echo microtime(true); ?>" alt=""><?php if ( ! is_array($item['url'])) : ?></a><?php endif; ?>	</div>
				<?php if ( ! is_array($item['url'])) : ?>
				<h4><a href="<?php echo $item['url']; ?>"  target="_blank"><?php echo $item['title']; ?></a></h4>		
				<?php else: ?>	
				<h4>
					<?php $ii = 0; ?>
					<?php foreach ($item['url'] AS $title => $url) : ?>
					<?php if ($ii !== 0) echo ' | '; $ii++; ?>
					<a href="<?php echo $url; ?>" target="_blank"><?php echo $title; ?></a>
					<?php endforeach; ?>
				</h4>		
				<?php endif; ?>	
			</div> <!-- /cikkek-item -->				
		<?php endforeach; ?>
		</div>	
	</div>	
	<?php endif; ?>		
	
	<?php if ( ! empty($videok[$slug]) ) : ?>
	<div class="popup__content__videok">
		<div class="popup__content__videok__title">Videók a termékekről</div>
		<div class="videok-list">
		<?php foreach ($videok[$slug] AS $ytid) : ?>
			<div class="videok-list-item">
				<div><iframe src="https://www.youtube.com/embed/<?php echo $ytid; ?>?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen=""></iframe></div>					
			</div> <!-- /videok-item -->				
		<?php endforeach; ?>
		</div>	
	</div>	
	<?php endif; ?>		
	
	<?php if ( $slug == 'trilak') : ?>
	<div class="popup__content__videok">
		<div class="popup__content__videok__title">Online Festőakadémia</div>
		<div class="videok-list">
					<div class="videok-list-item">
				<div><iframe src="https://www.youtube.com/embed/sOs-kLkp9pQ?feature=oembed" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen=""></iframe></div>					
			</div> <!-- /videok-item -->				
					<div class="videok-list-item" style="display: flex;
    align-items: center;
    justify-content: center;
    border: 1px solid #eee;">
				<a href="https://www.youtube.com/watch?v=sOs-kLkp9pQ&list=PLP7nL36f5KyLnDdvkBmj9x5mItDQjBMNw" target="_blank">További epizódok &rarr;</a>					
			</div> <!-- /videok-item -->				
				</div>	
	</div>	
	<?php endif; ?>
	
	<?php if ( $slug == 'schuller') : ?>
	<div class="popup__content__videok">
		<div class="popup__content__videok__title">Videó a termékekről</div>
		<div class="fitVids-wrapper">
			<iframe src="https://www.facebook.com/plugins/video.php?height=314&href=https%3A%2F%2Fwww.facebook.com%2Fschullermagyarorszag%2Fvideos%2F399525021983792%2F&show_text=false&width=560&t=0" width="560" height="314" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowfullscreen="true" allow="autoplay; clipboard-write; encrypted-media; picture-in-picture; web-share" allowFullScreen="true"></iframe>
		</div>
<p>Termékeinkről bővebben ebben a Termékporfólióban találhat információt:</p>
		<div class="btnset"><a class="cta cta--baumit" href="<?php echo withUTM('https://www.schuller.eu/hu/kezd%c5%91lap'); ?>" target="_blank">Termékeinkről bővebben</a></div>		
	</div>	

	<?php endif; ?>	
	
	<?php if ( $slug != 'sika') : ?>
	<div class="popup__content__description">
		<div class="popup__content__description__title"><?php echo ($slug == 'baumit') ? 'A Baumitról' : 'Rólunk' ?></div>				
		<?php include('_'.$slug.'.php'); ?>
	</div>
	<?php endif; ?>	
</div>