<?php
if (empty($_POST)) {
	response(400, 'Invalid form data');
}
if (empty($_POST['email'])) {
	response(400, 'Invalid form data');
}


require_once('lang/i18n.php');
require_once('../jegyvasarlas/config.php'); // adatbazis, brevo api key
require_once('../brevo/autoload.php'); // Brevo email kuldo
global $wpdb;

$insertData = array();
$insertData['email'] = $_POST['email'];
if (! empty($_POST['name']))
	$insertData['name'] = $_POST['name'];
if (! empty($_POST['phone']))
	$insertData['phone'] = $_POST['phone'];
if (! empty($_POST['company']))
	$insertData['company'] = $_POST['company'];

$wpdb->insert('emw25_casestudy', $insertData);


$emailSubject = __('casestudy.action.subject');
$emailData = $insertData;

$emailBody = createHTML($emailData, 'email-casestudy-' . $current_language . '.html');
sendEmailBrevo($_POST['email'], $emailSubject, $emailBody);
sendLinkedInConversionEvent($_POST['email']);

response(200);


function sendEmailBrevo($to, $subject, $htmlContent)
{
	$config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', BREVO_API_KEY);
	$apiInstance = new Brevo\Client\Api\TransactionalEmailsApi(new GuzzleHttp\Client(),	$config);
	$sendSmtpEmail = new \Brevo\Client\Model\SendSmtpEmail([
		'subject' => $subject,
		'sender' => ['name' => 'HOMEINFO.hu', 'email' => 'info@homeinfo.hu'],
		'replyTo' => ['name' => 'HOMEINFO.hu', 'email' => 'hirdetes@homeinfo.hu'],
		'to' => [['email' => $to]],
		'bcc' => [['email' => 'fejlesztes@homeinfo.hu'], ['email' => 'hirdetes@homeinfo.hu'], ['email' => 'l.lucalaszlo@gmail.com']],
		'htmlContent' => $htmlContent
	]);

	try {
		$result = $apiInstance->sendTransacEmail($sendSmtpEmail);
	} catch (Exception $e) {
		//echo 'Az email küldés problémába ütközött. Kérjük, írjon a fejlesztes@homeinfo.hu címre.';
		mail('fejlesztes@homeinfo.hu', 'Email kuldo hiba | ÉMW25', $e->getMessage());
		response(400, 'Email send failed');
	}
}

function createHTML($data, $templateFile)
{
	ob_start();
	include(__DIR__ . '/' . $templateFile);
	$html = ob_get_clean();
	return $html;
}


function sendLinkedInConversionEvent(string $userEmail)
{
	// LinkedIn Access Token (from Developer Portal or OAuth2 flow)	
	$accessToken = 'AQXPH9ArM_WoX4J-txNgq3uX8qtuxNxB0mCYHb4jMXZPVCTLTl1jDqAi9B9NK3QO61RTo4-HGkHf6-_Y8twwf9lRzB42397hlnE-57EKtKKw7mm-CfgB-k2wcfjAyEma10KzvkrOuvcu6CXvOyMyygZGxEJXjPx-c7i_-M5oWIqGMhxvlBqT8qNmNBwdoPQfJGVhtYyCSia04Qp_tnjJFZZFskTabXoig-Z_TivLBHuYImUF6EyEKId_fy8rrkWsR6Hm2Hn1mf3ZGRO3DEwnVCREmeGE4IO9BDkHJk_neJQfoR1OoAgbbEd0aRi5FtdcrbrgH8_xNnbpTa9AZ0X6Febpu3xJg6fR8a2gp6d3aS7bMrvGiVrtY5csWUrTyhCO35-nLLuE4Y3dWHcGBpkUMcRdSM84VrDrOry-pRWk6PnOXbNLUIVjHddixFxgKtFVQCMXues1ICjLKDscTLE';

	// LinkedIn Conversion URN (from Campaign Manager)
	$conversionURN = 'urn:lla:llaPartnerConversion:22527401';

	// Prepare payload
	$data = [
		'conversion' => $conversionURN,
		'conversionHappenedAt' => round(microtime(true) * 1000),
		'user' => [
			'userIds' => [
				[
					'idType' => 'SHA256_EMAIL',
					'idValue' => hash('sha256', strtolower($userEmail))
				]
			]
		],
		'eventId' => uniqid('submit_', true),
	];

	// Initialize cURL
	$ch = curl_init('https://api.linkedin.com/rest/conversionEvents');
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
		'Authorization: Bearer ' . $accessToken,
		'Content-Type: application/json',
		'LinkedIn-Version: 202505'
	]);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

	// Send request
	$response = curl_exec($ch);
	$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	curl_close($ch);
	if ($httpCode != 201) {
		error_log("LinkedIn CAPI Error: Status {$httpCode} - Response: {$response}");
		mail('fejlesztes@homeinfo.hu', 'LinkedIn CAPI Error', 'see error_log', ['From' => 'Homeinfo <noreply@homeinfo.hu>']);
	}
	//error_log("Sending LinkedIn conversion: " . json_encode($data));
	//error_log("Response: " . $response);
}


function response($status)
{
	http_response_code($status);
	$lang = $_GET['lang'] ?? 'hu';
	$file = 'docs/emw-casestudy-' . $lang . '.pdf';

	if (file_exists($file)) {
		header('Content-Type: application/pdf');
		header('Content-Disposition: attachment; filename="' . basename($file) . '"');
		header('Content-Length: ' . filesize($file));
		readfile($file);
		exit;
	} else {
		echo "File not found.";
	}
}
