<?php
require_once('_top.inc.php');
require_once('../jegyvasarlas/config.php');
require_once('data.php');

$standok = array();
//$standok[] = ['standNo' => '1', 'slug' => 'tesa', 'size' => '4x4'];
$acsarnok = $wpdb->get_results("SELECT * FROM emw25_standok WHERE building = 'A'", ARRAY_A);
foreach ($acsarnok as $row) {
	if(empty($row['slug'])) { // üres stand 
		$standok[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => '', 'size' => $row['size'], 'name'=>'', 'cats'=>''];
		continue;	
	}	
	$slugs = explode(',',$row['slug']);
	foreach ($slugs AS $slug) {
		$slug = trim($slug);
		$stand = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name'=>'', 'cats'=>''];

		if (empty($cegek[$slug])) // cegek közt nem talaljuk
		{
			$standok[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name'=>$slug, 'cats'=>''];
			continue;
		}	
		$cegek[$slug]['stand'] = ['no' => $row['standNo'], 'size' => $row['size']];	// stand atok atadasa
		$stand['name'] = $cegek[$slug]['name']; // cégnév atvetele
		if (!empty($cegek[$slug]['cats']))
			$stand['cats'] = implode(' ', $cegek[$slug]['cats']); // kategoria atvetele
		$standok[] = $stand;
		
		// Az 'A' csarnok cégei jelenjek meg a "Szerkezetek és építőanyagok" kategóriában
		if (is_array($cegek[$slug]['cats']))
			$cegek[$slug]['cats'][] =  "Szerkezetek és építőanyagok";
		else
			$cegek[$slug]['cats'] = [ "Szerkezetek és építőanyagok" ];
	}
}
// Nev szerinti sorrend
uasort($standok, function ($a, $b) {
	$nev1 = $a['name'] ?? strtolower($a['slug']);
	$nev2 = $b['name'] ?? strtolower($b['slug']);
	return $nev1 <=> $nev2;
});

$standokB = array();
//$standok[] = ['standNo' => '1', 'slug' => 'tesa', 'size' => '4x4'];
$bcsarnok = $wpdb->get_results("SELECT * FROM emw25_standok WHERE building = 'B'", ARRAY_A);
foreach ($bcsarnok as $row) {
	if(empty($row['slug'])) { // üres stand 
		$standokB[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => '', 'size' => $row['size'], 'name'=>'', 'cats'=>''];
		continue;	
	}	
	$slugs = explode(',',$row['slug']);
	foreach ($slugs AS $slug) {
		$slug = trim($slug);
		$stand = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name'=>'', 'cats'=>''];

		if (empty($cegek[$slug])) // cegek közt nem talaljuk
		{
			$standokB[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name'=>$slug, 'cats'=>''];
			continue;
		}	
		$cegek[$slug]['stand'] = ['no' => $row['standNo'], 'size' => $row['size']];	// stand atok atadasa
		$stand['name'] = $cegek[$slug]['name']; // cégnév atvetele
		if (!empty($cegek[$slug]['cats']))
			$stand['cats'] = implode(' ', $cegek[$slug]['cats']); // kategoria atvetele
		$standokB[] = $stand;
		
		// A 'B' csarnok cégei jelenjek meg a "Asztalosipar" kategóriában
		if (is_array($cegek[$slug]['cats']))
			$cegek[$slug]['cats'][] =  "Asztalosipar";
		else
			$cegek[$slug]['cats'] = [ "Asztalosipar" ];		
	}
}
// Nev szerinti sorrend
uasort($standokB, function ($a, $b) {
	$nev1 = $a['name'] ?? strtolower($a['slug']);
	$nev2 = $b['name'] ?? strtolower($b['slug']);
	return $nev1 <=> $nev2;
});

?>
<script>
  document.addEventListener('DOMContentLoaded', () => {
    // Simple approach: each button scrolls its closest scrollable parent
    document.querySelectorAll('.scroll-prev, .scroll-next').forEach(btn => {
      const container = btn.closest('.scroll_btn');
      if (!container) return;
	  
      const isNext = btn.classList.contains('scroll-next');
      const isVertical = container.hasAttribute('data-vertical');
      
    
      
      // Update button opacity based on scroll position
      const updateOpacity = () => {
        if (isVertical) {
          const atStart = container.scrollTop <= 0;
          const atEnd = container.scrollTop >= container.scrollHeight - container.clientHeight;
          btn.style.opacity = (isNext ? atEnd : atStart) ? '0' : '0.9';
        } else {
          const atStart = container.scrollLeft <= 200;
          const atEnd = container.scrollLeft >= container.scrollWidth - container.clientWidth-100;
          btn.style.opacity = (isNext ? atEnd : atStart) ? '0' : '0.9';
		  
        }
      };
      
      // Scroll on click
      btn.addEventListener('click', () => {
        const amount = isVertical ? container.clientHeight : container.clientWidth;
        container.scrollBy({
          [isVertical ? 'top' : 'left']: isNext ? amount : -amount,
          behavior: 'smooth'
        });
      });
      
      // Initial setup and scroll listener
    
      updateOpacity();
      container.addEventListener('scroll', updateOpacity);
    });
  });
</script>


<?php if (isset($_GET['dev'])) : ?>
<div class="relative isolate flex  justify-center items-center gap-x-6 overflow-hidden bg-gray-50 px-6 py-2.5 sm:px-3.5 ">
  <div aria-hidden="true" class="absolute left-[max(-7rem,calc(50%-52rem))] top-1/2 -z-10 -translate-y-1/2 transform-gpu blur-2xl">
    <div style="clip-path: polygon(74.8% 41.9%, 97.2% 73.2%, 100% 34.9%, 92.5% 0.4%, 87.5% 0%, 75% 28.6%, 58.5% 54.6%, 50.1% 56.8%, 46.9% 44%, 48.3% 17.4%, 24.7% 53.9%, 0% 27.9%, 11.9% 74.2%, 24.9% 54.1%, 68.6% 100%, 74.8% 41.9%)" class="aspect-[577/310] w-[36.0625rem] bg-gradient-to-r from-[#ff80b5] to-[#9089fc] opacity-30"></div>
  </div>
  <div aria-hidden="true" class="absolute left-[max(45rem,calc(50%+8rem))] top-1/2 -z-10 -translate-y-1/2 transform-gpu blur-2xl">
    <div style="clip-path: polygon(74.8% 41.9%, 97.2% 73.2%, 100% 34.9%, 92.5% 0.4%, 87.5% 0%, 75% 28.6%, 58.5% 54.6%, 50.1% 56.8%, 46.9% 44%, 48.3% 17.4%, 24.7% 53.9%, 0% 27.9%, 11.9% 74.2%, 24.9% 54.1%, 68.6% 100%, 74.8% 41.9%)" class="aspect-[577/310] w-[36.0625rem] bg-gradient-to-r from-[#ff80b5] to-[#9089fc] opacity-30"></div>
  </div>
  <div class="flex flex-wrap justify-center items-center gap-x-4 gap-y-2">
    <p class="text-sm lg:text-base text-gray-900">
      <?php echo __('emw.kedvezmenyes'); ?>
    </p>
    <p><a href="<?php echo $JEGYVASARLAS_LINK; ?>" class="flex-none rounded-full bg-gray-900 px-3.5 py-1 text-sm font-semibold text-white shadow-sm hover:bg-gray-700 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-gray-900"><?php echo __('emw.ticket'); ?><span aria-hidden="true">&rarr;</span></a></p>
  </div>
</div>
<?php endif; ?>

<?php if (isset($_GET['dev1'])) : ?><?php endif; ?>
<script defer>
        document.addEventListener("DOMContentLoaded", function () {
            const countdownElement = document.getElementById("countdown");
            const targetDate = new Date("2025-10-18T08:00:00").getTime();

            function updateCountdown() {
                const now = new Date().getTime();
                const difference = targetDate - now;

                if (difference <= 0) {
                    //countdownElement.innerHTML = "A visszaszámlálás lejárt!";
                    countdownElement.remove();
                    clearInterval(interval);
                    return;
                }

                const days = Math.floor(difference / (1000 * 60 * 60 * 24));
                const hours = Math.floor((difference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((difference % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((difference % (1000 * 60)) / 1000);

                countdownElement.innerHTML = `${days} nap ${hours} óra ${minutes} perc ${seconds} másodperc`;
            }

            updateCountdown();
            const interval = setInterval(updateCountdown, 1000);
        });
    </script>
	<div class="text-center p-6 bg-gradient-to-r from-blue-700 to-[#607D8B] text-white ">
        <h1 class="text-2xl font-bold mb-4">Nyitás</h1>
        <p id="countdown" class="text-xl font-mono"></p>
    </div>	


<nav class="main-nav">
	<ol>
		<li><a data-ga-event="Menüpont kattintás"
				href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.menu.jegyvasarlas'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#kiallitok"><?php echo __('emw.menu.exhibitors'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#helyszin"><?php echo __('emw.menu.location'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#ujdonsagok"><?php echo __('emw.menu.innovations'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#programok"><?php echo __('emw.menu.programs'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#nyeremenyek"><?php echo __('emw.menu.prizes'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll" href="#mesterkviz"><?php echo __('emw.menu.quiz'); ?></a>
		</li>
		<li class="kiallitoknak"><a href="kiallitoknak.php?lang=<?php echo $_GET['lang'] ?? 'hu'; ?>"
				data-ga-event="Menüpont kattintás"><i class="bi bi-info-circle-fill"></i>
				<?php echo __('emw.menu.for_exhibitors'); ?></a></li>
	</ol>
</nav>



<style>
	.eventdesc {
		list-style-position: inside;
		display: flex;
		flex-direction: column;
		gap: 1rem;
	}
</style>

<section id="eventdsc">
	 <main>
		<div class="eventdesc">
			<div><?php echo __('emw.event_desc'); ?></div>
			<div><?php echo __('emw.plusz'); ?></div>
<?php /*
			<div class="fitVids-wrapper">
				<iframe src="https://www.youtube.com/embed/tHVSFAnUDK4?rel=0" frameborder="0"
					allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
					allowfullscreen="" title=""></iframe>
			</div>
 */ ?>

		</div>
	</main>

	<footer style="margin-top:1rem;">
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
	
	<div style="margin-top:1rem;">
		Játssz és nyerj jegyet az Építőipari és Asztalosipari Mester Workshowra a <strong><a style="color: #0088f1;" href="https://homeinfovip.page.link/?link=https://www.homeinfo.hu/&apn=homeinfo.vip.homeinfo_vip&ibi=homeinfo.vip.homeinfoVip&isi=6504399378&ius=homeinfo-mester" target="_blank">HOMEINFO Mester applikáció</a></strong>ban! Minden <strong>ÉMW kvíz</strong> kitöltése után esélyed van megnyerni az <strong>50 db ingyen belépő</strong> egyikét! Figyeld a push üzeneteket és legyél a szerencsések között!
	</div>
</section>
	

<div  class="px-4 mb-16 sm:px-10">

		<div class=" max-w-7xl mx-auto">
<iframe
				src="https://www.youtube.com/embed/LBUuvSbUdew?controls=1&amp;showinfo=0&amp;rel=0&amp;autoplay=1&amp;mute=1&amp;loop=1&amp;playlist=LBUuvSbUdew"
				allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
				frameborder="0" allowfullscreen="" class="aspect-video w-full max-h-[80vh] rounded-lg"></iframe>


			<?php $gallery = array(
				['img' =>  'emw24-27.jpg', 'thumb' => '80af827e8bfbf9476b4a4f03737ed2311a250665.jpg'],
				['img' =>  'emw24-26.jpg', 'thumb' => '46c1d7b410ae020e4e6112e05fc65e6bf63413a7.jpg'],
				['img' =>  'emw24-36.jpg', 'thumb' => 'b17973cfea050a8e2473bcd876a9def342b4f01d.jpg'],
				['img' =>  'emw24-78.jpg', 'thumb' => '67028c0fb22fbcb7b37dd471619b1403f4da91ed.jpg'],
				['img' =>  'emw24-82.jpg', 'thumb' => '36a7ae1fd6b463e9a262dbb159906d072fb47465.jpg'],
				['img' =>  'emw24-85.jpg', 'thumb' => '4854ef8cbb3b8662dac1331ce1ee5250d1e28afd.jpg'],
				['img' =>  'emw24-94.jpg', 'thumb' => '2e6f98be5fc7f4eb24c0c89fd87a290669bb6a9b.jpg'],
				['img' =>  'emw24-126.jpg', 'thumb' => '891e5d1b58cd6733cbe81e60f4774b351d2d5461.jpg'],
				['img' =>  'emw24-154.jpg', 'thumb' => '50accc8c17409480e5f515e0b5d23c6f13460d3a.jpg'],
				['img' =>  'emw24-231.jpg', 'thumb' => 'ce309e137c229900c8a59b335f2a487b0ae40c41.jpg'],
				['img' =>  'emw24-235.jpg', 'thumb' => '9419ef770e0962f2cb4e5bfed1e333ecbbcaa57d.jpg'],
				['img' =>  'emw24-296.jpg', 'thumb' => '7c781bd3871a8064def88a97f812bcd58b64aa64.jpg'],
				['img' =>  'emw24-227.jpg', 'thumb' => '963d23df8763aaaf267aaf0d4ead0258f1ddffa6.jpg'],

				['img' =>  'emw24-15.jpg', 'thumb' => 'efc0dc1e49b31fb9a2aaceb8d9017d029e23d75c.jpg'],
				['img' =>  'emw24-19.jpg', 'thumb' => 'bbdd3c96f86aac89e52107e36d8228180edee82d.jpg'],
				['img' =>  'emw24-26.jpg', 'thumb' => '46c1d7b410ae020e4e6112e05fc65e6bf63413a7.jpg'],
				['img' =>  'emw24-18.jpg', 'thumb' => '18b31340eff7e5e4b57fc3a6aa6c5a9ca0708566.jpg'],
				['img' =>  'emw24-31.jpg', 'thumb' => '90faaa1fd4f9962f79e4e35cd392c876a20fadf3.jpg'],
				['img' =>  'emw24-47.jpg', 'thumb' => '5fad6f809e30fe80b5b6c5ee9bd8a33d33edd35b.jpg'],
				['img' =>  'emw24-53.jpg', 'thumb' => 'f0ae007124dcd1a0b9b9aafd6315a66abe3e373e.jpg'],
				['img' =>  'emw24-56.jpg', 'thumb' => '126e0990398ba79a8b160153281004b2d46421b6.jpg'],
				['img' =>  'emw24-78.jpg', 'thumb' => '67028c0fb22fbcb7b37dd471619b1403f4da91ed.jpg'],
				['img' =>  'emw24-90.jpg', 'thumb' => 'f8f8b98a9908b7876d5961be5c3beb896a39603a.jpg'],
				['img' =>  'emw24-92.jpg', 'thumb' => 'bb49060bb344fddb7e23900c43a91205e63cba99.jpg'],
				['img' =>  'emw24-95.jpg', 'thumb' => '892f9f1773507c380b4a1a6185641c937550e009.jpg'],
				['img' =>  'emw24-130.jpg', 'thumb' => '6121dcab59d8828ec3a687a92aec4f94684bc100.jpg'],
				['img' =>  'emw24-186.jpg', 'thumb' => '1331ae5e063fd9e240fda6d9b2910b3ddca69de0.jpg'],
				
				['img' =>  'emw24-206.jpg', 'thumb' => '9044e23f94c400f7f317f6d73367d7097643b177.jpg'],
				['img' =>  'emw24-251.jpg', 'thumb' => '71ae9416858c78ab9e2264c2ff044235f4c609c1.jpg'],
				['img' =>  'emw24-272.jpg', 'thumb' => '9831383c341165103ed4b450cb66165ba8678e29.jpg'],
				['img' =>  'emw24-289.jpg', 'thumb' => 'f06f1b0d6b66d8767145b8ad7dfd3ae0f6083b93.jpg'],
				['img' =>  'emw24-300.jpg', 'thumb' => '4dd00e4cf35189346ffd330d474182b692f87001.jpg'],
				['img' =>  'emw24-320.jpg', 'thumb' => '6962754230e565e4e5863c6ab880420eec60e6b1.jpg'],


				// ['img' =>  'emw24-326.jpg', 'thumb' => 'e445ec3b19bd1018305a25e70845cdf4702b0b96.jpg'],
			); ?>
			<div class="container mt-8 sm:mt-20">
				<div x-data="{activeIndex: 1}" class="xl:flex xl:h-[534px] xl:gap-4">
					<div class="mb-4 xl:mb-0 xl:w-3/4">
						<div class="overflow-hidden rounded-xl">
							<?php foreach ($gallery as $index => $item) : ?>
								<img loading="lazy" x-show="activeIndex === <?php echo $index + 1; ?>"
									src="https://static.homeinfo.hu/files/emw-2024/<?php echo $item['img']; ?>"
									alt="gallery image" class="block w-full h-full aspect-[956/536] object-cover object-center">
							<?php endforeach; ?>
						</div>
					</div>
					<div class="w-full overflow-x-auto  xl:flex-1 xl:w-1/4  xl:overflow-x-hidden xl:overflow-y-auto scroll_btn">
						<button class="scroll-prev" style="padding: 1rem;">←</button>
						<div class="flex items-center gap-2 sm:gap-4  xl:flex-col xl:gap-2">
							<?php foreach ($gallery as $index => $item) : ?>
								<button @click="activeIndex = <?php echo $index + 1; ?>" :class=" activeIndex === <?php echo $index + 1; ?> ? 'border-blue-500' : 'border-transparent' " class="shrink-0 max-w-[100px] md:max-w-none aspect-[956/536] overflow-hidden rounded-lg border lg:rounded-xl">
									<img loading="lazy" src="https://static.homeinfo.hu/cache/<?php echo $item['thumb']; ?>" alt="thumbnail-<?php echo $index + 1; ?>" class="w-full object-cover object-center">
								</button>
							<?php endforeach; ?>
							<button class="scroll-next" style="padding: 1rem;">→</button>
						</div>
						
					</div>
					
				</div>
				
			</div>
			<script src="assets/alpine.min.js"></script>			
</div>
	
</div>

<section style="margin-bottom:2rem;">
<footer>
<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
</footer>
</section>
<section id="kiallitok">
	<header>
		<?php echo __('emw.show'); ?>
	</header>
	<main>
		<?php /**/ ?>
		<ul id="kiallitokListFilter">
			<li class="on" data-filter="">Mind</li>
			<?php foreach ($categories as $cat): ?>
				<li data-ga-event="Szűrő" data-filter="<?php echo htmlspecialchars($cat); ?>">
					<?php echo __('cat.' . $cat); ?>
				</li>
			<?php endforeach; ?>
		</ul>

		<style>
			.showMoreBtn {
				display: none;
			}

			/*@media only screen and (max-width:640px) {
					.cropped {max-height:400px;overflow:hidden;}
					.showMoreBtn {display:block;width:100%;position:relative;top: -2px;z-index:1;background: linear-gradient(0deg, rgba(255,255,255,1) 33%, rgba(255,255,255,0) 100%); text-align:center; border:0;height:40px;line-height:40px; margin-top:-40px; cursor:pointer;}
					.showMoreBtn strong {padding: 3px 5px;        border: 1px solid #03379a;        background: #03379a;        color: #fff; border-radius:2px;}					
				}*/
		</style>
		<ul class="kiallitok-list cropped" id="kiallitokList">
			<?php foreach ($cegek as $slug => $item): ?>
				<?php if (isset($item['hidden']))
					continue; ?>
				<li id="<?php echo $slug; ?>"
					data-category="Mind <?php echo (!empty($item['cats'])) ? implode(' ', $item['cats']) : ''; ?>">

					<?php if (!empty($item['web']) || !empty($item['parent'])): ?>
						<?php if ($slug === "bostikerfre"): ?>
							<a href="https://www.bostik.com" target="_blank" title="<?php echo $item['name']; ?>">
							<?php else: ?>
								<a href="#<?php echo (!empty($item['parent'])) ? $item['parent'] : $slug; ?>-adatok"
									title="<?php echo $item['name']; ?>">
								<?php endif; ?>
							<?php else: ?>
								<a style="cursor:default" title="<?php echo $item['name']; ?>">
								<?php endif; ?>

								<img loading="lazy"
									src="/cegkereso/files/logo/<?php echo $slug; ?>.png?<?php echo microtime(true); ?>"
									alt="<?php echo $item['name']; ?>">
								<span>
									<?php echo $item['name']; ?>
								</span>
								<button type="button">adatlap</button>
							</a>
				</li>

			<?php endforeach; ?>
		</ul>

		<button type="button" class="showMoreBtn" data-show-more-id="kiallitokList"><strong>Még
				<?php echo count($cegek) - 9; ?> db kiállító
			</strong></button>
		<script>
			const kiallitokListFilter = document.querySelector('#kiallitokListFilter');
			const kiallitokListFilterElements = kiallitokListFilter.querySelectorAll('li');
			const kiallitokListElements = document.querySelectorAll('#kiallitokList li');

			kiallitokListFilter.addEventListener('click', e => {
				e.stopPropagation();

				if (e.target.nodeName !== 'LI') return false;

				kiallitokListFilterElements.forEach(li => li.classList.remove('on'));

				e.target.classList.add('on');

				const category = e.target.dataset.filter;
				kiallitokListElements.forEach(li => {
					if (category === "Mind" || li.dataset.category.includes(category)) {
						li.classList.remove('hide');
					} else {
						li.classList.add('hide');
					}
				});
			});

			document.addEventListener('click', function (event) {
				let id = event.target.parentElement.dataset.showMoreId;
				if (!id) return;
				let el = document.getElementById(id);
				el.classList.remove('cropped');
				event.target.parentElement.remove();
			});

		</script>
		<?php /*			
<ul class="automarkak-list">				
<li class="header"> Haszongépjármű partnereink<br> <a class="btn" href="tesztvezetes.php">Időpontfoglalás tesztvezetésre</a> </li>      				
<li id="citroen">         				

	<img loading="lazy" src="assets/logo-citroen.png" alt="Citröen">

</li> 							
<li id="peugeot">         				

	<img loading="lazy" src="assets/logo-peugeot.png" alt="Peugeot">

</li>				
<li id="fiat">         				

	<img loading="lazy" src="assets/logo-fiat.png" alt="FIAT">

</li>  			 
</ul>	*/ ?>		
</main> 
</section>

<section id="tiktokkers" style="margin-top:2rem;">
<header><i class="bi bi-tiktok"></i> A szakma ismert arcai, akik szerint érdemes ott lenni. <i class="bi bi-tiktok"></i></header>
<main>  
<div class="tiktokkers">
<?php foreach($tiktokkers AS  $item ) : ?>				
<div class="tiktokkers__item">
<figure class="tiktokkers__item__figure"><img src="files/tiktokker/<?php echo $item['img']; ?>.webp"></figure>
<div class="tiktokkers__item__details">
	<a href="<?php echo $item['link']; ?>" target="_blank">@<?php echo $item['tiktok']; ?></a>
	<span><?php echo $item['name']; ?></span>
</div>					
</div>
<?php endforeach; ?>
</div>
</main> 
</section>

<section >       
<footer style="margin-top:2rem;">
<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
</footer>			
</section>	


<?php foreach ($cegek as $slug => $item): ?>
	<?php if (!empty($item['parent']))
		continue; ?>
	<?php if (!empty($item['hidden']))
		continue; ?>
	<div id="<?php echo $slug; ?>-adatok" class="overlay">
		<div class="popup"><span class="loader"></span></div>
		<a class="overlay__close" href="#close">&times;</a>
	</div>
<?php endforeach; ?>

<?php
$lang = isset($_GET['lang']) ? $_GET['lang'] : null;
$cikkek = ($lang === 'en') ? $cikkek_en : $cikkek;
foreach ($cikkek as $slug => $items): ?>
	<?php foreach ($items as $i => $item): ?>
		<div id="<?php echo $item['id']; ?>-cikk" class="overlay">
			<div class="popup"><span class="loader"></span></div>
			<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>
		</div>
	<?php endforeach; ?>
<?php endforeach; ?>

<script>
	const initGallery = (selector, isMobile) => {
		const slider = document.querySelector(selector);

		if (!slider) return;

		const scrollLeftBtn = slider.previousElementSibling;
		const scrollRightBtn = slider.nextElementSibling;

		if (isMobile) {
			scrollLeftBtn.classList.add('hide');
			scrollRightBtn.classList.add('hide');
			return;
		}

		let mouseDown = false;
		let dragged = false;
		let startX, scrollLeft;
		let startDragging = (e) => {
			mouseDown = true;
			startX = e.pageX - slider.offsetLeft;
			scrollLeft = slider.scrollLeft;
		};
		let stopDragging = (e) => {
			e.preventDefault();
			mouseDown = false;
			if (dragged) {
				dragged = false;
			} else {
				console.log('go');
			}
		};
		slider.addEventListener('mousemove', (e) => {
			e.preventDefault();
			if (!mouseDown) { return; }
			const x = e.pageX - slider.offsetLeft;
			const scroll = x - startX;
			slider.scrollLeft = scrollLeft - scroll;
			dragged = true;
		});
		slider.addEventListener('mousedown', startDragging, false);
		slider.addEventListener('mouseup', stopDragging, false);
		slider.addEventListener('mouseleave', stopDragging, false);
		slider.addEventListener('click', (e) => e.preventDefault(), false);
		scrollLeftBtn.addEventListener('click', (e) => {
			slider.scroll({ left: slider.scrollLeft - 680, top: 0, behavior: 'smooth' });
		}, false);
		scrollRightBtn.addEventListener('click', (e) => {
			slider.scroll({ left: slider.scrollLeft + 680, top: 0, behavior: 'smooth' });
		}, false);
	};

	const isMobile = /Mobi/i.test(navigator.userAgent) || /Anroid/i.test(navigator.userAgent);
	const scrollbarWidth = (window.innerWidth - document.body.clientWidth) + 'px';
	const url = 'https://www.homeinfo.hu/emw/';
	async function hashchange(e) {
		if (e.newURL.includes('-adatok') || e.newURL.includes('-cikk')) {
			document.documentElement.classList.add('overlay-active');
			if (!isMobile) document.documentElement.style.paddingRight = scrollbarWidth;
			const suffix = (e.newURL.includes('-adatok')) ? '-adatok' : '-cikk';
			const slug = e.newURL.split('#')[1].replace(suffix, '');
			const lang = document.documentElement.lang || 'en'; // or get from your PHP variable
			const query = (e.newURL.includes('-adatok'))
				? `adatlap.php?slug=${slug}&lang=${lang}`
				: `cikk.php?slug=${slug}&lang=${lang}`;

			if (document.querySelector('#' + slug + suffix + ' .popup__content')) return;
			try {
				const response = await fetch(url + query);
				const result = await response.text();
				document.querySelector('#' + slug + suffix + ' .popup').innerHTML = result;
				initGallery('#' + slug + suffix + ' .popup__content__gallery__list', isMobile);
				if (e.newURL.includes('-adatok')) {
					gtag('event', '[EMW] ' + slug, { 'event_category': 'adatlap_megnyitas' });
					//console.log('[EMW] '+slug+', event_category: adatlap_megnyitas ');					
				}
				if (e.newURL.includes('-cikk')) {
					const _slug = document.querySelector('#' + slug + suffix + ' .popup__content--cikkek').dataset.slug;
					gtag('event', '[EMW] ' + _slug, { 'event_category': 'cikk_olvasas', 'event_label': '[AV] ' + slug });
					//console.log('[EMW] '+_slug+', [AV] '+slug);
				}
				const outgoing = document.querySelectorAll('#' + slug + suffix + ' a');
				outgoing.forEach(a => {
					a.addEventListener('mouseup', evt => {
						if (evt.which == 3) return;
						if (a.href.includes('-adatok') || a.href.includes('-cikk') || a.href.includes('nyeremeny-') || a.href.includes('ujdonsag-') || a.href.includes('#close')) return;
						let ceg_slug = slug;
						if (e.newURL.includes('-cikk')) {
							ceg_slug = document.querySelector('#' + slug + suffix + ' .popup__content--cikkek').dataset.slug;
						}
						gtag('event', '[EMW] ' + ceg_slug, { 'event_category': 'atkattintas', 'event_label': '[CT] ' + a.href });
						//console.log('[EMW] '+ceg_slug+','+'[CT] '+a.href);
					}, false);
				});
				const ujdonsagBovebben = document.querySelectorAll('#' + slug + suffix + ' .ujdonsag-list a');
				ujdonsagBovebben.forEach(a => {
					a.addEventListener('mouseup', evt => {
						if (evt.which == 3) return;
						if (!a.href.includes('#ujdonsag-')) return;
						let ceg_slug = slug;
						gtag('event', '[EMW] ' + ceg_slug, { 'event_category': 'ujdonsag_bovebben', 'event_label': '[AV] ' + a.title });
						//console.log('[EMW] '+ceg_slug+',[ujdonsag_bovebben] '+'event_label:[AV] '+a.title);
					}, false);
				});

			} catch (error) {
				console.error(`Load error: ${error.message}`);
			}
		} else if (e.newURL.includes('nyeremeny-') || e.newURL.includes('ujdonsag-')) {
			document.documentElement.classList.add('overlay-active');
			if (!isMobile) document.documentElement.style.paddingRight = scrollbarWidth;
		}
		else {
			document.documentElement.classList.remove('overlay-active');
			if (!isMobile) document.documentElement.style.paddingRight = 0;
			if (e.oldURL.includes('-adatok')) {
				//document.querySelector(slug+'-adatok .popup').innerHTML = '';
			}
		}
	}
	window.addEventListener('hashchange', hashchange);
	if (window.location.hash.includes('-adatok') || window.location.hash.includes('-cikk') || window.location.hash.includes('nyeremeny-') || window.location.hash.includes('ujdonsag-')) {
		hashchange({ newURL: window.location.href });
	}
</script>


<div class="divider" id="nyeremenyek"></div>

<section id="tombola">
	<header><?php echo __('emw.prizes'); ?></header>
	<main>
		
			<h1 id="standnyeremeny" style="text-transform: uppercase;padding-top: 2em;padding-bottom: 0.5em;"><?php echo __('emw.prizes.local'); ?></h1>
		
			<h1>Sorsolás:</h1>
			<ul >
			<li><strong>12:00</strong></li>
			<li><strong>15:00</strong></li>
			<li>(16:00 -az át nem vett nyereményeket újrasorsoljuk)</li>
			</ul>


		<div class="felajanlas-list cropped" id="nyeremenyekLista">
			
			<?php
			$lang = isset($_GET['lang']) ? $_GET['lang'] : null;
			$nyeremenyek = ($lang === 'en') ? $nyeremenyek_en : $nyeremenyek;
			foreach ($nyeremenyek as $slug => $items): ?>
				<?php foreach ($items as $i => $item): ?>
					<?php $logo = (!empty($item['logo'])) ? $item['logo'] : $slug; ?>
					<?php $num = (!empty($item['filename'])) ? $item['filename'] : $i + 1; ?>
					<div class="felajanlas-item">
						<figure>
							<img loading="lazy" class="company-logo" src="/cegkereso/files/logo/<?php echo $logo; ?>.png" width="140"
								height="140" alt="">
							<img loading="lazy" class="product-photo"
								src="assets/tombola-<?php echo $slug; ?>-<?php echo $num; ?>.webp?21" alt="">
						</figure>
						<h4><span><?php echo $item['title']; ?></span><span><?php echo $item['price']; ?></span></h4>
						<div>
							<?php if (is_array($item['desc'])): ?>
								<ul>
									<?php foreach ($item['desc'] as $listItem): ?>
										<li><?php echo $listItem; ?></li>
									<?php endforeach; ?>
								</ul>
							<?php else: ?>
								<p><?php echo $item['desc']; ?></p>
							<?php endif; ?>
						</div>
					</div> <!-- /felajanlas-item -->
					

					<div id="nyeremeny-<?php echo $slug; ?>-<?php echo $i; ?>" class="overlay">
						<div class="popup">
							<div class="popup__content">
								<div class="popup__content__header">
									<figure><img src="assets/tombola-<?php echo $slug; ?>-<?php echo $num; ?>.webp?12" alt="">
									</figure>
									<h3><?php echo $item['title']; ?></h3>
								</div>
								<div class="popup__content__description">
									<?php if (is_array($item['desc'])): ?>
										<ul>
											<?php foreach ($item['desc'] as $listItem): ?>
												<li><?php echo $listItem; ?></li>
											<?php endforeach; ?>
										</ul>
									<?php else: ?>
										<p><?php echo $item['desc']; ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>
						
					</div>

				<?php endforeach; ?>
			<?php endforeach; ?>
			
		</div>

	<h1 id="standnyeremeny" style="text-transform: uppercase;padding-top: 2em;padding-bottom: 0.5em;"><?php echo __('emw.prizes.stand'); ?></h1>
		<div  class="felajanlas-list cropped" id="nyeremenyekLista">
			<?php
			$lang = isset($_GET['lang']) ? $_GET['lang'] : null;
			$nyeremenyek = ($lang === 'en') ? $stand_nyeremenyek_en : $stand_nyeremenyek;
			foreach ($nyeremenyek as $slug => $items): ?>
				<?php foreach ($items as $i => $item): ?>
					<?php $logo = (!empty($item['logo'])) ? $item['logo'] : $slug; ?>
					<?php $num = (!empty($item['filename'])) ? $item['filename'] : $i + 1; ?>
					<div class="felajanlas-item">
						<figure>
							<img loading="lazy" class="company-logo" src="/cegkereso/files/logo/<?php echo $logo; ?>.png" width="140"
								height="140" alt="">
							<img loading="lazy" class="product-photo" style="background: white;"
								src="assets/<?php echo $item['file']; ?>.webp?21" alt="">
						</figure>
						<h4><span><?php echo $item['title']; ?></span><span><?php echo $item['price']; ?></span></h4>
						<div>
							<?php if (is_array($item['desc'])): ?>
								<ul>
									<?php foreach ($item['desc'] as $listItem): ?>
										<li><?php echo $listItem; ?></li>
									<?php endforeach; ?>
								</ul>
							<?php else: ?>
								<p><?php echo $item['desc']; ?></p>
							<?php endif; ?>
						</div>
					</div> <!-- /felajanlas-item -->

					

				<?php endforeach; ?>
			<?php endforeach; ?>
		</div>





		<button type="button" class="showMoreBtn" data-show-more-id="nyeremenyekLista" style="top:0;"><strong>Mutasd
				mindet</strong></button>
	</main>
	<footer><?php echo __('emw.prizes.more'); ?></footer>

	<footer style="margin-top:1rem;">
		<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>

</section>


<?php /*
<section id="tamogatok">
<main>
<h6>Támogatóink</h6>
<ul>
<li><img src="assets/tamogato-alfakepzo.png" height="81"></li>
<li><img src="assets/tamogato-gyemanthegy.png" height="81"></li>
<li><img src="assets/tamogato-matrix.png" height="81"></li>
<li><img src="assets/tamogato-mesto.png" height="81"></li>
<li><img src="assets/tamogato-tusketablak.png" height="81"></li>
</ul>
</main>
</section>


<section >       
<footer style="margin-top:2rem;">
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>">Jegyvásárlás</a>
</footer>			
</section>	



<div class="divider" id="emwvideo"></div>	

<section class="emwvideo">
<header>Tavaly az ÉMW-n</header>
<main>
<div class="fitVids-wrapper">
<iframe src="https://www.youtube.com/embed/G0Y2sTt4WRI?rel=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen="" title=""></iframe>
</div>
</main>		
</section>	

<section id="bwgallery">
<header>Képek a tavalyi ÉMW-ről</header>
<main>  
<div class="bwgallery__scroll bwgallery__scroll--left"><i class="bi bi-chevron-compact-left"></i></div>
<div class="bwgallery">
<?php shuffle($bwgallery); ?>
<?php foreach($bwgallery AS $src) : ?>
<figure>
<img src="<?php echo $src; ?>">
</figure>
<?php endforeach; ?>				
</div>
<div class="bwgallery__scroll bwgallery__scroll--right"><i class="bi bi-chevron-compact-right"></i></div>
</main>
<footer><a target="_blank" class="cta" href="https://static.homeinfo.hu/?event=emw-2023"><i class="bi bi-images"></i> Építőipari Mester Workshop 2023 képek</a></footer>
</section>
<script>initGallery('.bwgallery', isMobile);</script>
*/ ?>


<section id="standterkep">
	<div class="divider"></div>
<header>"A" csarnok standtérkép</header>
<main>

	<div data-standterkep="A csarnok" class="standterkep">
		<ul data-standterkep-filter class="standterkep-filter">
			<li class="on">Mind</li>
			<?php foreach ($categories AS $cat) : ?>
			<li><?php echo $cat; ?></li>
			<?php endforeach; ?>
		</ul>
		<div class="standterkep-colset">
			<div class="standterkep-colset-left">
				<ul data-standterkep-list class="standterkep-list">      
					<?php foreach ($standok AS $standData) : ?>
					<?php if (empty($standData['slug'])) continue; ?>
					<li data-stand="<?php echo $standData['standNo']; ?>" data-category="Mind <?php echo $standData['cats']; ?>"><?php echo $standData['name']; ?></li>
					<?php endforeach; ?>
				</ul>
			</div>
			<div class="standterkep-colset-right">
				<div class="stands">          
					<img src="assets/standterkep.png" alt=""> 
					<?php $standNoVolt = array(); ?>
					<?php foreach ($standok AS $standData) : ?>
					<?php if ( in_array($standData['standNo'], $standNoVolt) ) continue; ?>
					<?php $standNoVolt[] = $standData['standNo']; ?>
					<?php list($w,$h) = explode('x',$standData['size']); ?>
					<div id="stand<?php echo $standData['id']; ?>" class="stand w<?php echo $w; ?> h<?php echo $h; ?> <?php echo (empty($standData['slug'])) ? 'empty' : ''?>" data-stand-id="stand<?php echo $standData['standNo']; ?>"><?php echo $standData['standNo']; ?></div>
					<?php endforeach; ?>							   
				</div>
			</div>
		</div>
	</div>

	
	</main>
	
	<div class="divider"></div>
	
	<header>"B" csarnok standtérkép</header>
	<main>
	
	<div data-standterkep="B csarnok" class="standterkep">
		<ul data-standterkep-filter class="standterkep-filter">
			<li class="on">Mind</li>
			<?php foreach ($categories AS $cat) : ?>
			<li><?php echo $cat; ?></li>
			<?php endforeach; ?>
		</ul>
		<div class="standterkep-colset">
			<div class="standterkep-colset-left">
				<ul data-standterkep-list class="standterkep-list">      
					<?php foreach ($standokB AS $standData) : ?>
					<?php if (empty($standData['slug'])) continue; ?>
					<li data-stand="<?php echo $standData['standNo']; ?>" data-category="Mind <?php echo $standData['cats']; ?>"><?php echo $standData['name']; ?></li>
					<?php endforeach; ?>
				</ul>
			</div>
			<div class="standterkep-colset-right">
				<div class="stands">          
					<img src="assets/standterkep-b.png" alt=""> 
					<?php $standNoVolt = array(); ?>
					<?php foreach ($standokB AS $standData) : ?>
					<?php if ( in_array($standData['standNo'], $standNoVolt) ) continue; ?>
					<?php $standNoVolt[] = $standData['standNo']; ?>
					<?php list($w,$h) = explode('x',$standData['size']); ?>
					<div id="stand<?php echo $standData['id']; ?>" class="stand w<?php echo $w; ?> h<?php echo $h; ?> <?php echo (empty($standData['slug'])) ? 'empty' : ''?>" data-stand-id="stand<?php echo $standData['standNo']; ?>"><?php echo $standData['standNo']; ?></div>
					<?php endforeach; ?>							   
				</div>
			</div>
		</div>
	</div>


<script type="module">
import { standTerkepInit } from './standterkep.js';	
const acsarnok = document.querySelector('[data-standterkep="A csarnok"]');
const bcsarnok = document.querySelector('[data-standterkep="B csarnok"]');
standTerkepInit(acsarnok);
standTerkepInit(bcsarnok);
</script>

</main>
</section>


<div class="divider" id="programok"></div>
<section>
<header>Programok</header>
<main>  			

<div class="programok cropped" id="programokLista">
<?php foreach ($programok AS $eloadas) : ?>	
<div class="programok__item">
<div class="programok__item__body">				
	<header class="programok__item__body_header">
		<div class="programok__item__body_header__icon">
			<i class="bi bi-clock"></i>
		</div>		
		<div class="programok__item__body_header__time">
			<time datetime="2023-10-06"><?php echo $eloadas['idopont']; ?></time>
		</div>	
	</header>	
	<article class="programok__item__body_content">
		<figure class="programok__item__body_content__logo">
			<img loading="lazy" class="company-logo" src="/cegkereso/files/logo/<?php echo (is_array($eloadas['slug'])) ? $eloadas['slug'][0] : $eloadas['slug']; ?>.png" width="140" height="140" alt="">
			<?php if  (is_array($eloadas['slug'])) : ?>
			<img loading="lazy" class="company-logo" src="/cegkereso/files/logo/<?php echo  $eloadas['slug'][1]; ?>.png" width="140" height="140" alt="">
			<?php endif; ?>
			<figcaption><?php echo $cegek[$eloadas['slug']]['name']; ?></figcaption>
		</figure>
		<div class="programok__item__body_content__title">
			
			<h3><strong><?php echo $eloadas['eloado']; ?></strong><br><?php echo $eloadas['title']; ?></h3>
		</div>		
				
		<div class="programok__item__body_content__stand">
			<span><?php echo $eloadas['csarnok']; ?>  csarnok</span>
		</div>	
	</article>						
</div>					
</div>
<?php endforeach; ?>
</div>
<button type="button" class="showMoreBtn" data-show-more-id="programokLista" style="top:0;"><strong >Mutasd mindet</strong></button>	

<?php /*
<p class="py-3">Továbbá&hellip;</p>
<ul class="list">
<li>Gépek és szerszámok bemutatója és kipróbálása</li>
<li>Vágási, ragasztási, csiszolási technikák</li>
<li>Burkolási segédanyagok használata</li>
<li>Nagy lapok felrakása</li>
<li>Innovációk, újdonságok</li>
<li>Akciós vásárlási lehetőség</li>
<li>Ajándékok</li>
</ul>      	  	
*/ ?>
</main>
</section>  

<div class="divider" id="BlumMinipressVerseny"></div>

<style>
.blum-verseny  {display:flex;flex-direction:column;   background: transparent;     }
.blum-verseny .img-sm {display: block;  width: 100%;  height: auto;  aspect-ratio: 580 / 300;}
.blum-verseny .img-lg {display: none;  width: 100%;  height: auto;  aspect-ratio: 425 / 575; min-width: 425px;}
.blum-verseny div {padding: 1rem;display:flex;flex-direction:column;gap:1rem;}
.blum-verseny h3 {font-size:120%;font-weight:bold;}
.blum-verseny ul {list-style: disc;   margin-left: 20px;}
@media (min-width: 768px) {
	.blum-verseny div {padding:2rem}
}
@media (min-width: 1024px) {
.blum-verseny  {flex-direction:row;align-items: center;}
.blum-verseny div {padding:2rem 3rem; flex-grow: 1; font-size: large;}
.blum-verseny figure {padding:2rem; padding-right:0;}
.blum-verseny .img-sm {display: none;}
.blum-verseny .img-lg {display: block;}
.blum-verseny p {}
.blum-verseny ul {  margin-left: 50px;}
}		

</style>
<section>	
	<main>
		<div class="blum-verseny">
			<figure>          
				<img src="../emw/assets/blum-minipress-verseny.webp" alt="" class="img-sm">
				<img src="../emw/assets/blum-minipress-verseny-large.webp" alt="" class="img-lg">
			</figure>	
			<div>	
				<h3>Mutasd meg, mit tudsz a Minipress P-vel!</h3>


<p>
A precizitás, gyorsaság és ügyesség most mindent eldönt!
<br>Vegyél részt a <strong>Blum által megrendezett versenyen</strong>, ahol a kihívás:
<br>👉 kivetőpánt fúrása és bepréselése Minipress P-vel – időre!
</p>
 

<p>🎁 <strong>Nyeremények</strong>:</p>
<ul>
<li>🥇 1. helyezet – <strong>ECODRILL</strong></li>
<li>🥈 2. helyezet – <strong>Botos sablon kivetőpánt rendszerekhez</strong></li>
<li>🥉 3. helyezet – <strong>Univerzális-egyes sablon</strong></li>
</ul>
<p>💪 Mutasd meg a profizmusod, dolgozz gyorsan és pontosan – a dicsőség és a nyeremények csak rád várnak!</p>

 

<p>⚙️ <strong>Versenyfeltételek</strong>:</p>
<ul>
<li>A versenyen csak 18 éven felüli személyek vehetnek részt.</li>
<li>Feladat: kivetőpánt fúrása és bepréselése Minipress P-vel, a lehető legrövidebb idő alatt.</li>
<li>A három leggyorsabb, hibátlanul teljesítő versenyző részesül díjazásban.</li>
<li>A biztonsági előírások betartása kötelező a verseny teljes ideje alatt.</li>
<li>A nyerteseket a nap végén hirdetjük ki a helyszínen és online felületeinken.</li>
<li>A szervezők fenntartják a jogot a szabályok módosítására.</li>
</ul>
			</div>	
		
		</div>	
	</main>
	<footer style="margin-top:2rem;">
		<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>		


<div class="divider" id="LeierVerseny"></div>

<style>
.leier-verseny  {display:flex;flex-direction:column;   background: transparent;     }
.leier-verseny img {display: block;  width: 100%;  height: auto;  aspect-ratio: 759 / 537;}
.leier-verseny div {padding: 1rem;display:flex;flex-direction:column;gap:1rem;}
.leier-verseny h3 {font-size:120%;font-weight:bold;}
.leier-verseny ul {list-style: disc;   margin-left: 20px;}
@media (min-width: 768px) {
	.leier-verseny div {padding:2rem}
}
@media (min-width: 1024px) {
.leier-verseny  {flex-direction:row;align-items: center;}
.leier-verseny div {padding:2rem 3rem; flex-grow: 1; font-size: large;}
.leier-verseny figure {padding:2rem; padding-right:0;max-width: 580px;}
.leier-verseny p {}
.leier-verseny ul {  margin-left: 50px;}
}		

</style>
<section>	
	<main>
		<div class="leier-verseny">
			<figure>          
				<img src="../emw/assets/leier-verseny.webp" alt="" >
			</figure>	
			<div>	
				<h3>Ki a legerősebb az ÉMW-n?</h3>
				<p>
					Próbáld ki magad a Leier betoncserép tartó versenyén!
				</p>
				<p><strong>Nyeremények</strong>:</p>
				<ul>
					<li>A 3 legkitartóbb játékos Leier <strong>ajándékcsomagot</strong> kap!</li>
					<li>Minden résztvevő <strong>garantált nyereménnyel</strong> távozik!</li>
				</ul>
			</div>			
		</div>	
	</main>
	<footer style="margin-top:2rem;">
		<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>		
<div class="divider" id="ZalakeramiaVerseny"></div>

<style>
.zalakeramia-verseny  {display:flex;flex-direction:column;   background: transparent;     }
.zalakeramia-verseny figure {order:2;}
.zalakeramia-verseny img {display: block;  width: 100%;  height: auto;  aspect-ratio: 768 / 431;}
.zalakeramia-verseny div {padding: 1rem;display:flex;flex-direction:column;gap:1rem;}
.zalakeramia-verseny h3 {font-size:120%;font-weight:bold;}
.zalakeramia-verseny ul {list-style: disc;   margin-left: 20px;}
@media (min-width: 768px) {
	.zalakeramia-verseny div {padding:2rem}
}
@media (min-width: 1024px) {
.zalakeramia-verseny  {flex-direction:row;align-items: center;}
.zalakeramia-verseny div {padding:2rem 3rem; flex-grow: 1; font-size: large;order:2;}
.zalakeramia-verseny figure {padding:2rem; padding-right:0;max-width: 580px;order:1;}
.zalakeramia-verseny p {}
.zalakeramia-verseny ul {  margin-left: 50px;}
}		

</style>
<section>	
	<main>
		<div class="zalakeramia-verseny">

			<div>	
				<h3>Dekorlap mesterfutam</h3>
				<p>
					Rakd ki 3 percen belül a dekorlap-mintát és máris nyertél egy ajándékot!
				</p>
				<p><strong>Választható nyeremények</strong>:</p>
				<ul>
					<li>Kesztyű</li>
					<li>Sniccer</li>
					<li>Mérőszalag</li>
					<li>Jégkaparó</li>
				</ul>
					<p><strong>Nap végén ajándékcsomagot is átadunk a gyorsasági részidőn legjobb 3 játékos között.</strong></p>
			</div>	
			<figure>          
				<img src="../emw/assets/zalakeramia-verseny.webp" alt="" >
			</figure>				
		</div>	
	</main>
	<footer style="margin-top:2rem;">
		<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>		
<?php if (isset($_GET['dev'])) : ?><?php endif; ?>
<div class="divider" id="Foodtrucks"></div>

<style>
.foodtrucks  { display:flex; gap:2rem; flex-direction:column; background: transparent; }
.foodtrucks h2  { text-align:center; font-size:24px;font-weight:bold; }
.foodtruck {display:flex; gap:20px; flex-direction:column;}
.foodtruck h3 {font-size:20px;font-weight:bold;}
.foodtruck p {}
.foodtruck figure { display:flex; gap:10px;}
.foodtruck img {display:block;  aspect-ratio: 1 / 1; object-fit:cover;object-position: center;}
@media (min-width: 768px) {
	
}
@media (min-width: 1024px) {

}		

</style>
<section>	
	<main>
		<div class="foodtrucks">	
			<h2><?php echo __('emw.foodtrucks'); ?></h2>
			<div class="foodtruck">	
				<h3><?php echo __('emw.foodtrucks.cheche.title'); ?></h3>
				<p><?php echo __('emw.foodtrucks.cheche.desc'); ?></p>			
				<figure>
					<a href="../emw/files/foodtrucks/che-che-burger-1.webp" target="_blank"><img src="../emw/files/foodtrucks/che-che-burger-1-thumb.webp"></a>	
					<a href="../emw/files/foodtrucks/che-che-burger-2.webp" target="_blank"><img src="../emw/files/foodtrucks/che-che-burger-2-thumb.webp"></a>	
					<a href="../emw/files/foodtrucks/che-che-burger-3.webp" target="_blank"><img src="../emw/files/foodtrucks/che-che-burger-3-thumb.webp"></a>
					<a href="../emw/files/foodtrucks/meraki-4.webp" target="_blank"><img src="../emw/files/foodtrucks/meraki-4-thumb.webp"></a>
				</figure>				
			</div>				
			<div class="foodtruck">	
				<h3>Meraki görög foodtruck</h3>				
				<figure>
					<a href="../emw/files/foodtrucks/meraki-1.webp" target="_blank"><img src="../emw/files/foodtrucks/meraki-1-thumb.webp"></a>
					<a href="../emw/files/foodtrucks/meraki-2.webp" target="_blank"><img src="../emw/files/foodtrucks/meraki-2-thumb.webp"></a>
					<a href="../emw/files/foodtrucks/meraki-3.webp" target="_blank"><img src="../emw/files/foodtrucks/meraki-3-thumb.webp"></a>
				
				</figure>
			</div>			
		</div>	
	</main>
	<footer style="margin-top:2rem;">
		<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>

<div class="divider" id="ujdonsagok"></div>
<section>
	<header>
		<?php echo __('emw.prods_title'); ?>
	</header>
	<main>
		<div id="ujdonsagokLista" style="display: flex;flex-wrap: wrap;  ">
			<?php

			$lang = isset($_GET['lang']) ? $_GET['lang'] : null;
			$ujdonsagok = ($lang === 'en') ? $ujdonsagok_en : $ujdonsagok;

			foreach ($ujdonsagok as $slug => $items): ?>




				<div class="ujdonsag-list scroll_btn" style="<?php echo (count($items) < 4 ) ? 'margin: 0 auto;' : ''; ?>">
					<button class="scroll-prev" style="  transform: translateY(-50%);">←</button>
					<?php foreach ($items as $i => $item): ?>
						
						<?php $src = (isset($item['file'])) ? $item['file'] : 'assets/ujdonsagok-' . $slug . '-' . ++$i . '.webp'; ?>
						<div class="ujdonsag-list-item" style="">
							<figure>
								<img loading="lazy" class="company-logo" src="/cegkereso/files/logo/<?php echo $slug; ?>.png"
									width="140" height="140" alt="">
								<?php if ($item['title'] === 'Kesseböhmer ChefsTable'): ?>

									<div class="kachel-grid-wrapper-2 product-photo">
										<div data-poster-url="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-poster-00001.jpg"
											data-video-urls="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.mp4,https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.webm"
											data-autoplay="true" data-loop="true" data-wf-ignore="true"
											class="background-video w-background-video w-background-video-atom">
											<video style="height: 15em; aspect-ratio: 385 / 252;" autoplay loop muted playsinline
												data-wf-ignore="true" data-object-fit="cover">
												<source
													src="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.mp4"
													data-wf-ignore="true">
												<source
													src="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.webm"
													data-wf-ignore="true">
											</video>
										</div>
									</div>
								<?php else: ?>
									<img loading="lazy" class="product-photo" src="<?php echo $src; ?>?1" width="385" height="252"
										alt="">
								<?php endif; ?>
							</figure>
							<h2>
								<?php echo $item['title']; ?>
							</h2>
							<div class="et_pb_text_inner" data-slug="<?php echo $slug; ?>"
								data-title="<?php echo htmlEntities($item['title'], ENT_QUOTES); ?>">
								<div>
									<?php if (is_array($item['desc'])): ?>
										<ul>
											<?php foreach ($item['desc'] as $listItem): ?>
												<li>
													<?php echo $listItem; ?>
												</li>
											<?php endforeach; ?>
										</ul>
									<?php else: ?>
										<p>
											<?php echo nl2br($item['desc']); ?>
										</p>
									<?php endif; ?>
									<?php if (!empty($item['feats'])): ?>
										<ul>
											<?php foreach ($item['feats'] as $listItem): ?>
												<li>
													<?php echo $listItem; ?>
												</li>
											<?php endforeach; ?>
										</ul>
									<?php endif; ?>
									<?php if (!empty($item['more'])): ?>
										<p><a href="<?php echo withUTM($item['more']['href']); ?>" target="_blank">
												<?php echo $item['more']['title']; ?> &rarr;
											</a></p>
									<?php endif; ?>
								</div>
							</div>
						</div> <!-- .ujdonsag-list-item -->

						<div id="ujdonsag-<?php echo $slug; ?>-<?php echo $i; ?>" class="overlay">
							<div class="popup">
								<div class="popup__content">
									<div class="popup__content__header">
										<figure><img src="<?php echo $src; ?>" alt=""></figure>
										<h3><?php echo $item['title']; ?></h3>
									</div>
									<div class="popup__content__description">
										<?php if (is_array($item['desc'])): ?>
											<ul>
												<?php foreach ($item['desc'] as $listItem): ?>
													<li><?php echo $listItem; ?></li>
												<?php endforeach; ?>
											</ul>
										<?php else: ?>
											<p><?php echo nl2br($item['desc']); ?></p>
										<?php endif; ?>
										<?php if (!empty($item['feats'])): ?>
											<ul>
												<?php foreach ($item['feats'] as $listItem): ?>
													<li><?php echo $listItem; ?></li>
												<?php endforeach; ?>
											</ul>
										<?php endif; ?>
										<?php if (!empty($item['more'])): ?>
											<p><a href="<?php echo withUTM($item['more']['href']); ?>"
													target="_blank"><?php echo $item['more']['title']; ?> &rarr;</a></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>
						</div>

					<?php endforeach; ?>
					<button class="scroll-next" style="  transform: translateY(-50%);">→</button>
				</div>
			<?php endforeach; ?>

		</div> <!-- .ujdonsag-list -->

		<button type="button" class="showMoreBtn" data-show-more-id="ujdonsagokLista" style="top:0;"><strong>Mutasd
				mindet</strong></button>
	</main>

	<footer style="margin-top:2rem;">
		<div style="margin:auto;margin-bottom:1rem;max-width:960px"><?php echo __('emw.plusz'); ?></div>
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>

</section>
<script>
	(function ($) {

		var $parents = $('.ujdonsag-list .et_pb_text_inner');
		var $titles = $parents.find('h2');
		var $texts = $parents.find('div');

		$texts.hide();

		$parents.each(function (index, value) {
			$(this).append('<a class="bovebben" href="#bovebben" data-slug="' + this.dataset.slug + '" data-title="' + this.dataset.title + '">&plus; <?php echo __('show.more'); ?></a>');
		});

		$('.ujdonsag-list .et_pb_text_inner').on('click', 'a.bovebben', function (e) {
			e.preventDefault();
			var $a = $(this);
			if ($a.text() == '+ <?php echo __('show.more'); ?>') {
				$a.parent().find('div').show().end().end().html('&times; <?php echo __('show.less'); ?>');
				gtag('event', '[EMW] ' + this.dataset.slug, { 'event_category': 'ujdonsag_bovebben', 'event_label': '[AV] ' + this.dataset.title });
				//console.log('[EMW] '+this.dataset.slug+',[ujdonsag_bovebben] '+'event_label:[AV] '+this.dataset.title);
			} else {
				$a.parent().find('div').hide().end().end().html('&plus; <?php echo __('show.more'); ?>');
			}

		});

	})(jQuery);
</script>

<?php include('_quizblock.inc.php') ?>

<div class="divider" id="helyszin"></div>
<section>
	<header><?php echo __('title.location'); ?></header>
	<main>
		<h2><strong><?php echo __('emw.hall'); ?></strong></h2>

		<p><a href="assets/emw_3dterkep.webp" target="_blank"><img loading="lazy"
					style="max-width:960px;margin:auto;width:100%;"
					src="assets/emw_3dterkep_<?php echo $_GET['lang'] ?? 'hu'; ?>.webp" alt=""></a></p>
		<p style="max-width:738px;margin:1rem auto;">
			<?php echo __('emw.open'); ?>
			<br>
			<br>
			<?php echo __('emw.arena'); ?>
	</main>
	<?php /*	
<footer style="margin-top:2rem;">
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>">Jegyvásárlás az eseményre</a>
</footer> 
*/ ?>
</section>
	
	



	
 <?php /*
  	  	
</main>
</section>   



<div class="divider" id="jegyvasarlas"></div>
<section class="jegyvasarlas">        
<header>Jegyvásárlás</header>		
<main>
<div class="text-center">	 
<p>
<strong>Belépőjegy applikációban</strong>				
<br><strong><big style="font-size: 24px;"><?php echo $jegyvasalasConfig['brutto_egysegar_app']; ?> Ft</big></strong>
<br><small>Az applikációs jegyek nyereményjátékban vesznek részt! A nyereményeket lásd lejjebb.</small>
<br><small>18 év alatt - nagykorú felügyelete mellett - a belépés ingyenes.</small>
<br>
<br><a class="cta" href="<?php echo $JEGYVASARLAS_LINK; ?>" target="_blank">Megvásárolom</a>	
<br><a href="http://simplepartner.hu/PaymentService/Fizetesi_tajekoztato.pdf" target="_blank">
<img style="width:100%;max-width:320px;margin:15px auto 0;display:block;    padding: 10px 15px;   background: #fff;" id="SimplePayImg" src="/jegyvasarlas/assets/simplepay_bankcard_logos_left.png" title=" SimplePay - Online bankkártyás fizetés" alt=" SimplePay vásárlói tájékoztató"> 
</a>
<br>Nyomtatható és helyszíni jegyár <?php echo $jegyvasalasConfig['brutto_egysegar']; ?> Ft.		

</p>
<p></p>

</div>
</main>
</section>	

<section>
	<footer style="margin-top:2rem;">
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>
*/ ?>


<?php /*	
<section id="tombola">        
<header>Nyeremények a standokon</header>	
<main> 
<div class="felajanlas-list cropped" id="nyeremenyStandonLista">			
<?php foreach ($nyeremenyekStandon AS $slug => $items) : ?>
<?php foreach ($items AS $i => $item) : ?>
<?php $logo = ( ! empty($item['logo'])) ? $item['logo'] : $slug; ?>
<div class="felajanlas-item">
<figure>
	<img loading="lazy" class="company-logo" src="assets/logo-<?php echo $logo; ?>.png" width="140" height="140" alt="">
	<img loading="lazy" class="product-photo" src="assets/tombola-standon-<?php echo $slug; ?>-<?php echo ++$i; ?>.webp?3" alt="">
</figure>
<h4><span><?php echo $item['title']; ?></span><span><?php echo $item['price']; ?></span></h4>					
<div>
	<?php if(is_array($item['desc'])): ?>
	<ul>
		<?php foreach ($item['desc'] AS $listItem) : ?>
		<li><?php echo $listItem; ?></li>
		<?php endforeach; ?>
	</ul>
	<?php else: ?>
	<p><?php echo $item['desc']; ?></p>
	<?php endif; ?>
</div>				
</div> <!-- /felajanlas-item -->

<div id="nyeremeny-<?php echo $slug; ?>-<?php echo $i; ?>" class="overlay">
<div class="popup">				
	<div class="popup__content">
		<div class="popup__content__header">
			<figure><img src="assets/tombola-standon-<?php echo $slug; ?>-<?php echo $i; ?>.webp?12" alt=""></figure>
			<h3><?php echo $item['title']; ?></h3>			
		</div>				
		<div class="popup__content__description">
			<?php if(is_array($item['desc'])): ?>
			<ul>
				<?php foreach ($item['desc'] AS $listItem) : ?>
				<li><?php echo $listItem; ?></li>
				<?php endforeach; ?>
			</ul>
			<?php else: ?>
			<p><?php echo $item['desc']; ?></p>
			<?php endif; ?>		
		</div>	
	</div>		
</div>
<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>	
</div>

<?php endforeach; ?>
<?php endforeach; ?>									
</div>	
<button type="button" class="showMoreBtn" data-show-more-id="nyeremenyStandonLista" style="top:0;"><strong >Mutasd mindet</strong></button>	
</main> 


<footer style="margin-top:1rem;">
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>">Jegyvásárlás</a>
</footer>	

</section>	
*/ ?>


<?php /*
<div class="divider"></div>	

<section id="facebookcsoport">   
<main>
<a href="https://www.facebook.com/groups/epitoiparimesterworkshop/" target="_blank"><img loading="lazy" src="assets/emw-csoport-banner.webp" alt="ÉMW Facebook zárt csoport" title="Csatlakozz zárt Facebook csoportunkhoz!"></a>
</main>	
</section>	
*/ ?>


<div class="divider"></div>

<section id="mediamegjelensek">
	<header><?php echo __('emw.media'); ?></header>
	<ul id="mediaLista">
		<li><a href="https://www.homeinfo.hu/" target="_blank"><img loading="lazy" src="assets/media-homeinfo.png"></a>
		</li>
		<li><a href="https://www.tradefairdates.com" target="_blank"><img loading="lazy"
					src="assets/media-tradefairdates.png"></a></li>
		<?php /*
<li><a href="https://www.daibau.hu/" target="_blank"><img loading="lazy" src="assets/media-daibau.png"></a></li>
<li><a href="https://jazzy.hu/" target="_blank"><img loading="lazy" src="assets/media-jazzy.png"></a></li>
<li><a href="https://karcfm.hu/" target="_blank"><img loading="lazy" src="assets/media-karcfm.png"></a></li>
<li><a href="https://rtl.hu/" target="_blank"><img loading="lazy" src="assets/media-rtl.png"></a></li>
<li><a href="https://tv2play.hu/" target="_blank"><img loading="lazy" src="assets/media-tv2.png"></a></li>
<li><a href="https://www.viasat3.hu/" target="_blank"><img loading="lazy" src="assets/media-viasat3.png"></a></li>
*/ ?>
	</ul>
</section>
<?php /*	
<div class="divider" id="bwvideo"></div>	

<section class="bwvideo">
<header>Videó a januári Országos Burkolói Workshopról</header>
<main>
<div class="fitVids-wrapper">
<iframe src="https://www.youtube.com/embed/AsFp4ToRW8c?rel=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen="" title=""></iframe>
</div>
</main>		
</section>			


<div class="divider"></div>	

<section id="tovabbiesemenyek">   
<header>További kiállításaink</header>	
<div class="following-events">
<div><a href="https://www.furdoszoba-kiallitas.hu/" target="_blank" title="Fürdőszoba és Otthoni Wellness Kiállítás" data-ga-event="kiallitasok"><img src="/assets/homeinfo2017/images/events-banner-fs-2024-374x70.webp" width="374" height="70" alt=""></a></div>	
<div><a href="https://www.furdoszoba-kiallitas.hu/burkoloi-workshop/" target="_blank" title="Burkolói Workshop" data-ga-event="kiallitasok"><img src="/assets/homeinfo2017/images/events-banner-bw-2024-374x70.webp" width="374" height="70" alt=""></a></div>			
<div><a href="https://www.butor-lampa-textil-kiallitas.hu/" target="_blank" title="Bútor, Lámpa, Lakástextil Kiállítás" data-ga-event="kiallitasok"><img src="/assets/homeinfo2017/images/events-banner-vk-2024-374x70.webp" width="374" height="70" alt=""></a></div>
</div>		
</section>	
*/ ?>
<footer id="pageFooter">

	<p style="text-align: center;">
		<?php echo __('emw.event_footer'); ?>
		<br>&copy;<?php echo date('Y'); ?> Develon Kft. - <a style="text-decoration:underline;"
			href="https://www.homeinfo.hu/latogatoi-szabalyzat-tajekoztato">
			<?php echo __('emw.event_footer_link'); ?></a>
	</p>

</footer>



<script>
	document.addEventListener('click', function (event) {
		let gaEvent = event.target.dataset.gaEvent;
		if (!gaEvent) return;
		gtag('event', '[EMW] ' + gaEvent, { 'event_category': 'kattintás', 'event_label': event.target.textContent });
	});	
</script>

<a href="#" id="scrollToTop" title="Lap teteje" style="display: none;"><?php echo __('emw.up'); ?></a>
<script>
	(function ($) {
		var $scrollToTop = $('#scrollToTop');
		$(window).scroll(function () {
			if ($(this).scrollTop() > 100) {
				$scrollToTop.fadeIn();
			} else {
				$scrollToTop.fadeOut();
			}
		});
		$scrollToTop.click(function (e) {
			e.preventDefault();
			$('html, body').animate({ scrollTop: 0 }, 500);
		});
	})(jQuery);
</script>
<script>

	function toggleUjdonsagList(logoElement) {
		const ujdonsagList = logoElement.nextElementSibling;
		if (ujdonsagList && ujdonsagList.classList.contains('ujdonsag-list')) {
			if (ujdonsagList.style.display === 'none' || !ujdonsagList.style.display) {
				ujdonsagList.style.display = 'grid';
			} else {
				ujdonsagList.style.display = 'none';
			}
		}
	}
</script>

<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>

</body>

</html>