<?php
require_once('_top.inc.php');
require_once('../jegyvasarlas/config.php');
require_once('data_dev_old.php');



?>

<nav class="main-nav">
	<ol>
		<li><a data-ga-event="Menüpont kattintás"
				href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.menu.jegyvasarlas'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#kiallitok"><?php echo __('emw.menu.exhibitors'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#helyszin"><?php echo __('emw.menu.location'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#ujdonsagok"><?php echo __('emw.menu.innovations'); ?></a></li>
		<li><a class="soon_<?php echo $_GET['lang'] ?? 'hu'; ?>" data-ga-event="Menüpont kattintás" rel="scroll"
				href="#programok"><?php echo __('emw.menu.programs'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll"
				href="#nyeremenyek"><?php echo __('emw.menu.prizes'); ?></a></li>
		<li><a data-ga-event="Menüpont kattintás" rel="scroll" href="#mesterkviz"><?php echo __('emw.menu.quiz'); ?></a>
		</li>
		<li class="kiallitoknak"><a href="kiallitoknak.php?lang=<?php echo $_GET['lang'] ?? 'hu'; ?>"
				data-ga-event="Menüpont kattintás"><i class="bi bi-info-circle-fill"></i>
				<?php echo __('emw.menu.for_exhibitors'); ?></a></li>
	</ol>
</nav>




<style>
	.eventdesc {
		list-style-position: inside;
		display: flex;
		flex-direction: column;
		gap: 1rem;
	}
</style>

<section id="eventdsc">
	<main>
		<div class="eventdesc">
			<div><?php echo __('emw.event_desc'); ?></div>

			<div class="fitVids-wrapper">
				<iframe src="https://www.youtube.com/embed/tHVSFAnUDK4?rel=0" frameborder="0"
					allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
					allowfullscreen="" title=""></iframe>
			</div>


		</div>
	</main>

	<footer style="margin-top:0rem;">
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>



<section id="kiallitok">
	<header>
		<?php echo __('emw.show'); ?>
	</header>
	<main>
		<?php /**/ ?>
		<ul id="kiallitokListFilter">
			<li class="on" data-filter="">Mind</li>
			<?php foreach ($categories as $cat): ?>
				<li data-ga-event="Szűrő" data-filter="<?php echo htmlspecialchars($cat); ?>">
					<?php echo __('cat.' . $cat); ?>
				</li>
			<?php endforeach; ?>
		</ul>

		<style>
			.showMoreBtn {
				display: none;
			}

			/*@media only screen and (max-width:640px) {
					.cropped {max-height:400px;overflow:hidden;}
					.showMoreBtn {display:block;width:100%;position:relative;top: -2px;z-index:1;background: linear-gradient(0deg, rgba(255,255,255,1) 33%, rgba(255,255,255,0) 100%); text-align:center; border:0;height:40px;line-height:40px; margin-top:-40px; cursor:pointer;}
					.showMoreBtn strong {padding: 3px 5px;        border: 1px solid #03379a;        background: #03379a;        color: #fff; border-radius:2px;}					
				}*/
		</style>
		<ul class="kiallitok-list cropped" id="kiallitokList">
			<?php foreach ($cegek as $slug => $item): ?>
				<?php if (isset($item['hidden']))
					continue; ?>
				<li id="<?php echo $slug; ?>"
					data-category="Mind <?php echo (!empty($item['cats'])) ? implode(' ', $item['cats']) : ''; ?>">

					<?php if (!empty($item['web']) || !empty($item['parent'])): ?>
						<?php if ($slug === "bostikerfre"): ?>
							<a href="https://www.bostik.com" target="_blank" title="<?php echo $item['name']; ?>">
							<?php else: ?>
								<a href="#<?php echo (!empty($item['parent'])) ? $item['parent'] : $slug; ?>-adatok"
									title="<?php echo $item['name']; ?>">
								<?php endif; ?>
							<?php else: ?>
								<a style="cursor:default" title="<?php echo $item['name']; ?>">
								<?php endif; ?>

								<img loading="lazy"
									src="/cegkereso/files/logo/<?php echo $slug; ?>.png?<?php echo microtime(true); ?>"
									alt="<?php echo $item['name']; ?>">
								<span>
									<?php echo $item['name']; ?>
								</span>
								<button type="button">adatlap</button>
							</a>
				</li>

			<?php endforeach; ?>
		</ul>

		<button type="button" class="showMoreBtn" data-show-more-id="kiallitokList"><strong>Még
				<?php echo count($cegek) - 9; ?> db kiállító
			</strong></button>
		<script>
			const kiallitokListFilter = document.querySelector('#kiallitokListFilter');
			const kiallitokListFilterElements = kiallitokListFilter.querySelectorAll('li');
			const kiallitokListElements = document.querySelectorAll('#kiallitokList li');

			kiallitokListFilter.addEventListener('click', e => {
				e.stopPropagation();

				if (e.target.nodeName !== 'LI') return false;

				kiallitokListFilterElements.forEach(li => li.classList.remove('on'));

				e.target.classList.add('on');

				const category = e.target.dataset.filter;
				kiallitokListElements.forEach(li => {
					if (category === "Mind" || li.dataset.category.includes(category)) {
						li.classList.remove('hide');
					} else {
						li.classList.add('hide');
					}
				});
			});

			document.addEventListener('click', function (event) {
				let id = event.target.parentElement.dataset.showMoreId;
				if (!id) return;
				let el = document.getElementById(id);
				el.classList.remove('cropped');
				event.target.parentElement.remove();
			});

		</script>
		<?php /*			
<ul class="automarkak-list">				
<li class="header"> Haszongépjármű partnereink<br> <a class="btn" href="tesztvezetes.php">Időpontfoglalás tesztvezetésre</a> </li>      				
<li id="citroen">         				

	<img loading="lazy" src="assets/logo-citroen.png" alt="Citröen">

</li> 							
<li id="peugeot">         				

	<img loading="lazy" src="assets/logo-peugeot.png" alt="Peugeot">

</li>				
<li id="fiat">         				

	<img loading="lazy" src="assets/logo-fiat.png" alt="FIAT">

</li>  			 
</ul>			
</main>
</section>

<section id="tiktokkers" style="margin-top:2rem;">
<header><i class="bi bi-tiktok"></i> Találkozz a szakma legnagyobb arcaival <i class="bi bi-tiktok"></i></header>
<main>  
<div class="tiktokkers">
<?php foreach($tiktokkers AS  $item ) : ?>				
<div class="tiktokkers__item">
<figure class="tiktokkers__item__figure"><img src="files/tiktokker/<?php echo $item['img']; ?>.webp"></figure>
<div class="tiktokkers__item__details">
	<a href="<?php echo $item['link']; ?>" target="_blank">@<?php echo $item['tiktok']; ?></a>
	<span><?php echo $item['name']; ?></span>
</div>					
</div>
<?php endforeach; ?>
</div>

</main>  */ ?>
</section>



<?php foreach ($cegek as $slug => $item): ?>
	<?php if (!empty($item['parent']))
		continue; ?>
	<?php if (!empty($item['hidden']))
		continue; ?>
	<div id="<?php echo $slug; ?>-adatok" class="overlay">
		<div class="popup"><span class="loader"></span></div>
		<a class="overlay__close" href="#close">&times;</a>
	</div>
<?php endforeach; ?>

<?php
$lang = isset($_GET['lang']) ? $_GET['lang'] : null;
$cikkek = ($lang === 'en') ? $cikkek_en : $cikkek;
foreach ($cikkek as $slug => $items): ?>
	<?php foreach ($items as $i => $item): ?>
		<div id="<?php echo $item['id']; ?>-cikk" class="overlay">
			<div class="popup"><span class="loader"></span></div>
			<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>
		</div>
	<?php endforeach; ?>
<?php endforeach; ?>

<script>
	const initGallery = (selector, isMobile) => {
		const slider = document.querySelector(selector);

		if (!slider) return;

		const scrollLeftBtn = slider.previousElementSibling;
		const scrollRightBtn = slider.nextElementSibling;

		if (isMobile) {
			scrollLeftBtn.classList.add('hide');
			scrollRightBtn.classList.add('hide');
			return;
		}

		let mouseDown = false;
		let dragged = false;
		let startX, scrollLeft;
		let startDragging = (e) => {
			mouseDown = true;
			startX = e.pageX - slider.offsetLeft;
			scrollLeft = slider.scrollLeft;
		};
		let stopDragging = (e) => {
			e.preventDefault();
			mouseDown = false;
			if (dragged) {
				dragged = false;
			} else {
				console.log('go');
			}
		};
		slider.addEventListener('mousemove', (e) => {
			e.preventDefault();
			if (!mouseDown) { return; }
			const x = e.pageX - slider.offsetLeft;
			const scroll = x - startX;
			slider.scrollLeft = scrollLeft - scroll;
			dragged = true;
		});
		slider.addEventListener('mousedown', startDragging, false);
		slider.addEventListener('mouseup', stopDragging, false);
		slider.addEventListener('mouseleave', stopDragging, false);
		slider.addEventListener('click', (e) => e.preventDefault(), false);
		scrollLeftBtn.addEventListener('click', (e) => {
			slider.scroll({ left: slider.scrollLeft - 680, top: 0, behavior: 'smooth' });
		}, false);
		scrollRightBtn.addEventListener('click', (e) => {
			slider.scroll({ left: slider.scrollLeft + 680, top: 0, behavior: 'smooth' });
		}, false);
	};

	const isMobile = /Mobi/i.test(navigator.userAgent) || /Anroid/i.test(navigator.userAgent);
	const scrollbarWidth = (window.innerWidth - document.body.clientWidth) + 'px';
	const url = 'https://www.homeinfo.hu/emw/';
	async function hashchange(e) {
		if (e.newURL.includes('-adatok') || e.newURL.includes('-cikk')) {
			document.documentElement.classList.add('overlay-active');
			if (!isMobile) document.documentElement.style.paddingRight = scrollbarWidth;
			const suffix = (e.newURL.includes('-adatok')) ? '-adatok' : '-cikk';
			const slug = e.newURL.split('#')[1].replace(suffix, '');
			const lang = document.documentElement.lang || 'en'; // or get from your PHP variable
			const query = (e.newURL.includes('-adatok'))
				? `adatlap.php?slug=${slug}&lang=${lang}`
				: `cikk.php?slug=${slug}&lang=${lang}`;

			if (document.querySelector('#' + slug + suffix + ' .popup__content')) return;
			try {
				const response = await fetch(url + query);
				const result = await response.text();
				document.querySelector('#' + slug + suffix + ' .popup').innerHTML = result;
				initGallery('#' + slug + suffix + ' .popup__content__gallery__list', isMobile);
				if (e.newURL.includes('-adatok')) {
					gtag('event', '[EMW] ' + slug, { 'event_category': 'adatlap_megnyitas' });
					//console.log('[EMW] '+slug+', event_category: adatlap_megnyitas ');					
				}
				if (e.newURL.includes('-cikk')) {
					const _slug = document.querySelector('#' + slug + suffix + ' .popup__content--cikkek').dataset.slug;
					gtag('event', '[EMW] ' + _slug, { 'event_category': 'cikk_olvasas', 'event_label': '[AV] ' + slug });
					//console.log('[EMW] '+_slug+', [AV] '+slug);
				}
				const outgoing = document.querySelectorAll('#' + slug + suffix + ' a');
				outgoing.forEach(a => {
					a.addEventListener('mouseup', evt => {
						if (evt.which == 3) return;
						if (a.href.includes('-adatok') || a.href.includes('-cikk') || a.href.includes('nyeremeny-') || a.href.includes('ujdonsag-') || a.href.includes('#close')) return;
						let ceg_slug = slug;
						if (e.newURL.includes('-cikk')) {
							ceg_slug = document.querySelector('#' + slug + suffix + ' .popup__content--cikkek').dataset.slug;
						}
						gtag('event', '[EMW] ' + ceg_slug, { 'event_category': 'atkattintas', 'event_label': '[CT] ' + a.href });
						//console.log('[EMW] '+ceg_slug+','+'[CT] '+a.href);
					}, false);
				});
				const ujdonsagBovebben = document.querySelectorAll('#' + slug + suffix + ' .ujdonsag-list a');
				ujdonsagBovebben.forEach(a => {
					a.addEventListener('mouseup', evt => {
						if (evt.which == 3) return;
						if (!a.href.includes('#ujdonsag-')) return;
						let ceg_slug = slug;
						gtag('event', '[EMW] ' + ceg_slug, { 'event_category': 'ujdonsag_bovebben', 'event_label': '[AV] ' + a.title });
						//console.log('[EMW] '+ceg_slug+',[ujdonsag_bovebben] '+'event_label:[AV] '+a.title);
					}, false);
				});

			} catch (error) {
				console.error(`Load error: ${error.message}`);
			}
		} else if (e.newURL.includes('nyeremeny-') || e.newURL.includes('ujdonsag-')) {
			document.documentElement.classList.add('overlay-active');
			if (!isMobile) document.documentElement.style.paddingRight = scrollbarWidth;
		}
		else {
			document.documentElement.classList.remove('overlay-active');
			if (!isMobile) document.documentElement.style.paddingRight = 0;
			if (e.oldURL.includes('-adatok')) {
				//document.querySelector(slug+'-adatok .popup').innerHTML = '';
			}
		}
	}
	window.addEventListener('hashchange', hashchange);
	if (window.location.hash.includes('-adatok') || window.location.hash.includes('-cikk') || window.location.hash.includes('nyeremeny-') || window.location.hash.includes('ujdonsag-')) {
		hashchange({ newURL: window.location.href });
	}
</script>
<?php /*
<section id="tamogatok">
<main>
<h6>Támogatóink</h6>
<ul>
<li><img src="assets/tamogato-alfakepzo.png" height="81"></li>
<li><img src="assets/tamogato-gyemanthegy.png" height="81"></li>
<li><img src="assets/tamogato-matrix.png" height="81"></li>
<li><img src="assets/tamogato-mesto.png" height="81"></li>
<li><img src="assets/tamogato-tusketablak.png" height="81"></li>
</ul>
</main>
</section>


<section >       
<footer style="margin-top:2rem;">
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>">Jegyvásárlás</a>
</footer>			
</section>	



<div class="divider" id="emwvideo"></div>	

<section class="emwvideo">
<header>Tavaly az ÉMW-n</header>
<main>
<div class="fitVids-wrapper">
<iframe src="https://www.youtube.com/embed/G0Y2sTt4WRI?rel=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen="" title=""></iframe>
</div>
</main>		
</section>	

<section id="bwgallery">
<header>Képek a tavalyi ÉMW-ről</header>
<main>  
<div class="bwgallery__scroll bwgallery__scroll--left"><i class="bi bi-chevron-compact-left"></i></div>
<div class="bwgallery">
<?php shuffle($bwgallery); ?>
<?php foreach($bwgallery AS $src) : ?>
<figure>
<img src="<?php echo $src; ?>">
</figure>
<?php endforeach; ?>				
</div>
<div class="bwgallery__scroll bwgallery__scroll--right"><i class="bi bi-chevron-compact-right"></i></div>
</main>
<footer><a target="_blank" class="cta" href="https://static.homeinfo.hu/?event=emw-2023"><i class="bi bi-images"></i> Építőipari Mester Workshop 2023 képek</a></footer>
</section>
<script>initGallery('.bwgallery', isMobile);</script>

<section id="standterkep">

<header>Standtérkép</header>
<main>
<ul id="standTerkepListaFilter">
<li class="on">Mind</li>
<?php foreach ($categories AS $cat) : ?>
<li><?php echo $cat; ?></li>
<?php endforeach; ?>
</ul>


<div id="standTerkep">
<div id="standTerkepLeft">
<ul class="cropped" id="standTerkepLista">      
	<?php foreach ($standok AS $standData) : ?>
	<?php if (empty($standData['slug'])) continue; ?>
	<li data-stand="<?php echo $standData['standNo']; ?>" data-category="Mind <?php echo $standData['cats']; ?>"><?php echo $standData['name']; ?></li>
	<?php endforeach; ?>
</ul>
<button type="button" class="showMoreBtn" data-show-more-id="standTerkepLista"><strong >Mutasd mindet</strong></button>
</div>
<div id="standTerkepRight">   
<div id="standok">          
	<img src="assets/standterkep-alap.png" alt=""> 
	<?php $standNoVolt = array(); ?>
	<?php foreach ($standok AS $standData) : ?>
	<?php if ( in_array($standData['standNo'], $standNoVolt) ) continue; ?>
	<?php $standNoVolt[] = $standData['standNo']; ?>
	<?php list($w,$h) = explode('x',$standData['size']); ?>
	<div class="stand w<?php echo $w; ?> h<?php echo $h; ?> <?php echo (empty($standData['slug'])) ? 'empty' : ''?>" id="stand<?php echo $standData['standNo']; ?>"><?php echo $standData['standNo']; ?></div>
	<?php endforeach; ?>							   
</div>
</div>
</div>
<script type="module">
import { standTerkepInit } from './standterkep.js';					
standTerkepInit();
</script>
</main>
</section>
*/ ?>
<section>
	<footer style="margin-top:2rem;">
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>



<?php /*



<div class="divider" id="ravakKepzes"></div>

<style>
.ravak-kepzes  {display:flex;flex-direction:column;   background: #eee;     }
.ravak-kepzes img {display: block;  width: 100%;  height: auto;  aspect-ratio: 580 / 300;}
.ravak-kepzes div {padding: 1rem;display:flex;flex-direction:column;gap:1rem;}
@media (min-width: 768px) {
.ravak-kepzes  {flex-direction:row;align-items: center;}
.ravak-kepzes div {width:50%;padding: 2rem;}
.ravak-kepzes figure {width:50%;max-width: 580px;}
.ravak-kepzes p {}
}		
@media (min-width: 1024px) {
.ravak-kepzes div {width:50%;padding:2rem 4rem; flex-grow: 1; font-size: large;}

}
</style>
<section>	
<main>
<div class="ravak-kepzes">
<figure>          
<a href="https://www.homeinfo.hu/emw/ravak-kepzes.php" target="_blank"><img src="../emw/files/ravak/kepzes-banner2.webp" alt=""></a> 
</figure>	
<div>	
<h3>Időpontfoglalás RAVAK Fürdőszoba Mester képzésre</h3>
<p>Az Építőipari Mester Workshown lehetőség van a látogatók számára regisztrációra a RAVAK standhoz, ahol a márkaszervies csapat bemutatja a szakszerű RAVAK kád és zuhanykabin telepítés legfontosabb mozzanatait. A helyszínen alkalom van a 2 napos RAVAK Fürdőszoba Mester képzésre is jelentkezni.</p>	
<a class="btn" href="https://www.homeinfo.hu/emw/ravak-kepzes.php" target="_blank">Időpontfoglalás</a>
</div>	
</div>	
</main>
</section>		


<div class="divider" id="DewaltChallenge"></div>
<style>
.dewalt-challenge-section  {display:flex; align-items: center; padding-top: 0;  padding-bottom: 0;position: relative;    width: 100%;background-color:rgb(238, 238, 238);}
.dewalt-challenge {display:flex; flex-wrap: wrap; justify-content: center;    }
.dewalt-challenge-item {}
.dewalt-challenge-image {visibility:hidden;width:100%;}
.dewalt-challenge-content {}
.dewalt-challenge-content-block {background-color:rgb(238, 238, 238);  padding:2rem; position: relative;  z-index:2;}
.dewalt-challenge-wyswig {display:flex;flex-direction:column;gap:1rem; }
.dewalt-challenge-wyswig ul {margin-left:2rem;}
@media (min-width: 768px) {
.dewalt-challenge { flex-wrap: nowrap; }
.dewalt-challenge-item { display: flex;  width:50%; align-items: center; }
.dewalt-challenge-content-block { margin-left:0rem; background-color:rgb(238, 238, 238); }
}		
@media (min-width: 1024px) {

}
</style>	
<section><main>
<div class="dewalt-challenge-section">
<div class="dewalt-challenge"> 

<div class="dewalt-challenge-item" style="background:url(https://www.homeinfo.hu/emw/assets/dewalt-challenge.webp);   background-position: center;    background-size: cover;">      
<div class="dewalt-challenge-image">
<img loading="lazy" src="https://www.homeinfo.hu/emw/assets/dewalt-challenge.webp" title="DEWALT 3-Thru-3 Challenge contenders playing the game" alt="DEWALT 3-Thru-3 Challenge contenders playing the game" >
</div>
</div>  


<div class="dewalt-challenge-item">  	
<div class="dewalt-challenge-content">  	   
<div class="dewalt-challenge-content-block">  	   
<div class="dewalt-challenge-wyswig">  	   
<h2> VEGYEN RÉSZT </h2>                   
<p>Készen áll arra, hogy próbára tegye képességeit? Keressen egy <strong>3-THRU-3 Challenge</strong>: 100 Éves Kiadás eseményt az Ön közelében, és vegyen részt rajta!</p>
<p><strong>Kezdés:</strong></p>
<ul>
	<li>péntek 11.00 és 15.00</li>
	<li>szombat 11.00 és 15.00</li>
</ul>	
<p><strong>Díjak:</strong></p>					
<ul>
<li>1. díj: DEWALT furgon + 10 000 dollár értékű DEWALT szerszám</li>
<li>2. díj: 10 000 dollár értékű DEWALT szerszám</li>
<li>3. díj: 5000 dollár értékű DEWALT szerszám</li>
</ul>					
<a class="btn" href="https://www.dewalt.hu/3-thru-3" target="_blank">Esemény információk</a>      	   	    
</div> 
</div> 
</div> 
</div> 

</div> 
</div> 
</main>
</section>	
<section >       
<footer style="margin-top:2rem;">
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>">Jegyvásárlás</a>
</footer>			
</section>
*/ ?>


<div class="divider" id="ujdonsagok"></div>
<section>
	<header>
		<?php echo __('emw.prods_title'); ?>
	</header>
	<main>
		<div id="ujdonsagokLista" style="display: flex;flex-wrap: wrap;  ">
			<?php

			$lang = isset($_GET['lang']) ? $_GET['lang'] : null;
			$ujdonsagok = ($lang === 'en') ? $ujdonsagok_en : $ujdonsagok;

			foreach ($ujdonsagok as $slug => $items): ?>




				<div class="ujdonsag-list" style="">
					<?php foreach ($items as $i => $item): ?>
						<?php $src = (isset($item['file'])) ? $item['file'] : 'assets/ujdonsagok-' . $slug . '-' . ++$i . '.webp'; ?>
						<div class="ujdonsag-list-item" style="">
							<figure>
								<img loading="lazy" class="company-logo" src="/cegkereso/files/logo/<?php echo $slug; ?>.png"
									width="140" height="140" alt="">
								<?php if ($item['title'] === 'Kesseböhmer ChefsTable'): ?>

									<div class="kachel-grid-wrapper-2 product-photo">
										<div data-poster-url="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-poster-00001.jpg"
											data-video-urls="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.mp4,https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.webm"
											data-autoplay="true" data-loop="true" data-wf-ignore="true"
											class="background-video w-background-video w-background-video-atom">
											<video style="height: 15em; aspect-ratio: 385 / 252;" autoplay loop muted playsinline
												data-wf-ignore="true" data-object-fit="cover">
												<source
													src="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.mp4"
													data-wf-ignore="true">
												<source
													src="https://cdn.prod.website-files.com/64073cb5154efbf4f9b17dc6%2F681dc0a7c8001e522039b7a7_ChefsTable_Function%20of%20the%20product_3-2-transcode.webm"
													data-wf-ignore="true">
											</video>
										</div>
									</div>
								<?php else: ?>
									<img loading="lazy" class="product-photo" src="<?php echo $src; ?>?1" width="385" height="252"
										alt="">
								<?php endif; ?>
							</figure>
							<h2>
								<?php echo $item['title']; ?>
							</h2>
							<div class="et_pb_text_inner" data-slug="<?php echo $slug; ?>"
								data-title="<?php echo htmlEntities($item['title'], ENT_QUOTES); ?>">
								<div>
									<?php if (is_array($item['desc'])): ?>
										<ul>
											<?php foreach ($item['desc'] as $listItem): ?>
												<li>
													<?php echo $listItem; ?>
												</li>
											<?php endforeach; ?>
										</ul>
									<?php else: ?>
										<p>
											<?php echo nl2br($item['desc']); ?>
										</p>
									<?php endif; ?>
									<?php if (!empty($item['feats'])): ?>
										<ul>
											<?php foreach ($item['feats'] as $listItem): ?>
												<li>
													<?php echo $listItem; ?>
												</li>
											<?php endforeach; ?>
										</ul>
									<?php endif; ?>
									<?php if (!empty($item['more'])): ?>
										<p><a href="<?php echo withUTM($item['more']['href']); ?>" target="_blank">
												<?php echo $item['more']['title']; ?> &rarr;
											</a></p>
									<?php endif; ?>
								</div>
							</div>
						</div> <!-- .ujdonsag-list-item -->

						<div id="ujdonsag-<?php echo $slug; ?>-<?php echo $i; ?>" class="overlay">
							<div class="popup">
								<div class="popup__content">
									<div class="popup__content__header">
										<figure><img src="<?php echo $src; ?>" alt=""></figure>
										<h3><?php echo $item['title']; ?></h3>
									</div>
									<div class="popup__content__description">
										<?php if (is_array($item['desc'])): ?>
											<ul>
												<?php foreach ($item['desc'] as $listItem): ?>
													<li><?php echo $listItem; ?></li>
												<?php endforeach; ?>
											</ul>
										<?php else: ?>
											<p><?php echo nl2br($item['desc']); ?></p>
										<?php endif; ?>
										<?php if (!empty($item['feats'])): ?>
											<ul>
												<?php foreach ($item['feats'] as $listItem): ?>
													<li><?php echo $listItem; ?></li>
												<?php endforeach; ?>
											</ul>
										<?php endif; ?>
										<?php if (!empty($item['more'])): ?>
											<p><a href="<?php echo withUTM($item['more']['href']); ?>"
													target="_blank"><?php echo $item['more']['title']; ?> &rarr;</a></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>
						</div>

					<?php endforeach; ?>
				</div>
			<?php endforeach; ?>

		</div> <!-- .ujdonsag-list -->

		<button type="button" class="showMoreBtn" data-show-more-id="ujdonsagokLista" style="top:0;"><strong>Mutasd
				mindet</strong></button>
	</main>

	<footer style="margin-top:2rem;">
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>

</section>
<script>
	(function ($) {

		var $parents = $('.ujdonsag-list .et_pb_text_inner');
		var $titles = $parents.find('h2');
		var $texts = $parents.find('div');

		$texts.hide();

		$parents.each(function (index, value) {
			$(this).append('<a class="bovebben" href="#bovebben" data-slug="' + this.dataset.slug + '" data-title="' + this.dataset.title + '">&plus; <?php echo __('show.more'); ?></a>');
		});

		$('.ujdonsag-list .et_pb_text_inner').on('click', 'a.bovebben', function (e) {
			e.preventDefault();
			var $a = $(this);
			if ($a.text() == '+ <?php echo __('show.more'); ?>') {
				$a.parent().find('div').show().end().end().html('&times; <?php echo __('show.less'); ?>');
				gtag('event', '[EMW] ' + this.dataset.slug, { 'event_category': 'ujdonsag_bovebben', 'event_label': '[AV] ' + this.dataset.title });
				//console.log('[EMW] '+this.dataset.slug+',[ujdonsag_bovebben] '+'event_label:[AV] '+this.dataset.title);
			} else {
				$a.parent().find('div').hide().end().end().html('&plus; <?php echo __('show.more'); ?>');
			}

		});

	})(jQuery);
</script>

<?php include('_quizblock.inc.php') ?>

<div class="divider" id="helyszin"></div>
<section>
	<header><?php echo __('title.location'); ?></header>
	<main>
		<h2><strong><?php echo __('emw.hall'); ?></strong></h2>

		<p><a href="assets/emw_3dterkep.webp" target="_blank"><img loading="lazy"
					style="max-width:960px;margin:auto;width:100%;"
					src="assets/emw_3dterkep_<?php echo $_GET['lang'] ?? 'hu'; ?>.webp" alt=""></a></p>
		<p style="max-width:738px;margin:1rem auto;">
			<?php echo __('emw.open'); ?>
			<br>
			<br>
			<?php echo __('emw.arena'); ?>
	</main>
	<?php /*	
<footer style="margin-top:2rem;">
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>">Jegyvásárlás az eseményre</a>
</footer> 
*/ ?>
</section>

<?php /*	
<div class="divider" id="programok"></div>
<section>
<header>Programok</header>
<main>  			

<div class="programok cropped" id="programokLista">
<?php foreach ($programok AS $eloadas) : ?>	
<div class="programok__item">
<div class="programok__item__body">				
	<header class="programok__item__body_header">
		<div class="programok__item__body_header__icon">
			<i class="bi bi-clock"></i>
		</div>		
		<div class="programok__item__body_header__time">
			<time datetime="2023-10-06"><?php echo $eloadas['idopont']; ?></time>
		</div>	
	</header>	
	<article class="programok__item__body_content">
		<figure class="programok__item__body_content__logo">
			<img loading="lazy" class="company-logo" src="assets/logo-<?php echo (is_array($eloadas['slug'])) ? $eloadas['slug'][0] : $eloadas['slug']; ?>.png" width="140" height="140" alt="">
			<?php if  (is_array($eloadas['slug'])) : ?>
			<img loading="lazy" class="company-logo" src="assets/logo-<?php echo  $eloadas['slug'][1]; ?>.png" width="140" height="140" alt="">
			<?php endif; ?>
			<figcaption><?php echo $cegek[$eloadas['slug']]['name']; ?></figcaption>
		</figure>
		<div class="programok__item__body_content__title">
			<h3><?php echo $eloadas['title']; ?></h3>
		</div>							
		<div class="programok__item__body_content__stand">
			<span><?php echo $cegek[$eloadas['slug']]['stand']['no']; ?>. stand</span>
		</div>	
	</article>						
</div>					
</div>
<?php endforeach; ?>
</div>
<button type="button" class="showMoreBtn" data-show-more-id="programokLista" style="top:0;"><strong >Mutasd mindet</strong></button>	

<p class="py-3">Továbbá&hellip;</p>
<ul class="list">
<li>Gépek és szerszámok bemutatója és kipróbálása</li>
<li>Vágási, ragasztási, csiszolási technikák</li>
<li>Burkolási segédanyagok használata</li>
<li>Nagy lapok felrakása</li>
<li>Innovációk, újdonságok</li>
<li>Akciós vásárlási lehetőség</li>
<li>Ajándékok</li>
</ul>      	  	
</main>
</section>   
*/ ?>

<?php /*
<div class="divider" id="jegyvasarlas"></div>
<section class="jegyvasarlas">        
<header>Jegyvásárlás</header>		
<main>
<div class="text-center">	 
<p>
<strong>Belépőjegy applikációban</strong>				
<br><strong><big style="font-size: 24px;"><?php echo $jegyvasalasConfig['brutto_egysegar_app']; ?> Ft</big></strong>
<br><small>Az applikációs jegyek nyereményjátékban vesznek részt! A nyereményeket lásd lejjebb.</small>
<br><small>18 év alatt - nagykorú felügyelete mellett - a belépés ingyenes.</small>
<br>
<br><a class="cta" href="<?php echo $JEGYVASARLAS_LINK; ?>" target="_blank">Megvásárolom</a>	
<br><a href="http://simplepartner.hu/PaymentService/Fizetesi_tajekoztato.pdf" target="_blank">
<img style="width:100%;max-width:320px;margin:15px auto 0;display:block;    padding: 10px 15px;   background: #fff;" id="SimplePayImg" src="/jegyvasarlas/assets/simplepay_bankcard_logos_left.png" title=" SimplePay - Online bankkártyás fizetés" alt=" SimplePay vásárlói tájékoztató"> 
</a>
<br>Nyomtatható és helyszíni jegyár <?php echo $jegyvasalasConfig['brutto_egysegar']; ?> Ft.		

</p>
<p></p>

</div>
</main>
</section>	
*/ ?>
<section>
	<footer style="margin-top:2rem;">
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>
</section>


<div class="divider" id="nyeremenyek"></div>

<section id="tombola">
	<header><?php echo __('emw.prizes.local'); ?></header>
	<main>
		<div class="felajanlas-list cropped" id="nyeremenyekLista">
			<?php
			$lang = isset($_GET['lang']) ? $_GET['lang'] : null;
			$nyeremenyek = ($lang === 'en') ? $nyeremenyek_en : $nyeremenyek;
			foreach ($nyeremenyek as $slug => $items): ?>
				<?php foreach ($items as $i => $item): ?>
					<?php $logo = (!empty($item['logo'])) ? $item['logo'] : $slug; ?>
					<?php $num = (!empty($item['filename'])) ? $item['filename'] : $i + 1; ?>
					<div class="felajanlas-item">
						<figure>
							<img loading="lazy" class="company-logo" src="assets/logo-<?php echo $logo; ?>.png" width="140"
								height="140" alt="">
							<img loading="lazy" class="product-photo"
								src="assets/tombola-<?php echo $slug; ?>-<?php echo $num; ?>.webp?21" alt="">
						</figure>
						<h4><span><?php echo $item['title']; ?></span><span><?php echo $item['price']; ?></span></h4>
						<div>
							<?php if (is_array($item['desc'])): ?>
								<ul>
									<?php foreach ($item['desc'] as $listItem): ?>
										<li><?php echo $listItem; ?></li>
									<?php endforeach; ?>
								</ul>
							<?php else: ?>
								<p><?php echo $item['desc']; ?></p>
							<?php endif; ?>
						</div>
					</div> <!-- /felajanlas-item -->

					<div id="nyeremeny-<?php echo $slug; ?>-<?php echo $i; ?>" class="overlay">
						<div class="popup">
							<div class="popup__content">
								<div class="popup__content__header">
									<figure><img src="assets/tombola-<?php echo $slug; ?>-<?php echo $num; ?>.webp?12" alt="">
									</figure>
									<h3><?php echo $item['title']; ?></h3>
								</div>
								<div class="popup__content__description">
									<?php if (is_array($item['desc'])): ?>
										<ul>
											<?php foreach ($item['desc'] as $listItem): ?>
												<li><?php echo $listItem; ?></li>
											<?php endforeach; ?>
										</ul>
									<?php else: ?>
										<p><?php echo $item['desc']; ?></p>
									<?php endif; ?>
								</div>
							</div>
						</div>
						<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>
					</div>

				<?php endforeach; ?>
			<?php endforeach; ?>
		</div>
		<button type="button" class="showMoreBtn" data-show-more-id="nyeremenyekLista" style="top:0;"><strong>Mutasd
				mindet</strong></button>
	</main>
	<footer><?php echo __('emw.prizes.more'); ?></footer>

	<footer style="margin-top:1rem;">
		<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>"><?php echo __('emw.ticket'); ?></a>
	</footer>

</section>
<?php /*	
<section id="tombola">        
<header>Nyeremények a standokon</header>	
<main> 
<div class="felajanlas-list cropped" id="nyeremenyStandonLista">			
<?php foreach ($nyeremenyekStandon AS $slug => $items) : ?>
<?php foreach ($items AS $i => $item) : ?>
<?php $logo = ( ! empty($item['logo'])) ? $item['logo'] : $slug; ?>
<div class="felajanlas-item">
<figure>
	<img loading="lazy" class="company-logo" src="assets/logo-<?php echo $logo; ?>.png" width="140" height="140" alt="">
	<img loading="lazy" class="product-photo" src="assets/tombola-standon-<?php echo $slug; ?>-<?php echo ++$i; ?>.webp?3" alt="">
</figure>
<h4><span><?php echo $item['title']; ?></span><span><?php echo $item['price']; ?></span></h4>					
<div>
	<?php if(is_array($item['desc'])): ?>
	<ul>
		<?php foreach ($item['desc'] AS $listItem) : ?>
		<li><?php echo $listItem; ?></li>
		<?php endforeach; ?>
	</ul>
	<?php else: ?>
	<p><?php echo $item['desc']; ?></p>
	<?php endif; ?>
</div>				
</div> <!-- /felajanlas-item -->

<div id="nyeremeny-<?php echo $slug; ?>-<?php echo $i; ?>" class="overlay">
<div class="popup">				
	<div class="popup__content">
		<div class="popup__content__header">
			<figure><img src="assets/tombola-standon-<?php echo $slug; ?>-<?php echo $i; ?>.webp?12" alt=""></figure>
			<h3><?php echo $item['title']; ?></h3>			
		</div>				
		<div class="popup__content__description">
			<?php if(is_array($item['desc'])): ?>
			<ul>
				<?php foreach ($item['desc'] AS $listItem) : ?>
				<li><?php echo $listItem; ?></li>
				<?php endforeach; ?>
			</ul>
			<?php else: ?>
			<p><?php echo $item['desc']; ?></p>
			<?php endif; ?>		
		</div>	
	</div>		
</div>
<a class="overlay__close" href="#<?php echo $slug; ?>-adatok">&times;</a>	
</div>

<?php endforeach; ?>
<?php endforeach; ?>									
</div>	
<button type="button" class="showMoreBtn" data-show-more-id="nyeremenyStandonLista" style="top:0;"><strong >Mutasd mindet</strong></button>	
</main> 


<footer style="margin-top:1rem;">
<a class="btn" href="<?php echo $JEGYVASARLAS_LINK; ?>">Jegyvásárlás</a>
</footer>	

</section>	
*/ ?>


<?php /*
<div class="divider"></div>	

<section id="facebookcsoport">   
<main>
<a href="https://www.facebook.com/groups/epitoiparimesterworkshop/" target="_blank"><img loading="lazy" src="assets/emw-csoport-banner.webp" alt="ÉMW Facebook zárt csoport" title="Csatlakozz zárt Facebook csoportunkhoz!"></a>
</main>	
</section>	
*/ ?>


<div class="divider"></div>

<section id="mediamegjelensek">
	<header><?php echo __('emw.media'); ?></header>
	<ul id="mediaLista">
		<li><a href="https://www.homeinfo.hu/" target="_blank"><img loading="lazy" src="assets/media-homeinfo.png"></a>
		</li>
		<li><a href="https://www.tradefairdates.com" target="_blank"><img loading="lazy"
					src="assets/media-tradefairdates.png"></a></li>
		<?php /*
<li><a href="https://www.daibau.hu/" target="_blank"><img loading="lazy" src="assets/media-daibau.png"></a></li>
<li><a href="https://jazzy.hu/" target="_blank"><img loading="lazy" src="assets/media-jazzy.png"></a></li>
<li><a href="https://karcfm.hu/" target="_blank"><img loading="lazy" src="assets/media-karcfm.png"></a></li>
<li><a href="https://rtl.hu/" target="_blank"><img loading="lazy" src="assets/media-rtl.png"></a></li>
<li><a href="https://tv2play.hu/" target="_blank"><img loading="lazy" src="assets/media-tv2.png"></a></li>
<li><a href="https://www.viasat3.hu/" target="_blank"><img loading="lazy" src="assets/media-viasat3.png"></a></li>
*/ ?>
	</ul>
</section>
<?php /*	
<div class="divider" id="bwvideo"></div>	

<section class="bwvideo">
<header>Videó a januári Országos Burkolói Workshopról</header>
<main>
<div class="fitVids-wrapper">
<iframe src="https://www.youtube.com/embed/AsFp4ToRW8c?rel=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen="" title=""></iframe>
</div>
</main>		
</section>			


<div class="divider"></div>	

<section id="tovabbiesemenyek">   
<header>További kiállításaink</header>	
<div class="following-events">
<div><a href="https://www.furdoszoba-kiallitas.hu/" target="_blank" title="Fürdőszoba és Otthoni Wellness Kiállítás" data-ga-event="kiallitasok"><img src="/assets/homeinfo2017/images/events-banner-fs-2024-374x70.webp" width="374" height="70" alt=""></a></div>	
<div><a href="https://www.furdoszoba-kiallitas.hu/burkoloi-workshop/" target="_blank" title="Burkolói Workshop" data-ga-event="kiallitasok"><img src="/assets/homeinfo2017/images/events-banner-bw-2024-374x70.webp" width="374" height="70" alt=""></a></div>			
<div><a href="https://www.butor-lampa-textil-kiallitas.hu/" target="_blank" title="Bútor, Lámpa, Lakástextil Kiállítás" data-ga-event="kiallitasok"><img src="/assets/homeinfo2017/images/events-banner-vk-2024-374x70.webp" width="374" height="70" alt=""></a></div>
</div>		
</section>	
*/ ?>
<footer id="pageFooter">

	<p style="text-align: center;">
		<?php echo __('emw.event_footer'); ?>
		<br>&copy;<?php echo date('Y'); ?> Develon Kft. - <a style="text-decoration:underline;"
			href="https://www.homeinfo.hu/latogatoi-szabalyzat-tajekoztato">
			<?php echo __('emw.event_footer_link'); ?></a>
	</p>

</footer>

<script>
	document.addEventListener('click', function (event) {
		let gaEvent = event.target.dataset.gaEvent;
		if (!gaEvent) return;
		gtag('event', '[EMW] ' + gaEvent, { 'event_category': 'kattintás', 'event_label': event.target.textContent });
	});	
</script>

<a href="#" id="scrollToTop" title="Lap teteje" style="display: none;"><?php echo __('emw.up'); ?></a>
<script>
	(function ($) {
		var $scrollToTop = $('#scrollToTop');
		$(window).scroll(function () {
			if ($(this).scrollTop() > 100) {
				$scrollToTop.fadeIn();
			} else {
				$scrollToTop.fadeOut();
			}
		});
		$scrollToTop.click(function (e) {
			e.preventDefault();
			$('html, body').animate({ scrollTop: 0 }, 500);
		});
	})(jQuery);
</script>
<script>

	function toggleUjdonsagList(logoElement) {
		const ujdonsagList = logoElement.nextElementSibling;
		if (ujdonsagList && ujdonsagList.classList.contains('ujdonsag-list')) {
			if (ujdonsagList.style.display === 'none' || !ujdonsagList.style.display) {
				ujdonsagList.style.display = 'grid';
			} else {
				ujdonsagList.style.display = 'none';
			}
		}
	}
</script>

<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>

</body>

</html>