<?php
require_once('data.php');
require_once('top.inc.php');
?>

<div class="bg-[#f8f9ff] text-black pt-[64px] md:pt-[72px]">

	<header
		class="py-3 px-4 sm:px-10 z-50 fixed w-full top-0 left-0 transition-all bg-white bg-opacity-90"
		id="mainNavbar">
		<div class="relative flex items-center justify-between gap-4">
			<div class="flex items-center">
				<a href="<?php echo EVENT_URL; ?>"
					class="hover:text-blue-600 block font-semibold transition-all text-xs sm:text-sm">&larr; <?php echo __('back.asvisitor'); ?></a>
			</div>
			<div class="flex items-center">
				<a href="<?php echo EVENT_URL; ?>"><img src="assets/header-logo.png" alt="logo" class="h-10 md:h-12" /></a>
			</div>
			<div class="flex items-center gap-6 ">
				<a href="#ajanlatkeres" data-ga-event="Ajánlatkérés"
					class="bg-blue-600 hover:bg-blue-700 transition-all text-white md:font-bold text-xs md:text-sm rounded-lg md:px-5 md:py-3 px-3 py-2"><?php echo __('button.offer'); ?></a>

				<nav class="flex mx-auto gap-2">
					<?php echo language_switcher_links(); ?>
				</nav>
			</div>

		</div>
	</header>
	<img src="https://www.homeinfo.hu/emw/assets/emw2025_fejlec_kiallitoknak_<?php echo $_GET['lang'] ?? 'hu'; ?>.webp?1" class="" alt="">
	<div class="bg-gradient-to-b from-blue-900 via-blue-800 to-blue-500 text-white py-12 xl:py-16 px-4  sm:px-10">

		<div class="max-w-7xl mx-auto">
			<div class="lg:px-5 text-center ">
				<?php // <img src="https://www.homeinfo.hu/assets/homeinfo2017/images/homeinfo-logo-124x54.tudastar.png" class="mx-auto mb-6" alt=""> 
				?>
				<img src="https://www.homeinfo.hu/emw/assets/homeinfo-logo.png" class="mx-auto mb-6" alt="">
				<h2 class="lg:text-5xl md:text-4xl text-3xl font-extrabold mb-4 lg:!leading-[55px]">
					<?php echo __('exhibitors_title'); ?></h2>
				<p class=" mt-4 text-base leading-relaxed"><?php echo __('exhibitors_lead'); ?></p>
			</div>
		</div>

		<?php
		$stats = [
			/*[
				'title' => __('stat.1.title'),
				'value' => '3107',
			],*/

			/*[
				'title' => __('stat.3.title'),
				'value' => '95%',
			],*/
			[
				'title' => __('stat.7.title'),
				'value' => '12 000',
			],
			[
				'title' => __('stat.5.title'),
				'value' => '100+',
			],
			[
				'title' => __('stat.6.title'),
				'value' => '150+',
			],
			[
				'title' => __('stat.2.title'),
				'value' => '50+',
			],


		];
		?>
		<div class="mx-auto max-w-7xl py-2 mt-8">
			<div class="grid grid-cols-2 md:grid-cols-4 row-gap-8">
				<?php foreach ($stats as $index => $stat) : ?>
					<div class="mb-12 text-center md:mb-0 md:px-2 <?php echo ($index < count($stats) - 1) ? 'md:border-r-2' : ''; ?>">
						<div class="font-heading text-[2.6rem] font-bold  md:text-2xl lg:text-4xl">
							<?php echo $stat['value']; ?>
						</div>
						<p class="text-sm font-medium md:text-xs lg:text-sm tracking-widest ">
							<?php echo $stat['title']; ?>
						</p>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
		<?php
		$testimonials = array(
			array(
				'quote' => __('testimonals.aco.quote'),
				'name' => '',
				'title' => '',
				'company' => 'ACO Kereskedelmi Kft.',
				'slug' => 'aco',
			),
			array(
				'quote' => __('testimonals.casati.quote'),
				'name' => 'ŐSZ SZABÓ Dóra',
				'title' => 'Marketing',
				'company' => 'Casati Color Hungary',
				'slug' => 'casati',
			),
			array(
				'quote' => __('testimonals.rockwool.quote'),
				'name' => 'SOMLÓSI Károly',
				'title' => 'Marketing Manager',
				'company' => 'ROCKWOOL Hungary Kft.',
				'slug' => 'rockwool',
			),
			array(
				'quote' => __('testimonals.wendy.quote'),
				'name' => '',
				'title' => __('Képviselet vezető'),
				'company' => 'Wendy 2003 Bt.',
				'slug' => 'wendy',
			),
		);
		if (isset($_GET['faipar'])) {
			array_unshift($testimonials, array(
				'quote' => __('testimonals.metabo.quote'),
				'name' => 'GUBEK József',
				'title' => '',
				'company' => 'Metabo Hungária Kft.',
				'slug' => 'metabo',
			));
		}
		?>

		<section class=" mt-8 relative px-5 xl:px-16">
			<div class="mx-auto max-w-7xl ">

				<!-- Scrollable Container -->
				<div class=" flow-root">
					<div class="">
						<!-- Add 'no-scrollbar' class here if you want to hide the scrollbar -->
						<div class="overflow-x-auto pb-8 no-scrollbar">
							<div class="swiper-container testimonial-swiper flex space-x-6 sm:space-x-8 ">
								<div class="swiper-wrapper">
									<!-- Quote Cards  -->
									<?php foreach ($testimonials as $index => $item) : ?>
										<div class="swiper-slide flex flex-col w-full h-auto sm:w-96 flex-shrink-0 rounded-xl bg-white p-6 shadow-lg ring-1 ring-gray-900/5">
											<blockquote class="flex-grow text-gray-700 text-base">
												<p>"<?php echo $item['quote']; ?>"</p>
											</blockquote>
											<figcaption class="mt-6 flex items-center gap-x-4 border-t border-gray-200 pt-6">
												<img src="/cegkereso/files/logo/<?php echo $item['slug']; ?>.png"
													class="shrink-0 w-12 h-12 rounded-full max-sm:mb-2 shadow p-1" alt="<?php echo $item['slug']; ?> logo">
												<div>
													<div class="font-semibold text-sm text-gray-700"><?php echo (!empty($item['name'])) ? $item['name'] : ''; ?></div>
													<div class="mt-0.5 text-xs text-gray-600"><?php echo (!empty($item['title'])) ? $item['title'] . ', ' . $item['company'] : $item['company']; ?></div>
												</div>
											</figcaption>
										</div>
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
			<!-- Navigation Buttons: Now INSIDE swiper-container for better relative positioning -->
			<div class="testimonial-swiper-prev absolute top-1/2 -translate-y-10 left-0 xl:left-3 z-10 rounded-full shadow-md cursor-pointer transition-opacity">
				<span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-white/30  group-hover:bg-white/50  group-focus:ring-4 group-focus:ring-white  group-focus:outline-none">
					<svg class="w-4 h-4 text-blue-600 xl:text-white  rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
						<path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 1 1 5l4 4"></path>
					</svg>
					<span class="sr-only"><?php echo __('pager.prev'); ?></span>
				</span>
			</div>
			<div class="testimonial-swiper-next absolute top-1/2 -translate-y-10 right-0 xl:right-3 z-10  rounded-full shadow-md cursor-pointer transition-opacity">
				<span class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-white/30 group-hover:bg-white/50  group-focus:ring-4 group-focus:ring-white  group-focus:outline-none">
					<svg class="w-4 h-4 text-blue-600 xl:text-white  rtl:rotate-180" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
						<path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"></path>
					</svg>
					<span class="sr-only"><?php echo __('pager.next'); ?></span>
				</span>
			</div>
		</section>
		<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
		<script>
			// Initialize Swiper
			var swiper = new Swiper('.testimonial-swiper', {
				slidesPerView: 'auto', // Important:  'auto' allows slides to size themselves
				spaceBetween: 24, // Space between slides.  Adjust to match your `space-x-*` values.
				grabCursor: true, // Show grab cursor on desktop
				// Optional parameters
				loop: true, // Autoplay often works best with loop: true
				// Autoplay configuration
				autoplay: {
					delay: 5000, // Time in milliseconds (5 seconds)
					disableOnInteraction: true, // Autoplay will be disabled after user interactions (swipes, clicks)
					// pauseOnMouseEnter: true, // Optional: Pauses autoplay when mouse enters swiper container
				},
				// Navigation arrows (you can add these, see Swiper docs if desired)
				navigation: {
					nextEl: '.testimonial-swiper-next',
					prevEl: '.testimonial-swiper-prev',
				},
				// Responsive breakpoints
				breakpoints: {
					// when window width is >= 640px (sm)
					640: {
						slidesPerView: 1,
						spaceBetween: 20
					},
					// when window width is >= 768px (md)
					768: {
						slidesPerView: 2,
						spaceBetween: 24
					},
					// when window width is >= 1024px (lg)
					1024: {
						slidesPerView: 3,
						spaceBetween: 24
					}
				},
			});
		</script>


	</div>
	<div class="px-4 sm:px-10">
		<div class="mt-[-30px] max-w-7xl mx-auto">

			<!-- <iframe class="w-full  aspect-[16/9]" src="https://docs.google.com/presentation/d/14ylBCq6UiREd0zAsJp_1lpUlEGLv-XCX47rx3Z3sVWI/embed?slide=id.g3414aa2ac29_0_0" width="960" height="769" allowfullscreen="true" mozallowfullscreen="true" webkitallowfullscreen="true"></iframe> -->
			<?php
			//$videoId = 'tHVSFAnUDK4';
			$videoId = 'G0Y2sTt4WRI';
			if (isset($_GET['lang']) AND $_GET['lang'] !== 'hu' )
				$videoId = 'XReciF6ZUtc';
			?>
			<iframe
				src="https://www.youtube.com/embed/<?php echo $videoId; ?>?controls=1&amp;showinfo=0&amp;rel=0&amp;autoplay=1&amp;mute=1&amp;loop=1&amp;playlist=<?php echo $videoId; ?>"
				allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
				frameborder="0" allowfullscreen="" class="aspect-video w-full max-h-[80vh] rounded-lg"></iframe>


			<?php $gallery = array(
				['img' =>  'emw24-27.jpg', 'thumb' => '80af827e8bfbf9476b4a4f03737ed2311a250665.jpg'],
				['img' =>  'emw24-26.jpg', 'thumb' => '46c1d7b410ae020e4e6112e05fc65e6bf63413a7.jpg'],
				['img' =>  'emw24-36.jpg', 'thumb' => 'b17973cfea050a8e2473bcd876a9def342b4f01d.jpg'],
				['img' =>  'emw24-78.jpg', 'thumb' => '67028c0fb22fbcb7b37dd471619b1403f4da91ed.jpg'],
				['img' =>  'emw24-82.jpg', 'thumb' => '36a7ae1fd6b463e9a262dbb159906d072fb47465.jpg'],
				['img' =>  'emw24-85.jpg', 'thumb' => '4854ef8cbb3b8662dac1331ce1ee5250d1e28afd.jpg'],
				['img' =>  'emw24-94.jpg', 'thumb' => '2e6f98be5fc7f4eb24c0c89fd87a290669bb6a9b.jpg'],
				['img' =>  'emw24-126.jpg', 'thumb' => '891e5d1b58cd6733cbe81e60f4774b351d2d5461.jpg'],
				['img' =>  'emw24-154.jpg', 'thumb' => '50accc8c17409480e5f515e0b5d23c6f13460d3a.jpg'],
				['img' =>  'emw24-231.jpg', 'thumb' => 'ce309e137c229900c8a59b335f2a487b0ae40c41.jpg'],
				['img' =>  'emw24-235.jpg', 'thumb' => '9419ef770e0962f2cb4e5bfed1e333ecbbcaa57d.jpg'],
				['img' =>  'emw24-296.jpg', 'thumb' => '7c781bd3871a8064def88a97f812bcd58b64aa64.jpg'],
				['img' =>  'emw24-227.jpg', 'thumb' => '963d23df8763aaaf267aaf0d4ead0258f1ddffa6.jpg'],
				// ['img' =>  'emw24-326.jpg', 'thumb' => 'e445ec3b19bd1018305a25e70845cdf4702b0b96.jpg'],
			); ?>
			<div class="container mt-8 sm:mt-20">
				<div x-data="{activeIndex: 1}" class="xl:flex xl:h-[534px] xl:gap-4">
					<div class="mb-4 xl:mb-0 xl:w-3/4 ">
						<div class="overflow-hidden rounded-xl">
							<?php foreach ($gallery as $index => $item) : ?>
								<img loading="lazy" x-show="activeIndex === <?php echo $index + 1; ?>"
									src="https://static.homeinfo.hu/files/emw-2024/<?php echo $item['img']; ?>"
									alt="gallery image" class="block w-full h-full aspect-[956/536] object-cover object-center">
							<?php endforeach; ?>
						</div>
					</div>
					<div class="w-full overflow-x-auto  xl:flex-1 xl:w-1/4  xl:overflow-x-hidden xl:overflow-y-auto">
						<div class="flex items-center gap-2 sm:gap-4  xl:flex-col xl:gap-2">
							<?php foreach ($gallery as $index => $item) : ?>
								<button @click="activeIndex = <?php echo $index + 1; ?>" :class=" activeIndex === <?php echo $index + 1; ?> ? 'border-blue-500' : 'border-transparent' " class="shrink-0 max-w-[100px] md:max-w-none aspect-[956/536] overflow-hidden rounded-lg border lg:rounded-xl">
									<img loading="lazy" src="https://static.homeinfo.hu/cache/<?php echo $item['thumb']; ?>" alt="thumbnail-<?php echo $index + 1; ?>" class="w-full object-cover object-center">
								</button>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
			<script src="assets/alpine.min.js"></script>
			<?php /* ELV: Egy képernyő, egy fő cél. 
			<div class="mt-8 flex justify-center px-4 sm:px-8 md:px-10">
				<a href="https://static.homeinfo.hu/" target="_blank"
					class="inline-block bg-blue-600 hover:bg-blue-700 transition-all text-white font-bold text-sm md:text-base rounded px-5 py-3">
					További képek a galériában</a>
			</div>
			*/ ?>


			<?php if (isset($_GET['faipar'])) : ?>
				<?php include 'faipar.inc.php'; ?>
			<?php endif; ?>

			<div class="font-[sans-serif] mt-8 sm:mt-20 px-4 sm:px-8 md:px-10">
				<div class="text-center">
					<h2
						class="text-2xl font-extrabold text-gray-800 inline-block relative after:absolute after:w-4/6 after:h-1 after:left-0 after:right-0 after:-bottom-4 after:mx-auto after:bg-indigo-400 after:rounded-full">
						<?php echo __('title.partners'); ?></h2>
				</div>
				
				<div class="flex flex-col lg:flex-row gap-8 mt-16">
					<div>
						<h3 class="text-center font-extrabold text-gray-800"><?php echo __('cat.Építőipar'); ?></h3>
						<div class="border rounded-xl p-4 mt-4">
							<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6  gap-4 md:gap-6 lg:gap-2  text-center  max-w-7xl max-lg:max-w-3xl max-md:max-w-xl mx-auto">
								<?php foreach ($cegek as $slug => $item) : ?>
									<?php if (isset($item['hidden'])) continue; ?>
									<?php if (empty($item['cats'])) continue; ?>
									<?php if (in_array('Asztalosipar', $item['cats']) AND ! in_array($slug,['anda', 'bosch', 'bostik', 'butorvonal', 'dufa', 'festatools', 'festool', 'helios', 'hikoki', 'krdesign', 'matrixoktatas', 'meffert', 'mester', 'mls', 'milesi', 'piktorfestek', 'stanley', 'trilak', 'wolfcraft', 'zakanyszerszam'])) continue; ?>
									<div id="<?php echo $slug; ?>">
										<img loading="lazy" src="/cegkereso/files/logo/<?php echo $slug; ?>.png" class="w-full aspect-square bg-white object-contain rounded-xl inline-block" alt="<?php echo $item['name']; ?>">
										<span class="hidden  py-0 md:py-4  bg-[#f8f9ff]">
											<h4 class="text-gray-800 text-xs"><?php echo $item['name']; ?></h4>
											<p class="text-gray-800 text-xs mt-1"><?php echo $item['label']; ?></p>
										</span>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>				
					<div>	
						<h3 class="text-center font-extrabold text-gray-800"><?php echo __('cat.Asztalosipar'); ?></h3>
						<div class="border rounded-xl p-4 mt-4">
							<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6  gap-4 md:gap-6 lg:gap-2  text-center  max-w-7xl max-lg:max-w-3xl max-md:max-w-xl mx-auto">
								<?php foreach ($cegek as $slug => $item) : ?>
									<?php if (isset($item['hidden'])) continue; ?>
									<?php if ( ! isset($item['cats']) OR ! in_array('Asztalosipar', $item['cats'])) continue; ?>
									<div id="<?php echo $slug; ?>">
										<img loading="lazy" src="/cegkereso/files/logo/<?php echo $slug; ?>.png" class="w-full aspect-square bg-white object-contain rounded-xl inline-block" alt="<?php echo $item['name']; ?>">
										<span class="hidden  py-0 md:py-4  bg-[#f8f9ff]">
											<h4 class="text-gray-800 text-xs"><?php echo $item['name']; ?></h4>
											<p class="text-gray-800 text-xs mt-1"><?php echo $item['label']; ?></p>
										</span>
									</div>
								<?php endforeach; ?>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="max-w-3xl mx-auto mt-8 sm:mt-20">
				<div class="text-center">
					<h2
						class="text-2xl font-extrabold text-gray-800 inline-block relative after:absolute after:w-4/6 after:h-1 after:left-0 after:right-0 after:-bottom-4 after:mx-auto after:bg-indigo-400 after:rounded-full">
						<?php echo __('title.targets'); ?></h2>
				</div>
				<?php $targets = (isset($_GET['faipar'])) ? explode(';', __('targets_faipar')) : explode(';', __('targets'));	?>
				<ul class="flex justify-center flex-wrap mt-16">
					<?php foreach ($targets as $target) : ?>
						<li class="flex align-center mx-1">
							<span class="text-xs md:text-base p-2 px-3  mb-2 md:mb-4 rounded border  bg-gray-400/25 text-gray-800">
								<?php echo $target ?>
							</span>
						</li>
					<?php endforeach; ?>
				</ul>
			</div>

			<div class="mt-8 sm:mt-20 px-4 sm:px-8 md:px-0">
				<div class="text-center">
					<h2 class="text-2xl font-extrabold text-gray-800 inline-block relative after:absolute after:w-4/6 after:h-1 after:left-0 after:right-0 after:-bottom-4 after:mx-auto after:bg-indigo-400 after:rounded-full">
						<?php echo __('title.location'); ?></h2>
				</div>
				<div class="mt-12 grid lg:grid-cols-3 items-start gap-4 md:gap-12 max-w-7xl mx-auto  ">
					<div>
						<h2 class="text-gray-800 text-xl font-semibold"> <?php echo __('location.timing'); ?> </h2>
						<div class="space-y-8 mt-8">
							<div class="flex">
								<div class="w-8 h-8 flex items-center shrink-0 rounded border p-1.5">
									<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-full">
										<path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
									</svg>
								</div>
								<div class="ml-4">
									<h4 class="text-gray-800 text-base font-semibold"> <?php echo __('location.event'); ?> </h4>
									<p class="text-sm mt-1"><?php echo htmlspecialchars($dateFormatter->format(new DateTime(DATE_EVENT)), ENT_QUOTES, 'UTF-8'); ?></p>
								</div>
							</div>
						</div>
						<div class="space-y-8 mt-8">
							<div class="flex">
								<div class="w-8 h-8 flex items-center shrink-0 rounded border p-1.5">
									<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-full">
										<path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
									</svg>
								</div>
								<div class="ml-4">
									<h4 class="text-gray-800 text-base font-semibold"> <?php echo __('location.buildup'); ?> </h4>
									<p class="text-sm mt-1"><?php echo htmlspecialchars($dateFormatter->format(new DateTime(DATE_BUILDUP)), ENT_QUOTES, 'UTF-8'); ?></p>
								</div>
							</div>
						</div>
						<div class="space-y-8 mt-8">
							<div class="flex">
								<div class="w-8 h-8 flex items-center shrink-0 rounded border p-1.5">
									<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-full">
										<path stroke-linecap="round" stroke-linejoin="round" d="M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 0 1 2.25-2.25h13.5A2.25 2.25 0 0 1 21 7.5v11.25m-18 0A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75m-18 0v-7.5A2.25 2.25 0 0 1 5.25 9h13.5A2.25 2.25 0 0 1 21 11.25v7.5m-9-6h.008v.008H12v-.008ZM12 15h.008v.008H12V15Zm0 2.25h.008v.008H12v-.008ZM9.75 15h.008v.008H9.75V15Zm0 2.25h.008v.008H9.75v-.008ZM7.5 15h.008v.008H7.5V15Zm0 2.25h.008v.008H7.5v-.008Zm6.75-4.5h.008v.008h-.008v-.008Zm0 2.25h.008v.008h-.008V15Zm0 2.25h.008v.008h-.008v-.008Zm2.25-4.5h.008v.008H16.5v-.008Zm0 2.25h.008v.008H16.5V15Z"></path>
									</svg>
								</div>
								<div class="ml-4">
									<h4 class="text-gray-800 text-base font-semibold"> <?php echo __('location.teardown'); ?> </h4>
									<p class="text-sm mt-1"><?php echo htmlspecialchars($dateWithTimeFormatter->format(new DateTime(DATE_TEARDOWN_START)), ENT_QUOTES, 'UTF-8'); ?><br><?php echo htmlspecialchars($dateWithTimeFormatter->format(new DateTime(DATE_TEARDOWN_END)), ENT_QUOTES, 'UTF-8'); ?></p>
								</div>
							</div>
						</div>
					</div>
					<div class="bg-[#03379a] rounded-3xl md:col-span-2 overflow-hidden">
						<div class="p-3 sm:p-6">
							<h2 class="text-xl text-white font-semibold"><?php echo __('event_location'); ?></h2>
							<p class="text-base text-gray-300 leading-relaxed"><?php echo __('event_location_address'); ?> | GPS: <a class="text-yellow-300 underline" href="https://www.google.hu/maps/place/47.5012+19.10141" target="_blank"> 47.5012, 19.10141 </a></p>
						</div>
						<a href="https://www.homeinfo.hu/emw/assets/emw_3dterkep_<?php echo $current_language; ?>.webp" target="_blank" class="block">
							<img src="https://www.homeinfo.hu/emw/assets/emw_3dterkep_<?php echo $current_language; ?>.webp" class="w-full h-full object-cover" alt="">
						</a>
					</div>
				</div>
			</div>

			<?php if (!isset($_GET['faipar'])) : ?>
				<?php include 'faipar.inc.php'; ?>
			<?php endif; ?>

			<div class="max-w-7xl max-md:max-w-xl mx-auto mt-8 sm:mt-16 text-center">
				<h2
					class="text-2xl font-extrabold text-gray-800 inline-block relative after:absolute after:w-4/6 after:h-1 after:left-0 after:right-0 after:-bottom-4 after:mx-auto after:bg-indigo-400 after:rounded-full">
					<?php echo __('title.standreservation'); ?></h2>
				<p class="text-gray-600 text-sm mb-1 mt-10"><?php echo __('desc.standreservation'); ?></p>
				<div class="mx-auto  grid max-w-lg sm:grid-cols-2 items-center gap-4  sm:max-w-xl lg:mx-0 lg:max-w-none mt-16">
					<a href="standok.php?lang=<?php echo $current_language; ?>" target="_blank"><img class="rounded-lg  w-full" loading="lazy" src="assets/acsarnok_<?php echo $current_language; ?>.webp" alt="A csarnok"></a>
					<a href="standok.php?lang=<?php echo $current_language; ?>" target="_blank"><img class="rounded-lg  w-full" loading="lazy" src="assets/bcsarnok_<?php echo $current_language; ?>.webp" alt="B csarnok"></a>
				</div>
				<div class="mt-8">
					<a href="standok.php?lang=<?php echo $current_language; ?>" target="_blank"
						class="bg-blue-600 hover:bg-blue-700 transition-all text-white md:font-bold text-xs md:text-sm rounded-lg md:px-5 md:py-3 px-3 py-2 "><?php echo __('button.standreservation'); ?></a>
				</div>
			</div>

	
		</div>

	</div>


	<div class="bg-gradient-to-r from-blue-700 to-blue-300 w-full h-36 mt-20" id="ajanlatkeres"></div>
	<div class="-mt-20 mb-6 px-4">
		<div class="mx-auto max-w-3xl shadow-lg p-8 relative bg-white rounded-lg">
			<h2 class="text-xl text-gray-800 font-bold"><?php echo __('title.offer'); ?></h2>

			<form action="contact.action.php" method="post" class="mt-8 grid gap-6">
				<div>
					<input type="text" placeholder="<?php echo __('form.company'); ?>" name="company"
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div>
					<select name="scope" class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]">
						<option value=""><?php echo __('form.scope.options.blank'); ?></option>
						<option value="Forgalmazó"><?php echo __('form.scope.options.distributor'); ?></option>
						<option value="Gyártó"><?php echo __('form.scope.options.manufacturer'); ?></option>
					</select>
				</div>
				<div>
					<input type="text" placeholder="<?php echo __('form.name'); ?>" name="name" required
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div>
					<input type="email" placeholder="<?php echo __('form.email'); ?>" name="email" required
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div>
					<input type="tel" pattern="^\+?[0-9\s\-]{7,20}$" placeholder="<?php echo __('form.phone'); ?>" name='phone' required
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div>
					<textarea placeholder="<?php echo __('form.message'); ?>" rows="6" name="message"
						class="col-span-full w-full rounded-lg px-4 border border-gray-300 text-sm pt-3 outline-[#007bff]"></textarea>
				</div>
				<div class="flex items-center col-span-full">
					<input id="policy" name="policy" type="checkbox" required class="w-4 h-4 mr-3" />
					<label for="policy" class="text-sm text-gray-400"><?php echo __('form.privacy'); ?></label>
				</div>
				<div id="response" class="p-6 bg-green-100 border border-green-300 text-green-900 rounded-xl shadow-md hide"></div>
				<button type='button' onclick="submitForm(this.form)"
					class="text-white w-max bg-[#007bff] hover:bg-blue-600 rounded-lg text-sm px-6 py-3 mt-4 tracking-wide">
					<svg xmlns="http://www.w3.org/2000/svg" width="16px" height="16px" fill='#fff'
						class="mr-2 inline" viewBox="0 0 548.244 548.244">
						<path fill-rule="evenodd"
							d="M392.19 156.054 211.268 281.667 22.032 218.58C8.823 214.168-.076 201.775 0 187.852c.077-13.923 9.078-26.24 22.338-30.498L506.15 1.549c11.5-3.697 24.123-.663 32.666 7.88 8.542 8.543 11.577 21.165 7.879 32.666L390.89 525.906c-4.258 13.26-16.575 22.261-30.498 22.338-13.923.076-26.316-8.823-30.728-22.032l-63.393-190.153z"
							clip-rule="evenodd" data-original="#000000" />
					</svg>
					<?php echo __('form.submit'); ?>
				</button>
			</form>

		</div>
	</div>
	
		<div class="max-w-2xl mx-auto text-center mt-16">
			<h2 class="text-gray-600 text-sm mb-1"><?php echo __('title.team'); ?>:</h2>
			<p class="text-gray-800 text-xl font-bold leading-relaxed">hirdetes@homeinfo.hu</p>
		</div>

		<div
			class="grid grid-cols-2  md:grid-cols-3 lg:grid-cols-5  gap-2 text-center my-8 max-w-5xl max-lg:max-w-3xl max-md:max-w-xl mx-auto">

			<div>
				<img src="<?php echo EVENT_URL; ?>assets/team/tamas.webp"
					class="w-32 h-32 rounded-full inline-block" />
				<div class="py-4">
					<h4 class="text-gray-800 text-sm font-bold">DÉVÉNYI Tamás</h4>
					<p class="text-gray-800 text-xs mt-1">
						<?php echo __('team.title.director'); ?>
					</p>
				</div>
			</div>
			<div>
				<img src="<?php echo EVENT_URL; ?>assets/team/attila.webp"
					class="w-32 h-32 rounded-full inline-block" />
				<div class="py-4">
					<h4 class="text-gray-800 text-sm font-bold">ELEKES Attila</h4>
					<p class="text-gray-800 text-xs mt-1"><?php echo __('team.title.director'); ?></p>
				</div>
			</div>
			<div>
				<img src="<?php echo EVENT_URL; ?>assets/team/dora.webp"
					class="w-32 h-32 rounded-full inline-block" />
				<div class="py-4">
					<h4 class="text-gray-800 text-sm font-bold">SZABÓ Dóra</h4>
					<p class="text-gray-800 text-xs mt-1"><?php echo __('team.title.sales'); ?></p>
					<p class="text-gray-800 text-xs mt-1"><a href="tel:+36704133797" class="underline text-blue-600">+36 70 / 413 3797</a></p>
				</div>
			</div>
			<div>
				<img src="<?php echo EVENT_URL; ?>assets/team/szandi.webp"
					class="w-32 h-32 rounded-full inline-block" />
				<div class="py-4">
					<h4 class="text-gray-800 text-sm font-bold">LASÁN Alexandra</h4>
					<p class="text-gray-800 text-xs mt-1"><?php echo __('team.title.projectmanager'); ?></p>

				</div>
			</div>
			<div>
				<img src="<?php echo EVENT_URL; ?>assets/team/alexa.webp"
					class="w-32 h-32 rounded-full inline-block" />
				<div class="py-4">
					<h4 class="text-gray-800 text-sm font-bold">KULCSÁR Alexa</h4>
					<p class="text-gray-800 text-xs mt-1"><?php echo __('team.title.customerrelations'); ?></p>

				</div>
			</div>
		</div>
	

	<div class="bg-gradient-to-r from-gray-700 to-blue-300 w-full h-36 mt-16" id="casestudy"></div>
	<div class="-mt-20 mb-6 px-4">
		<div class="mx-auto max-w-3xl shadow-lg p-8 relative bg-white rounded-lg">
			<h2 class="text-xl text-gray-800 font-bold"><?php echo __('title.casestudy'); ?></h2>
			<p class="text-gray-600 text-sm mb-1 mt-6"><?php echo __('desc.casestudy'); ?></p>
			<form action="casestudy.action.php?lang=<?php echo $_GET['lang'] ?? 'hu'; ?>" method="post" class="mt-8 grid gap-6">
				<div>
					<input type="text" placeholder="<?php echo __('form.company'); ?>" name="company"
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div>
					<input type="text" placeholder="<?php echo __('form.name'); ?>" name="name" required
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div>
					<input type="email" placeholder="<?php echo __('form.email'); ?>" name="email" required
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div>
					<input type="tel" pattern="^\+?[0-9\s\-]{7,20}$" placeholder="<?php echo __('form.phone'); ?>" name='phone' required
						class="w-full rounded-lg py-2.5 px-4 border border-gray-300 text-sm outline-[#007bff]" />
				</div>
				<div class="flex items-center col-span-full">
					<input id="policy" name="policy" type="checkbox" required class="w-4 h-4 mr-3" />
					<label for="policy" class="text-sm text-gray-400"><?php echo __('form.privacy'); ?></label>
				</div>
				<div id="response2" class="p-6 bg-green-100 border border-green-300 text-green-900 rounded-xl shadow-md hide"></div>
				<button type="button" onclick="submitForm2(this.form)"
					class="text-white w-max bg-[#007bff] hover:bg-blue-600 rounded-lg text-sm px-6 py-3 mt-4 tracking-wide">

					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="#fff" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 inline">
						<path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path>
						<polyline points="7 10 12 15 17 10"></polyline>
						<line x1="12" y1="15" x2="12" y2="3"></line>
					</svg>
					<?php echo __('casestudy.submit'); ?>
				</button>
			</form>
		</div>
	</div>
	<div id="popupModal" class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 hidden">
		<div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full relative">
			<button id="closePopup" class="absolute top-2 right-2 text-gray-400 hover:text-black text-xl">&times;</button>
			<p class="text-lg text-center font-semibold mb-4">
				<?php echo __('casestudy.popup.title'); ?>
			</p>
			<a href="#casestudy" id="popupLink" class="flex justify-center">
				<button class="bg-blue-600 hover:bg-blue-700 text-white font-semibold px-6 py-3 rounded-lg transition">
					<?php echo __('casestudy.popup.download'); ?>
				</button>
			</a>
		</div>
	</div>
	<script>
		document.addEventListener('DOMContentLoaded', () => {
			const popup = document.getElementById('popupModal');
			const closeBtn = document.getElementById('closePopup');
			const popupLink = document.getElementById('popupLink');
			const popupKey = 'popupShown';
			let shown = false;

			const showPopup = () => {
				if (!shown && !sessionStorage.getItem(popupKey)) {
					popup.classList.remove('hidden');
					shown = true;
					sessionStorage.setItem(popupKey, 'true'); // Prevent repeat
				}
			};

			// Show after 30 seconds
			//setTimeout(showPopup, 30000);
			// sok meddo 20250902

			// Exit intent trigger
			//document.addEventListener('mouseleave', (e) => {
			//	if (e.clientY <= 0) showPopup();
			//});

			// Close button
			if (closeBtn) {
				closeBtn.addEventListener('click', () => {
					popup.classList.add('hidden');
				});
			}
			if (popupLink) {
				popupLink.addEventListener('click', () => {
					popup.classList.add('hidden');
				});
			}
		});
	</script>

	<div class="mx-auto max-w-3xl mt-16 px-4 lg:px-0">
		<img src="https://www.homeinfo.hu/assets/homeinfo2017/images/homeinfo-logo-124x54.tudastar.png"
			class="w-24 object-contain" alt="Homeinfo" />
		<h3 class="text-base text-gray-600 mt-4 uppercase"><?php echo __('homeinfo.title'); ?></h3>
		<h2 class="text-3xl md:leading-10 font-extrabold text-gray-800 mb-4 mt-2"><?php echo __('homeinfo.subtitle'); ?></h2>
		<p class="mt-4 text-base text-gray-600 leading-relaxed"><?php echo __('homeinfo.desc'); ?></p>
	</div>

	<?php include 'footer.inc.php'; ?>
</div>

<script>
	async function submitForm(form) {
		const responseDiv = document.getElementById("response");
		if (form.reportValidity()) {

			event.preventDefault();

			var formData = new FormData(form);

			try {
				const response = await fetch(form.action, {
					method: 'POST',
					body: formData
				});

				if (response.ok) {
					const jsonResponse = await response.json();
					responseDiv.innerHTML = jsonResponse.message;
					responseDiv.classList.remove('hide');
					form.reset();
					const submitFormBtn = form.querySelector('button');
					submitFormBtn.disabled = true;
					submitFormBtn.className = '';
					submitFormBtn.classList.add('cursor-not-allowed', 'bg-gray-500', 'text-white', 'opacity-50', 'w-max', 'rounded-lg', 'text-sm', 'px-6', 'py-3', 'mt-4', 'tracking-wide');

				} else {
					// Handle server errors
					responseDiv.innerHTML = 'Error: ' + response.statusText;
					responseDiv.classList.remove('hide');
				}
			} catch (error) {
				console.error('Error:', error);
				responseDiv.innerHTML = 'An error occurred.';
				responseDiv.classList.remove('hide');
			}
		} else {
			// Display a message if the form is not valid
			//document.getElementById("response").innerHTML = 'Az adatok nem megfelelőek!';
		}
	}
	async function submitForm2(form) {
		const responseDiv = document.getElementById("response2");
		if (form.reportValidity()) {

			event.preventDefault();

			var formData = new FormData(form);

			try {
				const response = await fetch(form.action, {
					method: 'POST',
					body: formData
				});

				if (response.ok) {
					const blob = await response.blob();

					// Create a temporary link to trigger download
					const url = window.URL.createObjectURL(blob);
					const a = document.createElement('a');
					a.href = url;
					a.download = "emw-casestudy-<?php echo $_GET['lang'] ?? 'hu'; ?>.pdf";
					document.body.appendChild(a);
					a.click();
					a.remove();
					window.URL.revokeObjectURL(url);

					form.reset();
					const submitFormBtn = form.querySelector('button');
					submitFormBtn.disabled = true;
					submitFormBtn.className = '';
					submitFormBtn.classList.add('cursor-not-allowed', 'bg-gray-500', 'text-white', 'opacity-50', 'w-max', 'rounded-lg', 'text-sm', 'px-6', 'py-3', 'mt-4', 'tracking-wide');

					responseDiv.innerHTML = '<?php echo __('casestudy.success'); ?>';
					responseDiv.classList.remove('hide');
				} else {
					// Handle server errors
					responseDiv.innerHTML = 'Error: ' + response.statusText;
				}
			} catch (error) {
				console.error('Error:', error);
				responseDiv.innerHTML = 'An error occurred.';
			}
		} else {
			// Display a message if the form is not valid
			//document.getElementById("response").innerHTML = 'Az adatok nem megfelelőek!';
		}
	}
</script>
<script>
		document.addEventListener('click', function(event) {
			let gaEvent = event.target.dataset.gaEvent;
			if ( ! gaEvent) return;
			gtag('event', '[EMW] '+gaEvent, {'event_category':'kattintás', 'event_label': event.target.textContent});						
		});	
</script>
<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>
</body>

</html>