<?php
if (session_status() == PHP_SESSION_NONE)
    session_start();

// Define available languages and default
define('AVAILABLE_LANGUAGES', ['hu', 'en']);
define('DEFAULT_LANGUAGE', 'hu');

$current_language = DEFAULT_LANGUAGE;
$translations = [];
$locale_map = [
    'hu' => 'hu_HU',
    'en' => 'en_GB'
];

// 1. Language detection from URL (e.g., /?lang=es)
if (isset($_GET['lang']) && in_array($_GET['lang'], AVAILABLE_LANGUAGES)) {
    $current_language = $_GET['lang'];
    $_SESSION['lang'] = $current_language;
}
// 2. Language from session
elseif (isset($_SESSION['lang']) && in_array($_SESSION['lang'], AVAILABLE_LANGUAGES)) {
    $current_language = $_SESSION['lang'];
}
// 3. (Optional) Browser Accept-Language (more complex to parse reliably)
// else if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) { ... }

// Create IntlDateFormatter
$formatter_locale = $locale_map[$current_language] ?? $locale_map[DEFAULT_LANGUAGE];
$dateFormatter = new IntlDateFormatter(
    $formatter_locale . '.UTF-8', // Add .UTF-8
    IntlDateFormatter::FULL,
    IntlDateFormatter::NONE,
    'Europe/Budapest'
);
$dateWithTimeFormatter = new IntlDateFormatter(
    $formatter_locale . '.UTF-8', // Add .UTF-8
    IntlDateFormatter::FULL,
    IntlDateFormatter::SHORT,
    'Europe/Budapest'
);

// Load translation file
function load_translations(string $lang_code): void
{
    global $translations, $current_language; // Use global for simplicity here
    $file_path = __DIR__ . '/' . $lang_code . '.php';
    if (file_exists($file_path)) {
        $translations = require $file_path;
    } else {
        // Fallback to default if specified language file not found
        $translations = require __DIR__ . '/' . DEFAULT_LANGUAGE . '.php';
        $current_language = DEFAULT_LANGUAGE; // Ensure current_language reflects actual loaded
    }
}

load_translations($current_language);

// Translation helper function
function __(string $key, array $replacements = []): string
{
    global $translations;
    $string = $translations[$key] ?? $key; // Return key itself if translation not found

    foreach ($replacements as $placeholder => $value) {
        $string = str_replace(':' . $placeholder, htmlspecialchars($value, ENT_QUOTES, 'UTF-8'), $string);
    }
    return nl2br($string);
}

// Function to generate language switcher links
function language_switcher_links(): string
{
    $links = '';
    foreach (AVAILABLE_LANGUAGES as $lang) {
        $url = strtok($_SERVER["REQUEST_URI"], '?') . '?lang=' . $lang;
		if (isset($_GET['faipar'])) 
			$url .= '&faipar';
        $links .= '<a class="text-xs md:text-sm nowrap" href="' . htmlspecialchars($url) . '">' . strtoupper($lang) . '</a> ';
    }
    return trim($links);
}
