<?php
require_once('data.php');
require_once('top.inc.php');
?>
<div class="bg-[#f8f9ff] text-black pt-[64px] md:pt-[72px]">

	<header
		class="py-3 px-4 sm:px-10 z-50 fixed w-full top-0 left-0 transition-all bg-white bg-opacity-90"
		id="mainNavbar">
		<div class="relative flex items-center justify-between gap-4">
			<div class="flex items-center">
				<a href="<?php echo EVENT_URL; ?>kiallitoknak.php"
					class="hover:text-blue-600 block font-semibold transition-all text-xs sm:text-sm">&larr; <?php echo __('Kiállítóknak'); ?></a>
			</div>
			<div class="flex items-center">
				<a href="<?php echo EVENT_URL; ?>"><img src="assets/header-logo.png" alt="logo" class="h-10 md:h-12" /></a>
			</div>
			<div class="flex items-center gap-6 ">
				<a href="#ajanlatkeres" data-ga-event="Ajánlatkérés"
					class="bg-blue-600 hover:bg-blue-700 transition-all text-white md:font-bold text-xs md:text-sm rounded-lg md:px-5 md:py-3 px-3 py-2"><?php echo __('button.offer'); ?></a>

				<nav class="flex mx-auto gap-2">
					<?php echo language_switcher_links(); ?>
				</nav>
			</div>

		</div>
	</header>
	
<article class="prose max-w-[750px]  mx-auto px-4 sm:px-6 lg:px-0 prose-img:rounded-xl  pt-8 lg:pt-16">
		<header>
			<h1>Médiatár</h1>
			<p class="text-base">A médiatárban lévő anyagok szabadon felhasználhatók és módosíthatók!</p>
		</header>	
<section>
 		

		<div class="space-y-4">
		  <div class="flex justify-between border-b pb-2">
			<span class="text-gray-600 text-base">Megnevezés</span>
			<span class="text-gray-800 text-base font-medium">HOMEINFO Építőipari és Asztalosipari Mester Workshow</span>
		  </div>
		  <div class="flex justify-between border-b pb-2">
			<span class="text-gray-600 text-base">Rövid megnevezés</span>
			<span class="text-gray-800 text-base font-medium">ÉMW</span>
		  </div>
		   <!-- <div class="flex justify-between border-b pb-2">
			<div class="text-gray-600 text-base">Hashtagek</div>
			<div class="text-gray-800 text-sm">
				<span class="inline-block px-2.5 py-1 text-xs font-medium text-dark">#emw</span>
				<span class="inline-block px-2.5 py-1 text-xs font-medium text-dark">#epitoiparimesterworkshow</span>				
				<span class="inline-block px-2.5 py-1 text-xs font-medium text-dark">#asztalosiparimesterworkshow</span>
				<span class="inline-block px-2.5 py-1 text-xs font-medium text-dark">#homeinfo</span>
				<span class="inline-block px-2.5 py-1 text-xs font-medium text-dark">#bok</span>
			</div>
		  </div>--> 		  
		  <div class="flex justify-between border-b pb-2">
			<span class="text-gray-600 text-base">Betűtípus</span>
			<span class="text-gray-800 text-sm"><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/gilroy.zip"><i class="bi bi-file-zip"></i> gilroy.zip</a>		</span>
		  </div>			  
		  <!-- <div class="flex justify-between border-b pb-2">
			<span class="text-gray-600 text-base">Beharangozó cikk</span>
			<span class="text-gray-800 text-sm"><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/vk25_beharangozo.zip"><i class="bi bi-file-zip"></i> vk25_beharangozo.zip</a>		</span>
		  </div>	-->  
		  <div class="flex justify-between border-b pb-2">
			<span class="text-gray-600 text-base">Színek</span>
			<span class="text-gray-800 text-sm">
				<div class="flex gap-1">
					<div class="bg-[#ffe619] px-2.5 py-1 text-xs font-medium text-dark">#ffe619</div>
					<div class="bg-[#03379a] px-2.5 py-1 text-xs font-medium text-white">#03379a</div>
				</div>	
			</span>
		  </div>		
		  <div class="flex justify-between  pb-2">
			<span class="text-gray-600 text-base">Logo</span>
			<span class="text-gray-800 text-sm">
				<div class="flex gap-1">
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logo/emw25-logo-1200x1200.png"><img class="max-h-[59px] p-2 shrink-0 not-prose" loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_logo/emw25-logo-1200x1200.png?1" alt=""></a>
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logo/emw25-logo-1200x1200-transparent.png"><img class="max-h-[59px] p-2 shrink-0 not-prose" loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_logo/emw25-logo-1200x1200-transparent.png?1" alt=""></a>					
				</div>		
			</span>
		  </div>	
		</div>	
		
		<h2>Hashtagek</h2>
		<div class="flex flex-start pb-2 gap-4 text-gray-800 text-sm border-b">			
			<span class="inline-block  py-1 font-medium text-dark">#emw</span>
			<span class="inline-block  py-1 font-medium text-dark">#epitoiparimesterworkshow</span>				
			<span class="inline-block  py-1 font-medium text-dark">#asztalosiparimesterworkshow</span>
			<span class="inline-block  py-1 font-medium text-dark">#homeinfo</span>
			<span class="inline-block  py-1 font-medium text-dark">#bok</span>			
		</div>		
		
		<h2>CIKKEK</h2>
		<div class="flex justify-between border-b pb-2">
			<div class="text-gray-600 text-base">Beharangozó cikk</div>
			<div class="text-gray-800 text-sm">
				<div class="flex gap-1">		
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_beharangozo_cikk.docx">docx (építőipar)</a> | 
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_beharangozo_cikk_asztalosipar.docx">docx (asztalosipar)</a>
				</div>		
			</div>
		</div>
		
		<h2>KIKÜLDHETŐ E-MAIL / EDM</h2>
		<div class="flex flex-col gap-2 border-b pb-2">
			<div class="flex justify-between">
				<div class="text-gray-600 text-base">eDM</div>
				<div class="text-gray-800 text-sm">
					<div class="flex gap-1">		
						<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/epitoipari-es-asztalosipari-mester-workshow.zip">Építőipari és Asztalosipari (zip)</a> | 
						<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/asztalosipari-mester-workshow.zip">Asztalosipari (zip)</a> | 
						<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/construction-and-carpentry-master-workshow.zip">Építőipari és Asztalosipari (zip) (en)</a>
					</div>		
				</div>			
			</div>		
<div class="flex justify-between">			
			<div class="text-gray-600 text-base">Nyereményjátékok és innovációk az Építőipari és Asztalosipari Mester Workshow-n</div>
			<div class="text-gray-800 text-sm">
				<div class="flex gap-1">		
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/nyeremenyjatekok-es-innovaciok-az-epitoipari-es-asztalosipari-mester-workshow-n.html">html</a> | 
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/prizes-and-innovations-at-the-master-workshop-for-construction-and-carpentry-professionals.html">html&nbsp;(en)</a> | 
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/email_kepek.zip">Képek&nbsp;(zip)</a>
				</div>		
			</div>	
			</div>	
<div class="flex justify-between">			
			<div class="text-gray-600 text-base">Újdonságok és innovációk az Építőipari  és Asztalosipari Mester Workshow-n</div>
			<div class="text-gray-800 text-sm">
				<div class="flex gap-1">		
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/ujdonsagok-es-innovaciok-az-epitoipari-es-asztalosipari-mester-workshow-n.html">html</a> | 
					<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/email_kepek.zip">Képek (zip)</a>
				</div>		
			</div>
			</div>
		</div>	
		
		<div class="mt-16 xl:mt-20">
		<h2>BANNEREK</h2>
			<figure>
				<figcaption class="mb-4">A/B Kreatív forrás <a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/EMW2025_MasterBanner.psd">PSD</a> (466MB)</figcaption>
				<img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/EMW2025_MasterBannerA.jpg" alt="">
			</figure>		
			<?php
				$files = [
					 'A/B Kreatív forrás (psd 466MB)'=>'EMW2025_MasterBanner.psd'
					,'1920x1080 Banner A v1 (jpg)'=>'EMW2025_MasterBannerA_1920x1080_v01.jpg'
					,'1920x1080 Banner A v2 (jpg)'=>'EMW2025_MasterBannerA_1920x1080_v02.jpg'
					,'1200x1200 Banner A v1 (jpg)'=>'EMW2025_MasterBannerA_1200x1200px_v01.jpg'
					,'1200x1200 Banner A v2 (jpg)'=>'EMW2025_MasterBannerA_1200x1200px_v02.jpg'
					,'1080x1920 Banner A (jpg)'=>'EMW2025_MasterBannerA_1080x1920px.jpg'					
				];
			?>
			<ul>	
				<?php foreach($files as $label => $src) : ?>
				<li><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/<?php echo $src ?>"><?php echo $label ?></a></li>	
				<?php endforeach; ?>
			</ul>	
		</div>			
		
		<div class="mt-16 xl:mt-20">
			<figure>
				<img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/EMW2025_MasterBannerB.jpg" alt="">				
			</figure>		
			<?php
				$files = [
					'A/B Kreatív forrás (psd 466MB)'=>'EMW2025_MasterBanner.psd'
					,'1920x1080 Banner B v1 (jpg)'=>'EMW2025_MasterBannerB_1920x1080.jpg'
					,'1200x1200 Banner B v1 (jpg)'=>'EMW2025_MasterBannerB_1200x1200px_v01.jpg'
					,'1200x1200 Banner B v2 (jpg)'=>'EMW2025_MasterBannerB_1200x1200px_v02.jpg'
					,'1080x1920 Banner B v2 (jpg)'=>'EMW2025_MasterBannerB_1080x1920px_v01.jpg'
					,'1080x1920 Banner B v2 (jpg)'=>'EMW2025_MasterBannerB_1080x1920px_v02.jpg'	
				];
			?>
			<ul>	
				<?php foreach($files as $label => $src) : ?>
				<li><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/<?php echo $src ?>"><?php echo $label ?></a></li>	
				<?php endforeach; ?>
			</ul>	
		</div>		
		
		<div class="mt-16 xl:mt-20">
			<figure>
				<figcaption class="mb-4">Logós kreatív (Építőipar)</figcaption>
				<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/emw25-emw-logos-1920x1080.png"><img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/emw25-emw-logos-1920x1080.png" alt=""></a>
			</figure>	
			<?php
				$files = [					
					'1920x1080 Logós Kreatív (png)'=>'emw25-emw-logos-1920x1080.png'
					,'1200x1200 Logós Kreatív (png)'=>'emw25-emw-logos-1200x1200.png'					
					,'1080x1920 Logós Kreatív (png)'=>'emw25-emw-logos-1080x1920.png'
				];
			?>
			<ul>	
				<?php foreach($files as $label => $src) : ?>
				<li><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/<?php echo $src ?>"><?php echo $label ?></a></li>	
				<?php endforeach; ?>
			</ul>			
			<figure>
				<figcaption class="mb-4">Logós kreatív (Asztalosipar)</figcaption>
				<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/emw25-amw-logos-1920x1080.png"><img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/emw25-amw-logos-1920x1080.png" alt=""></a>
			</figure>			
			<?php
				$files = [					
					'1920x1080 Logós Kreatív (png)'=>'emw25-amw-logos-1920x1080.png'
					,'1200x1200 Logós Kreatív (png)'=>'emw25-amw-logos-1200x1200.png'					
					,'1080x1920 Logós Kreatív (png)'=>'emw25-amw-logos-1080x1920.png'
				];
			?>
			<ul>	
				<?php foreach($files as $label => $src) : ?>
				<li><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/<?php echo $src ?>"><?php echo $label ?></a></li>	
				<?php endforeach; ?>
			</ul>
			<figure>
				<figcaption class="mb-4">Logós kreatív (en)</figcaption>
				<a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/emw25-eamw-logos-en-1920x1080.png"><img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/emw25-eamw-logos-en-1920x1080.png" alt=""></a>
			</figure>
			<?php
				$files = [					
					'1920x1080 Logós Kreatív - Építőipar és Asztalosipar (png)'=>'emw25-eamw-logos-en-1920x1080.png'
					,'1200x1200 Logós Kreatív - Építőipar (png)'=>'emw25-emw-logos-1200x1200.png'					
					,'1080x1920 Logós Kreatív - Építőipar (png)'=>'emw25-emw-logos-1080x1920.png'					
					,'1200x1200 Logós Kreatív - Asztalosipar (png)'=>'emw25-amw-logos-1200x1200.png'					
					,'1080x1920 Logós Kreatív - Asztalosipar (png)'=>'emw25-amw-logos-1080x1920.png'
				];
			?>
			<ul>	
				<?php foreach($files as $label => $src) : ?>
				<li><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_logos_kreativ/<?php echo $src ?>"><?php echo $label ?></a></li>	
				<?php endforeach; ?>
			</ul>
		</div>			
		
		<div class="mt-16 xl:mt-20">
		<h2>SZÓRÓLAPOK</h2>
			<figure class="my-1">
				<figcaption>Szórólap A3 és A5 <a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap_a3_a5.pdf">PDF</a> (11MB)</figcaption>
			</figure>					
			<div class="flex align-top gap-1">
				<div><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/2.png"><img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/2.png" alt=""></a><div><a href="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/2.ai" target="_blank">Forrás: ai (7.3MB)</a></div></div>
				<div><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/1.png"><img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/1.png" alt=""></a><div><a href="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/1.ai" target="_blank">Forrás: ai (7.3MB)</a></div></div>
				<div><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/3.png"><img loading="lazy" src="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/3.png" alt=""></a><div><a href="<?php echo EVENT_URL; ?>files/mediatar/emw25_szorolap/3.ai" target="_blank">Forrás: ai (7.3MB)</a></div></div>
			</div>	
		</div>		
		
		<div class="mt-16 xl:mt-20">
			<h2>VIDEÓK</h2>
			<p>Csatornánk: <a href="https://www.youtube.com/@HomeinfoHu" target="_blank">https://www.youtube.com/@HomeinfoHu</a></p>
			<figure>
				<iframe
					src="https://www.youtube.com/embed/LBUuvSbUdew?controls=1&amp;rel=0&amp;playlist=LBUuvSbUdew"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-video w-full max-h-[80vh] rounded-lg"></iframe>
				
				<figcaption class="mt-2"><a target="_blank" href="https://www.youtube.com/watch?v=LBUuvSbUdew">https://www.youtube.com/watch?v=LBUuvSbUdew</a></figcaption>
			</figure>				
			
			<figure>
				<iframe
					src="https://www.youtube.com/embed/C3GjCI8BghM?controls=1&amp;rel=0&amp;playlist=C3GjCI8BghM"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-video w-full max-h-[80vh] rounded-lg"></iframe>
				
				<figcaption  class="mt-2"><a target="_blank" href="https://www.youtube.com/watch?v=C3GjCI8BghM">https://www.youtube.com/watch?v=C3GjCI8BghM</a></figcaption>
			</figure>											
				
		</div>			
		
		<div class="mt-16 xl:mt-20">
			<h2>SHORT VIDEÓK</h2>
			<p>Még több short videó: <a href="https://www.youtube.com/@HomeinfoHu/shorts" target="_blank">https://www.youtube.com/@HomeinfoHu/shorts</a></p>
			<div class="grid md:grid-cols-3 gap-2">
			
				<iframe
					src="https://www.youtube.com/embed/ek7RQJOgUpc?rel=0"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-[9/16] w-full max-h-[50vh] rounded-lg"></iframe>
				
				<iframe
					src="https://www.youtube.com/embed/7GiFSMJ74HU?rel=0"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-[9/16] w-full max-h-[50vh] rounded-lg"></iframe>
				
				<iframe
					src="https://www.youtube.com/embed/33qAOrLwcfE?rel=0"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-[9/16] w-full max-h-[50vh] rounded-lg"></iframe>
				<iframe
					src="https://www.youtube.com/embed/GtXr5fgRD00?rel=0"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-[9/16] w-full max-h-[50vh] rounded-lg"></iframe>
				<iframe
					src="https://www.youtube.com/embed/8rI4Dd4Ywio?rel=0"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-[9/16] w-full max-h-[50vh] rounded-lg"></iframe>
				<iframe
					src="https://www.youtube.com/embed/8lr4QJFcXZY?rel=0"
					allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
					frameborder="0" allowfullscreen="" class="aspect-[9/16] w-full max-h-[50vh] rounded-lg"></iframe>
				
				
			
			</div>	
		</div>			
		<div class="mt-16 xl:mt-20">
			<h2>RÁDIÓ SPOTOK</h2>
			
			<?php
				$files = [					
					 'Rádió spot 10s - Építőipari Workshow (mp3)'=>'20250918-Epitoipari_Workshop_10s.mp3'
					,'Rádió spot 20s - Építőipari Workshow (mp3)'=>'20250918-Epitoipari_Workshop_20s.mp3'
					,'Rádió spot 30s - Építőipari Workshow (mp3)'=>'20250918-Epitoipari_Workshop_30s.mp3'					
					,'Rádió spot 10s - Asztalosipari Workshow (mp3)'=>'20250918-Asztalos_Workshop_10s.mp3'					
				];
			?>
			<ul>	
				<?php foreach($files as $label => $src) : ?>
				<li><a target="_blank" href="<?php echo EVENT_URL; ?>files/mediatar/emw25_radio/<?php echo $src ?>"><?php echo $label ?></a></li>	
				<?php endforeach; ?>
			</ul>
		</div>	
		
    </section>	
</article>	
		


	<?php include 'footer.inc.php'; ?>
</div>

<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>
</body>

</html>