<?php
require_once('top.inc.php'); // tracking codes
/**
 * 2023.11.23 Facebook Conversion API
 * Prezentáció megtekintése esemény és redirect
 */
ini_set('display_errors', 1);

require __DIR__ . '/../termekek/vendor/fbcapi.php';

use FacebookAds\Object\ServerSide\ActionSource;
use FacebookAds\Object\ServerSide\Event;
use FacebookAds\Object\ServerSide\EventRequest;
use FacebookAds\Object\ServerSide\UserData;

$eventName = 'ViewContent';
$eventId = $eventName . date("U", time()) . rand(1000, 9999);
$userData = (new UserData())
    ->setClientIpAddress($_SERVER['REMOTE_ADDR'])
    ->setClientUserAgent($_SERVER['HTTP_USER_AGENT']);
$eventSourceUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

$event = (new Event())
    ->setEventName($eventName)
    ->setEventTime(time())
    ->setEventSourceUrl($eventSourceUrl)
    ->setUserData($userData)
    ->setEventId($eventId)
    ->setActionSource(ActionSource::WEBSITE);

$request = (new EventRequest($pixel_id))
    //->setTestEventCode('TEST8048')
    ->setEvents(array($event));
$request->execute();

$url = 'https://docs.google.com/presentation/d/14ylBCq6UiREd0zAsJp_1lpUlEGLv-XCX47rx3Z3sVWI/embed?slide=id.g3414aa2ac29_0_0';
if ( (isset($_GET['lang']) AND $_GET['lang'] == 'en') OR (isset($_GET['en'])) OR (isset($_GET['eng'])) )
	$url = 'https://docs.google.com/presentation/d/11eMvGbKiEV3OuXKRYp-g6vSre5281yS29pk8PlvSLEY/embed?slide=id.g3414aa2ac29_0_0';
?>
<div class="bg-[#f8f9ff] ">

    <iframe class="w-full h-screen aspect-[16/9]" src="<?php echo $url; ?>" width="960" height="769" allowfullscreen="true" mozallowfullscreen="true" webkitallowfullscreen="true"></iframe>
</div>
<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>
</body>

</html>