<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);
header('X-Robots-Tag: noindex, noarchive, nosnippet', TRUE); 
header('Content-Type: text/html; charset=utf-8');

date_default_timezone_set('Europe/Budapest');
setlocale(LC_ALL, 'hu_HU');

require_once('../jegyvasarlas/config.php');

if (session_status() == PHP_SESSION_NONE) 
    session_start();

global $wpdb;

$wpdbInsp = new wpdb( 'dasl1_usr_inspir', 'p-^u;.TdrB*5', 'dasl1_db_inspiracio', 'localhost' );
$wpdbInsp->query("
	SET 
		NAMES 'utf8', 
		CHARACTER SET 'utf8', 
		character_set_results = 'utf8', 
		character_set_client = 'utf8', 
		character_set_connection = 'utf8', 
		character_set_database = 'utf8', 
		character_set_server = 'utf8'
");

global $wpdb;
global $wpdbInsp;


if ( empty($_POST['submit']) ) 
{
	header("Location: /emw/sorsolas.php");		
	exit;	
}
	
		

$dayName = ( date('Y-m-d') == '2024-10-19' ) ? 'szombat' : 'pentek';

// SORSOLÁS 

// Elmúlt egy órában belépett látogató
$recentVisitorId = $wpdb->get_var( "SELECT kinek FROM `jegyek` WHERE UNIX_TIMESTAMP(`belepett_mikor_$dayName`) BETWEEN UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 1 HOUR)) AND UNIX_TIMESTAMP() ORDER BY RAND() LIMIT 1" );	
$recentVisitorToken = getRecentVisitorToken($recentVisitorId);	

// Elmúlt egy órában telepítette az APP-ot
$newAppUserToken = $wpdbInsp->get_var( "SELECT token FROM `inspiracio_fbuser` WHERE UNIX_TIMESTAMP(`last_login`) BETWEEN UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 1 HOUR)) AND UNIX_TIMESTAMP() AND `token` IS NOT NULL AND `verified` = 1 ORDER BY RAND() LIMIT 1" ); 

if (mt_rand(0,1))	{
	$token = ($recentVisitorToken) ? $recentVisitorToken : $newAppUserToken;	
} else {
	$token = ($newAppUserToken) ? $newAppUserToken : $recentVisitorToken; 
}
	
won($token);			


// --- HELPERS
 
function getRecentVisitorToken($id)
{
	global $wpdb;
	global $wpdbInsp;	

	if ( ! $id)
		return false;
	
	$hashAuth = $wpdb->get_var( "SELECT app_user FROM `vasarlas` WHERE id = " . $id );
	$token = $wpdbInsp->get_var( "SELECT token FROM `inspiracio_fbuser` WHERE hashAuth LIKE '" . $hashAuth . "'" );
	return $token;
}

function won($token)
{	
	global $wpdbInsp;	
		

	// Nincs nyertes
	if ( empty($token) ) 
	{
		$_SESSION['sorsolasMessage']  = 'Nincs nyertes, sorsolj újra!';
		header("Location: /emw/sorsolas.php");		
		exit;		
	}
	
	if ($volt = $wpdbInsp->get_var( "SELECT token FROM `inspiracio_fbuser_emw24won` WHERE token LIKE '" . $token . "'" ))
	{
		$_SESSION['sorsolasMessage']  = 'Már nyert, sorsolj újra!';
		header("Location: /emw/sorsolas.php");		
		exit;		
	}		
		
	// Nyeremeny flag a badgehez
	$wpdbInsp->update('inspiracio_fbuser', ['emw24won' => 1], ['token' => $token]);
	
	// Mentés -csak egszer nyerhet
	$wpdbInsp->insert('inspiracio_fbuser_emw24won', ['token' => $token]);
	$won_id = $wpdbInsp->insert_id;
	
	 $notification = '{
      "title": "Építőipari Mester Workshow",
      "body": "Gratulálunk nyertél! Nyereményed átveheted a bejáratnál a pénztárban!"
    }';
	
	// App push értesítés
	$ch = curl_init("https://www.homeinfo.hu/vip/send.php");
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('token' => $token, 'notification' => $notification )));	
	curl_setopt($ch, CURLOPT_POST, TRUE);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	$response = curl_exec($ch);
		if (curl_errno($ch)) {
		$response = curl_error($ch);
	}	
	curl_close($ch);
	
	$_SESSION['sorsolasMessage'] = '<strong>Sikeres sorsolás!</strong> ('.date('Y.m.d H:i:s').')';
	header("Location: /emw/sorsolas.php");		
	exit;	
}

