<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);
header('X-Robots-Tag: noindex, noarchive, nosnippet', TRUE); 
header('Content-Type: text/html; charset=utf-8');

date_default_timezone_set('Europe/Budapest');
setlocale(LC_ALL, 'hu_HU');

require_once('../jegyvasarlas/config.php');

if (session_status() == PHP_SESSION_NONE) 
    session_start();

$wpdbInsp = new wpdb( 'dasl1_usr_inspir', 'p-^u;.TdrB*5', 'dasl1_db_inspiracio', 'localhost' );
$wpdbInsp->query("
	SET 
		NAMES 'utf8', 
		CHARACTER SET 'utf8', 
		character_set_results = 'utf8', 
		character_set_client = 'utf8', 
		character_set_connection = 'utf8', 
		character_set_database = 'utf8', 
		character_set_server = 'utf8'
");

global $wpdbInsp;

$lastSuccess = $_SESSION['sorsolasLastSuccess'] ?? NULL;
$message = $_SESSION['sorsolasMessage'] ?? NULL;
unset($_SESSION['sorsolasMessage']);

$winners = getWinners();

function getWinners()
{	
	global $wpdbInsp;	
	
	$result = $wpdbInsp->get_results( "SELECT * FROM inspiracio_fbuser_emw24won WHERE 1", ARRAY_A );
	return $result;
}



?>
<!DOCTYPE html>
<html lang="hu">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>Sorsolás | ÉMW24</title>
<meta name="description" content="">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
<link href="/jegyvasarlas/assets/main.css" rel="stylesheet" type="text/css">
<style>
	.winners {display: grid;  grid-template-columns: auto auto auto;}
	.winners div {padding: .5rem;    border: 1px solid #eee;}

</style>
</head>

<body id="survey">

	<header>
		<figure id="img580x300">				
			<a target="_blank" href="https://www.emworkshop.hu/" title="Építőipari Mester Workshop">
				<img src="https://www.homeinfo.hu/edm/static/emw2024_580x300.jpg" width="580" height="300" alt="">
			</a>			
		</figure>
	</header>
	<form method="post" action="sorsolas.action.php">
	<div id="survey-container">	
	<div id="survey-questions" class="single">
	<div class="question clearfix form-question">
	
		<header class="eventHeader">			
			<hgroup>
				<div class="eventHeader__title">Helyszíni sorsolás</div>
				<div class="eventHeader__date">2024. október 18-19.</div>
				<div class="eventHeader__info">
					<ul>
						<li>Óránként max 3x sorsolunk</li>
						<li>Egy látogatót legfeljebb egyszer sorsol ki a rendszer</li>							
						<li>A kupon átadásakor a nyertes telefonján az 'Átvetem' gombot meg kell nyomni</li>
					</ul>							
				</div>			
			</hgroup>
		</header>

		<div class="question-form clearfix" style="padding-top:2rem;">

	
			<button type="submit" name="submit" value="1" class="button" style="width:100%;background:#2196f3;"><strong>Sorsolás</strong></button>
			
			<?php if ( ! empty($message)) : ?>
			<p style="padding: 1rem;
    margin: 1rem 0;
    margin-bottom: 0;
    background: #FFEB3B;
    text-align: center;
    border-radius: 3px;
    border: 1px solid #FF9800;"><?php echo $message; ?></p>			
			<?php endif; ?>
		</div>
		
			
		<header style="padding-top:0;">					
			<hgroup>
				<h3 class="question-title">
					Nyertesek
				</h3>			
			</hgroup>
		</header>
		
		<div class="question-form clearfix" >
			<?php if ( ! empty($winners) ) : ?>
			<div class="winners">					
				<div><strong>Az.</strong></div>					
				<div><strong>Sorsolás dátuma</strong></div>
				<div><strong>Átvétel dátuma</strong></div>			
				<?php foreach ($winners AS $item) : ?>			
				<div><?php echo str_pad($item['id'],3,"0",STR_PAD_LEFT); ?></div>					
				<div><?php echo $item['created_at']; ?></div>
				<div><?php echo $item['received_at']; ?></div>			
				<?php endforeach; ?>
			</div>
			<?php else: ?>
			<p>Még nincs nyertes.</p>
			<?php endif; ?>

		</div>
		
	</div>
	</div>
	</div>
	</form>
	
</body>
</html>