<?php
require_once($_SERVER['DOCUMENT_ROOT'] . '/assets/homeinfo2017/define.php');


header('Content-Type: text/html; charset=utf-8');

define('ABSPATH', DOCUMENT_ROOT . '/emw/');

require_once DOCUMENT_ROOT . '/brevo/autoload.php'; // Brevo email kuldo
require_once DOCUMENT_ROOT . '/jegyvasarlas/wpdb.php';
require_once ABSPATH . '/data.php';
require_once __DIR__ . '/lang/i18n.php';


$wpdb = new wpdb('dasl1_usr_jegyv', 'S]!X,0tL0rC1', 'dasl1_db_jegyvasarlas', 'localhost');
$wpdb->query("
	SET 
		NAMES 'utf8', 
		CHARACTER SET 'utf8', 
		character_set_results = 'utf8', 
		character_set_client = 'utf8', 
		character_set_connection = 'utf8', 
		character_set_database = 'utf8', 
		character_set_server = 'utf8'
");
global $wpdb;

date_default_timezone_set('Europe/Budapest');

$successMessage = FALSE;
$errorMessage = FALSE;
$cancellationMessage = FALSE;
$foglaltLettKozben = FALSE;
$teMarFoglaltal = FALSE;


setlocale(LC_ALL, 'hu_HU');



// seed database
/*
$standok = [
    ["stand" => 1, "size" => "8x7"],
    ["stand" => 2, "size" => "4x4"],
    ["stand" => 3, "size" => "7x3"],
    ["stand" => 4, "size" => "1x1"],
    ["stand" => 5, "size" => "5x3"],
    ["stand" => 6, "size" => "7x3"],
    ["stand" => 7, "size" => "7x3"],
    ["stand" => 8, "size" => "6x7"],
    ["stand" => 9, "size" => "6x7"],
    ["stand" => 10, "size" => "6x7"],
    ["stand" => 11, "size" => "5x5"],
    ["stand" => 12, "size" => "4x10"],
    ["stand" => 13, "size" => "4x6"],
    ["stand" => 14, "size" => "4x5"],
    ["stand" => 15, "size" => "4x5"],
    ["stand" => 16, "size" => "4x8"],
    ["stand" => 17, "size" => "5x8"],
    ["stand" => 18, "size" => "8x65"],
    ["stand" => 19, "size" => "8x65"],
    ["stand" => 20, "size" => "8x7"],
    ["stand" => 21, "size" => "8x7"],
    ["stand" => 22, "size" => "8x7"],
    ["stand" => 23, "size" => "8x7"],
    ["stand" => 24, "size" => "6x7"],
    ["stand" => 25, "size" => "6x7"],
    ["stand" => 26, "size" => "6x7"],
    ["stand" => 27, "size" => "6x7"],
    ["stand" => 28, "size" => "10x14"],
    ["stand" => 29, "size" => "5x9"],
    ["stand" => 30, "size" => "4x5"],
    ["stand" => 31, "size" => "5x5"],
    ["stand" => 32, "size" => "4x5"],
    ["stand" => 33, "size" => "4x7"],
    ["stand" => 34, "size" => "4x7"],
    ["stand" => 35, "size" => "4x5"],
    ["stand" => 36, "size" => "4x5"],
    ["stand" => 37, "size" => "4x5"],
    ["stand" => 38, "size" => "10x10"],
    ["stand" => 39, "size" => "12x10"],
    ["stand" => 40, "size" => "8x10"],
    ["stand" => 41, "size" => "8x10"],
    ["stand" => 42, "size" => "8x5"],
    ["stand" => 43, "size" => "8x5"],
    ["stand" => 44, "size" => "5x10"],
    ["stand" => 45, "size" => "4x10"],
    ["stand" => 46, "size" => "4x6"],
    ["stand" => 47, "size" => "4x6"],
    ["stand" => 48, "size" => "4x10"],
    ["stand" => 49, "size" => "5x10"],
    ["stand" => 50, "size" => "8x5"],
    ["stand" => 51, "size" => "8x5"],
    ["stand" => 52, "size" => "8x10"],
    ["stand" => 53, "size" => "8x10"],
    ["stand" => 54, "size" => "6x10"],
    ["stand" => 55, "size" => "6x10"],
    ["stand" => 56, "size" => "10x10"],
    ["stand" => 57, "size" => "5x5"],
    ["stand" => 58, "size" => "4x10"],
    ["stand" => 59, "size" => "5x5"],
    ["stand" => 60, "size" => "4x7"],
    ["stand" => 61, "size" => "4x5"],
    ["stand" => 62, "size" => "5x5"],
    ["stand" => 63, "size" => "10x4"],
    ["stand" => 64, "size" => "5x4"],
    ["stand" => 65, "size" => "5x5"],
    ["stand" => 66, "size" => "6x4"],
    ["stand" => 67, "size" => "6x4"],
    ["stand" => 68, "size" => "6x4"],
    ["stand" => 69, "size" => "4x5"],
    ["stand" => 70, "size" => "16x6"],
    ["stand" => 71, "size" => "6x6"],
    ["stand" => 72, "size" => "3x6"]
];
foreach ($standok AS $stand) 	$wpdb->insert( 'emw25_standok', array( 'stand' => $stand['stand'], 'building' => 'A', 'size' => $stand['size'] ), array( '%s', '%s' ) );

$standokB = [
    ["stand" => 1, "size" => "10x6"],
    ["stand" => 2, "size" => "10x10"],
    ["stand" => 3, "size" => "10x6"],
    ["stand" => 4, "size" => "8x4"],
    ["stand" => 5, "size" => "9x4"],
    ["stand" => 6, "size" => "10x6"],
    ["stand" => 7, "size" => "10x5"],
    ["stand" => 8, "size" => "10x5"],
    ["stand" => 9, "size" => "9x6"],
    ["stand" => 10, "size" => "9x4"],
    ["stand" => 11, "size" => "7x4"],
    ["stand" => 12, "size" => "10x6"],
    ["stand" => 13, "size" => "10x5"],
    ["stand" => 14, "size" => "10x5"],
    ["stand" => 15, "size" => "10x6"],
    ["stand" => 16, "size" => "9x4"],
    ["stand" => 17, "size" => "9x4"],
    ["stand" => 18, "size" => "8x6"],
    ["stand" => 19, "size" => "8x10"],
    ["stand" => 20, "size" => "8x6"],
    ["stand" => 21, "size" => "7x4"],
    ["stand" => 22, "size" => "6x4"],
    ["stand" => 23, "size" => "4x6"],
    ["stand" => 24, "size" => "4x10"],
    ["stand" => 25, "size" => "4x6"],
    ["stand" => 26, "size" => "7x4"]
];

foreach ($standokB AS $stand) 	$wpdb->insert( 'emw25_standok', array( 'stand' => $stand['stand'], 'building' => 'B', 'size' => $stand['size'] ), array( '%s', '%s' ) );
exit;
*/


$listaar = array();
$listaar['kiemelt'] = 44000;
$listaar['standard'] = 39000;
$listaar['bcsarnok'] = 44000;

if (date('Y-m-d') <= '2025-05-16') {
	$listaar['kiemelt'] = 40000;
	$listaar['standard'] = 36000;
	$listaar['bcsarnok'] = 40000;
}



$standok = $wpdb->get_results("SELECT * FROM emw25_standok WHERE building = 'A' ", ARRAY_A);
$standokB = $wpdb->get_results("SELECT * FROM emw25_standok WHERE building = 'B' ", ARRAY_A);


if (! empty($_GET['lemondas']) and ! empty($_GET['id'])) {
	$foglalas = $wpdb->get_row($wpdb->prepare("SELECT * FROM emw25_standok WHERE id = %d AND email = %s", $_GET['id'], $_GET['lemondas']));
	if (! empty($foglalas)) {
		$wpdb->query("UPDATE `emw25_standok` SET `email`=NULL,`name`=NULL,`phone`=NULL,`create_date`='0000-00-00 00:00:00' WHERE `id`= " . $foglalas->id . ";");
		$cancellationMessage = TRUE;
	} else {
		header("Location: https://www.homeinfo.hu/emw/standok.php" . "&lang=" . ($_GET['lang'] ?? "hu"));
	}
}

if (! empty($_POST['submit'])) {
	$where = array();
	$where['id'] = $_POST['selected_stand'];

	$row = array();
	$row['name'] = $_POST['name'];
	$row['email'] = $_POST['email'];
	$row['phone'] = $_POST['phone'];


	$extras = array();
	if (! empty($_POST['extras'])) {
		foreach ($_POST['extras'] as $i => $value) {
			$extra = array();
			$extra['value'] = $value;
			$extra['quantity'] = $_POST['quantity'][$i];
			$extra['sumprice'] = $_POST['sumprice'][$i];
			$extras[] = $extra;
		}
	}

	$extras_total = 0;
	if (! empty($_POST['extras_total']))
		$extras_total = $_POST['extras_total'];
	$extras_discount = 0;
	if (! empty($_POST['extras_discount']))
		$extras_discount = $_POST['extras_discount'];

	$extras_discount_percent = 0;
	if (! empty($_POST['extras_discount_percent']))
		$extras_discount_percent = $_POST['extras_discount_percent'];

	$final_price = 0;
	if (! empty($_POST['final_price']))
		$final_price = $_POST['final_price'];

	$stand_price = 0;
	if (! empty($_POST['stand_price']))
		$stand_price = $_POST['stand_price'];

	$stand_discount = 0;
	if (! empty($_POST['stand_discount']))
		$stand_discount = $_POST['stand_discount'];

	$stand_discount_percent = 0;
	if (! empty($_POST['stand_discount_percent']))
		$stand_discount_percent = $_POST['stand_discount_percent'];



	$stand_dimensions = 0;
	if (! empty($_POST['stand_dimensions']))
		$stand_dimensions = $_POST['stand_dimensions'];
	$waste_fee = 0;
	if (! empty($_POST['waste_fee']))
		$waste_fee = $_POST['waste_fee'];

	$comment = '';
	if (! empty($_POST['comment']))
		$comment = $_POST['comment'];

	// megnezzuk hogy az email cim foglalt-e mar
	$foglalas = array();

	if (strpos($row['email'], '@homeinfo.hu') === FALSE) // mi tobbszor is foglalhatunk
		$foglalas = $wpdb->get_row($wpdb->prepare("SELECT * FROM emw25_standok WHERE email LIKE '%s'", $row['email']), ARRAY_A);

	if (! empty($foglalas)) {
		$teMarFoglaltal = TRUE;
	} else {
		// megnezzuk hogy idokozben elfogyott-e a hely	
		$szabad = $wpdb->get_var($wpdb->prepare("SELECT id FROM emw25_standok WHERE email IS NULL AND id = %d", $where['id']));

		if (! $szabad) {
			$foglaltLettKozben = TRUE;
		} else {
			// db save
			if ($wpdb->update('emw25_standok', $row, $where)) {

				// lemodo link

				
				$cancelUrl = 'https://www.homeinfo.hu/emw/standok.php?lemondas=' . $row['email'] . '&id=' . $where['id'] . '&lang=' . ($_GET['lang'] ?? 'hu');
				$foglalas = $wpdb->get_row($wpdb->prepare("SELECT * FROM emw25_standok WHERE id = %d", $where['id']), ARRAY_A);
				$foglalas['link'] = $cancelUrl;
				$foglalas['extras'] = $extras;
				$foglalas['extras_total'] = $extras_total;
				$foglalas['extras_discount'] = $extras_discount;
				$foglalas['extras_discount_percent'] = $extras_discount_percent;
				$foglalas['final_price'] = $final_price;
				$foglalas['stand_price'] = $stand_price;
				$foglalas['stand_discount'] = $stand_discount;
				$foglalas['stand_discount_percent'] = $stand_discount_percent;
				$foglalas['stand_dimensions'] = $stand_dimensions;
				$foglalas['waste_fee'] = $waste_fee;
				$foglalas['comment'] = $comment;

				// email	
				$emailBody = createHTML($foglalas,  'standok-email_' . ($_GET['lang'] ?? 'hu') . '.html');


				sendEmailBrevo($row['email'], __('standok.email.subject'), $emailBody);


				$successMessage = TRUE;
			} else {
				$errorMessage = TRUE;
			}
		}
	}
}


function my_print_error()
{
	global $wpdb;

	if ($wpdb->last_error !== '') {
		$str   = htmlspecialchars($wpdb->last_error, ENT_QUOTES);
		$query = htmlspecialchars($wpdb->last_query, ENT_QUOTES);

		if (strpos($str, 'Duplicate entry') !== FALSE)
			print __('standok.error.duplicate');
		else
			print __('standok.error.database', ['str' => $str, 'query' => $query]);
	}
}


// Helper - Email küldése
function sendEmailBrevo($to, $subject, $htmlContent)
{
	$config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', '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');
	$apiInstance = new Brevo\Client\Api\TransactionalEmailsApi(new GuzzleHttp\Client(),	$config);
	$sendSmtpEmail = new \Brevo\Client\Model\SendSmtpEmail([
		'subject' => $subject,
		'sender' => ['name' => 'HOMEINFO.hu', 'email' => 'info@homeinfo.hu'],
		'replyTo' => ['name' => 'HOMEINFO.hu support', 'email' => 'fejlesztes@homeinfo.hu'],
		'to' => [['email' => $to]],
		//		 'bcc' => [['email' => 'fejlesztes@homeinfo.hu']],
		'bcc' => [['email' => 'tamas.devenyi@homeinfo.hu'], ['email' => 'dora.szabo@homeinfo.hu'], ['email' => 'alexandra.lasan@homeinfo.hu'], ['email' => 'fejlesztes@homeinfo.hu']],
		'htmlContent' => $htmlContent,
		//'attachment' => [ ['content' => base64_encode($icsString), 'name'	=> 'invite.ics'] ]	 
	]);

	try {
		$result = $apiInstance->sendTransacEmail($sendSmtpEmail);
	} catch (Exception $e) {
		//echo 'Az email küldés problémába ütközött. Kérjük, írjon a fejlesztes@homeinfo.hu címre.';
		mail('fejlesztes@homeinfo.hu', 'Email kuldo hiba, sendmail helyettesites | EMW standok.php', $e->getMessage());

		//sendEmail($to, $subject, $htmlContent, $icsString);
	}
}

function createHTML($data, $template)
{
	ob_start();
	include(ABSPATH . $template);
	$html = ob_get_clean();
	return $html;
}



?>
<!DOCTYPE html>
<html lang="hu">

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

	<title><?php echo __('standok.title'); ?> | ÉMW</title>
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
	<link rel="apple-touch-icon" sizes="180x180" href="https://www.homeinfo.hu/emw/apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="https://www.homeinfo.hu/emw/favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="https://www.homeinfo.hu/emw/favicon-16x16.png">
	<link rel="manifest" href="https://www.homeinfo.hu/emw/site.webmanifest">
	<meta property="og:title" content="<?php echo __('standok.title'); ?>">
	<meta property="og:description" content="">

	<meta property="og:url" content="https://www.homeinfo.hu/emw/standok.php?lang=<?php echo $_GET['lang'] ?? 'hu'; ?>">
	<meta property="og:image" content="">
	<meta property="fb:app_id" content="">

	<link href="/jegyvasarlas/assets/main.css" rel="stylesheet" type="text/css">
	<link href="/emw/standterkep-foglalas.css?35" rel="stylesheet" type="text/css">


	<script src="/media/jui/js/jquery.min.js?287fb55bac9e5f8ec84bd927bf4af23f" type="text/javascript"></script>
	<?php include(ASSETS_PATH . '/homeinfo.google-analytics.php'); /*+pinterest*/ ?>
	<?php include(ASSETS_PATH . '/homeinfo.facebook-pixel.php'); ?>
	<?php include(ASSETS_PATH . '/homeinfo.tiktok-pixel.php'); ?>

	<style>
		#survey>header {
			max-width: 1000px;
			margin: 2rem auto 0;
			background: #ffe619;
			border-radius: 1rem 1rem 0 0;
		}


		.alert-error .button {
			background: #e70b0b !important;
		}

		.question {
			max-width: 1000px;
		}
	</style>
</head>

<body id="survey">
	<header>
		<?php /* <h1>
			 <span><a href="https://www.homeinfo.hu/"><img src="https://www.homeinfo.hu/assets/homeinfo2017/images/homeinfo-logo-124x54.tudastar.png" alt=""></a></span> 
		</h1>   
		<p style="text-align:center;font-size:1.4rem;"><strong><?php echo __('standok.ravak_registration'); ?></strong></p>
		*/ ?>
		<figure id="img580x300">
			<a target="_blank" href="https://www.homeinfo.hu/emw/standok.php?lang=<?php echo $_GET['lang'] ?? 'hu'; ?>" title="<?php echo __('standok.event_title'); ?>">
				<img src="/emw/assets/emw_580x128_<?php echo $_GET['lang'] ?? 'hu'; ?>.webp" width="580" height="128" alt="">
			</a>
		</figure>
	</header>

	<form method="post">

		<div id="survey-container">


			<div id="survey-questions" class="single">
				<div class="question clearfix form-question">
					<header class="eventHeader">
						<hgroup>
							<div class="eventHeader__title"><?php echo __('standok.title'); ?></div>
							<!--div class="eventHeader__date">2025. október 18-19.</div-->
							<?php 
								$url = 'https://docs.google.com/presentation/d/14ylBCq6UiREd0zAsJp_1lpUlEGLv-XCX47rx3Z3sVWI/embed?slide=id.g3414aa2ac29_0_0';
								if ( (isset($_GET['lang']) AND $_GET['lang'] == 'en') OR (isset($_GET['en'])) OR (isset($_GET['eng'])) )
									$url = 'https://docs.google.com/presentation/d/11eMvGbKiEV3OuXKRYp-g6vSre5281yS29pk8PlvSLEY/embed?slide=id.g3414aa2ac29_0_0';
							?>
							<div class="eventHeader__info">
								<ul>
									<li><a href="<?php echo $url; ?>" target="_blank"><?php echo __('standok.offer_presentation'); ?></a></li>
									<li><?php echo __('standok.hold_info'); ?></li>
									<li><?php echo __('standok.contract_info'); ?></li>
								</ul>
							</div>
						</hgroup>
					</header>

					<?php if ($cancellationMessage) : ?>

						<hgroup>
							<div class="alert alert-success">
								<figure><img src="/jegyvasarlas/assets/success_icon.svg"></figure>
								<p><strong><?php echo __('standok.cancellation.success'); ?></strong></p>
							</div>
						</hgroup>
						<footer>
							<nav class="question-nav clearfix">
								<ul>
									<li><a class="button" href="https://www.homeinfo.hu/emw/?lang=<?php echo $_GET['lang'] ?? 'hu'; ?>"><?php echo __('standok.cancellation.button'); ?></a></li>
								</ul>
							</nav>
						</footer>

					<?php elseif ($successMessage) : ?>

						<hgroup>
							<div class="alert alert-success">
								<figure><img src="/jegyvasarlas/assets/success_icon.svg"></figure>
								<p>
									<strong><?php echo __('standok.success.title'); ?></strong>
									<br><?php echo __('standok.success.number'); ?><strong><?php echo $foglalas['stand']; ?></strong>
									<br>
									<br><?php echo __('standok.success.contact'); ?>
								</p>
							</div>
						</hgroup>
						<footer>
							<nav class="question-nav clearfix">
								<ul>
									<?php if (! empty($cancelUrl)) : ?>
										<li><a class="button" href="<?php echo $cancelUrl; ?>" style="background:#f44336;">&times; <?php echo __('standok.success.cancel'); ?></a></li>
									<?php endif; ?>
								</ul>
							</nav>
						</footer>

					<?php elseif ($teMarFoglaltal) : ?>
						<hgroup>
							<div class="alert alert-error">
								<figure><img src="/jegyvasarlas/assets/error_icon.svg"></figure>
								<p>
									<?php echo __('standok.error.exists'); ?>
									<br>
									<br>Stand: <strong><?php echo $foglalas['stand']; ?></strong>
									<br>
									<br><a class="cta-btn btn button" href="https://www.homeinfo.hu/emw/standok.php?lemondas=<?php echo $foglalas['email']; ?>&id=<?php echo $foglalas['id']; ?>&lang=<?php echo $_GET['lang'] ?? 'hu'; ?>" target="_blank"><?php echo __('standok.success.cancel'); ?></a>
								</p>
							</div>
						</hgroup>
					<?php else: ?>

						<?php if ($errorMessage) : ?>
							<hgroup>
								<div class="alert alert-error">
									<figure><img src="/jegyvasarlas/assets/error_icon.svg"></figure>
									<p><?php echo my_print_error(); ?></p>
								</div>
							</hgroup>
						<?php endif; ?>


						<?php if ($foglaltLettKozben) : ?>
							<hgroup>
								<div class="alert alert-error">
									<figure><img src="/jegyvasarlas/assets/error_icon.svg"></figure>
									<p><?php echo __('standok.error.taken'); ?><br><?php echo __('standok.choose.other'); ?></p>
								</div>
							</hgroup>
						<?php endif; ?>

						<!--header>					
					<hgroup>
						<h3 class="question-title">
							<?php echo __('standok.available_stands'); ?>
						</h3>			
					</hgroup>
				</header-->

						<div class="question-form clearfix">

							<div class="standok">
								<section id="standterkep">

									<main>


										<div id="standTerkep">

											<div id="standTerkepRight">
												<h2>&bdquo;A&rdquo; <?php echo __('standok.hall'); ?><h2>
														<div id="standok">
															<img src="/emw/standterkep-foglalas_<?php echo $_GET['lang'] ?? 'hu'; ?>.png" alt="">
															<!-- <img src="/emw/standterkep_dev.png" alt="">	-->
															<?php foreach ($standok as $item) : ?>
																<?php list($w, $h) = explode('x', $item['size']); ?>
																<input type="radio" name="selected_stand" id="radio<?php echo $item['id']; ?>" <?php echo (empty($item['name']) AND empty($item['email'])) ? '' : 'disabled' ?> value="<?php echo $item['id']; ?>">
																<label class="stand w<?php echo $w; ?> h<?php echo $h; ?> <?php echo (empty($item['name']) AND empty($item['email'])) ? 'empty' : 'disabled' ?>" id="stand<?php echo $item['id']; ?>" for="radio<?php echo $item['id']; ?>">
																	<strong><?php echo $item['stand']; ?></strong>
																	<span class="dimensions" data-sqmprice="<?php echo $listaar[$item['type']]; ?>"><?php echo str_replace(['65'], ['6.5'], $item['size']); ?></span>
																</label>
															<?php endforeach; ?>
														</div>

														<h2>&bdquo;B&rdquo; <?php echo __('standok.hall'); ?> - <?php echo __('standok.wood'); ?><h2>
																<div id="standokB">
																	<img src="/emw/standterkep-foglalas-b_<?php echo $_GET['lang'] ?? 'hu'; ?>.png" alt="">
																	<!-- <img src="/emw/standterkep-foglalas-b-dev.png" alt="">	-->
																	<?php foreach ($standokB as $item) : ?>
																		<?php list($w, $h) = explode('x', $item['size']); ?>
																		<input type="radio" name="selected_stand" id="radio<?php echo $item['id']; ?>" <?php echo (empty($item['name']) AND empty($item['email'])) ? '' : 'disabled' ?> value="<?php echo $item['id']; ?>">
																		<label class="stand w<?php echo $w; ?> h<?php echo $h; ?> <?php echo (empty($item['name']) AND empty($item['email'])) ? 'empty' : 'disabled' ?>" id="stand<?php echo $item['id']; ?>" for="radio<?php echo $item['id']; ?>">
																			<strong><?php echo $item['stand']; ?></strong>
																			<span class="dimensions" data-sqmprice="<?php echo $listaar[$item['type']]; ?>"><?php echo str_replace(['65'], ['6.5'], $item['size']); ?></span>
																		</label>
																	<?php endforeach; ?>
																</div>
											</div>

										</div>

									</main>
								</section>
							</div>



							<ul>
								<li><label><?php echo __('form.name'); ?><span class="required">*</span></label><input required name="name" type="text"></li>
								<li class="question-item">
									<div class="emailMobilZip">
										<div class="emailMobilIr__email"><label><span class="label"><?php echo __('form.email'); ?><span class="required">*</span></span></label><input required type="email" name="email"></div>
										<div class="emailMobilIr__mobil"><label><span class="label"><?php echo __('form.phone'); ?><span class="required">*</span></span></label><input required type="text" name="phone"></div>

									</div>
								</li>
								<li><label><?php echo __('form.message'); ?></label><textarea name="comment" cols="10" rows="3"></textarea></li>


								<li class="question-item">
									<label class="checkbox">
										<input required="" name="policy" value="1" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.privacy_terms'); ?><span class="required">*</span></span>
									</label>
								</li>

								<?php /*					
						<li class="question-item">
							<label class="checkbox">
								<input required="" name="policy" value="1" type="checkbox">
								<div class="checkbox-button"></div>
								<span class="label" style="font-weight:300;">A <a target="_blank" href="https://www.homeinfo.hu/stand-elofoglalas-szandeknyilatkozat.pdf"><u><?php echo __('standok.form.intent_declaration'); ?></u></a>-ot elolvastam, elfogadom.<span class="required">*</span></span>
							</label>
						</li>				
*/ ?>


							</ul>
							<style>
								.extrasList {}

								.extrasList li {
									display: flex;
									align-items: center;
									gap: 2rem;
								}

								.extrasList li>div {
									white-space: nowrap;
									min-width: 68px;
								}

								.extrasList label {
									flex-grow: 1;
								}

								.extrasList .label {
									flex-grow: 1;
									width: 100%;
								}

								.extrasList label small {
									font-size: small;
									opacity: .7;
								}

								.extrasList [readonly] {
									border-color: transparent;
									background: none;
									cursor: default;
								}

								.extrasList [name*=quantity] {
									width: 74px;
								}

								.extrasList textarea[readonly] {
									border-color: transparent;
									background: none;
									font-size: small;
									opacity: .7;
									padding: 0;
									margin: 0;
									width: 100%;
									height: auto;
									min-height: auto;
									resize: none;
									field-sizing: content;
									line-height: 1.5;
								}
							</style>
							<h4 style="padding:1rem 0;margin: 1rem 0; font-weight:bold;"><?php echo __('standok.extras.title'); ?></h4>
							<ul class="extrasList" id="extras-list">
								<li class="question-item gratis">
									<label class="checkbox">
										<input value="<?php echo __('standok.extras.vip_parking'); ?>" type="checkbox" checked disabled>
										<div class="checkbox-button"></div>
										<input value="<?php echo __('standok.extras.vip_parking'); ?>" type="hidden" name="extras[0]">
										<span class="label" style="font-weight:300;">
											<?php echo __('standok.extras.vip_parking'); ?>
											<textarea name="description[0]" cols="1" rows="1" readonly><?php echo __('standok.extras.vip_parking_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[0]" value="1" type="number" min="1" max="1" readonly></div>
									<div><input type="text" name="unitprice[0]" value="11 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[0]" value="<?php echo __('standok.extras.free'); ?>" readonly></div>
								</li>
								<li class="question-item gratis">
									<label class="checkbox">
										<input value="<?php echo __('standok.extras.gift_ticket'); ?>" type="checkbox" checked disabled>
										<div class="checkbox-button"></div>
										<input value="<?php echo __('standok.extras.gift_ticket'); ?>" type="hidden" name="extras[1]">
										<span class="label" style="font-weight:300;">
											<?php echo __('standok.extras.gift_ticket'); ?>
											<textarea name="description[1]" cols="1" rows="1" readonly><?php echo __('standok.extras.gift_ticket_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[1]" value="50" type="number" min="50" max="50" readonly></div>
									<div><input type="text" name="unitprice[1]" value="1 650 Ft" readonly></div>
									<div><input type="text" name="sumprice[1]" value="<?php echo __('standok.extras.free'); ?>" readonly></div>
								</li>
								<li class="question-item gratis">
									<label class="checkbox">
										<input value="<?php echo __('standok.extras.content_box'); ?>" type="checkbox" checked disabled>
										<div class="checkbox-button"></div>
										<input value="<?php echo __('standok.extras.content_box'); ?>" type="hidden" name="extras[2]">
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.content_box'); ?>
											<textarea name="description[2]" cols="1" rows="1" readonly><?php echo __('standok.extras.content_box_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[2]" value="1" type="number" min="1" max="1" readonly></div>
									<div><input type="text" name="unitprice[2]" value="-" readonly></div>
									<div><input type="text" name="sumprice[2]" value="<?php echo __('standok.extras.free'); ?>" readonly></div>
								</li>
								<li class="question-item gratis">
									<label class="checkbox">
										<input value="Homeinfo Mester App" type="checkbox" checked disabled>
										<div class="checkbox-button"></div>
										<input value="Homeinfo Mester App" type="hidden" name="extras[3]">
										<span class="label" style="font-weight:300;">Homeinfo Mester App
											<textarea name="description[6]" cols="1" rows="1" readonly><?php echo __('standok.extras.master_app_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[3]" value="<?php echo __('standok.extras.master_app_duration'); ?>" type="text" min="6" max="6" readonly></div>
									<div><input type="text" name="unitprice[3]" value="-" readonly></div>
									<div><input type="text" name="sumprice[3]" value="<?php echo __('standok.extras.free'); ?>" readonly></div>
								</li>
								<li class="question-item">
									<label class="checkbox">
										<input name="extras[4]" value="<?php echo __('standok.extras.advertising'); ?>" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.advertising'); ?>
											<textarea name="description[4]" cols="1" rows="1" readonly><?php echo __('standok.extras.advertising_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[4]" value="1" type="number" step="1" min="1" max="10"></div>
									<div><input type="text" name="unitprice[4]" value="250 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[4]" value="250 000 Ft" readonly></div>
								</li>
								<li class="question-item">
									<label class="checkbox">
										<input name="extras[5]" value="<?php echo __('standok.extras.crown_installation'); ?>" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.crown_installation'); ?>
											<textarea name="description[5]" cols="1" rows="1" readonly><?php echo __('standok.extras.crown_installation_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[5]" value="1" type="number" step="1" min="1" max="10"></div>
									<div><input type="text" name="unitprice[5]" value="250 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[5]" value="250 000 Ft" readonly></div>
								</li>
								<li class="question-item">
									<label class="checkbox">
										<input name="extras[6]" value="<?php echo __('standok.extras.program_guide_full'); ?>" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.program_guide_full'); ?>
											<textarea name="description[6]" cols="1" rows="1" readonly><?php echo __('standok.extras.program_guide_full_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[6]" value="1" type="number" step="1" min="1" max="10"></div>
									<div><input type="text" name="unitprice[6]" value="350 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[6]" value="350 000 Ft" readonly></div>
								</li>
								<li class="question-item">
									<label class="checkbox">
										<input name="extras[7]" value="<?php echo __('standok.extras.program_guide_half'); ?>" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.program_guide_half'); ?>
											<textarea name="description[7]" cols="1" rows="1" readonly><?php echo __('standok.extras.program_guide_half_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[7]" value="1" type="number" step="1" min="1" max="10"></div>
									<div><input type="text" name="unitprice[7]" value="275 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[7]" value="275 000 Ft" readonly></div>
								</li>
								<li class="question-item">
									<label class="checkbox">
										<input name="extras[8]" value="<?php echo __('standok.extras.conference_presentation'); ?>" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.conference_presentation'); ?>
											<textarea name="description[8]" cols="1" rows="1" readonly><?php echo __('standok.extras.conference_presentation_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[8]" value="1" type="number" step="1" min="1" max="10"></div>
									<div><input type="text" name="unitprice[8]" value="430 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[8]" value="430 000 Ft" readonly></div>
								</li>
								<li class="question-item">
									<label class="checkbox">
										<input name="extras[9]" value="<?php echo __('standok.extras.amplified_presentation'); ?>" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.amplified_presentation'); ?>
											<textarea name="description[9]" cols="1" rows="1" readonly><?php echo __('standok.extras.amplified_presentation_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[9]" value="1" type="number" step="1" min="1" max="10"></div>
									<div><input type="text" name="unitprice[9]" value="210 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[9]" value="210 000 Ft" readonly></div>
								</li>
								<li class="question-item">
									<label class="checkbox">
										<input name="extras[10]" value="<?php echo __('standok.extras.main_sponsor'); ?>" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.extras.main_sponsor'); ?>
											<textarea name="description[10]" cols="1" rows="1" readonly><?php echo __('standok.extras.main_sponsor_desc'); ?></textarea>
										</span>
									</label>
									<div><input name="quantity[10]" value="1" type="number" min="1" max="1" readonly></div>
									<div><input type="text" name="unitprice[10]" value="2 000 000 Ft" readonly></div>
									<div><input type="text" name="sumprice[10]" value="2 000 000 Ft" readonly></div>
								</li>
							</ul>
							<!-- Updated Summary Section -->
							<div class="summary-section" style="padding: 15px 10px; margin-top: 10px; border-top: 1px solid #ccc;">

								<!-- Stand Details Row -->
								<div class="summary-row" style="display: flex; align-items: center; justify-content: flex-end; margin-bottom: 5px; min-height: 1.5em;">
									<span id="stand-details-label" style="margin-right: 20px; width: 150px; text-align: right;">Stand:</span>
									<input type="text" id="stand-price-display" value="<?php echo __('standok.form.not_selected'); ?>" style="text-align: right; font-weight: normal; border: none; background: transparent; width: 150px;" readonly>
								</div>

								<!-- === NEW: Stand Discount Row === -->
								<div class="summary-row" style="display: flex; align-items: center; justify-content: flex-end; margin-bottom: 5px;">
									<span id="stand-discount-label" style="margin-right: 20px; width: 150px; text-align: right;"><?php echo __('standok.form.stand_discount', ['percent' => '0']); ?></span>
									<input type="text" id="total-stand-discount-amount" value="- 0 Ft" style="text-align: right; font-weight: normal; border: none; background: transparent; width: 150px; color: green;" readonly>
								</div>
								<!-- ============================== -->

								<!-- Extras Total Row -->
								<div class="summary-row" style="display: flex; align-items: center; justify-content: flex-end; margin-bottom: 5px;">
									<span style="margin-right: 20px; width: 150px; text-align: right;"><?php echo __('standok.form.extras_total'); ?></span>
									<input type="text" id="total-extras-price" value="0 Ft" style="text-align: right; font-weight: normal; border: none; background: transparent; width: 150px;" readonly>
								</div>

								<!-- Extras Discount Row -->
								<div class="summary-row" style="display: flex; align-items: center; justify-content: flex-end; margin-bottom: 5px;">
									<span id="extras-discount-label" style="margin-right: 20px; width: 150px; text-align: right;"><?php echo __('standok.form.extras_discount', ['percent' => '0']); ?></span> <!-- Renamed ID for clarity -->
									<input type="text" id="total-extras-discount-amount" value="- 0 Ft" style="text-align: right; font-weight: normal; border: none; background: transparent; width: 150px; color: green;" readonly> <!-- Renamed ID for clarity -->
								</div>

								<!-- Waste Fee Row -->
								<div class="summary-row" style="display: flex; align-items: center; justify-content: flex-end; margin-bottom: 5px;">
									<span style="margin-right: 20px; width: 150px; text-align: right;"><?php echo __('standok.form.waste_fee'); ?></span>
									<input type="text" id="total-waste-fee" value="0 Ft" style="text-align: right; font-weight: normal; border: none; background: transparent; width: 150px;" readonly>
								</div>

								<!-- Divider -->
								<div style="display: flex; justify-content: flex-end; margin-bottom: 5px;">
									<div style="border-top: 1px solid #eee; width: calc(150px + 150px + 20px);"></div>
								</div>

								<!-- Final Price Row -->
								<div class="summary-row" style="display: flex; align-items: center; justify-content: flex-end; font-size: 1.1em;">
									<strong style="margin-right: 20px; width: 150px; text-align: right;"><?php echo __('standok.form.total'); ?></strong>
									<input type="text" id="total-final-price" value="0 Ft" style="text-align: right; font-weight: bold; border: none; background: transparent; width: 150px;" readonly>
								</div>

								<!-- Hidden Fields -->
								<input type="hidden" name="selected_stand" id="hidden-selected-stand-value" value="">
								<input type="hidden" name="stand_price" id="hidden-stand-price" value="0">
								<input type="hidden" name="stand_dimensions" id="hidden-stand-dimensions" value="">
								<input type="hidden" name="stand_discount_percent" id="hidden-stand-discount-percent" value="0"> <!-- NEW -->
								<input type="hidden" name="stand_discount" id="hidden-stand-discount-amount" value="0"> <!-- NEW -->
								<input type="hidden" name="extras_total" id="hidden-extras-total" value="0">
								<input type="hidden" name="extras_discount_percent" id="hidden-extras-discount-percent" value="0"> <!-- Renamed -->
								<input type="hidden" name="extras_discount" id="hidden-extras-discount-amount" value="0"> <!-- Renamed -->
								<input type="hidden" name="waste_fee" id="hidden-waste-fee" value="0">
								<input type="hidden" name="final_price" id="hidden-final-price" value="0">

							</div>
							<script>
								/**
								 * Complete JavaScript for Quote Form Calculation with State Persistence
								 *
								 * Features:
								 * - Handles Stand selection (calculates area, price).
								 * - Calculates extras total (excluding .gratis items).
								 * - Calculates Waste Fee based on stand area.
								 * - Calculates tiered discount *only on extras total*.
								 * - Displays Stand Price, Extras Total, Discount (on Extras), Waste Fee, and Final Price.
								 * - Updates hidden fields for all calculated values.
								 * - Persists state using sessionStorage.
								 * - Handles bfcache.
								 */

								// --- Helper Functions ---

								function parseCurrency(currencyString) {
									if (!currencyString) return 0;
									const numericString = String(currencyString).replace(/[^\d]/g, '');
									return parseInt(numericString, 10) || 0;
								}

								function formatCurrency(number) {
									const formattedNumber = Number(number).toLocaleString('hu-HU', {
										minimumFractionDigits: 0,
										maximumFractionDigits: 0
									});
									return formattedNumber + ' Ft';
								}

								function formatDiscountCurrency(number) {
									if (number === 0) return '- 0 Ft';
									const formattedNumber = Number(number).toLocaleString('hu-HU', {
										minimumFractionDigits: 0,
										maximumFractionDigits: 0
									});
									return '- ' + formattedNumber + ' Ft';
								}

								function calculateSquareMeters(dimensions) {
									if (typeof dimensions !== 'string' || !dimensions.includes('x')) return 0;
									const parts = dimensions.split('x');
									if (parts.length !== 2) return 0;
									const width = parseFloat(parts[0]);
									const height = parseFloat(parts[1]);
									if (isNaN(width) || isNaN(height) || width <= 0 || height <= 0) return 0;
									return width * height;
								}

								// --- Constants ---
								const SESSION_STORAGE_KEY = 'quoteFormState';
								const WASTE_FEE_RATE_PER_SQM = 350;
								const WASTE_FEE_MULTIPLIER = 1.1;

								// Stand Discount Thresholds/Rates
								const STAND_DISCOUNT_THRESHOLD_1 = 1000000;
								const STAND_DISCOUNT_THRESHOLD_2 = 2000000;
								const STAND_DISCOUNT_RATE_1 = 0.05; // 5%
								const STAND_DISCOUNT_RATE_2 = 0.10; // 10%

								// Extras Discount Thresholds/Rates
								const EXTRAS_DISCOUNT_THRESHOLD_1 = 649000;
								const EXTRAS_DISCOUNT_THRESHOLD_2 = 2000000;
								const EXTRAS_DISCOUNT_THRESHOLD_3 = 3000000;
								const EXTRAS_DISCOUNT_RATE_1 = 0.05; // 5%
								const EXTRAS_DISCOUNT_RATE_2 = 0.10; // 10%
								const EXTRAS_DISCOUNT_RATE_3 = 0.15; // 15%

								// --- State Management Functions --- (No changes needed here)

								function saveStateToSessionStorage() {
									const itemContainer = document.getElementById('extras-list');
									const selectedStandRadio = document.querySelector('input[name="selected_stand"]:checked');
									const state = {
										extras: {},
										selectedStandValue: selectedStandRadio ? selectedStandRadio.value : null
									};
									if (itemContainer) {
										const listItems = itemContainer.querySelectorAll('li.question-item:not(.gratis)'); // Respect :not(.gratis)
										listItems.forEach(item => {
											const checkbox = item.querySelector('input[type="checkbox"][name^="extras["]');
											const quantityInput = item.querySelector('input[type="number"][name^="quantity["]');
											let index = null;
											let match = null;
											if (checkbox && checkbox.name) match = checkbox.name.match(/\[(\d+)\]/);
											else if (quantityInput && quantityInput.name) match = quantityInput.name.match(/\[(\d+)\]/);
											if (match) index = match[1];

											if (index !== null && checkbox && quantityInput) {
												state.extras[index] = {
													checked: checkbox.checked,
													quantity: quantityInput.value
												};
											}
										});
									} else {
										console.warn("saveState: Cannot find item container '#extras-list'.");
									}
									try {
										sessionStorage.setItem(SESSION_STORAGE_KEY, JSON.stringify(state));
										console.log("State saved to sessionStorage:", state);
									} catch (e) {
										console.error("Error saving state:", e);
									}
								}

								function restoreStateFromSessionStorage() {
									const itemContainer = document.getElementById('extras-list');
									let stateRestored = false;
									try {
										const savedStateString = sessionStorage.getItem(SESSION_STORAGE_KEY);
										if (!savedStateString) return false;
										const savedState = JSON.parse(savedStateString);
										console.log("Attempting restore:", savedState);

										// Restore Stand
										if (savedState.selectedStandValue) {
											const standRadioToSelect = document.querySelector(`input[name="selected_stand"][value="${savedState.selectedStandValue}"]`);
											if (standRadioToSelect) {
												standRadioToSelect.checked = true;
												stateRestored = true;
												console.log(`Restored stand: ${savedState.selectedStandValue}`);
											} else {
												const currentlyCheckedStand = document.querySelector('input[name="selected_stand"]:checked');
												if (currentlyCheckedStand) currentlyCheckedStand.checked = false;
											}
										} else {
											const currentlyCheckedStand = document.querySelector('input[name="selected_stand"]:checked');
											if (currentlyCheckedStand) currentlyCheckedStand.checked = false;
										}

										// Restore Extras (respecting :not(.gratis))
										if (itemContainer && savedState.extras) {
											const listItems = itemContainer.querySelectorAll('li.question-item:not(.gratis)'); // Apply selector here too
											let extrasRestoredCount = 0;
											listItems.forEach(item => {
												const checkbox = item.querySelector('input[type="checkbox"][name^="extras["]');
												const quantityInput = item.querySelector('input[type="number"][name^="quantity["]');
												const unitPriceInput = item.querySelector('input[type="text"][name^="unitprice["]');
												const sumPriceInput = item.querySelector('input[type="text"][name^="sumprice["]');
												let index = null;
												let match = null;
												if (checkbox && checkbox.name) match = checkbox.name.match(/\[(\d+)\]/);
												else if (quantityInput && quantityInput.name) match = quantityInput.name.match(/\[(\d+)\]/);
												if (match) index = match[1];

												if (index !== null && savedState.extras[index] && checkbox && quantityInput && unitPriceInput && sumPriceInput) {
													const itemState = savedState.extras[index];
													checkbox.checked = itemState.checked;
													quantityInput.value = itemState.quantity;
													const quantity = parseInt(quantityInput.value, 10) || 0;
													const unitPrice = parseCurrency(unitPriceInput.value);
													sumPriceInput.value = formatCurrency(quantity * unitPrice);
													extrasRestoredCount++;
													stateRestored = true;
												}
											});
											console.log(`Restored state for ${extrasRestoredCount} extras.`);
										}
										if (stateRestored) console.log("State successfully restored.");
									} catch (e) {
										console.error("Error restoring state:", e);
										stateRestored = false;
									}
									return stateRestored;
								}


								// --- Main Calculation Logic ---

								function updateSummaryAndDiscount() {
									console.log(">>> Running updateSummaryAndDiscount...");

									// Select elements (including new ones)
									const itemContainer = document.getElementById('extras-list');
									const standDetailsLabel = document.getElementById('stand-details-label');
									const standPriceDisplay = document.getElementById('stand-price-display');
									const standDiscountLabel = document.getElementById('stand-discount-label'); // New
									const standDiscountAmountDisplay = document.getElementById('total-stand-discount-amount'); // New
									const extrasTotalDisplay = document.getElementById('total-extras-price');
									const extrasDiscountLabel = document.getElementById('extras-discount-label'); // Renamed ID
									const extrasDiscountAmountDisplay = document.getElementById('total-extras-discount-amount'); // Renamed ID
									const wasteFeeDisplay = document.getElementById('total-waste-fee');
									const finalPriceDisplay = document.getElementById('total-final-price');

									// Hidden fields
									const hiddenSelectedStandValue = document.getElementById('hidden-selected-stand-value');
									const hiddenStandPrice = document.getElementById('hidden-stand-price');
									const hiddenStandDimensions = document.getElementById('hidden-stand-dimensions');
									const hiddenStandDiscountPercent = document.getElementById('hidden-stand-discount-percent'); // New
									const hiddenStandDiscountAmount = document.getElementById('hidden-stand-discount-amount'); // New
									const hiddenExtrasTotal = document.getElementById('hidden-extras-total');
									const hiddenExtrasDiscountPercent = document.getElementById('hidden-extras-discount-percent'); // Renamed
									const hiddenExtrasDiscountAmount = document.getElementById('hidden-extras-discount-amount'); // Renamed
									const hiddenWasteFee = document.getElementById('hidden-waste-fee');
									const hiddenFinalPrice = document.getElementById('hidden-final-price');

									// Basic element check
									if (!standPriceDisplay || !standDiscountAmountDisplay || !extrasTotalDisplay || !extrasDiscountAmountDisplay || !wasteFeeDisplay || !finalPriceDisplay /* Add other critical checks */ ) {
										console.error('updateSummary: Missing one or more required summary display elements.');
										return;
									}

									let standPrice = 0;
									let standDescription = "<?php echo __('standok.form.not_selected'); ?>";
									let selectedStandValue = "";
									let standDimensionsValue = "";
									let standArea = 0;

									// 1. Calculate Stand Price, Area and Details
									const selectedStandRadio = document.querySelector('input[name="selected_stand"]:checked');
									if (selectedStandRadio) {
										selectedStandValue = selectedStandRadio.value;
										const standLabel = document.querySelector(`label[for="${selectedStandRadio.id}"]`);
										const dimensionsSpan = standLabel ? standLabel.querySelector('span.dimensions') : null;
										if (dimensionsSpan) {
											const dimensionsText = dimensionsSpan.textContent;
											standDimensionsValue = dimensionsText;
											const sqmPrice = parseFloat(dimensionsSpan.dataset.sqmprice) || 0;
											standArea = calculateSquareMeters(dimensionsText);
											if (standArea > 0 && sqmPrice > 0) {
												standPrice = standArea * sqmPrice;
												standDescription = `Stand (${dimensionsText} = ${standArea} m²):`;
												console.log(`Stand: Value=${selectedStandValue}, Area=${standArea}, Price=${standPrice}`);
											} else {
												standDescription = `<?php echo __('standok.form.price_error'); ?>`;
											}
										} else {
											standDescription = `<?php echo __('standok.form.missing_data'); ?>`;
										}
									} else {
										console.log("No stand selected.");
									}
									standDetailsLabel.textContent = standDescription;
									standPriceDisplay.value = selectedStandRadio ? formatCurrency(standPrice) : "<?php echo __('standok.form.not_selected'); ?>";

									// 2. Calculate Stand Discount
									let standDiscountPercent = 0;
									let standDiscountAmount = 0;
									if (standPrice > STAND_DISCOUNT_THRESHOLD_2) {
										standDiscountPercent = STAND_DISCOUNT_RATE_2 * 100;
										standDiscountAmount = Math.round(standPrice * STAND_DISCOUNT_RATE_2);
									} else if (standPrice > STAND_DISCOUNT_THRESHOLD_1) {
										standDiscountPercent = STAND_DISCOUNT_RATE_1 * 100;
										standDiscountAmount = Math.round(standPrice * STAND_DISCOUNT_RATE_1);
									}
									console.log(`Calculated stand discount: ${standDiscountAmount} (${standDiscountPercent}%)`);


									// 3. Calculate Extras Subtotal (excluding .gratis)
									let extrasSubtotal = 0;
									if (itemContainer) {
										const listItems = itemContainer.querySelectorAll('li.question-item:not(.gratis)');
										listItems.forEach(function(item) {
											const checkbox = item.querySelector('input[type="checkbox"]');
											const sumInput = item.querySelector('input[name^="sumprice["]');
											if (checkbox && checkbox.checked && sumInput) {
												extrasSubtotal += parseCurrency(sumInput.value);
											}
										});
									}
									console.log(`Calculated extras subtotal: ${extrasSubtotal}`);


									// 4. Calculate Extras Discount (New Logic)
									let extrasDiscountPercent = 0;
									let extrasDiscountAmount = 0;
									if (extrasSubtotal >= EXTRAS_DISCOUNT_THRESHOLD_3) {
										extrasDiscountPercent = EXTRAS_DISCOUNT_RATE_3 * 100;
										extrasDiscountAmount = Math.round(extrasSubtotal * EXTRAS_DISCOUNT_RATE_3);
									} else if (extrasSubtotal >= EXTRAS_DISCOUNT_THRESHOLD_2) {
										extrasDiscountPercent = EXTRAS_DISCOUNT_RATE_2 * 100;
										extrasDiscountAmount = Math.round(extrasSubtotal * EXTRAS_DISCOUNT_RATE_2);
									} else if (extrasSubtotal > EXTRAS_DISCOUNT_THRESHOLD_1) { // Note: strict '>' for the first threshold
										extrasDiscountPercent = EXTRAS_DISCOUNT_RATE_1 * 100;
										extrasDiscountAmount = Math.round(extrasSubtotal * EXTRAS_DISCOUNT_RATE_1);
									}
									console.log(`Calculated extras discount: ${extrasDiscountAmount} (${extrasDiscountPercent}%)`);


									// 5. Calculate Waste Fee
									let wasteFee = 0;
									if (standArea > 0) {
										wasteFee = Math.round(standArea * WASTE_FEE_RATE_PER_SQM * WASTE_FEE_MULTIPLIER);
									}
									console.log(`Calculated waste fee: ${wasteFee}`);


									// 6. Calculate Final Price (incorporating both discounts)
									// Final = (Stand Price - Stand Discount) + (Extras Total - Extras Discount) + Waste Fee
									const finalPrice = (standPrice - standDiscountAmount) + (extrasSubtotal - extrasDiscountAmount) + wasteFee;
									console.log(`Final Price: ${finalPrice} = (Stand ${standPrice} - Disc ${standDiscountAmount}) + (Extras ${extrasSubtotal} - Disc ${extrasDiscountAmount}) + Waste ${wasteFee}`);


									// 7. Update Display Elements
									standDiscountLabel.textContent = `<?php echo __('standok.form.stand_discount', ['percent' => '${standDiscountPercent}']); ?>`;
									standDiscountAmountDisplay.value = formatDiscountCurrency(standDiscountAmount);
									extrasTotalDisplay.value = formatCurrency(extrasSubtotal);
									extrasDiscountLabel.textContent = `<?php echo __('standok.form.extras_discount', ['percent' => '${extrasDiscountPercent}']); ?>`; // Update label
									extrasDiscountAmountDisplay.value = formatDiscountCurrency(extrasDiscountAmount);
									wasteFeeDisplay.value = formatCurrency(wasteFee);
									finalPriceDisplay.value = formatCurrency(finalPrice);
									console.log("Updated summary display elements.");

									// 8. Update Hidden Input Fields
									hiddenSelectedStandValue.value = selectedStandValue;
									hiddenStandPrice.value = standPrice;
									hiddenStandDimensions.value = standDimensionsValue;
									hiddenStandDiscountPercent.value = standDiscountPercent; // New
									hiddenStandDiscountAmount.value = standDiscountAmount; // New
									hiddenExtrasTotal.value = extrasSubtotal;
									hiddenExtrasDiscountPercent.value = extrasDiscountPercent; // Renamed
									hiddenExtrasDiscountAmount.value = extrasDiscountAmount; // Renamed
									hiddenWasteFee.value = wasteFee;
									hiddenFinalPrice.value = finalPrice;
									console.log("Updated hidden fields.");

									console.log("<<< updateSummaryAndDiscount Finished.");
								}

								// --- Initial Setup and Event Binding ---
								document.addEventListener('DOMContentLoaded', function() {
									console.log("DOMContentLoaded event fired.");
									const itemContainer = document.getElementById('extras-list');
									const standRadios = document.querySelectorAll('input[name="selected_stand"]');

									console.log("Attempting restore...");
									restoreStateFromSessionStorage(); // Restore state first

									// Stand Radio Button Changes
									standRadios.forEach(function(radio) {
										radio.addEventListener('change', function() {
											if (this.checked) {
												console.log("Stand selection changed - Value:", this.value);
												updateSummaryAndDiscount();
												saveStateToSessionStorage();
											}
										});
									});

									// Quantity/Checkbox Listeners (respecting :not(.gratis))
									if (itemContainer) {
										// Quantity Input Changes
										itemContainer.querySelectorAll('li.question-item:not(.gratis) input[type="number"][name^="quantity["]').forEach(function(quantityInput) {
											quantityInput.addEventListener('input', function() {
												console.log("Quantity changed:", this.name, this.value);
												const parentLi = this.closest('li.question-item'); // Find parent li
												if (!parentLi) return;
												const unitPriceInput = parentLi.querySelector('input[type="text"][name^="unitprice["]');
												const sumPriceInput = parentLi.querySelector('input[type="text"][name^="sumprice["]');
												if (!unitPriceInput || !sumPriceInput) return;
												const quantity = parseInt(this.value, 10) || 0;
												const unitPrice = parseCurrency(unitPriceInput.value);
												sumPriceInput.value = formatCurrency(quantity * unitPrice);
												updateSummaryAndDiscount();
												saveStateToSessionStorage();
											});
										});

										// Checkbox Changes
										itemContainer.querySelectorAll('li.question-item:not(.gratis) input[type="checkbox"][name^="extras["]').forEach(function(checkbox) {
											checkbox.addEventListener('change', function() {
												console.log("Checkbox changed:", this.name, this.checked);
												updateSummaryAndDiscount();
												saveStateToSessionStorage();
											});
										});
									}

									// Initial Calculation
									console.log("Calculating initial summary...");
									updateSummaryAndDiscount();
									console.log("Initial setup complete.");
								}); // End DOMContentLoaded


								// --- Listener for bfcache restoration ---
								window.addEventListener('pageshow', function(event) {
									console.log(`pageshow: persisted=${event.persisted}`);
									if (event.persisted) {
										console.log("Restored from bfcache. Recalculating summary...");
										updateSummaryAndDiscount();
									}
								}); // End pageshow listener

								console.log("Quote script loaded.");
							</script>

						</div>

						<footer>

							<nav class="question-nav clearfix">
								<ul>
													<li class="question-item">
									<label class="checkbox">
										<input required="" name="policy" value="1" type="checkbox">
										<div class="checkbox-button"></div>
										<span class="label" style="font-weight:300;"><?php echo __('standok.privacy_terms'); ?></span><span class="required">*</span>
									</label>
								</li>
									<li style="text-align:center"><button type="submit" name="submit" value="1" class="button"><?php echo __('standok.form.submit'); ?></button></li>
								</ul>
							</nav>

						</footer>

				</div>
			<?php endif; ?>

			</div>
		</div>
	</form>

	<div id="loading" class="loading" style="display:none;"></div>

	<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>

</body>

</html>