export function standTerkepInit(standTerkep) {	
	if (standTerkep)
	{
		const standTerkepListaFilter = standTerkep.querySelector('[data-standterkep-filter]');
		const standTerkepListaFilterElements = standTerkepListaFilter.querySelectorAll('li');
		const standTerkepListaElements = standTerkep.querySelectorAll('[data-standterkep-list] li');
		const stands = standTerkep.querySelectorAll('.stand');

		standTerkepListaFilter.addEventListener('click', e => {
			e.stopPropagation();
			
			if(e.target.nodeName !== 'LI') return false;
			
			standTerkepListaFilterElements.forEach(li => li.classList.remove('on'));
			
			e.target.classList.add('on');
			
			const tooltips = standTerkep.querySelectorAll('.stand-tooltip');
			tooltips.forEach(item => item.remove());

			const category = e.target.innerText; 

			stands.forEach(stand => stand.classList.add('off'));     

			standTerkepListaElements.forEach(li => {
				const standNo =  li.dataset.stand.split(',');
					   
				if( li.dataset.category.includes(category)) {
					li.classList.remove('hide');
					standNo.forEach(no => standTerkep.querySelector('[data-stand-id="stand'+no+'"')?.classList.remove('off'));     
				} else {
					li.classList.add('hide');		
					
				}
					
			})
		});
		
		standTerkepListaElements.forEach(li => {
			li.addEventListener('click', e => { 
				const standNo = li.dataset.stand.split(',');                
				standTerkep.querySelector('[data-stand-id="stand'+standNo[0]+'"').dispatchEvent(new Event('click'));										
			});					
		}); 
		
		stands.forEach(stand => {    
			stand.addEventListener('click', e => {   
				const van = stand.querySelector('.stand-tooltip');
				if (van) {
					van.remove();
					return;
				}
				let companies = [];
						 
				standTerkepListaElements.forEach(li => {
					const standNo = li.dataset.stand.split(',');                
					standNo.forEach(num => {
						if (num == stand.innerText) {
							companies.push(li);                          
						}                    
					});
				});            
								   
				const tooltips = standTerkep.querySelectorAll('.stand-tooltip');
				tooltips.forEach(item => item.remove());
				if ( ! companies) return;
				let text = ''; 
				companies.forEach(item => text = (!text) ? item.innerText : text + ', ' + item.innerText);       
				const tooltip = document.createElement('div');
				tooltip.className = "stand-tooltip";        
				tooltip.innerText = text;        
				tooltip.style.opacity = 1;
				stand.append(tooltip);
			})
		});
		
		standTerkep.addEventListener('click', e => { 					
			standTerkep.querySelector('.stand-tooltip')?.remove();
		}, { capture: true });
		
	} 
} 