<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);

header("X-Robots-Tag: noindex, noarchive, nosnippet", TRUE);
header('Content-Type: text/html; charset=utf-8');

require_once('../jegyvasarlas/config.php');


global $wpdb;

date_default_timezone_set('Europe/Budapest');

define('DAY_PENTEK',18);
define('DAY_SZOMBAT',19);
//define('DAY_VASARNAP',25);



// live
$live = 0;
if ( date('d') == DAY_PENTEK)
	$live = $wpdb->get_row( "SELECT COUNT(`id`) AS db FROM `jegyek` WHERE `belepett_pentek` > 0 AND  UNIX_TIMESTAMP(`belepett_mikor_pentek`) BETWEEN UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 1 HOUR)) AND UNIX_TIMESTAMP();", ARRAY_A );
if ( date('d') == DAY_SZOMBAT)
	$live = $wpdb->get_row( "SELECT COUNT(`id`) AS db FROM `jegyek` WHERE `belepett_szombat` > 0 AND  UNIX_TIMESTAMP(`belepett_mikor_szombat`) BETWEEN UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 1 HOUR)) AND UNIX_TIMESTAMP();", ARRAY_A );

// Péntek
$pentek = array('7'=>0,'8'=>0,'9'=>0,'10'=>0,'11'=>0,'12'=>0,'13'=>0,'14'=>0,'15'=>0,'16'=>0,'17'=>0);
//$res = $wpdb->get_results("SELECT HOUR(`belepett_mikor_pentek`) AS hour, COUNT(`id`) AS db FROM `jegyek` WHERE `belepett_pentek` > 0 GROUP BY HOUR(`belepett_mikor_pentek`) ORDER BY HOUR(`belepett_mikor_pentek`) ASC;", ARRAY_A );
// Diákjegy nélkül
$res = $wpdb->get_results("SELECT HOUR(`belepett_mikor_pentek`) AS hour, COUNT(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN `vasarlas` ON  (`vasarlas`.id = `jegyek`.kinek AND (`vasarlas`.`kupon_tipus` NOT LIKE 'Diákjegy' OR `vasarlas`.`kupon_tipus` IS NULL) ) WHERE `belepett_pentek` > 0 GROUP BY HOUR(`belepett_mikor_pentek`) ORDER BY HOUR(`belepett_mikor_pentek`) ASC;", ARRAY_A );
foreach ($res AS $item)			
	$pentek[$item['hour']] = $item['db'];	
	
// 366 diák sacc eloszlás	
$pentek['8'] += 60;
$pentek['9'] += 136; 
$pentek['10'] += 150;
$pentek['11'] += 20;
	
// Szombat
$szombat = array('7'=>0,'8'=>0,'9'=>0,'10'=>0,'11'=>0,'12'=>0,'13'=>0,'14'=>0,'15'=>0,'16'=>0,'17'=>0);
$res = $wpdb->get_results("SELECT HOUR(`belepett_mikor_szombat`) AS hour, COUNT(`id`) AS db FROM `jegyek` WHERE `belepett_szombat` > 0 GROUP BY HOUR(`belepett_mikor_szombat`) ORDER BY HOUR(`belepett_mikor_szombat`) ASC;", ARRAY_A );
foreach ($res AS $item)			
	$szombat[$item['hour']] = $item['db'];


//  Belépett helyszini vásárlók 
$buyBok = array();
$res = $wpdb->get_results("SELECT DAY(`create_date`) AS nap, SUM(`jegyek_szama`) AS db FROM `vasarlas` WHERE `penztar_id` IS NOT NULL AND `statusz` = 'FINISHED' AND `event` = 'emw' GROUP BY DAY(`create_date`);", ARRAY_A );
foreach ($res AS $item)			
	$buyBok[$item['nap']] = $item['db'];	
	
//  Belépett Online vásárlók	-ki kell szurni az elogeneralt jegyeket (`jegyek`.`kinek` > 1) és a tiszteltejgyeket (`vasarlas`.`darabar` > 0)
$buyOnline = array();
$res = $wpdb->get_results("SELECT DAY(`jegyek`.`belepett_mikor_pentek`) AS nap, count(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN vasarlas ON (`vasarlas`.`id` = `jegyek`.`kinek` AND `vasarlas`.`darabar` > 0) WHERE  `jegyek`.`kinek` > 1 AND `jegyek`.`belepett_pentek` > 0 GROUP BY DAY(`jegyek`.`belepett_mikor_pentek`);", ARRAY_A );
foreach ($res AS $item)			
	$buyOnline[$item['nap']] = $item['db'];
$res = $wpdb->get_results("SELECT DAY(`jegyek`.`belepett_mikor_szombat`) AS nap, count(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN vasarlas ON (`vasarlas`.`id` = `jegyek`.`kinek` AND `vasarlas`.`darabar` > 0) WHERE  `jegyek`.`kinek` > 1 AND `jegyek`.`belepett_szombat` > 0 GROUP BY DAY(`jegyek`.`belepett_mikor_szombat`);", ARRAY_A );
foreach ($res AS $item)			
	$buyOnline[$item['nap']] = $item['db'];
	
//  Belépett Tiszteletjegy azaz darabar = 0 (lehet kinek = 1 is, az előgenerált tiszteltjegy)
$buyNone = array();
//$res = $wpdb->get_results("SELECT DAY(`jegyek`.`belepett_mikor_pentek`) AS nap, count(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN vasarlas ON (`vasarlas`.`id` = `jegyek`.`kinek` AND `vasarlas`.`darabar` = 0 ) WHERE `jegyek`.`belepett_pentek` > 0 GROUP BY DAY(`jegyek`.`belepett_mikor_pentek`);", ARRAY_A );
$res = $wpdb->get_results("SELECT DAY(`jegyek`.`belepett_mikor_pentek`) AS nap, count(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN vasarlas ON (`vasarlas`.`id` = `jegyek`.`kinek` AND `vasarlas`.`darabar` = 0 AND (`vasarlas`.`kupon_tipus` NOT LIKE 'Diákjegy' OR `vasarlas`.`kupon_tipus` IS NULL)) WHERE `jegyek`.`belepett_pentek` > 0 GROUP BY DAY(`jegyek`.`belepett_mikor_pentek`);", ARRAY_A );
foreach ($res AS $item)			
	$buyNone[$item['nap']] = $item['db'];
$buyNone['18'] += 366; // diákok száma 	
$res = $wpdb->get_results("SELECT DAY(`jegyek`.`belepett_mikor_szombat`) AS nap, count(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN vasarlas ON (`vasarlas`.`id` = `jegyek`.`kinek` AND `vasarlas`.`darabar` = 0) WHERE `jegyek`.`belepett_szombat` > 0 GROUP BY DAY(`jegyek`.`belepett_mikor_szombat`);", ARRAY_A );
foreach ($res AS $item)			
	$buyNone[$item['nap']] = $item['db'];


// Fizetős jegyek
$jegyekSum = $wpdb->get_var("SELECT sum(jegyek_szama) FROM `vasarlas` WHERE `statusz` LIKE 'FINISHED' AND `darabar` > 0 AND `event` = 'emw';"); 
$jegyekBelepett = $wpdb->get_var("SELECT count(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN vasarlas ON (`vasarlas`.`id` = `jegyek`.`kinek` AND `vasarlas`.`darabar` > 0 AND  `vasarlas`.`event` = 'emw' and `vasarlas`.`statusz` LIKE 'FINISHED') WHERE ( `jegyek`.`belepett_pentek` > 0 OR  `jegyek`.`belepett_szombat` > 0 )");
	
// Tsizteletjegyesek belépési aránya
$tiszteletjegyekSum = $wpdb->get_var("SELECT sum(jegyek_szama)  FROM `vasarlas` WHERE `darabar` = 0 AND `event` = 'emw' AND DATE(create_date) <= '2024-10-19'"); 
//$tiszteletjegyekSum += 578; // +elogeneralt bétextil 148, Qtee 30, Szitnetika 400 
$tiszteletjegyekBelepett = $wpdb->get_var("SELECT count(`jegyek`.`id`) AS db FROM `jegyek` INNER JOIN vasarlas ON (`vasarlas`.`id` = `jegyek`.`kinek` AND `vasarlas`.`darabar` = 0 AND  `event` = 'emw') WHERE ( `jegyek`.`belepett_pentek` > 0 OR  `jegyek`.`belepett_szombat` > 0 ) ");

	
// Total	
//$sumPentek   = $wpdb->get_row("SELECT count(`id`) as db FROM `jegyek` WHERE belepett_pentek > 0 ", ARRAY_A ); 	
// diákok nélkül
$sumPentek   = $wpdb->get_row("SELECT count(`jegyek`.`id`) as db FROM `jegyek`  INNER JOIN `vasarlas` ON  (`vasarlas`.id = `jegyek`.kinek AND (`vasarlas`.`kupon_tipus` NOT LIKE 'Diákjegy' OR `vasarlas`.`kupon_tipus` IS NULL) )WHERE belepett_pentek > 0 ", ARRAY_A ); 	
$sumPentek['db'] += 366; // Belépett diákok
$sumPentek['db'] += 151; // 302 Le nem olvasott belépés (a fennmaradó megvásárolt és be nem lépett jegyek száma) megfeleztük két napra
$sumSzombat  = $wpdb->get_row("SELECT count(`id`) as db FROM `jegyek` WHERE belepett_szombat > 0 ", ARRAY_A );		
$sumSzombat['db'] += 151; // 302 Le nem olvasott belépés (a fennmaradó megvásárolt és be nem lépett jegyek száma) megfeleztük két napra
	
// Pénztárak
$penztar1 = penztarData(1);		
$penztar2 = penztarData(3);		
	
function penztarData($penztar_id)
{		
	global $jegyvasalasConfig;
	global $wpdb;
	$brutto_egysegar = $jegyvasalasConfig['brutto_egysegar_helyszini'];
	
	$initArr = [
		'jegyek_szama' => 0,
		'bevetel' => 0,
		'bevetel_bankkartya' => 0,
		'bevetel_keszpenz' => 0,
		'sztorno_jegyek' => 0,
		'sztorno_osszeg' => 0,
	];
	
	$kimutatas = [
	 	DAY_PENTEK => $initArr,
		DAY_SZOMBAT => $initArr,
	];	
	
	// Napi jegyek_szama nap=>2024-01-24, sum=>3  
	$napok = $wpdb->get_results( $wpdb->prepare("SELECT DAY(`create_date`) AS nap, SUM(`jegyek_szama`) AS sum FROM `vasarlas` WHERE statusz = 'FINISHED' AND `penztar_id` = %d GROUP BY DATE(`create_date`) ORDER BY `create_date` DESC;", $penztar_id), ARRAY_A);
	foreach($napok AS $item)
	{
		// Napi jegyek száma
		$kimutatas[$item['nap']]['jegyek_szama'] = $item['sum'];
		// $kimutatas[$item['nap']]['jegyek_szama_papir'] = $wpdb->get_var($wpdb->prepare("SELECT sum(jegyek_szama) FROM `vasarlas` WHERE `statusz` LIKE 'FINISHED' AND `penztar_id`=%d AND DAY(create_date)=%s AND email = 'helyszini@jegyvasarlo.hu'", $penztar_id, $item['nap']));	
		// az online a tablazatba szamoljuk ki a ketto kulonbsegebol
		
		// Napi bevetel
		$kimutatas[$item['nap']]['bevetel'] = $item['sum'] * $brutto_egysegar;
		$kimutatas[$item['nap']]['bevetel_bankkartya'] = $wpdb->get_var($wpdb->prepare("SELECT sum(jegyek_szama) FROM `vasarlas` WHERE paymentmethod = 'Bankkártya' AND `statusz` LIKE 'FINISHED' AND `penztar_id`=%d AND DAY(create_date)=%s", $penztar_id, $item['nap'])) * $brutto_egysegar;;					
		$kimutatas[$item['nap']]['bevetel_keszpenz'] = $kimutatas[$item['nap']]['bevetel'] - $kimutatas[$item['nap']]['bevetel_bankkartya'];
		

		// NApi sztornó
		$kimutatas[$item['nap']]['sztorno_jegyek'] = $wpdb->get_var($wpdb->prepare("SELECT sum(jegyek_szama) FROM `vasarlas` WHERE `statusz` LIKE 'STORNO' AND `penztar_id`=%d AND DAY(create_date)=%s", $penztar_id, $item['nap']));				
		$kimutatas[$item['nap']]['sztorno_osszeg'] = $kimutatas[$item['nap']]['sztorno_jegyek'] * $brutto_egysegar;				
	}		

	return $kimutatas;
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<!-- Libs CSS -->
    <link rel="stylesheet" href="../termekek/dashboard/feather.min.css">
    <link rel="stylesheet" href="../termekek/dashboard/flatpickr.min.css">
    <link rel="stylesheet" href="../termekek/dashboard/quill.core.css">
    <link rel="stylesheet" href="../termekek/dashboard/select2.min.css">
    <link rel="stylesheet" href="../termekek/dashboard/vs2015.css">
    <link rel="stylesheet" href="../termekek/dashboard/mapbox-gl.css" >
    <link rel="stylesheet" href="../termekek/dashboard/theme.min.css">
	<style type="text/css">/* Chart.js */
	@keyframes chartjs-render-animation{from{opacity:.99}to{opacity:1}}.chartjs-render-monitor{animation:chartjs-render-animation 1ms}.chartjs-size-monitor,.chartjs-size-monitor-expand,.chartjs-size-monitor-shrink{position:absolute;direction:ltr;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1}.chartjs-size-monitor-expand>div{position:absolute;width:1000000px;height:1000000px;left:0;top:0}.chartjs-size-monitor-shrink>div{position:absolute;width:200%;height:200%;left:0;top:0}
	.break-word {overflow-wrap: break-word; word-wrap: break-word;  -ms-word-break: break-all;  word-break: break-all;  word-break: break-word;	}
	.header-date {    margin-top: .5em;   margin-bottom: 0;}
	.navbar-light {
    background-color: #03379a;
    border-color: #ffffff;
}
	</style>
	
	<title>Statisztika | ÉMW 2024</title>	
</head>
<body>

<nav class="navbar navbar-vertical fixed-left navbar-expand-md navbar-light" id="sidebar">
	<div class="container-fluid">



		<!-- Brand -->
		<a class="" href="/emw/">
			<img src="android-chrome-192x192.png" class="" alt="ÉMW 2024">
		</a>



	</div>
</nav> 

<div class="main-content">

	<!-- HEADER -->
	<div class="header">
		<div class="container-fluid">

			<!-- Body -->
			<div class="header-body">
				<div class="row align-items-end">
					<div class="col">
						<!-- Pretitle -->
						<h6 class="header-pretitle">
							Áttekintés
						</h6>
						<!-- Title -->
						<h1 class="header-title">
							Statisztika
						</h1> 
					</div>
					<div class="col-auto">
						<strong>Vásárolt jegy belépett: <?php echo $jegyekBelepett ;?> / <?php echo $jegyekSum ;?>  </strong>
					</div>						
					<div class="col-auto">
						<strong>Tiszteletjegy belépett: <?php echo $tiszteletjegyekBelepett ;?> / <?php echo $tiszteletjegyekSum ;?>  </strong>
					</div>														
					<div class="col-auto">
						<strong><mark>Összesen: <?php echo $sumPentek['db'] + $sumSzombat['db'] ; ?> db belépés</mark> (366 diákkal és 302 le nem olvasott jeggyel)</strong>
					</div>
				</div> <!-- / .row -->
			</div> <!-- / .header-body -->

		</div>
	</div> <!-- / .header -->

<div class="container-fluid">
      
	<div class="row">
		<div class="col-12 col-lg-6 col-xl">
		
			<!-- Card -->
			<div class="card border-success" >
				<div class="card-body">
					<div class="row align-items-center">
						<div class="col">							
							<h6 class="card-title text-uppercase text-muted mb-2">
								<span class="text-success">●</span> Elmúlt 1 óra
							</h6>                   							
							<span class="h2 mb-0">
								<?php echo $live['db'];?> db
								
							</span>
						</div>
						<div class="col-auto">           
						 
							<span class="h2 fe fe-users text-muted mb-0"></span>
						</div>
					</div> <!-- / .row -->
				</div>
			</div>
			
		</div>	
		<div class="col-12 col-lg-6 col-xl">
		<!-- Card -->
			<div class="card">
				<div class="card-body">
					<div class="row align-items-center">
						<div class="col">							
							<h6 class="card-title text-uppercase text-muted mb-2">
								Péntek
							</h6>                   							
							<span class="h2 mb-0">
								<?php echo $sumPentek['db'];?> db <small>(366 diákkal és 151 le nem olvasott jeggyel)</small>
							</span>
						</div>
						<div class="col-auto">           
						 
							<span class="h2 fe fe-users text-muted mb-0"></span>
						</div>
					</div> <!-- / .row -->
				</div>
			</div>	
		</div>
		<div class="col-12 col-lg-6 col-xl">
		<!-- Card -->
			<div class="card">
				<div class="card-body">
					<div class="row align-items-center">
						<div class="col">							
							<h6 class="card-title text-uppercase text-muted mb-2">
								Szombat
							</h6>                   							
							<span class="h2 mb-0">
								<?php echo ($sumSzombat['db']) ? $sumSzombat['db'] : 0;?> db <small>(151 le nem olvasott jeggyel)</small>
							</span>
						</div>
						<div class="col-auto">           
						 
							<span class="h2 fe fe-users text-muted mb-0"></span>
						</div>
					</div> <!-- / .row -->
				</div>			
				</div>			
		</div>
		<div class="col-12 col-lg-6 col-xl">

		</div>
	</div>
	
	
	<?php if ($sumSzombat['db'] > 0) : ?>
	<div class="row">
		<div class="col-12 col-xl-8">


			<div class="card">
				<div class="card-header">
					<div class="row align-items-center">
						<div class="col">
							<h4 class="card-header-title">
								Szombat - <?php echo $sumSzombat['db']; ?> db
							</h4>
						</div>	
						
					</div><!-- / .row -->
				</div>
				<div class="card-body">

					<!-- Chart -->
					<div class="chart"><div class="chartjs-size-monitor"><div class="chartjs-size-monitor-expand"><div class=""></div></div><div class="chartjs-size-monitor-shrink"><div class=""></div></div></div>
					  <canvas id="visitorsChart2fs" class="chart-canvas chartjs-render-monitor" width="993" height="300" style="display: block; width: 993px; height: 300px;" ></canvas>
					</div>
					<script>
					window.visitorsChart2fs.data = {
						labels: ["<?php echo implode('","',array_keys($szombat));?>"],
						datasets: [{
							label: "Látogató",
							data: [<?php echo implode(',',$szombat);?>]
						}]
					};
					</script>
				</div>
			</div>

		</div>
		<div class="col-12  col-xl-4">
			<!-- Devices -->
			<div class="card">
				<div class="card-header">
					<div class="row align-items-center">
						<div class="col">
							<!-- Title -->
							<h4 class="card-header-title">
							Szombat - <?php echo $sumSzombat['db']; ?> db 
							</h4>
						</div>
					</div> <!-- / .row -->
				</div>
				<div class="card-body">
					<!-- Chart -->
					<div class="chart chart-appended">
						<canvas id="visitorsPie2fs" class="chart-canvas" data-toggle="legend" data-target="#visitorsPie2fsLegend"></canvas>
					</div>
					<!-- Legend -->
					<div id="visitorsPie2fsLegend" class="chart-legend"></div>
					<script>
						window.visitorsPie2fs.labels = ["Helyszíni (<?php echo $buyBok[DAY_SZOMBAT]; ?>)","Online (<?php echo $buyOnline[DAY_SZOMBAT]; ?>)","Tiszteletjegy (<?php echo $buyNone[DAY_SZOMBAT]; ?>)"];					
						window.visitorsPie2fs.data = [<?php echo $buyBok[DAY_SZOMBAT]; ?>, <?php echo $buyOnline[DAY_SZOMBAT]; ?>, <?php echo $buyNone[DAY_SZOMBAT]; ?>];				
					</script>	
				</div>
			</div>	

		</div>
	</div><!-- / .row -->		
	
	
		
	<div class="row">

		<div class="col-12 col-xl-8">
		<!-- Card -->
		<div class="card">
              <div class="card-header">
                <div class="row align-items-center">
                  <div class="col">

                    <!-- Title -->
                    <h4 class="card-header-title">
                      Szombat - Pénztárak
                    </h4>

                  </div>
                 
                </div> <!-- / .row -->
              </div>
              <div class="table-responsive mb-0">
                <table class="table table-sm table-nowrap card-table">
                  <thead>
                    <tr>
                      <th>Pénztár </th>                     
					  <th> Jegyek </th>
                      <th> Bevétel </th>
                      <th> Bankkártya </th>
                      <th>Készpénz</th>                     
                      <th>Sztorno jegyek</th>                     
                      <th>Sztorno összeg</th>                     
                    </tr>
                  </thead>
                  <tbody class="list">
					<tr>
                      <td>Pénztár 1</td>
                      <td><?php echo $penztar1[DAY_SZOMBAT]['jegyek_szama']; ?> db</td>
                      <td><strong><?php echo number_format($penztar1[DAY_SZOMBAT]['bevetel'], 0, '', ' '); ?> Ft</strong></td>
                      <td><?php echo number_format($penztar1[DAY_SZOMBAT]['bevetel_bankkartya'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar1[DAY_SZOMBAT]['bevetel_keszpenz'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar1[DAY_SZOMBAT]['sztorno_jegyek'], 0, '', ' '); ?> db</td>
                      <td><?php echo number_format($penztar1[DAY_SZOMBAT]['sztorno_osszeg'], 0, '', ' '); ?> Ft</td>
                    </tr>					
					<tr>
                      <td>Pénztár 2</td>
                      <td><?php echo $penztar2[DAY_SZOMBAT]['jegyek_szama']; ?> db</td>
                      <td><strong><?php echo number_format($penztar2[DAY_SZOMBAT]['bevetel'], 0, '', ' '); ?> Ft</strong></td>
                      <td><?php echo number_format($penztar2[DAY_SZOMBAT]['bevetel_bankkartya'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar2[DAY_SZOMBAT]['bevetel_keszpenz'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar2[DAY_SZOMBAT]['sztorno_jegyek'], 0, '', ' '); ?> db</td>
                      <td><?php echo number_format($penztar2[DAY_SZOMBAT]['sztorno_osszeg'], 0, '', ' '); ?> Ft</td>					  
                    </tr>					
					</tbody>
                </table>
              </div>
            </div>
		</div>
	</div>	
<?php endif; ?>		
	
<?php if ($sumPentek['db'] > 0) : ?>
	<div class="row">
		<div class="col-12 col-xl-8">


			<div class="card">
				<div class="card-header">
					<div class="row align-items-center">
						<div class="col">
							<h4 class="card-header-title">
								Péntek - <?php echo $sumPentek['db']; ?> db 
							</h4>
						</div>	
									
											
					</div><!-- / .row -->
				</div>
				<div class="card-body">

					<!-- Chart -->
					<div class="chart"><div class="chartjs-size-monitor"><div class="chartjs-size-monitor-expand"><div class=""></div></div><div class="chartjs-size-monitor-shrink"><div class=""></div></div></div>
					  <canvas id="visitorsChart" class="chart-canvas chartjs-render-monitor" width="993" height="300" style="display: block; width: 993px; height: 300px;" ></canvas>
					</div>
					<script>
					window.visitorsChart.data = {
						labels: ["<?php echo implode('","',array_keys($pentek));?>"],
						datasets: [{
							label: "Látogató",
							data: [<?php echo implode(',',$pentek);?>]
						}]
					};
					</script>
				</div>
			</div>

		</div>
		<div class="col-12  col-xl-4">
			<!-- Devices -->
			<div class="card">
				<div class="card-header">
					<div class="row align-items-center">
						<div class="col">
							<!-- Title -->
							<h4 class="card-header-title">
							Péntek - <?php echo $sumPentek['db']; ?> db 
							</h4>
						</div>
					</div> <!-- / .row -->
				</div>
				<div class="card-body">
					<!-- Chart -->
					<div class="chart chart-appended">
						<canvas id="visitorsPie" class="chart-canvas" data-toggle="legend" data-target="#visitorsPieLegend"></canvas>
					</div>
					<!-- Legend -->
					<div id="visitorsPieLegend" class="chart-legend"></div>
					<script>
						window.visitorsPie.labels = ["Helyszíni (<?php echo $buyBok[DAY_PENTEK]; ?>)","Online (<?php echo $buyOnline[DAY_PENTEK]; ?>)","Tiszteletjegy (<?php echo $buyNone[DAY_PENTEK]; ?>)"];					
						window.visitorsPie.data = [<?php echo $buyBok[DAY_PENTEK]; ?>, <?php echo $buyOnline[DAY_PENTEK]; ?>, <?php echo $buyNone[DAY_PENTEK]; ?>];				
					</script>	
				</div>
			</div>	

		</div>
	</div><!-- / .row -->		
	
	
	
	
	<div class="row">

		<div class="col-12 col-xl-8">
		<!-- Card -->
		<div class="card">
              <div class="card-header">
                <div class="row align-items-center">
                  <div class="col">

                    <!-- Title -->
                    <h4 class="card-header-title">
                      Péntek - Pénztárak
                    </h4>

                  </div>
                 
                </div> <!-- / .row -->
              </div>
              <div class="table-responsive mb-0">
                <table class="table table-sm table-nowrap card-table">
                  <thead>
                    <tr>
                      <th>Pénztár </th>                     
					  <th> Jegyek </th>
                      <th> Bevétel </th>
                      <th> Bankkártya </th>
                      <th>Készpénz</th>                     
                      <th>Sztorno jegyek</th>                     
                      <th>Sztorno összeg</th>                     
                    </tr>
                  </thead>
                  <tbody class="list">
					<tr>
                      <td>Pénztár 1</td>
                      <td><?php echo $penztar1[DAY_PENTEK]['jegyek_szama']; ?> db</td>
                      <td><strong><?php echo number_format($penztar1[DAY_PENTEK]['bevetel'], 0, '', ' '); ?> Ft</strong></td>
                      <td><?php echo number_format($penztar1[DAY_PENTEK]['bevetel_bankkartya'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar1[DAY_PENTEK]['bevetel_keszpenz'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar1[DAY_PENTEK]['sztorno_jegyek'], 0, '', ' '); ?> db</td>
                      <td><?php echo number_format($penztar1[DAY_PENTEK]['sztorno_osszeg'], 0, '', ' '); ?> Ft</td>
                    </tr>					
					<tr>
                      <td>Pénztár 2</td>
                      <td><?php echo $penztar2[DAY_PENTEK]['jegyek_szama']; ?> db</td>
                      <td><strong><?php echo number_format($penztar2[DAY_PENTEK]['bevetel'], 0, '', ' '); ?> Ft</strong></td>
                      <td><?php echo number_format($penztar2[DAY_PENTEK]['bevetel_bankkartya'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar2[DAY_PENTEK]['bevetel_keszpenz'], 0, '', ' '); ?> Ft</td>
                      <td><?php echo number_format($penztar2[DAY_PENTEK]['sztorno_jegyek'], 0, '', ' '); ?> db</td>
                      <td><?php echo number_format($penztar2[DAY_PENTEK]['sztorno_osszeg'], 0, '', ' '); ?> Ft</td>					  
                    </tr>					
					</tbody>
                </table>
              </div>
            </div>
		</div>
	</div>
	
	<?php endif; ?>	
	
</div>	

<script src="../termekek/dashboard/jquery.min.js"></script>
<script src="../termekek/dashboard/bootstrap.bundle.min.js"></script>
<script src="../termekek/dashboard/draggable.bundle.legacy.js"></script>
<script src="../termekek/dashboard/autosize.min.js"></script>	
<script src="../termekek/dashboard/Chart.min.js"></script>
<script src="../termekek/dashboard/flatpickr.min.js"></script>
<script src="../termekek/dashboard/highlight.pack.min.js"></script>
<script src="../termekek/dashboard/jquery.mask.min.js"></script>
<script src="../termekek/dashboard/list.min.js"></script>
<script src="../termekek/dashboard/quill.min.js"></script>
<script src="../termekek/dashboard/select2.min.js"></script>
<script src="../termekek/dashboard/Chart.extension.min.js"></script>
<script src="../termekek/dashboard/mapbox-gl.js"></script>
<script src="../termekek/dashboard/theme.js?13"></script>
</body>
</html>