<?php
require_once($_SERVER['DOCUMENT_ROOT'] . '/assets/homeinfo2017/define.php');

error_reporting(E_ALL);
ini_set("display_errors", 1);
header('Content-Type: text/html; charset=utf-8');

define('ABSPATH', DOCUMENT_ROOT.'/emw/');

require_once DOCUMENT_ROOT.'/ev-furdoszobaja/vendor/autoload.php'; // Brevo email kuldo
require_once DOCUMENT_ROOT.'/kepgaleria-otletek/scripts/class.phpmailer.php'; // Backup email
require_once DOCUMENT_ROOT.'/jegyvasarlas/wpdb.php';


$wpdb = new wpdb( 'dasl1_usr_jegyv', 'S]!X,0tL0rC1', 'dasl1_db_jegyvasarlas', 'localhost' );
$wpdb->query("
	SET 
		NAMES 'utf8', 
		CHARACTER SET 'utf8', 
		character_set_results = 'utf8', 
		character_set_client = 'utf8', 
		character_set_connection = 'utf8', 
		character_set_database = 'utf8', 
		character_set_server = 'utf8'
");
global $wpdb;

date_default_timezone_set('Europe/Budapest');

$successMessage = FALSE;
$errorMessage = FALSE;
$cancellationMessage = FALSE;
$foglaltLettKozben = FALSE;
$teMarFoglaltal = FALSE;

$_SESSION['ervenyesJegy'] = 1; // nem kerunk jegyet

if ( ! isset($_SESSION['ervenyesJegy']))
	$_SESSION['ervenyesJegy'] = 0;

setlocale(LC_ALL, 'hu_HU');

if ( ! empty($_GET['lemondas']) AND ! empty($_GET['id']) )
{	
	$foglalas = $wpdb->get_row( $wpdb->prepare("SELECT * FROM emw24_tesztvezetes WHERE tesztvezetes_id = %d AND email = %s", $_GET['id'], $_GET['lemondas'] ) );	
	if ( ! empty($foglalas))
	{
		$wpdb->query("UPDATE `emw24_tesztvezetes` SET `email`=NULL,`name`=NULL,`phone`=NULL,`create_date`='0000-00-00 00:00:00' WHERE `tesztvezetes_id`= ".$foglalas->tesztvezetes_id.";");
		$cancellationMessage = TRUE;
	}
	else
	{
		header("Location: https://www.homeinfo.hu/emw/tesztvezetes.php"); 
	}
						
}

$autok = array();

$autok[1]['name'] = 'Citroen C5 X Plug-in Hybrid';
$autok[1]['img'] = 'https://www.homeinfo.hu/emw/assets/citroen.webp';
$autok[1]['idopontok']['péntek'] = $wpdb->get_results( "SELECT * FROM emw24_tesztvezetes WHERE `nap` LIKE 'péntek' AND `auto` = '".$autok[1]['name']."'", ARRAY_A );
$autok[1]['idopontok']['szombat'] = $wpdb->get_results( "SELECT * FROM emw24_tesztvezetes WHERE `nap` LIKE 'szombat' AND `auto` = '".$autok[1]['name']."'", ARRAY_A );


$autok[2]['name'] = 'Fiat 600 Hybrid';
$autok[2]['img'] = 'https://www.homeinfo.hu/emw/assets/fiat.webp';
$autok[2]['idopontok']['péntek'] = $wpdb->get_results( "SELECT * FROM emw24_tesztvezetes WHERE `nap` LIKE 'péntek' AND `auto` = '".$autok[2]['name']."'", ARRAY_A );
$autok[2]['idopontok']['szombat'] = $wpdb->get_results( "SELECT * FROM emw24_tesztvezetes WHERE `nap` LIKE 'szombat' AND `auto` = '".$autok[2]['name']."'", ARRAY_A );


$autok[3]['name'] = 'Peugeot 3008 Hybrid';
$autok[3]['img'] = 'https://www.homeinfo.hu/emw/assets/peugeot.webp';
$autok[3]['idopontok']['péntek'] = $wpdb->get_results( "SELECT * FROM emw24_tesztvezetes WHERE `nap` LIKE 'péntek' AND `auto` = '".$autok[3]['name']."'", ARRAY_A );
$autok[3]['idopontok']['szombat'] = $wpdb->get_results( "SELECT * FROM emw24_tesztvezetes WHERE `nap` LIKE 'szombat' AND `auto` = '".$autok[3]['name']."'", ARRAY_A );



if ( ! empty($_POST['submit']) )
{		
	$where = array();	
	$where['tesztvezetes_id'] = $_POST['idopont'];
			
	$row = array();		
	$row['name'] = $_POST['name'];
	$row['email'] = $_POST['email'];
	$row['phone'] = $_POST['phone'];
	
	
	// megnezzuk hogy az email cim foglalt-e mar
	$foglalas = $wpdb->get_row( $wpdb->prepare("SELECT * FROM emw24_tesztvezetes WHERE email LIKE '%s'", $row['email']), ARRAY_A  );
	if ( ! empty($foglalas))
	{	
		$teMarFoglaltal = TRUE;
	}
	else
	{
		// megnezzuk hogy idokozben elfogyott-e a hely	
		$szabad = $wpdb->get_var( $wpdb->prepare("SELECT tesztvezetes_id FROM emw24_tesztvezetes WHERE email IS NULL AND tesztvezetes_id = %d", $where['tesztvezetes_id']) );
		
		if ( ! $szabad)
		{	
			$foglaltLettKozben = TRUE;
		} 
		else 
		{
			// db save
			if ( $wpdb->update('emw24_tesztvezetes', $row, $where) )
			{						
				$date = ($foglalas['nap'] == 'péntek') ? '2024-10-18':'2024-10-19';
				// lemodo link
				$cancelUrl = 'https://www.homeinfo.hu/emw/tesztvezetes.php?lemondas='.$row['email'].'&id='.$where['tesztvezetes_id'];
				$foglalas = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM emw24_tesztvezetes WHERE tesztvezetes_id = %d", $where['tesztvezetes_id']), ARRAY_A  );
				// email	
				$emailBody = createHTML(array('link'=>$cancelUrl, 'idopont'=>$foglalas['idopont'], 'auto'=>$foglalas['auto'], 'nap'=>$foglalas['nap']), 'tesztvezetes-email.html');			
				$icsData = array();
				$icsData['CREATED'] = date('Ymd\\THis') . "\n";
				$icsData['UID'] = $where['tesztvezetes_id'] . "\n";
				$icsData['DTSTAMP'] = date('Ymd\\THis') . "\n";
				$icsData['DTSTART'] = date('Ymd\\THis',strtotime($date.' '.$foglalas['idopont'])) . "\n";
				$icsData['DTEND'] = date('Ymd\\THis',strtotime($date.' '.$foglalas['idopont'] . '+ 30 minute')) . "\n";						
				sendEmailBrevo($row['email'], 'Tesztvezetés időpontfoglalás // ÉMW', $emailBody, createICS($icsData));		
				
				if ( ! empty($_POST['feliratkozas'])) 
				{
					$sub = "https://www.homeinfo.hu/index.php?option=com_acymailing&ctrl=sub&task=optin&hiddenlists=365&user[email]=".$row['email']."&user[name]=".urlencode($row['name']);
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL,$sub);
					curl_setopt($ch, CURLOPT_HTTPGET, 0);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					ob_start();
					curl_exec($ch); 
					ob_end_clean();
					curl_close($ch);
				}	
						
				$successMessage = TRUE;
			}	
			else
			{
				$errorMessage = TRUE;

			}	
		}		
	}		
			
}


function my_print_error()
{
    global $wpdb;
	
    if($wpdb->last_error !== '') 
	{
        $str   = htmlspecialchars( $wpdb->last_error, ENT_QUOTES );
        $query = htmlspecialchars( $wpdb->last_query, ENT_QUOTES );
		
		if (strpos($str,'Duplicate entry') !== FALSE)
			print "<strong>Hiba!</strong><br>Ön már lefoglalta ezt az időpontot!";
		else
			print "Hiba történt, kérjük, próbálja később!<br><br><strong>Database error:</strong> [$str]<br /><code>$query</code>";
   }
}

		
// Helper - Email küldése
function sendEmailBrevo($to, $subject, $htmlContent, $icsString) 
{		
	$config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', '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');
	$apiInstance = new Brevo\Client\Api\TransactionalEmailsApi(new GuzzleHttp\Client(),	$config);
	$sendSmtpEmail = new \Brevo\Client\Model\SendSmtpEmail([
		 'subject' => $subject,
		 'sender' => ['name' => 'HOMEINFO.hu', 'email' => 'info@homeinfo.hu'],
		 'replyTo' => ['name' => 'HOMEINFO.hu support', 'email' => 'fejlesztes@homeinfo.hu'],
		 'to' => [['email' => $to]],
		 'bcc' => [['email' => 'fejlesztes@homeinfo.hu']],
		 'htmlContent' => $htmlContent,		 
		 'attachment' => [ ['content' => base64_encode($icsString), 'name'	=> 'invite.ics'] ]	 
	]); 

	try {
		$result = $apiInstance->sendTransacEmail($sendSmtpEmail);  		
	} catch (Exception $e) {
		//echo 'Az email küldés problémába ütközött. Kérjük, írjon a fejlesztes@homeinfo.hu címre.';
		mail('fejlesztes@homeinfo.hu','Email kuldo hiba, sendmail helyettesites | EMW tesztvezetes.php',$e->getMessage());
		
		sendEmail($to, $subject, $htmlContent, $icsString);
	}
}

function sendEmail($address, $subject, $body, $ics) 
{	
	$mail = new PHPMailer;
	$mail->CharSet = 'UTF-8';
	$mail->setFrom('noreply@homeinfo.hu', 'Építőipari Mester Workshop');
	$mail->addReplyTo('fejlesztes@homeinfo.hu');

	$mail->addAddress($address); 
	
	if ($address !== 'fejlesztes@homeinfo.hu')
		$mail->addBCC('fejlesztes@homeinfo.hu'); 	

	//if ( ! empty($attachments))
	//	foreach ($attachments AS $attachment)
	//		$mail->addAttachment($attachment['file'], $attachment['name']);  		
	if ( ! empty($ics))		
		$mail->AddStringAttachment($ics,'invite.ics');		
			
	$mail->isHTML(true);                                 

	$mail->Subject = $subject;
	$mail->Body    = $body;
	
	return $mail->send();
}

function createHTML($data, $template) 
{		
	ob_start();
	include(ABSPATH.$template);
	$html = ob_get_clean();	
	return $html;
}

function createICS($data) 
{		
	ob_start();
	include(ABSPATH.'tesztvezetes.ics');
	$text = ob_get_clean();	
	return $text;
}

?>
<!DOCTYPE html>
<html lang="hu">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

<title>Tesztvezetés időpontfoglalás | ÉMW</title>
<meta name="description" content="">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">

<meta property="og:title" content="Tesztvezetés időpontfoglalás">
<meta property="og:description" content="">
<meta property="og:url" content="https://www.homeinfo.hu/emw/tesztvezetes.php">
<meta property="og:image" content="">
<meta property="fb:app_id" content="">

<link href="/jegyvasarlas/assets/main.css" rel="stylesheet" type="text/css">


<script src="/media/jui/js/jquery.min.js?287fb55bac9e5f8ec84bd927bf4af23f" type="text/javascript"></script>
<?php include(ASSETS_PATH . '/homeinfo.google-analytics.php'); /*+pinterest*/ ?>		
<?php include(ASSETS_PATH . '/homeinfo.facebook-pixel.php'); ?>	
<?php include(ASSETS_PATH . '/homeinfo.tiktok-pixel.php'); ?>	

<style>
	.tesztvezetes {display:flex;flex-direction:column; gap:4px;margin-bottom:2rem;}
	.tesztvezetes__item {display:flex;flex-direction:column;gap:1rem; }
	.tesztvezetes__item img {max-width:100%;}
	.tesztvezetes__item figcaption {text-align:center;}
	.tesztvezetes__item__time {display:flex;flex-direction:column;    gap: 2px;}
	
	.tesztvezetes__item__time div  {display:flex;flex-direction:row; justify-content: center;align-items:center; width: 100%;}						
	.tesztvezetes__item__time input[type="radio"] {opacity: 0; position: fixed; width: 0; }						
	.tesztvezetes__item__time label {display: block; text-align:center;background:#fff; padding: 0.6rem 1.2rem;font-size: 18px; border: 1px solid #fff; border-radius: 4px;  margin: 0;  box-shadow: 0 3px 6px 0 rgba(0,0,0,.1); white-space:nowrap; font-weight: 300;}
	.tesztvezetes__item__time label:hover { background-color: rgba(100,107,188,.16); border-color: rgba(100,107,188,.16);}
	.tesztvezetes__item__time label span {display:none;}
	.tesztvezetes__item__time input[type="radio"]:checked + label { background-color: rgba(100,107,188,.16);   border-color: #ced2dd;box-shadow: none; font-weight:bold;	}
	.tesztvezetes__item__time input[type="radio"]:disabled + label { background-color:#f3f3f3; color: #999;  border-color: #fff;cursor:not-allowed;	box-shadow: none;     text-decoration: line-through;}
	
	.alert-error .button {background:#e70b0b!important;}
	
	@media (min-width: 1024px) {  
		.tesztvezetes {flex-direction:row; gap:1rem;}
		.tesztvezetes__item { width:33%;}
		.tesztvezetes__item figcaption {    min-height: 36px;}
		.tesztvezetes__item__time .h  {display:flex;flex-direction:row; justify-content: center;align-items:center;}				
		.tesztvezetes__item__time .h div {width:50%;}			
	} 
</style>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/css-spinning-spinners/1.1.0/load8.css" />
</head>
<body id="survey">
	<header>
		<?php /* <h1>
			 <span><a href="https://www.homeinfo.hu/"><img src="https://www.homeinfo.hu/assets/homeinfo2017/images/homeinfo-logo-124x54.tudastar.png" alt=""></a></span> 
		</h1>   
		<p style="text-align:center;font-size:1.4rem;"><strong>Regisztráció RAVAK bemutatóra</strong></p>
		*/ ?>
		<figure id="img580x300">				
			<a target="_blank" href="https://www.emworkshop.hu/" title="Építőipari Mester Workshop">
				<img src="https://www.homeinfo.hu/edm/static/emw2024_580x300.jpg" width="580" height="300" alt="">
			</a>			
		</figure>
	</header>
	
<form method="post">
	
	<div id="survey-container" >	
		

		<div id="survey-questions" class="single">
			<div class="question clearfix form-question">
				<header class="eventHeader">			
					<hgroup>
						<div class="eventHeader__title">Időpontfoglalás tesztvezetésre</div>
						<div class="eventHeader__date">2024. október 18-19.</div>
						<div class="eventHeader__info">
							<ul>
								<li>Partnereink által biztosított haszongépjárművek tesztvezetésére foglalhatsz időpontot</li>
								<li>A tesztvezetésen az <strong>Építőipari Mester Workshopra érvényes jegy</strong> szükséges (<a href="/jegyvasarlas/" target="_blank" style="  font-weight: bold;">Jegyvásárlás az ÉMW-re! &rarr;</a>)</li>							
								<li>Egy email címmel legfeljebb <strong>1 időpont</strong> foglalható!</li>
								<li>Amit mindenképpen hozz magaddal: <strong>jogosítvány és lakcímkártya</strong>!</li>
							</ul>							
						</div>			
					</hgroup>
				</header>					

<?php if ($cancellationMessage) : ?>
				
				<hgroup>			
					<div class="alert alert-success">
						<figure><img src="/jegyvasarlas/assets/success_icon.svg"></figure>		
						<p><strong>Foglalásod töröltük!</strong></p>
					</div>	
				</hgroup>
				<footer>
					<nav class="question-nav clearfix">
						<ul>			
							<li><a class="button" href="https://www.homeinfo.hu/emw/tesztvezetes.php">Új időpont foglalása</a></li>
							
						</ul>				
					</nav>
				</footer>					
				
<?php elseif ($successMessage) : ?>
				
				<hgroup>			
					<div class="alert alert-success">
						<figure><img src="/jegyvasarlas/assets/success_icon.svg"></figure>		
						<p>		
								Autó: <strong><?php echo $foglalas['auto']; ?></strong>
							<br>Időpont: <strong><?php echo $foglalas['nap']; ?> <?php echo $foglalas['idopont']; ?></strong>
							<br>
							<br>A foglalásról emailben küldtünk értesítőt, amely tartalmazza a foglalás lemondásához szükséges információt is.</p>
					</div>	
				</hgroup>
				<footer>
					<nav class="question-nav clearfix">
						<ul>			
							<?php if ( ! empty($cancelUrl)) :?>
							<li><a class="button" href="<?php echo $cancelUrl; ?>" style="background:#f44336;">&times; Foglalás lemondása</a></li>
							<?php endif; ?>
						</ul>
					</nav>					
				</footer>			
				
<?php elseif ($teMarFoglaltal) : ?>
				<hgroup>
					<div class="alert alert-error">											
						<figure><img src="/jegyvasarlas/assets/error_icon.svg"></figure>		
						<p>
							A adott email címmel már van időpont foglalva!
							<br>
							<br>Autó: <strong><?php echo $foglalas['auto']; ?></strong>
							<br>Időpont: <strong><?php echo $foglalas['nap']; ?> <?php echo $foglalas['idopont']; ?></strong>
							<br>
							<br><a class="cta-btn btn button" href="https://www.homeinfo.hu/emw/tesztvezetes.php?lemondas=<?php echo $foglalas['email']; ?>&id=<?php echo $foglalas['tesztvezetes_id']; ?>" target="_blank">Időpont lemondása</a>
						</p>	
					</div>
				</hgroup>				
<?php else: ?>				
				
				<?php if ($errorMessage) : ?>
				<hgroup>
					<div class="alert alert-error">											
						<figure><img src="/jegyvasarlas/assets/error_icon.svg"></figure>														
						<p><?php echo my_print_error(); ?></p>
					</div>
				</hgroup>				
				<?php endif; ?>					
		
				
				<?php if ($foglaltLettKozben) : ?>				
				<hgroup>
					<div class="alert alert-error">											
						<figure><img src="/jegyvasarlas/assets/error_icon.svg"></figure>
						<p>A megadott időpontott közben lefoglalták.<br>Kérjük, válassz másikat!</p>				
					</div>
				</hgroup>					
				<?php endif; ?>			
	
				<header>					
					<hgroup>
						<h3 class="question-title">
							Foglalható gépjárművek
						</h3>			
					</hgroup>
				</header>
				
				<div class="question-form clearfix">					
				
					<div class="tesztvezetes">
						<?php foreach ($autok AS $auto) : ?>
						<div class="tesztvezetes__item">
							<figure>
								<img src="<?php echo $auto['img']; ?>">
								<figcaption><?php echo $auto['name']; ?></figcaption>
							</figure>
							<div class="tesztvezetes__item__time">	
								<div class="h">								
									<div>								
										<strong>Péntek</strong>
									</div>									
									<div>								
										<strong>Szombat</strong>
									</div>					
								</div>								
								<?php foreach ($auto['idopontok']['péntek'] AS $index => $item) : ?>
								<?php $item2 = $auto['idopontok']['szombat'][$index]; ?>
								<div>								
									<div>								
										<input type="radio" id="radio<?php echo $item['tesztvezetes_id']; ?>" name="idopont" value="<?php echo $item['tesztvezetes_id']; ?>" <?php if ( ! empty ($item['email'])) echo 'disabled'; ?>>
										<label for="radio<?php echo $item['tesztvezetes_id']; ?>"><?php echo $item['idopont']; ?></label>
									</div>									
									<div>								
										<input type="radio" id="radio<?php echo $item2['tesztvezetes_id']; ?>" name="idopont" value="<?php echo $item2['tesztvezetes_id']; ?>" <?php if ( ! empty ($item2['email'])) echo 'disabled'; ?>>
										<label for="radio<?php echo $item2['tesztvezetes_id']; ?>"><?php echo $item2['idopont']; ?></label>
									</div>					
								</div>					
								<?php endforeach; ?>					
							</div>					
						</div>						
						<?php endforeach; ?>				
					</div>
				
					
					
					<ul>					
						<li><label>Név</label><input required name="name" type="text"></li>
						<li class="question-item">
							<div class="emailMobilZip">
								<div class="emailMobilIr__email"><label><span class="label">Email<span class="required">*</span></span></label><input required type="email" name="email"></div>
								<div class="emailMobilIr__mobil"><label><span class="label">Mobil<span class="required">*</span></span></label><input required type="text" name="phone"></div>
								
							</div>
						</li>					
						

						<li class="question-item">
							<label class="checkbox">
								<input required="" name="policy" value="1" type="checkbox">
								<div class="checkbox-button"></div>
								<span class="label" style="font-weight:300;">A <a target="_blank" href="https://www.homeinfo.hu/latogatoi-szabalyzat-tajekoztato"><u>Kiállítás látogatói szabályzat és tájékoztató</u></a>-t elolvastam, tartalmát megismertem és megértettem.<span class="required">*</span></span>
							</label>
						</li>				

						<li class="question-item">
							<label class="checkbox">
								<input name="feliratkozas" value="1" type="checkbox">
								<div class="checkbox-button"></div>
								<span class="label" style="font-weight:300;">Az adatkezelési tájékoztatónak megfelelően küldhetnek emaileket (kedvezményekről, akciókról, újdonságokról - fürdőszoba, otthoni wellness, építkezés - felújítás témában)</span>
							</label>
						</li>	
					

					</ul>
							
				</div>	
				
				<footer>															
					
					<nav class="question-nav clearfix">
						<ul>			
							<li ><button type="submit" name="submit" value="1" class="button">Lefoglalom</button></li>
						</ul>
					</nav>
					
				</footer>
				<?php /*	
					<footer>															
					
					<nav class="question-nav clearfix">
						<ul>			
							<li >A foglalás lezárult.</button></li>
						</ul>
					</nav>
					
				</footer>	*/ ?>		
			</div>
<?php endif; ?>	
			
		</div>			
	</div>
</form>
	
	<div id="loading" class="loading" style="display:none;"></div>

<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>		
	
</body>
</html>