<?php
require_once __DIR__ . '/lang/i18n.php';

define('DOCUMENT_ROOT', '/home/dasl1/homeinfo.hu/public_html');
define('SITE_URL', 'https://www.homeinfo.hu/');
define('ASSETS_PATH', DOCUMENT_ROOT . '/assets/homeinfo2017');
define('ASSETS_URL', SITE_URL . 'assets/homeinfo2017');
// --EVENT SPECIFIC
define('EVENT_CODE', 'emw');
define('EVENT_YEAR_CODE_UPPER', 'EMW25');
define('EVENT_URL', 'https://www.homeinfo.hu/emw/');
define('EVENT_TITLE', __('event_title'));
define('EVENT_DESCRIPTION', __('event_desc'));
define('EVENT_START_DATE', '2025-10-18');
define('EVENT_END_DATE', '2025-10-18');
define('DATE_EVENT', '2025-10-18');
define('DATE_BUILDUP', '2025-10-17');
define('DATE_TEARDOWN_START', '2025-10-18 17:00');
define('DATE_TEARDOWN_END', '2025-10-19 23:59');

date_default_timezone_set('Europe/Budapest');
if (session_status() == PHP_SESSION_NONE)
	session_start();

if (empty($_SESSION['HTTP_REFERER']) and isset($_SERVER['HTTP_REFERER']))
	$_SESSION['HTTP_REFERER'] = $_SERVER['HTTP_REFERER'];

if (! isset($_SESSION['utm_source'])) $_SESSION['utm_source'] = '';
if (! isset($_SESSION['utm_medium'])) $_SESSION['utm_medium'] = '';
if (! isset($_SESSION['utm_term'])) $_SESSION['utm_term'] = '';
if (! isset($_SESSION['utm_content'])) $_SESSION['utm_content'] = '';
if (! isset($_SESSION['utm_campaign'])) $_SESSION['utm_campaign'] = '';

if (!empty($_GET['utm_source']))
	$_SESSION['utm_source'] = $_GET['utm_source'];
if (!empty($_GET['utm_medium']))
	$_SESSION['utm_medium'] = $_GET['utm_medium'];
if (!empty($_GET['utm_term']))
	$_SESSION['utm_term'] = $_GET['utm_term'];
if (!empty($_GET['utm_content']))
	$_SESSION['utm_content'] = $_GET['utm_content'];
if (!empty($_GET['utm_campaign']))
	$_SESSION['utm_campaign'] = $_GET['utm_campaign'];

$JEGYVASARLAS_LINK = 'https://www.homeinfo.hu/jegyvasarlas/?';
if (! empty($_SERVER['QUERY_STRING']))
	$JEGYVASARLAS_LINK .= $_SERVER['QUERY_STRING'] . '&';
$JEGYVASARLAS_LINK .= 'event=' . EVENT_CODE;

$title = EVENT_TITLE;
$description = EVENT_DESCRIPTION;
ob_clean();
flush();
?>
<!DOCTYPE html>
<html lang="hu" prefix="og://ogp.me/ns#">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="referrer" content="unsafe-url">

	<meta name="description" content="<?php echo $description; ?>">
	<meta name="keywords" content="<?php echo __('meta_keywords'); ?>">
	<title><?php echo $title; ?></title>

	<link rel="apple-touch-icon" sizes="180x180" href="<?php echo EVENT_URL; ?>apple-touch-icon.png">
	<link rel="icon" type="image/png" sizes="32x32" href="<?php echo EVENT_URL; ?>favicon-32x32.png">
	<link rel="icon" type="image/png" sizes="16x16" href="<?php echo EVENT_URL; ?>favicon-16x16.png">
	<link rel="manifest" href="<?php echo EVENT_URL; ?>site.webmanifest">

	<script type="application/ld+json">
		{
			"@context": "https://schema.org",
			"@type": "Event",
			"name": "<?php echo $title; ?>",
			"startDate": "<?php echo EVENT_START_DATE; ?>",
			"endDate": "<?php echo EVENT_END_DATE; ?>",
			"eventAttendanceMode": "https://schema.org/OfflineEventAttendanceMode",
			"location": {
				"@type": "Place",
				"name": "BOK (SYMA) csarnok",
				"address": {
					"@type": "PostalAddress",
					"streetAddress": "Dózsa György út 1",
					"addressLocality": "Budapest",
					"postalCode": "1146",
					"addressRegion": "",
					"addressCountry": "HU"
				}
			},
			"image": [
				"<?php echo EVENT_URL; ?>assets/emw2024_fejlec.webp"
			],
			"description": "<?php echo $description; ?>"
		}
	</script>

	<meta property="og:type" content="website">
	<meta property="og:title" content="<?php echo (! empty($ogTitle)) ? $ogTitle : $title; ?>">
	<meta property="og:description" content="<?php echo (! empty($ogDescription)) ? $ogDescription : $description; ?>">
	<meta property="og:url" content="<?php echo (! empty($ogUrl)) ? EVENT_URL . $ogUrl : EVENT_URL; ?>">
	<meta property="og:image" content="<?php echo (! empty($ogImage)) ? EVENT_URL . $ogImage : EVENT_URL . 'assets/emw25_1200x628.jpg'; ?>">
	<meta property="og:image:width" content="1200">
	<meta property="og:image:height" content="628">

	<script src="https://cdn.tailwindcss.com?plugins=typography"></script>
	<script>
		tailwind.config = {
			theme: {
				extend: {
					colors: {
						emwblue: '#03379a',
					}
				}
			}
		}
	</script>

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Barlow%20Condensed:100,400,900&display=swap" rel="stylesheet">
	<!-- <script src="https://code.jquery.com/jquery-2.2.4.min.js"></script> -->

	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
	<style>
		html {
			scroll-behavior: smooth;
		}

		body {
			font-family: 'Open Sans', sans-serif;
		}

		.no-scrollbar::-webkit-scrollbar {
			display: none;
		}

		.no-scrollbar {
			-ms-overflow-style: none;
			/* IE and Edge */
			scrollbar-width: none;
			/* Firefox */
		}

		.swiper-slide {
			display: flex;
			flex-direction: column;
			height: auto;
		}

		.swiper-button-prev::after,
		.swiper-button-next::after {
			content: '';
		}

		.swiper-button-disabled {
			opacity: 0.35;
			cursor: auto;
			pointer-events: none;
		}
	</style>
	<link rel="stylesheet" href="standterkep.css?1" type="text/css">


	<?php include(ASSETS_PATH . '/homeinfo.google-analytics.php'); /*+pinterest*/ ?>
	<?php include(ASSETS_PATH . '/homeinfo.facebook-pixel.php'); ?>
	<?php include(ASSETS_PATH . '/homeinfo.tiktok-pixel.php'); ?>
	<?php include(ASSETS_PATH . '/homeinfo.linkedin.php'); ?>

</head>

<body class="max-w-[1920px] mx-auto">
	<?php include(ASSETS_PATH . '/homeinfo.cookie.consent.php'); ?>


	<!-- <figure class="fejleckep">
		<a href="https://www.homeinfo.hu/emw/">
			<img class="fejleckep__img fejleckep__img--desktop" src="assets/emw2024_fejlec.webp" alt="">
			<img class="fejleckep__img fejleckep__img--mobil" src="assets/emw2024_fejlec_mobil.webp" alt="">
		</a>
	</figure> -->