<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);

header("X-Robots-Tag: noindex, noarchive, nosnippet", TRUE);
header('Content-Type: text/html; charset=utf-8');

date_default_timezone_set('Europe/Budapest');

	
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<!-- Libs CSS -->
    <link rel="stylesheet" href="../termekek/dashboard/feather.min.css">
    <link rel="stylesheet" href="../termekek/dashboard/flatpickr.min.css">
    <link rel="stylesheet" href="../termekek/dashboard/quill.core.css">
    <link rel="stylesheet" href="../termekek/dashboard/select2.min.css">
    <link rel="stylesheet" href="../termekek/dashboard/vs2015.css">
    <link rel="stylesheet" href="../termekek/dashboard/mapbox-gl.css" >
    <link rel="stylesheet" href="../termekek/dashboard/theme.min.css">
	<style type="text/css">/* Chart.js */
	@keyframes chartjs-render-animation{from{opacity:.99}to{opacity:1}}.chartjs-render-monitor{animation:chartjs-render-animation 1ms}.chartjs-size-monitor,.chartjs-size-monitor-expand,.chartjs-size-monitor-shrink{position:absolute;direction:ltr;left:0;top:0;right:0;bottom:0;overflow:hidden;pointer-events:none;visibility:hidden;z-index:-1}.chartjs-size-monitor-expand>div{position:absolute;width:1000000px;height:1000000px;left:0;top:0}.chartjs-size-monitor-shrink>div{position:absolute;width:200%;height:200%;left:0;top:0}
	.break-word {overflow-wrap: break-word; word-wrap: break-word;  -ms-word-break: break-all;  word-break: break-all;  word-break: break-word;	}
	.header-date {    margin-top: .5em;   margin-bottom: 0;}
	.navbar-light {
		background-color: #03379a;
		border-color: #ffffff;
		padding:0!important;
}
.navbar-light  a.navbar-brand {font-size:0;padding:0!important;margin:0!important;}
.navbar-light  img {width:100%;max-width:580px;height:auto;max-height:none!important;}
.text-bg-info-subtle {
    background-color: #d7eff6!important;
    color:#39afd1!important;
	</style>
	
	<title>Statisztika | ÉMW</title>	
</head>
<body>

<nav class="navbar navbar-vertical fixed-left navbar-expand-md navbar-light" id="sidebar">
	<div class="container-fluid">

		<!-- Toggler 
		<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#sidebarCollapse" aria-controls="sidebarCollapse" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon"></span>
		</button>-->

		<!-- Brand -->
<a class="" href="/emw/">
			<img src="android-chrome-192x192.png" class="" alt="ÉMW 2024">
		</a>


		<!-- Collapse 
		<div class="collapse navbar-collapse" id="sidebarCollapse">

			
			<ul class="navbar-nav">
				<li class="nav-item">
					<a class="nav-link" href="/furdoszoba-kiallitas/stat.php" >
						<i class="fe fe-home"></i> Áttekintés
					</a>                  
				</li>
			</ul>

			
			<div class="mt-auto"></div>
		</div>--> <!-- / .navbar-collapse -->

	</div>
</nav> 

<div class="main-content">

	<!-- HEADER -->
	<div class="header">
		<div class="container-fluid">

			<!-- Body -->
			<div class="header-body">
				<div class="row align-items-end">
					<div class="col">
						<!-- Pretitle -->
						<h6 class="header-pretitle">
							Áttekintés
						</h6>
						<!-- Title -->
						<h1 class="header-title">
							Statisztika
						</h1> 
					</div>
					<div class="col-auto">

					</div>
				</div> <!-- / .row -->
			</div> <!-- / .header-body -->

		</div>
	</div> <!-- / .header -->

<div class="container-fluid">
      
	<div class="row">
		<div class="col-12 col-lg-4 col-xl-4">		
			<!-- Card -->
			<div class="card">
				<div class="card-body">
					<div class="row align-items-center">
						<div class="col">							
							<h6 class="card-title text-uppercase text-muted mb-2">
								Látogatók száma
							</h6>                   							
							<span class="h2 mb-0">
								3 107 db
							</span>
						</div>
						<div class="col-auto">          						 
							<span class="h2 fe fe-users text-muted mb-0"></span>
						</div>
					</div> <!-- / .row -->
				</div>
			</div>			
		</div>			
<?php	/* off Edina 2024.04.24 
		<div class="col-12 col-lg-4 col-xl-4">		
			<!-- Card -->
			<div class="card">
				<div class="card-body">
					<div class="row align-items-center">
						<div class="col">							
							<h6 class="card-title text-uppercase text-muted mb-2">
								Fizető látogató
							</h6>                   							
							<span class="h2 mb-0">
								56,7%
							</span>
						</div>
						<div class="col-auto">          
						 
							<span class="h2 fe fe-dollar-sign text-muted mb-0"></span>
						</div>
					</div> <!-- / .row -->
				</div>
			</div>			
		</div>			
*/ ?>			
	</div>
		

	<div class="row">
		<div class="col-12 col-xl-4">
		
		
			<div class="card">
				<div class="card-header">
					<div class="row align-items-center">
						<div class="col">
							<!-- Title -->
							<h4 class="card-header-title">
								Látogatók területi eloszlása
							</h4>
						</div>
					</div> <!-- / .row -->
				</div>
				<div class="card-body">
					<!-- Chart -->
					<div class="chart chart-appended">
						<canvas id="holPie" class="chart-canvas" data-toggle="legend" data-target="#holPieLegend"></canvas>
					</div>
					<!-- Legend -->
					<div id="holPieLegend" class="chart-legend"></div>

				</div>
			</div>	

		</div>
		<div class="col-12  col-xl-4">
			
			<div class="card">
				<div class="card-header">
					<div class="row align-items-center">
						<div class="col">
							<!-- Title -->
							<h4 class="card-header-title">
								Látogatás célja
							</h4>
						</div>
					</div> <!-- / .row -->
				</div>
				<div class="card-body">
					<!-- Chart -->
					<div class="chart chart-appended">
						<canvas id="celPie" class="chart-canvas" data-toggle="legend" data-target="#celPieLegend"></canvas>
					</div>
					<!-- Legend -->
					<div id="celPieLegend" class="chart-legend"></div>
	
				</div>
			</div>	

		</div>

		<div class="col-12 col-xl-4">
		
		
			<div class="card">
				<div class="card-header">
					<div class="row align-items-center">
						<div class="col">
							<!-- Title -->
							<h4 class="card-header-title">
								Látogatók érdeklődése (összesen 10.320 választ jelöltek be)
							</h4>
						</div>
					</div> <!-- / .row -->
				</div>
				<div class="card-body">
					<!-- Chart -->
					<div class="chart chart-appended">
						<canvas id="erdeklodesPie" class="chart-canvas" data-toggle="legend" data-target="#erdeklodesPieLegend"></canvas>
					</div>
					<!-- Legend -->
					<div id="erdeklodesPieLegend" class="chart-legend"></div>

				</div>
			</div>	

		</div>
		
	</div><!-- / .row -->		
		

</div>	

<script src="../termekek/dashboard/jquery.min.js"></script>
<script src="../termekek/dashboard/bootstrap.bundle.min.js"></script>
<script src="../termekek/dashboard/draggable.bundle.legacy.js"></script>
<script src="../termekek/dashboard/autosize.min.js"></script>	
<script src="../termekek/dashboard/Chart.min.js"></script>
<script src="../termekek/dashboard/flatpickr.min.js"></script>
<script src="../termekek/dashboard/highlight.pack.min.js"></script>
<script src="../termekek/dashboard/jquery.mask.min.js"></script>
<script src="../termekek/dashboard/list.min.js"></script>
<script src="../termekek/dashboard/quill.min.js"></script>
<script src="../termekek/dashboard/select2.min.js"></script>
<script src="../termekek/dashboard/Chart.extension.min.js"></script>
<script src="../termekek/dashboard/mapbox-gl.js"></script>
<script src="../termekek/dashboard/theme.js?13"></script>
<style>
.chart-legend {text-align:left;}
.chart-legend ul  {list-style: none;   margin-left: 0;    padding-left: 0;}
.chart-legend ul li span {width: 12px; height: 12px; display: inline-block;  border-radius: 50%; margin-right:16px;}
</style>
<script>
	(function() {
		var e = document.getElementById("holPie");
		new Chart(e, {
			type: "pie",
			options: {
				tooltips: {
					intersect: true,
					callbacks: {
						title: function(e, t) {
							//return '<span style="color:'+t.datasets[0].backgroundColor[e[0].index]+'">'+t.labels[e[0].index]+'</span>';
							return t.labels[e[0].index];
						},
						label: function(e, t) {
							var a = "";
							return a += '<span class="popover-body-value">' + t.datasets[0].data[e.index] + "%</span>"
						}
					}
				},
				legendCallback: function(e) {
					var o = e.data, 
					l = "<ul>";
					return o.labels.forEach(function(e, t) {
						var a = o.datasets[0].backgroundColor[t];
						l += '<li>', l += '<span style="background-color: ' + a + '"></span><i style="display:inline-block;width:50px;">'+o.datasets[0].data[t] +'%</i>', l += e, l += "</li>"
					}), l+='</ul>'
				}				
			},
			data: {
				labels: ['Bupdapest', 'Pest megye', 'Vidék'],
				datasets: [{
					data: [36.4, 28.7, 32.9],
					backgroundColor: ['#2c7be5','#A6C5F7','#f33221']
				}]
			}
		})
	})();								
</script>	

<script>
	(function() {
		var e = document.getElementById("celPie");
		new Chart(e, {
			type: "pie",
			options: {
				tooltips: {
			
					intersect: true,

					callbacks: {
						title: function(e, t) {
							return t.labels[e[0].index]
						},
						label: function(e, t) {
							var a = "";
							return a += '<span class="popover-body-value">' + t.datasets[0].data[e.index] + "%</span>"
						}
					}
				},	
				/*  legend: {
					labels: {
					  generateLabels: (chart) => {						 
						const datasets = chart.data.datasets;
						return datasets[0].data.map((data, i) => ({
						  text: `${chart.data.labels[i]} ${data}`,
						  fillStyle: datasets[0].backgroundColor[i],
						}))
					  }
					}
				  },*/
				legendCallback: function(e) {
					var o = e.data, 
					l = "<ul>";
					return o.labels.forEach(function(e, t) {
						var a = o.datasets[0].backgroundColor[t];
						l += '<li>', l += '<span style="background-color: ' + a + '"></span><i style="display:inline-block;width:50px;">'+o.datasets[0].data[t] +'%</i>', l += e, l += "</li>"
					}), l+='</ul>'
				}				  
			},
			data: {				
				labels: ['Kivitelező, szakember',  'Gyártó képviselő', 'Kereskedő', 'Tanár, diák, hallgató', 'Tevező, Lakberendező, Egyéb', 'Magánszemély'],
				datasets: [{					
					data: [62.1, 4.9, 8.4, 2.3, 13.2, 9.1],
					backgroundColor: ['#2c7be5',"#D2DDEC","#A6C5F7", '#ab6ddd','#f25aba','#ff5b85','#ff7b4d','#ffa600','#8BC34A']
				}]
			},
		
		})
	})();						
</script>

<script>
	(function() {
		var e = document.getElementById("erdeklodesPie");
		new Chart(e, {
			type: "pie",
			options: {
				tooltips: {
			
					intersect: true,

					callbacks: {
						title: function(e, t) {
							return t.labels[e[0].index]
						},
						label: function(e, t) {
							var a = "";
							return a += '<span class="popover-body-value">' + t.datasets[0].value[e.index] + " db</span>"
						}
					}
				},	
				legendCallback: function(e) {
					var o = e.data, 
					l = "<ul>";
					return o.labels.forEach(function(e, t) {
						var a = o.datasets[0].backgroundColor[t];
						l += '<li>', l += '<span style="background-color: ' + a + '"></span><i style="display:inline-block;width:50px;">'+o.datasets[0].value[t] +' db</i> ', l += e, l += "</li>"
					}), l+='</ul>'
				}				  
			},
			data: {				
				labels: ['Burkolási anyag','Épületgépészeti termék','Festék','Haszongépjármű','Hőszigetelés','Munkaruházat','Szárazépítészet','Szerszám','Tető, tetőfedő anyagok'],
				datasets: [{					
					data: [16.3,7.9,16.8,4.3,10.9,10.4,8.4,16.6,7.3], 
					value: [1687,678,1335,476,1321,1244,1025,1869,685], 
					backgroundColor: ['#2c7be5',"#D2DDEC","#A6C5F7", '#ab6ddd','#f25aba','#ff5b85','#ff7b4d','#ffa600','#8BC34A']
				}]
			},
		})
	})();						
</script>

		



</body>
</html>