<?php

declare(strict_types=1);

use PSpell\Config;

spl_autoload_register(function ($class) {
	require __DIR__ . '/src/' . $class . '.php';
});

set_error_handler('ErrorHandler::handleError');
set_exception_handler('ErrorHandler::handleException');
date_default_timezone_set('Europe/Budapest');
header('Content-type: application/json; charset=UTF-8');
//header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
//header('Access-Control-Max-Age: 3600');
//header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

//print_r($_SERVER);
//$parts = explode('/', $_SERVER['REQUEST_URI']); ebbe benn van a query string is pl ?limit=5
$parts = explode('/', $_SERVER['SCRIPT_URL']);

$model = $parts[4];

if (! in_array($model, ['users', 'tickets', 'offers', 'events', 'config', 'products', 'videos', 'quizzes'])) {
	http_response_code(404);
	exit;
}

$id = $parts[5] ?? null;
$childresource = $parts[6] ?? null;
$childresource_id = $parts[7] ?? null;

$dbInsp = new Database('localhost', 'dasl1_db_inspiracio', 'dasl1_usr_inspir', 'p-^u;.TdrB*5');
$dbJegyvasarlas = new Database('localhost', 'dasl1_db_jegyvasarlas', 'dasl1_usr_jegyv', 'S]!X,0tL0rC1');

if ($model == 'config')
	$controller = new ConfigController(new ConfigGateway($dbInsp));
if ($model == 'users')
	$controller = new UserController(new UserGateway($dbInsp, $dbJegyvasarlas));
if ($model == 'tickets')
	$controller = new TicketController(new TicketGateway($dbJegyvasarlas));
if ($model == 'offers')
	$controller = new OfferController(new OfferGateway($dbInsp));
if ($model == 'events')
	$controller = new EventController(new EventGateway($dbInsp));
if ($model == 'products')
	$controller = new ProductController(new ProductGateway($dbInsp));
if ($model == 'videos')
	$controller = new VideoController(new VideoGateway($dbInsp));
if ($model == 'quizzes')
	$controller = new QuizController(new QuizGateway($dbInsp));


$controller->processRequest($_SERVER['REQUEST_METHOD'], $id, $childresource, $childresource_id);
