<?php
class OfferController
{
    private $gateway;

    public function __construct(OfferGateway $gateway)
    {
        $this->gateway = $gateway;
    }

    public function processRequest(string $method, ?string $id): void
    {
        if ($id) {
            $this->processResourceRequest($method, $id);
        } else {
            $this->processCollectionRequest($method);
        }
    }

    private function processResourceRequest(string $method, string $id): void
    {
        switch ($method) {
            case "GET":
                if ($id == "partners")
                    $offer = $this->gateway->getAllPartners();
                else
                    $offer = $this->gateway->get($id);

                if (! $offer) {
                    http_response_code(404);
                    echo json_encode(["message" => "User not found"]);
                    return;
                }

                echo json_encode($offer);
                break;

            default:
                http_response_code(405);
                header("Allow: GET");
        }
    }

    private function processCollectionRequest(string $method): void
    {
        switch ($method) {
            case "GET":
                echo json_encode($this->gateway->getAll());
                break;

            case "POST":

                break;

            default:
                http_response_code(405);
                header("Allow: GET, POST");
        }
    }
}
