<?php
class QuizController
{
    private $gateway;

    public function __construct(QuizGateway $gateway)
    {
        $this->gateway = $gateway;
    }

    public function processRequest(string $method, ?string $id): void
    {
        if ($id) {
            $this->processResourceRequest($method, $id);
        } else {
            $this->processCollectionRequest($method);
        }
    }

    private function processResourceRequest(string $method, string $fbuser_id): void
    {
        switch ($method) {
            case "GET":

                //$quizGroups = $this->gateway->getAll($fbuser_id);
                $quizGroups = $this->gateway->getMonth($fbuser_id, date("m"), date("Y"));

                if (! $quizGroups) {
                    http_response_code(404);
                    echo json_encode(["message" => "Question Groups not found"]);
                    return;
                }


                echo json_encode($quizGroups);
                break;

            default:
                http_response_code(405);
                header("Allow: GET");
        }
    }

    private function processCollectionRequest(string $method): void {}
}
