<?php

class UserController
{
	private $gateway;
	public function __construct(UserGateway $gateway)
	{
		$this->gateway = $gateway;
	}

	public function processRequest(string $method, ?string $id, ?string $childresource, ?string $childresource_id): void
	{
		if ($id) {
			$childresource = $childresource ?? null;
			$childresource_id = $childresource_id ?? null;
			$this->processResourceRequest($method, $id, $childresource, $childresource_id);
		} else {
			$this->processCollectionRequest($method);
		}
	}

	private function processResourceRequest(string $method, string $id, ?string $childresource, ?string $childresource_id): void
	{
		switch ($method) {
			case "GET":

				$user = $this->gateway->get($id);

				if (! $user) {
					http_response_code(404);
					echo json_encode(["message" => "User not found"]);
					return;
				}

				if (! empty($childresource)) {
					if ($childresource === 'toplist') {
						$yearmonth = $childresource_id ?? date("Y-m");
						$toplist = $this->gateway->getQuizToplistMonth($id, $yearmonth);
						if (empty($toplist)) {
							http_response_code(200);
							echo json_encode(["message" => "Toplist not found"]);
							return;
						}
						echo json_encode($toplist);
						return;
					}
					if ($childresource === 'quizzes') {
						if (! empty($childresource_id)) {
							$quizzes = $this->gateway->getUserQuestionsByGroups($childresource_id, $id);
						} else {
							$quizzes = $this->gateway->getUserQuizzes($id, date("m"), date("Y"));
						}
						if (empty($quizzes)) {
							http_response_code(200);
							echo json_encode(["message" => "Quizzes not found"]);
							return;
						}
						echo json_encode($quizzes);
						return;
					}

					if ($childresource === 'tickets') {
						$tickets = $this->gateway->getUserTickets($user['email']);
						if (empty($ticket)) {
							http_response_code(200);
							echo json_encode(["message" => "Ticket not found"]);
							return;
						}
						echo json_encode($ticket);
						return;
					}

					if ($childresource === 'ticket') {
						$ticket = $this->gateway->getUserTicket($user['hashAuth']);
						if (empty($ticket)) {
							http_response_code(200);
							echo json_encode(["message" => "Ticket not found"]);
							return;
						}
						echo json_encode($ticket);
						return;
					}

					if ($childresource === 'sorsjegy') {
						if (!empty($user['sorsjegy'])) {
							http_response_code(200);
							echo json_encode(["error" => "Már van sorsjegyed!"]);
							return;
						}
						if (! in_array(date("Y-m-d"), ['2025-10-13', '2025-10-14', '2025-10-18'])) {
							http_response_code(200);
							echo json_encode(["error" => "A játék még nem indult el. Próbáld később!"]);
							return;
						}

						$ticket = $this->gateway->getUserTicket($user['hashAuth']);
						if (empty($ticket) and $user['id'] !== 8248) {
							http_response_code(200);
							echo json_encode(["error" => "A játékban csak applikációs belépővel rendelkezők vehetnek részt."]);
							return;
						}

						$now = new DateTime('now', new DateTimeZone('Europe/Budapest'));
						$ranges = [
							['12:00', '12:30', 'noon'],
							['15:00', '15:30', 'afternoon'],
							['16:00', '16:30', 'late_afternoon'],
						];
						$matched = null;
						foreach ($ranges as [$startTime, $endTime, $label]) {
							$start = new DateTime($startTime, $now->getTimezone());
							$end   = new DateTime($endTime, $now->getTimezone());
							if ($now >= $start && $now <= $end) {
								$matched = $label;
								break;
							}
						}

						if ($matched === null) {
							http_response_code(200);
							echo json_encode(["error" => "A játék még nem indult el. Próbáld később!"]);
							return;
						}

						$sorsjegy = $this->gateway->createUserSorsjegy($user['id'], $matched);
						echo json_encode($sorsjegy);
						return;
					}
				}
				setType($user['new_ticket'], 'int');
				setType($user['emw24won'], 'int');
				echo json_encode($user);
				break;

			case "POST":

				$data = (array) json_decode(file_get_contents("php://input"), true);

				if (! empty($data['interest_id'])) {
					$interest_id = $data['interest_id'];
					$this->gateway->createUserInterest($id, $interest_id);

					http_response_code(201);
					echo json_encode([
						"message" => "User($id) interest $interest_id subscribed"
					]);
					return;
				}

				if (! empty($data['location_id'])) {
					$location_id = $data['location_id'];
					$this->gateway->createUserLocation($id, $location_id);

					http_response_code(201);
					echo json_encode([
						"message" => "User($id) location $location_id subscribed"
					]);
					return;
				}

				if (! empty($data['offer_id'])) {
					$offer_id = $data['offer_id'];
					$this->gateway->createUserOffer($id, $offer_id);

					http_response_code(201);
					echo json_encode([
						"message" => "User($id) offer $offer_id subscribed"
					]);
					return;
				}

				if (! empty($data['event_id'])) {
					$event_id = $data['event_id'];
					$this->gateway->createUserEvent($id, $event_id);

					http_response_code(201);
					echo json_encode([
						"message" => "User($id) event $event_id subscribed"
					]);
					return;
				}

				if (! empty($childresource)) {

					// /users/{userhash}/quizzes
					if ($childresource === 'quizzes') {
						$this->gateway->insertUserQuestionAnswer($id, $data);
						return;
					}
					// /users/{userhash}/stat			
					if ($childresource === 'stat') {
						$this->gateway->createUserStatEntry($id, $data);
						return;
					}
					// /users/{userhash}/nevjegy			
					if ($childresource === 'nevjegy') {
						// /users/{userhash}/nevjegy/photo
						if (! empty($childresource_id)) {
							$user = $this->gateway->get($id);
							$out =  $this->gateway->updateUserNevjegyPhoto($id, $_FILES['file'] ?? [], $user['hashAuth']);
							http_response_code(200);
							echo json_encode($out);
						} else {
							$this->gateway->updateUserNevjegy($id, $data);
						}
						return;
					}
				}

				break;

			case "PUT":
				$data = (array) json_decode(file_get_contents("php://input"), true);

				// /users/{id||userhash}/password
				if ($childresource === 'password') {
					if ($this->gateway->updateUserPassword($id, $data)) {
						http_response_code(200);
						echo json_encode(["message" => "Password updated"]);
					} else {
						http_response_code(400);
						echo json_encode(["message" => "A régi jelszó nem egyezik"]);
					}
					return;
				}


				// /users/{id||userhash}/sorsjegy		
				if ($childresource === 'sorsjegy') {
					$res = $this->gateway->updateUserSorsjegy($id, $data);
					echo json_encode($res);
					return;
				}

				$rows = $this->gateway->update($id, $data);


				if (isset($data['emw24won'])) {
					$user = $this->gateway->get($id);
					$this->gateway->updateUserEmw24won($user['token']);
				}

				echo json_encode([
					"message" => "User $id updated",
					"rows" => $rows
				]);
				break;

			case "DELETE":
				$data = (array) json_decode(file_get_contents("php://input"), true);

				if (! empty($data['interest_id'])) {
					$interest_id = $data['interest_id'];
					$rows = $this->gateway->deleteUserInterest($id, $interest_id);
					echo json_encode([
						"message" => "User($id) interest $interest_id unsubscribed",
						"rows" => $rows
					]);
					return;
				}

				if (! empty($data['location_id'])) {
					$location_id = $data['location_id'];
					$rows = $this->gateway->deleteUserLocation($id, $location_id);
					echo json_encode([
						"message" => "User($id) location $location_id unsubscribed",
						"rows" => $rows
					]);
					return;
				}

				if (! empty($data['offer_id'])) {
					$offer_id = $data['offer_id'];
					$rows = $this->gateway->deleteUserOffer($id, $offer_id);
					echo json_encode([
						"message" => "User($id) offer $offer_id unsubscribed",
						"rows" => $rows
					]);
					return;
				}

				if (! empty($data['event_id'])) {
					$event_id = $data['event_id'];
					$rows = $this->gateway->deleteUserEvent($id, $event_id);
					echo json_encode([
						"message" => "User($id) event $event_id unsubscribed",
						"rows" => $rows
					]);
					return;
				}

				break;

			default:
				http_response_code(405);
				header("Allow: GET, PUT, DELETE");
		}
	}

	private function processCollectionRequest(string $method): void {}
}
