<?php

class UserGateway
{
    private $conn;
    private $connJegy;

    public function __construct(Database $db1, Database $db2)
    {
        $this->conn = $db1->getConnection();
        $this->connJegy = $db2->getConnection();
    }


    public function get(string $id)
    {
        $WHERE = (ctype_digit($id))  ? "inspiracio_fbuser.id = :id" : "inspiracio_fbuser.hashAuth = :hash";

        $sql = "SELECT 					
					inspiracio_fbuser.*,
					inspiracio_fbuser.mail AS email, 
					hipro_profession.title AS profession
                FROM inspiracio_fbuser
				LEFT JOIN hipro_profession ON (hipro_profession.id = inspiracio_fbuser.profession_id)				
                WHERE " . $WHERE;

        $stmt = $this->conn->prepare($sql);

        if (ctype_digit($id))
            $stmt->bindValue(":id", $id, PDO::PARAM_INT);
        else
            $stmt->bindValue(":hash", $id, PDO::PARAM_STR);

        $stmt->execute();

        $data = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($data !== false) {
            // Érdeklődési körök
            $sql = "SELECT 
						hipro_interest.id,
						hipro_interest.title						
					FROM inspiracio_fbuser_hipro_interest
					INNER JOIN hipro_interest ON (hipro_interest.id = inspiracio_fbuser_hipro_interest.interest_id )
					WHERE inspiracio_fbuser_hipro_interest.fbuser_id = :id";

            $stmt = $this->conn->prepare($sql);

            $stmt->bindValue(":id", $data['id'], PDO::PARAM_INT);

            $stmt->execute();

            $interests = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $interests[] = $row;
            }
            $data["interests"] = json_encode($interests);

            // Érdeklődés terület (megye) szerint
            $sql = "SELECT 
						hipro_location.id,
						hipro_location.title						
					FROM inspiracio_fbuser_hipro_location
					INNER JOIN hipro_location ON (hipro_location.id = inspiracio_fbuser_hipro_location.location_id )
					WHERE inspiracio_fbuser_hipro_location.fbuser_id = :id";

            $stmt = $this->conn->prepare($sql);

            $stmt->bindValue(":id", $data['id'], PDO::PARAM_INT);

            $stmt->execute();

            $locations = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $locations[] = $row;
            }
            $data["locations"] = json_encode($locations);

            // Mentett ajánlások
            $sql = "SELECT 
						hipro_offer.*					
					FROM inspiracio_fbuser_hipro_offer
					INNER JOIN hipro_offer ON (hipro_offer.id = inspiracio_fbuser_hipro_offer.offer_id )
					WHERE inspiracio_fbuser_hipro_offer.fbuser_id = :id";

            $stmt = $this->conn->prepare($sql);

            $stmt->bindValue(":id", $data['id'], PDO::PARAM_INT);

            $stmt->execute();

            $offers = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $offers[] = $row;
            }
            $data["offers"] = json_encode($offers);

            // Mentett események
            $sql = "SELECT 
						hipro_event.*					
					FROM inspiracio_fbuser_hipro_event
					INNER JOIN hipro_event ON (hipro_event.id = inspiracio_fbuser_hipro_event.event_id )
					WHERE inspiracio_fbuser_hipro_event.fbuser_id = :id";

            $stmt = $this->conn->prepare($sql);

            $stmt->bindValue(":id", $data['id'], PDO::PARAM_INT);

            $stmt->execute();

            $events = array();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $events[] = $row;
            }
            $data["events"] = json_encode($events);

            // EMW25 sorsjegy            
            $sorsjegy = $this->getUserSorsjegy($data['id']);
            if ($sorsjegy)
                $data["sorsjegy"] = json_encode($sorsjegy);

            // EMW24 app nyeremenyen sorsolas
            // $sql = "SELECT 	*					
            // 		FROM inspiracio_fbuser_emw24won					
            // 		WHERE token = :token AND received_at IS NULL";
            // $stmt = $this->conn->prepare($sql);
            // $stmt->bindValue(":token", $data['token'], PDO::PARAM_STR);
            // $stmt->execute();
            // $won = $stmt->fetch(PDO::FETCH_ASSOC);
            // if ($won)
            //     $data["emw24wonData"] = json_encode($won);
        }

        return $data;
    }
    public function getUserSorsjegy(int $fbUserId)
    {
        $stmt = $this->connJegy->prepare("SELECT 	
                s.*, n.id AS nyeremeny_id, 
                n.title AS nyeremeny_title, 
                n.thumb As nyeremeny_thumb, 
                n.stand AS nyeremeny_stand
			FROM emw25_sorsjegy	s	
            LEFT JOIN emw25_nyeremeny n ON (n.id = s.nyeremeny_id)			
            WHERE s.fbuser_id = :fbuser_id");
        $stmt->execute(['fbuser_id' => $fbUserId]);

        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function createUserSorsjegy(int $fbUserId, string $pool): array
    {
        $result = [
            'success' => false,
            'nyeremeny_id' => null,
            'win' => false,
            'pool' => $pool,
        ];

        try {
            $this->connJegy->beginTransaction();

            // 1️⃣ Get total prize capacity (constant)
            $totalPrizes = $this->getTotalPrizeQuantity();
            if ($totalPrizes <= 0) {
                throw new RuntimeException('No prizes configured.');
            }

            // 2️⃣ Constant win rate
            $winRate = intdiv(100, $totalPrizes);

            // 3️⃣ Total tickets drawn so far
            $sql = "SELECT COUNT(*) AS cnt FROM emw25_sorsjegy";
            $ticketCount = (int)$this->connJegy->query($sql)->fetch()['cnt'];

            // Current ticket number
            $ticketCount++;

            // 4️⃣ Determine if current ticket is a winner
            $isWinner = ($ticketCount > 0 && $winRate > 0 && ($ticketCount % $winRate) === 0);

            // 5️⃣ Apply pool logic
            if ($isWinner) {
                if ($pool === 'noon') {
                    if (!$this->canDrawAtNoon($totalPrizes)) {
                        $isWinner = false; // Noon quota reached
                    }
                } elseif ($pool === 'afternoon') {
                    $this->restoreUnclaimedNoonPrizes(); // Return unclaimed prizes to pool
                }
            }

            // 6️⃣ Perform draw
            if ($isWinner) {
                $nyeremeny_id = $this->getRandomAvailablePrizeId();

                if ($nyeremeny_id) {
                    // Increment drawn_count
                    $dec = $this->connJegy->prepare("
                    UPDATE emw25_nyeremeny
                    SET drawn_count = drawn_count + 1
                    WHERE id = :id AND drawn_count < quantity
                ");
                    $dec->execute([':id' => $nyeremeny_id]);

                    if ($dec->rowCount() > 0) {
                        // Insert winning ticket
                        $stmt = $this->connJegy->prepare("
                        INSERT INTO emw25_sorsjegy (fbuser_id, nyeremeny_id, pool)
                        VALUES (:fbuser_id, :nyeremeny_id, :pool)
                    ");
                        $stmt->execute([
                            ':fbuser_id' => $fbUserId,
                            ':nyeremeny_id' => $nyeremeny_id,
                            ':pool' => $pool,
                        ]);

                        $result['success'] = true;
                        $result['win'] = true;
                        $result['nyeremeny_id'] = $nyeremeny_id;
                        $result['data'] = $this->getUserSorsjegy($fbUserId);
                    } else {
                        $result['success'] = $this->insertNonWinningTicket($fbUserId, $pool);
                        $result['data'] = $this->getUserSorsjegy($fbUserId);
                    }
                } else {
                    $result['success'] = $this->insertNonWinningTicket($fbUserId, $pool);
                    $result['data'] = $this->getUserSorsjegy($fbUserId);
                }
            } else {
                $result['success'] = $this->insertNonWinningTicket($fbUserId, $pool);
                $result['data'] = $this->getUserSorsjegy($fbUserId);
            }

            $this->connJegy->commit();
        } catch (Throwable $e) {
            $this->connJegy->rollBack();
            error_log("createUserSorsjegy failed: " . $e->getMessage());
            $result['success'] = false;
        }

        return $result['data'] ?? [];
    }


    private function getTotalPrizeQuantity(): int
    {
        $sql = "SELECT SUM(quantity) AS total FROM emw25_nyeremeny";
        $row = $this->connJegy->query($sql)->fetch();
        return (int)($row['total'] ?? 0);
    }

    private function insertNonWinningTicket(int $fbUserId, string $pool): bool
    {
        $stmt = $this->connJegy->prepare("
        INSERT INTO emw25_sorsjegy (fbuser_id, pool)
        VALUES (:fbuser_id, :pool)
    ");
        return $stmt->execute([':fbuser_id' => $fbUserId, ':pool' => $pool]);
    }

    private function getRandomAvailablePrizeId(): ?int
    {
        $sql = "
        SELECT id
        FROM emw25_nyeremeny
        WHERE drawn_count < quantity
        ORDER BY RAND()
        LIMIT 1
        FOR UPDATE
    ";
        $row = $this->connJegy->query($sql)->fetch();
        return $row['id'] ?? null;
    }
    private function canDrawAtNoon(int $totalPrizes): bool
    {
        $noonQuota = (int)ceil($totalPrizes / 2);

        $sql = "
        SELECT COUNT(*) AS cnt
        FROM emw25_sorsjegy
        WHERE pool = 'noon' AND nyeremeny_id IS NOT NULL
    ";
        $claimedAtNoon = (int)$this->connJegy->query($sql)->fetch()['cnt'];

        return $claimedAtNoon < $noonQuota;
    }
    private function restoreUnclaimedNoonPrizes(): void
    {
        $sql = "
        SELECT s.nyeremeny_id, COUNT(*) AS unclaimed
        FROM emw25_sorsjegy s
        JOIN emw25_nyeremeny n ON s.nyeremeny_id = n.id
        WHERE s.pool = 'noon'
          AND s.claimed = 0
          AND s.nyeremeny_id IS NOT NULL
        GROUP BY s.nyeremeny_id
    ";
        $rows = $this->connJegy->query($sql)->fetchAll(PDO::FETCH_ASSOC);

        if (!$rows) return;

        foreach ($rows as $row) {
            $nyeremenyId = (int)$row['nyeremeny_id'];
            $unclaimed   = (int)$row['unclaimed'];

            // Adjust drawn_count back by number of unclaimed items
            $stmt = $this->connJegy->prepare("
            UPDATE emw25_nyeremeny
            SET drawn_count = GREATEST(drawn_count - :unclaimed, 0)
            WHERE id = :id
        ");
            $stmt->execute([
                ':unclaimed' => $unclaimed,
                ':id' => $nyeremenyId,
            ]);
        }

        // Optionally mark as processed (so not restored twice)
        $this->connJegy->query("
        UPDATE emw25_sorsjegy
        SET claimed = 2  
        WHERE pool = 'noon' AND claimed = 0 AND nyeremeny_id IS NOT NULL
    ");
    }



    public function updateUserSorsjegy(string $id, array $data): array
    {
        $result = ['updated' => false, 'claimedCountChanged' => false];

        $set = [];
        $where = ['fbuser_id = :fbuser_id'];

        if (!empty($data['scratched'])) {
            $set[] = "scratched = 1";
            $where[] = "scratched = 0"; // only once
        }
        if (!empty($data['claimed'])) {
            $set[] = "claimed = 1";
            $where[] = "claimed = 0"; // only once
        }
        if (empty($set)) return $result;

        try {
            $this->connJegy->beginTransaction();

            // 1) Update sorsjegy
            $sql = "UPDATE emw25_sorsjegy SET " . implode(', ', $set) . " WHERE " . implode(' AND ', $where);
            $stmt = $this->connJegy->prepare($sql);
            $stmt->bindValue(':fbuser_id', $id, PDO::PARAM_INT);
            $stmt->execute();

            // run only once
            if ($stmt->rowCount() > 0) {
                $result['updated'] = true;

                // 2) If claimed just changed, increment claimed_count ONCE for the user's nyeremeny_id
                if (!empty($data['claimed'])) {
                    $qPrize = $this->connJegy->prepare("
                        SELECT nyeremeny_id
                        FROM emw25_sorsjegy
                        WHERE fbuser_id = :fbuser_id AND nyeremeny_id IS NOT NULL
                        LIMIT 1
                    ");
                    $qPrize->execute([':fbuser_id' => $id]);
                    $nyeremeny_id = $qPrize->fetchColumn();

                    if ($nyeremeny_id) {
                        // Lock the prize row to prevent race conditions (InnoDB)
                        $qLock = $this->connJegy->prepare("
                            SELECT claimed_count
                            FROM emw25_nyeremeny
                            WHERE id = :nyeremeny_id
                            FOR UPDATE
                        ");
                        $qLock->execute([':nyeremeny_id' => $nyeremeny_id]);

                        $qDec = $this->connJegy->prepare("
                            UPDATE emw25_nyeremeny
                            SET claimed_count = claimed_count + 1
                            WHERE id = :nyeremeny_id 
                        ");
                        $qDec->execute([':nyeremeny_id' => $nyeremeny_id]);

                        if ($qDec->rowCount() > 0) {
                            $result['claimedCountChanged'] = true;
                        }
                    }
                }
            }

            $this->connJegy->commit();
        } catch (Throwable $e) {
            $this->connJegy->rollBack();
            error_log("updateUserSorsjegy failed: " . $e->getMessage());
            // Optional: rethrow or enrich $result with an 'error' key
        }

        return $result;
    }



    /*            SELECT ROUND(
                SUM(CASE WHEN a.is_correct = 1 THEN 1 ELSE 0 END) / COUNT(DISTINCT q.id) * 100
            , 0)    
            AS success_rate
        */
    public function getUserQuizzes(string $id, string $month, string $year)
    {
        $month = $month ?? date("m");
        $year = $year ?? date("Y");

        $sql = "SELECT 
                qg.id, 
                qg.group_name AS name, 
                qg.release_date, 
                CASE 
                    WHEN ua.fbuser_id IS NOT NULL THEN 1
                    ELSE 0
                END AS answered,
                CASE 
                    WHEN ua.fbuser_id IS NOT NULL THEN (
                        SELECT 
                            SUM(CASE WHEN a.is_correct = 1 THEN 1 ELSE 0 END) 
                        
                        FROM quiz_questions q
                        LEFT JOIN quiz_user_answers ua2 ON ua2.question_id = q.id AND ua2.fbuser_id = :fbuser_id2
                        LEFT JOIN quiz_answers a ON a.id = ua2.answer_id
                        WHERE q.question_group_id = qg.id
                    )
                    ELSE NULL
                END AS correct_answers 
            FROM quiz_question_groups qg
            LEFT JOIN quiz_user_answers ua 
                ON ua.question_id IN (
                    SELECT q.id FROM quiz_questions q WHERE q.question_group_id = qg.id
                ) 
                AND ua.fbuser_id = :fbuser_id
            WHERE qg.release_date <= NOW() AND MONTH(qg.release_date) = :month AND YEAR(qg.release_date) = :year
            GROUP BY qg.id, qg.group_name, qg.release_date, ua.fbuser_id
            ORDER BY qg.release_date DESC;
        ";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":fbuser_id2", $id, PDO::PARAM_INT);
        $stmt->bindValue(":month", $month, PDO::PARAM_INT);
        $stmt->bindValue(":year", $year, PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $data[] = $row;
        }

        return $data;
    }

    public function getUserQuestionsByGroups(string $group_id, string $fbuser_id)
    {

        $sql = "SELECT 
                q.id,
                q.question_text AS title,
                q.question_image AS  image,
                COALESCE(qs.success_rate, 0) AS success_rate,
                JSON_ARRAYAGG(
                    JSON_OBJECT(
                        'id', a.id,
                        'label', a.answer_text,
                        'correct', a.is_correct,
                        'user_answer', COALESCE(ur.user_answer_id = a.id, 0)
                    )
                ) AS answers
            FROM quiz_questions q
            JOIN quiz_answers a ON q.id = a.question_id
            LEFT JOIN (
                SELECT 
                    ua.question_id, 
                    ua.answer_id AS user_answer_id
                FROM quiz_user_answers ua
                WHERE ua.fbuser_id = " . $fbuser_id . "
            ) ur ON q.id = ur.question_id
            LEFT JOIN (
                SELECT 
                    q.id AS question_id, 
                    ROUND((SUM(CASE WHEN a.is_correct = 1 THEN 1 ELSE 0 END) * 100 / COUNT(*))) AS success_rate
                FROM quiz_user_answers ua
                JOIN quiz_answers a ON ua.answer_id = a.id
                JOIN quiz_questions q ON ua.question_id = q.id
                WHERE q.question_group_id = " . $group_id . "
                GROUP BY q.id
            ) qs ON q.id = qs.question_id
            WHERE q.question_group_id = " . $group_id . "
            GROUP BY q.id, q.question_text, qs.success_rate;
        ";

        $stmt = $this->conn->prepare($sql);
        // binparammal valamiert nem megy
        //$stmt->bindParam(":group_id", $group_id, PDO::PARAM_INT);
        //$stmt->bindParam(":fbuser_id", $fbuser_id, PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $row['answers'] = json_decode($row['answers'], true);
            $data[] = $row;
        }

        return $data;
    }

    public function getQuizToplistMonth(string $id, string $yearmonth)
    {
        //$sql = "SELECT *, ROUND(accuracy_percentage,0) AS score FROM quiz_monthly_leaderboard WHERE month = DATE_FORMAT(NOW(), '%Y-%m')  ORDER BY accuracy_percentage DESC, total_answers DESC";
        $sql = "SELECT 
                *, 
                ROUND(accuracy_percentage,0) AS accuracy_percentage 
            FROM 
                quiz_monthly_leaderboard 
            WHERE 
                month = DATE_FORMAT(NOW(), :yearmonth)  
            ORDER BY score DESC, correct_answers DESC, total_answers DESC, mail ASC";


        $stmt = $this->conn->prepare($sql);
        $stmt->bindValue(":yearmonth", $yearmonth, PDO::PARAM_STR);

        $stmt->execute();

        $scoreBoard = array();
        $rank = 1;
        $found = false;
        $prev = NULL;
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {

            // mail vedelem, ezt irjuk ki nev helyett
            list($row['mail'],) = explode('@', $row['mail']);

            // A user az?
            if ($row['fbuser_id'] == $id)
                $found = true;

            //$row['rank'] = $rank;

            // döntetlennél vissza egyet
            if (
                !empty($prev)
                && $row['score'] == $prev['score']
                && $row['correct_answers'] == $prev['correct_answers']
                && $row['total_answers'] == $prev['total_answers']
            )
                //$row['rank'] -= 1;
                $rank--;

            $row['rank'] = $rank;

            // Alapvetően az elso 10 helyezett mutatjuk meg.. és a felhasználó eredményét
            // @2025.04.14 összeset mutassuk -tamás
            /*
			if (count($scoreBoard) < 50 || $found)*/
            $scoreBoard[] = $row;

            // Ha megvan a 10 és a user is akkor végeztünk
            /* if (count($scoreBoard) >= 50 && $found) {
                break;
            }*/

            $rank++;
            $prev = $row;
        }

        return $scoreBoard;
    }

    public function getUserTickets(string $email)
    {
        $sql = "SELECT * FROM `vasarlas` WHERE `email` LIKE :email AND `statusz` LIKE 'FINISHED' ORDER BY `id` DESC";

        $stmt = $this->connJegy->prepare($sql);

        $stmt->bindValue(":email", $email, PDO::PARAM_STR);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            //if ($row['event'] == 'emw')
            //$row['item_title'] = 'Burkolói Workshop és Fürdőszoba és Otthoni Wellness Kiállítás'; 				
            $row['item_title'] = 'Bútor, Lámpa, Dekor és HoReCa Design Kiállítás';
            $data[] = $row;
        }

        return $data;
    }
    public function getUserTicket(string $hashAuth)
    {
        $sql = "SELECT * FROM `jegyek` WHERE `user_hashAuth` LIKE :hashAuth";

        $stmt = $this->connJegy->prepare($sql);

        $stmt->bindValue(":hashAuth", $hashAuth, PDO::PARAM_STR);

        $stmt->execute();

        $data = $stmt->fetch(PDO::FETCH_ASSOC);

        return $data;
    }

    public function update(string $id, array $data): int
    {

        $fields = [
            'name' => PDO::PARAM_STR,
            'phone' => PDO::PARAM_STR,
            'phone_raw' => PDO::PARAM_STR,
            'nevjegy_cegnev' => PDO::PARAM_STR,
            'nevjegy_titulus' => PDO::PARAM_STR,
            'profession_id' => PDO::PARAM_INT,
            'new_ticket' => PDO::PARAM_INT,
            'emw24won' => PDO::PARAM_INT,
        ];

        $bindParams = [];
        $sets = [];
        foreach ($fields as $fieldName => $paramType) {
            if (array_key_exists($fieldName, $data)) {
                $sets[] = "$fieldName = :$fieldName";
                $bindParams[$fieldName] = $data[$fieldName];
            }
        }

        $where = ctype_digit($id) ? "id = :id" : "hashAuth = :hash";
        //$sql .= "WHERE $where";
        $sql   = "UPDATE inspiracio_fbuser SET " . implode(', ', $sets) . " WHERE $where";

        $stmt = $this->conn->prepare($sql);

        foreach ($bindParams as $fieldName => $value) {
            $stmt->bindValue(":$fieldName", $value, $fields[$fieldName]);
        }

        if (ctype_digit($id)) {
            $stmt->bindValue(":id", $id, PDO::PARAM_INT);
        } else {
            $stmt->bindValue(":hash", $id, PDO::PARAM_STR);
        }

        $stmt->execute();

        return $stmt->rowCount();
    }

    public function updateUserNevjegy(string $id, array $data): int
    {
        $fields = [
            'name'             => PDO::PARAM_STR,
            'nevjegy_titulus'  => PDO::PARAM_STR,
            'nevjegy_cegnev'   => PDO::PARAM_STR,
            'phone'            => PDO::PARAM_STR,
            'phone_raw'        => PDO::PARAM_STR,
            'nevjegy_website'  => PDO::PARAM_STR,
            'nevjegy_facebook' => PDO::PARAM_STR,
            'nevjegy_linkedin' => PDO::PARAM_STR,
            'nevjegy_photo'    => PDO::PARAM_STR,
        ];

        $sets = [];
        foreach ($fields as $key => $paramType) {
            if (array_key_exists($key, $data) && $data[$key] !== null && $data[$key] !== '') {
                $sets[] = "$key = :$key";
            }
        }

        if (!$sets) {
            // nothing to update; choose your strategy:
            return 0; // or throw new InvalidArgumentException('No data to update');
        }

        $where = ctype_digit($id) ? "id = :id" : "hashAuth = :hash";
        $sql   = "UPDATE inspiracio_fbuser SET " . implode(', ', $sets) . " WHERE $where";

        $stmt = $this->conn->prepare($sql);

        foreach ($fields as $key => $paramType) {
            if (array_key_exists($key, $data) && $data[$key] !== null && $data[$key] !== '') {
                $stmt->bindValue(":$key", $data[$key], $paramType);
            }
        }

        if (ctype_digit($id)) {
            $stmt->bindValue(':id', $id, PDO::PARAM_INT);
        } else {
            $stmt->bindValue(':hash', $id, PDO::PARAM_STR);
        }

        $stmt->execute();
        return $stmt->rowCount();
    }

    public function updateUserPassword(string $id, array $data): int
    {
        // data: old_password, new_password
        $oldPassword = $data['old_password'];
        $newPassword = $data['new_password'];
        $where = ctype_digit($id) ? "id = :id" : "hashAuth = :hash";
        $sql = "SELECT mester_app_password FROM inspiracio_fbuser WHERE $where LIMIT 1";
        $stmt = $this->conn->prepare($sql);
        if (ctype_digit($id)) {
            $stmt->bindValue(':id', $id, PDO::PARAM_INT);
        } else {
            $stmt->bindValue(':hash', $id, PDO::PARAM_STR);
        }
        $stmt->execute();
        $stored = $stmt->fetchColumn();

        if (!$stored || !password_verify($oldPassword, $stored)) {
            return 0;
        }
        // rehash if needed (cost changed, algo upgraded)
        if (password_needs_rehash($stored, PASSWORD_BCRYPT, ['cost' => 12])) {
            $stored = password_hash($oldPassword, PASSWORD_BCRYPT, ['cost' => 12]);
        }
        // set new password
        $newHash = password_hash($newPassword, PASSWORD_BCRYPT, ['cost' => 12]);

        $sql = "UPDATE inspiracio_fbuser SET mester_app_password = :new_password WHERE $where";
        $stmt = $this->conn->prepare($sql);
        if (ctype_digit($id)) {
            $stmt->bindValue(':id', $id, PDO::PARAM_INT);
        } else {
            $stmt->bindValue(':hash', $id, PDO::PARAM_STR);
        }
        $stmt->bindValue(":new_password", $newHash, PDO::PARAM_STR);
        $stmt->execute();
        return $stmt->rowCount();
    }
    public function updateUserNevjegyPhoto(string $id, array $file, ?string $userAuth = null): array
    {
        if (empty($file) || !isset($file['error']) || $file['error'] !== UPLOAD_ERR_OK) {
            throw new RuntimeException('No file uploaded or upload error.');
        }

        // 10 MB hard limit (tweak as needed)
        if (!isset($file['size']) || $file['size'] > 10 * 1024 * 1024) {
            throw new RuntimeException('File too large.');
        }

        // MIME check
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $mime  = $finfo->file($file['tmp_name']);
        $allowed = [
            'image/jpeg' => 'jpg',
            'image/png'  => 'png',
            'image/webp' => 'webp',
            'image/gif'  => 'gif',
        ];
        if (!isset($allowed[$mime])) {
            throw new RuntimeException('Unsupported image type.');
        }

        // Load image into GD
        switch ($mime) {
            case 'image/jpeg':
                $src = imagecreatefromjpeg($file['tmp_name']);
                break;
            case 'image/png':
                $src = imagecreatefrompng($file['tmp_name']);
                break;
            case 'image/webp':
                $src = imagecreatefromwebp($file['tmp_name']);
                break;
            case 'image/gif':
                $src = imagecreatefromgif($file['tmp_name']);
                break;
            default:
                $src = null;
        }
        if (!$src) throw new RuntimeException('Failed to read image.');

        // Optional: fix EXIF orientation for JPEG
        if ($mime === 'image/jpeg' && function_exists('exif_read_data')) {
            try {
                $exif = @exif_read_data($file['tmp_name']);
                if (!empty($exif['Orientation'])) {
                    $src = $this->applyExifOrientation($src, (int)$exif['Orientation']);
                }
            } catch (\Throwable $e) {
                // ignore EXIF errors
            }
        }

        $w = imagesx($src);
        $h = imagesy($src);

        // Center square crop
        $size = min($w, $h);
        $sx   = (int) floor(($w - $size) / 2);
        $sy   = (int) floor(($h - $size) / 2);

        // Output size: don't upscale, cap at 500
        $outSize = (int) max(1, min(500, $size));

        $dst = imagecreatetruecolor($outSize, $outSize);
        imagealphablending($dst, true);
        imagesavealpha($dst, false); // saving as JPEG, no alpha

        // High-quality resample
        imagecopyresampled($dst, $src, 0, 0, $sx, $sy, $outSize, $outSize, $size, $size);

        // Determine final target
        $slug = $userAuth;
        if ($slug === null || $slug === '') {
            // fallback: ID or hashAuth — keep it filesystem-safe
            $slug = ctype_digit($id) ? ('user_' . $id) : $id;
        }
        $slug = preg_replace('/[^a-zA-Z0-9_\-]/', '', $slug); // sanitize

        // Base dir: point this to YOUR public webroot
        // If your app is in a subfolder, adjust it; DOCUMENT_ROOT works if this code runs under web context.
        $webRelativeDir = "/vip/files/nevjegy/photo";
        $filename       = $slug . ".jpg";
        $publicPath     = $webRelativeDir . "/" . $filename;

        // Filesystem absolute path
        $docroot = rtrim($_SERVER['DOCUMENT_ROOT'] ?? dirname(__DIR__, 2), '/'); // fallback if CLI
        $absDir  = $docroot . $webRelativeDir;
        $absPath = $absDir . "/" . $filename;

        if (!is_dir($absDir) && !mkdir($absDir, 0755, true)) {
            imagedestroy($src);
            imagedestroy($dst);
            throw new RuntimeException('Failed to create target directory.');
        }

        // Save as JPEG (quality ~92)
        if (!imagejpeg($dst, $absPath, 92)) {
            imagedestroy($src);
            imagedestroy($dst);
            throw new RuntimeException('Failed to write file.');
        }

        // Cleanup
        imagedestroy($src);
        imagedestroy($dst);

        // Update DB path
        $this->updateUserNevjegy($id, ['nevjegy_photo' => $publicPath]);

        return ['path' => $publicPath];
    }

    /**
     * Fixes EXIF orientation (JPEG) using GD.
     */
    private function applyExifOrientation($img, int $orientation)
    {
        $w = imagesx($img);
        $h = imagesy($img);
        switch ($orientation) {
            case 2: // Mirror horizontal
                $flipped = imagecreatetruecolor($w, $h);
                imagecopyresampled($flipped, $img, 0, 0, $w - 1, 0, $w, $h, -$w, $h);
                imagedestroy($img);
                return $flipped;
            case 3: // Rotate 180
                $rot = imagerotate($img, 180, 0);
                imagedestroy($img);
                return $rot;
            case 4: // Mirror vertical
                $flipped = imagecreatetruecolor($w, $h);
                imagecopyresampled($flipped, $img, 0, 0, 0, $h - 1, $w, $h, $w, -$h);
                imagedestroy($img);
                return $flipped;
            case 5: // Mirror horizontal + rotate 270
                $img = $this->applyExifOrientation($img, 2);
                $rot = imagerotate($img, 270, 0);
                imagedestroy($img);
                return $rot;
            case 6: // Rotate 270 (iPhone portrait)
                $rot = imagerotate($img, -90, 0);
                imagedestroy($img);
                return $rot;
            case 7: // Mirror horizontal + rotate 90
                $img = $this->applyExifOrientation($img, 2);
                $rot = imagerotate($img, 90, 0);
                imagedestroy($img);
                return $rot;
            case 8: // Rotate 90
                $rot = imagerotate($img, 90, 0);
                imagedestroy($img);
                return $rot;
            default:
                return $img;
        }
    }


    public function updateUserEmw24won(string $token): bool
    {
        $sql = "UPDATE inspiracio_fbuser_emw24won SET received_at = NOW()  
				WHERE token = :token";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":token", $token, PDO::PARAM_STR);

        return $stmt->execute();
    }

    public function createUserInterest(string $id, string $interest_id): bool
    {
        $sql = "INSERT INTO inspiracio_fbuser_hipro_interest (fbuser_id, interest_id)
                VALUES (:fbuser_id, :interest_id)";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":interest_id", $interest_id, PDO::PARAM_INT);

        return $stmt->execute();
    }

    public function deleteUserInterest(string $id, string $interest_id): int
    {
        $sql = "DELETE FROM inspiracio_fbuser_hipro_interest
                WHERE fbuser_id = :id AND interest_id = :interest_id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":interest_id", $interest_id, PDO::PARAM_INT);

        $stmt->execute();

        return $stmt->rowCount();
    }

    public function createUserLocation(string $id, string $location_id): bool
    {
        $sql = "INSERT INTO inspiracio_fbuser_hipro_location (fbuser_id, location_id)
                VALUES (:fbuser_id, :location_id)";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":location_id", $location_id, PDO::PARAM_INT);

        return  $stmt->execute();
    }

    public function deleteUserLocation(string $id, string $location_id): int
    {
        $sql = "DELETE FROM inspiracio_fbuser_hipro_location
                WHERE fbuser_id = :id AND location_id = :location_id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":location_id", $location_id, PDO::PARAM_INT);

        $stmt->execute();

        return $stmt->rowCount();
    }

    public function createUserOffer(string $id, string $offer_id): bool
    {
        $sql = "INSERT INTO inspiracio_fbuser_hipro_offer (fbuser_id, offer_id)
                VALUES (:fbuser_id, :offer_id)";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":offer_id", $offer_id, PDO::PARAM_INT);

        return $stmt->execute();
    }

    public function deleteUserOffer(string $id, string $offer_id): int
    {
        $sql = "DELETE FROM inspiracio_fbuser_hipro_offer
                WHERE fbuser_id = :id AND offer_id = :offer_id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":offer_id", $offer_id, PDO::PARAM_INT);

        $stmt->execute();

        return $stmt->rowCount();
    }

    public function createUserEvent(string $id, string $event_id): bool
    {
        $sql = "INSERT INTO inspiracio_fbuser_hipro_event (fbuser_id, event_id)
                VALUES (:fbuser_id, :event_id)";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":event_id", $event_id, PDO::PARAM_INT);

        return $stmt->execute();
    }

    public function deleteUserEvent(string $id, string $event_id): int
    {
        $sql = "DELETE FROM inspiracio_fbuser_hipro_event
                WHERE fbuser_id = :id AND event_id = :event_id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":event_id", $event_id, PDO::PARAM_INT);

        $stmt->execute();

        return $stmt->rowCount();
    }


    public function insertUserQuestionAnswer(string $id, array $data): bool
    {
        $sql = "INSERT INTO quiz_user_answers (fbuser_id, question_id, answer_id)
                VALUES (:fbuser_id, :question_id, :answer_id)";

        $stmt = $this->conn->prepare($sql);

        foreach ($data as $row) {
            $stmt->bindValue(":fbuser_id", $id, PDO::PARAM_INT);
            $stmt->bindValue(":question_id", $row['question_id'], PDO::PARAM_INT);
            $stmt->bindValue(":answer_id", $row['answer_id'], PDO::PARAM_INT);
            $stmt->execute();
        }

        return true;
    }
    public function createUserStatEntry(string $id, array $data): bool
    {
        $sql = "INSERT INTO inspiracio_fbuser_hipro_stat (fbuser_id, event, page, content)
                VALUES (:fbuser_id, :event, :page, :content)";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $id, PDO::PARAM_INT);
        $stmt->bindValue(":event", $data['event'], PDO::PARAM_STR);
        $stmt->bindValue(":page", $data['page'], PDO::PARAM_STR);
        $stmt->bindValue(":content", $data['content'] ?? NULL, PDO::PARAM_STR);

        return $stmt->execute();
    }
}
