<?php
define('DOCUMENT_ROOT', '/home/dasl1/homeinfo.hu/public_html');

if (! class_exists('Authuser'))
	require_once(DOCUMENT_ROOT . '/assets/homeinfo2017/class.authuser.php');

require_once DOCUMENT_ROOT . '/brevo/autoload.php'; // Brevo email kuldo
require_once DOCUMENT_ROOT . '/jegyvasarlas/phpqrcode.php'; // Névjegyhez QR code generáló

header('Content-type: application/json; charset=UTF-8');
header('X-Robots-Tag: noindex, noarchive, nosnippet', TRUE);

// error_log('_REQUEST: ' . json_encode($_REQUEST), 0);

/**
 * auth2.php?getAction=fejlesztes@homeinfo.hu
 * auth2.php?action=login&email=fejlesztes@homeinfo.hu&password=123456 
 * auth2.php?action=register&email=fejlesztes@homeinfo.hu&password=123456
 * auth2.php?action=setpassword&email=fejlesztes@homeinfo.hu&password=123456 
 * auth2.php?action=resetpassword&email=fejlesztes@homeinfo.hu 
 * */

// EMAIL INPUT RETURN THE ACTION
if (! empty($_POST['getAction'])) {
	$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `mail`='" . mysqli_real_escape_string(HIDB::$conn, filter_var($_POST['getAction'], FILTER_SANITIZE_EMAIL)) . "';";
	$res = mysqli_query(HIDB::$conn, $sql);
	$user = mysqli_fetch_assoc($res);
	if (! $user) {
		http_response_code(200);
		echo json_encode(["action" => "register"]);
		exit;
	}

	if (empty($user['mester_app_password'])) {
		http_response_code(200);
		echo json_encode(["action" => "setpassword"]);
		exit;
	}
	http_response_code(200);
	echo json_encode(["action" => "login"]);
	exit;
}

// LOGIN AND SAVE PASSWORD
if (! empty($_POST['action'])) {

	$action = $_POST['action'];

	if (! in_array($action, array("login", "register", "setpassword", "resetpassword"))) {
		http_response_code(422);
		echo json_encode(["errors" => "Invalid action"]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	if (empty($_POST['email'])) {
		http_response_code(422);
		echo json_encode(["errors" => "Missing email"]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	if (! filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {
		http_response_code(422);
		echo json_encode(["errors" => "Invalid email"]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	// Get user by email
	if ($action != 'register') {
		$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `mail`='" . mysqli_real_escape_string(HIDB::$conn, $_POST['email']) . "';";
		$res = mysqli_query(HIDB::$conn, $sql);
		$user = mysqli_fetch_assoc($res);
		if (! $user) {
			http_response_code(422);
			echo json_encode(["errors" => "User not found"]);
			error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
			exit;
		}
	}

	if ($action == 'resetpassword') {
		// generate new 6 char password for human
		$randomPassword = substr(str_shuffle(str_repeat($x = '23456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ', ceil(6 / strlen($x)))), 1, 6);
		$sql = "UPDATE `inspiracio_fbuser` SET `mester_app_password`= '" . password_hash($randomPassword, PASSWORD_DEFAULT) . "', `mester_app_password_date`= NOW() WHERE `mail` = '" . mysqli_real_escape_string(HIDB::$conn, $_POST['email']) . "';";
		$res = mysqli_query(HIDB::$conn, $sql);
		$user['newpassword'] = $randomPassword;
		sendNewPasswordEmail($user);
		http_response_code(200);
		echo json_encode(["message" => "Email sent"]);
		exit;
	}

	if (empty($_POST['password'])) {
		http_response_code(422);
		echo json_encode(["errors" => "Missing password"]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}




	// Login and update
	if ($action == "login") {

		// password verify
		if (! password_verify($_POST['password'], $user['mester_app_password'])) {
			http_response_code(422);
			echo json_encode(["errors" => "Wrong password"]);
			error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
			exit;
		}

		$token = "";
		if (! empty($_POST['token']))
			$token = ", `token`= '" . $_POST['token'] . "'";

		$geo = "";
		if (! empty($_POST['lat']) and ! empty($_POST['lng']))
			$geo = ", `lat`= '" . $_POST['lat'] . "', `lng`= '" . $_POST['lng'] . "' ";

		$sql = "UPDATE `inspiracio_fbuser` SET `last_login`=NOW(), `count_login`=count_login+1, `count_login_fixed`=count_login_fixed+1, `mester_app_login`=mester_app_login+1" . $token . $geo  . " WHERE `id` = " . $user['id'] . ";";

		if (! mysqli_query(HIDB::$conn, $sql)) {
			http_response_code(422);
			echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
			error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
			exit;
		}
	}

	if ($action == "setpassword") {

		$mester_app_password = ", `mester_app_password`= '" . password_hash($_POST['password'], PASSWORD_DEFAULT) . "'"; // bcrypt
		$mester_app_password_date = ", `mester_app_password_date`= NOW()";
		$token = "";
		if (! empty($_POST['token']))
			$token = ", `token`= '" . $_POST['token'] . "'";

		$geo = "";
		if (! empty($_POST['lat']) and ! empty($_POST['lng']))
			$geo = ", `lat`= '" . $_POST['lat'] . "', `lng`= '" . $_POST['lng'] . "' ";

		$sql = "UPDATE `inspiracio_fbuser` SET `last_login`=NOW(), `count_login`=count_login+1, `count_login_fixed`=count_login_fixed+1, `mester_app_login`=mester_app_login+1" . $token . $geo . $mester_app_password . $mester_app_password_date . " WHERE `id` = " . $user['id'] . ";";

		if (! mysqli_query(HIDB::$conn, $sql)) {
			http_response_code(422);
			echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
			error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
			exit;
		}
	}

	// Register
	if ($action == "register") {
		$values = array();
		$values['app_reg'] = 1;
		$values['mail'] = mysqli_real_escape_string(HIDB::$conn, filter_var($_POST['email'], FILTER_SANITIZE_EMAIL));
		$values['hashAuth'] = hash('sha256', $_POST['email'] . bin2hex(random_bytes(32)));
		$values['last_login'] = date('Y-m-d H:i:s');
		$values['count_login'] = 1;
		$values['count_login_fixed'] = 1;
		$values['mester_app_login'] = 1;
		$values['mester_app_password'] = password_hash($_POST['password'], PASSWORD_DEFAULT); // bcrypt
		$values['sima'] = 1;
		$values['verified'] = 0;

		if (isset($_POST['lat']))
			$values['lat'] = $_POST['lat'];
		if (isset($_POST['lng']))
			$values['lng'] = $_POST['lng'];
		if (isset($_POST['token']))
			$values['token'] = $_POST['token'];  // push értesítésekhez

		$sql = "INSERT INTO `inspiracio_fbuser` (`" . implode('`, `', array_keys($values)) . "`) VALUES ('" . implode('\',\'', $values) . "');";
		if (! mysqli_query(HIDB::$conn, $sql)) {
			http_response_code(422);
			echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
			error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
			exit;
		}
	}
	// refresh user data
	$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `mail`='" . mysqli_real_escape_string(HIDB::$conn, filter_var($_POST['email'], FILTER_SANITIZE_EMAIL)) . "';";
	$res = mysqli_query(HIDB::$conn, $sql);
	$user = mysqli_fetch_assoc($res);
	$user = logUserAppLogin($user);
	extendsUserWithQrCode($user);
	http_response_code(200);
	echo json_encode($user);
	exit;
}







// HELPERS 

function logUserAppLogin($user)
{
	$user['lat'] = $user['lat'] ?? 'NULL';
	$user['lng'] = $user['lng'] ?? 'NULL';
	$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';

	$sql = "INSERT INTO `inspiracio_fbuser_app` (fbuser_id, lat, lng, user_agent, app) VALUES (" . $user['id'] . "," . $user['lat'] . "," . $user['lng'] . ",'" . $user_agent . "', 'homeinfo-mester')";
	if (! mysqli_query(HIDB::$conn, $sql)) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	return $user;
}

function generateVerificationCode($digits = 4)
{
	return random_int(10 ** ($digits - 1), (10 ** $digits) - 1);
}

function sendVerificationEmail($user)
{
	$to = $user['mail'];
	$subject = "Belépés megerősítés | HOMEINFO Mester App";
	$htmlContent = createHTML(['user' => $user], 'email-verification.html');
	sendEmailBrevo($to, $subject, $htmlContent);
}

function sendNewPasswordEmail($user)
{
	$to = $user['mail'];
	$subject = "Új jelszó | HOMEINFO Mester App";
	$htmlContent = createHTML(['user' => $user], 'email-newpassword.html');
	sendEmailBrevo($to, $subject, $htmlContent);
}


function createHTML($data, $template)
{
	ob_start();
	include(DOCUMENT_ROOT . '/vip/' . $template);
	$html = ob_get_clean();
	return $html;
}

function sendEmailBrevo($to, $subject, $htmlContent)
{
	$config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', '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');
	$apiInstance = new Brevo\Client\Api\TransactionalEmailsApi(new GuzzleHttp\Client(),	$config);
	$sendSmtpEmail = new \Brevo\Client\Model\SendSmtpEmail([
		'subject' => $subject,
		'sender' => ['name' => 'HOMEINFO.hu', 'email' => 'info@homeinfo.hu'],
		'replyTo' => ['name' => 'HOMEINFO.hu support', 'email' => 'fejlesztes@homeinfo.hu'],
		'to' => [['email' => $to]],
		'bcc' => [['email' => 'fejlesztes@homeinfo.hu']],
		'htmlContent' => $htmlContent
	]);

	try {
		$result = $apiInstance->sendTransacEmail($sendSmtpEmail);
	} catch (Exception $e) {
		//echo 'Az email küldés problémába ütközött. Kérjük, írjon a fejlesztes@homeinfo.hu címre.';
		mail('fejlesztes@homeinfo.hu', 'Email kuldo hiba, sendmail helyettesites | HOMEINFO Mester auth.php', $e->getMessage());
		http_response_code(200);
		echo json_encode(["error" => $e->getMessage()]);
	}
}


function extendsUserWithQrCode($user)
{
	// QR code
	// 
	// Apple ID: fqfd4fs9gw@privaterelay.appleid.com -> fqfd4fs9gw-1234
	// Dot: levente.horvath.work@gmail.hu ->levente-horvath-work-1234
	// Ideal: fejlesztes@homeinfo.hu -> fejlesztes-1234
	// email nincs mindenkinek és az apple id is hasheli az emailcimeket, 
	// legyen hashauth utolso nyolc karaktere + id, pl. abcdefgh-1234 
	// https://www.homeinfo.hu/vip/abcdefgh-1234
	$slug = substr($user['hashAuth'], -8) . '-' . $user['id'];
	$link = 'https://nevjegy.homeinfo.hu/' . $slug;
	$file = DOCUMENT_ROOT . '/vip/files/nevjegy/' . $slug . '.png';
	if (! file_exists($file))
		QRcode::png($link,  $file, QR_ECLEVEL_M, 8, 0);
	// $user['nevjegy']['qrcode'] = 'https://www.homeinfo.hu/vip/files/nevjegy/' . $slug . '.png';
	// $user['nevjegy']['link'] = $link;
	return $user;
}
