let activeFilters = {};
function initFilters({ items, filters, target }) {

    const filtersElement = target.querySelector('.filters');

    if (!filtersElement) return items;
    
    let filteredItems = items;

    activeFilters = {};
    
    filtersElement.innerHTML = '';

    filters.forEach((filter, idx, arr) => {
        let activeIcon = '', 
            activeClass = '';
        const storageName = `APP_${target.id.toUpperCase()}_FILTER_${filter.id}`;
        if (localStorage.getItem(storageName) !== null) {
            if (localStorage.getItem(storageName).length) {
                activeIcon = '<ons-icon icon="md-check"></ons-icon>';
                activeClass = 'active';
                activeFilters[filter.title] = [];
                localStorage.getItem(storageName).split(',').forEach(optionId => {
                    const option = filter.options.find(({ id }) => id == optionId);
                    if (filter.title == 'Partner')
                        activeFilters[filter.title].push(option.id);
                    else
                        activeFilters[filter.title].push(option.title);
                });
            }
        } else {
            // Ha nincs kezzel beallitott, mentett szuro, akkor profil preferenciak alapjan beallitjuk
            // @ 2024.11.06 Egyelore csak mentett szuro legyen, keves tartalom van lassunk midegyiket szures nelkul
            //if (user.interests.length && filter.title == 'Téma') {
            //	activeIcon = '<ons-icon icon="md-check"></ons-icon>';
            //	activeClass = 'active';
            //	activeFilters['Téma'] = [];
            //	user.interests.forEach( item => activeFilters['Téma'].push(item.title) );								
            //}
            //if (user.locations.length && filter.title == 'Terület') {
            //	activeIcon = '<ons-icon icon="md-check"></ons-icon>';
            //	activeClass = 'active';
            //	activeFilters['Terület'] = [];						
            //	user.locations.forEach( item => activeFilters['Terület'].push(item.title) );	
            //}
        }

        filtersElement.appendChild(ons.createElement(`<div class="filter__item"><button class="${activeClass}" onclick="appNavigator.pushPage('filter.html', { data: {title: '${filter.title}', filter: ${JSON.stringify(filter).split('"').join("&quot;")}, storage: '${storageName}'}})">${activeIcon}${filter.title}</button></div>`));

        if (activeFilters['Elérhetőség'])
            filteredItems = filteredItems.filter(({ type }) =>
                activeFilters['Elérhetőség'].some(filterValue =>
                    type.split('|').includes(filterValue)
                )
            );
        if (activeFilters['Kategória'])
            filteredItems = filteredItems.filter((item) => {
                return activeFilters['Kategória'].some(filterValue => item.type.split('|').includes(filterValue));
            });                
        if (activeFilters['Terület'])
            filteredItems = filteredItems.filter(({ location }) =>
                activeFilters['Terület'].some(filterValue =>
                    location.split('|').includes(filterValue)
                )
            );
        if (activeFilters['Téma'])
            filteredItems = filteredItems.filter(({ topic }) =>
                activeFilters['Téma'].some(filterValue =>
                    topic.split('|').includes(filterValue)
                )
            );
        if (activeFilters['Partner'])
            filteredItems = filteredItems.filter(({ partner }) =>
                activeFilters['Partner'].includes(partner)
            );
    });

    return filteredItems;
}

async function getPartners(target) {
    try {
        const response = await fetch(config.apiURL + target+'/partners');
        const result = await response.json();
        // console.log('result', result);
        const activeSet = new Set(result);        
        return config.partners.filter(({ id }) => activeSet.has(id)); 
    } catch (error) {
        console.error("Error:", error);
    }
};

export { initFilters, activeFilters, getPartners };
