<?php
date_default_timezone_set('Europe/Budapest');

// --- Error Reporting (Development vs Production) ---
error_reporting(E_ALL); // Development
ini_set('display_errors', 1); // Development
// error_reporting(0); // Production
// ini_set('display_errors', 0); // Production

set_time_limit(900); // 15 perc
ini_set('memory_limit', '256M'); // 256 MB memória

// --- Include Shared Config/Functions ---
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/../../termekek/sheets/vendor/autoload.php';
require_once __DIR__ . '/../../statisztika/analytics-api/service_firebase.php'; // App remove count from Firebase Analytics

// configure the Google Client
$client = new \Google_Client();
$client->setApplicationName('Google Sheets API');
$client->setScopes([\Google_Service_Sheets::SPREADSHEETS]);
$client->setAccessType('offline');
$client->setAuthConfig(__DIR__ . '/../../termekek/sheets/hi-marketplace-9715fa7dcfbe.json');

// configure the Sheets Service
$service = new \Google_Service_Sheets($client);
$spreadsheetId = '1hJw4q6eWqXsMcNrXgXlI5wF4Nr3D0WqVPN0TENWZrBA';

function db_connect()
{
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        // Log error securely, don't expose details to client in production
        // error_log("Database Connection Error: " . $conn->connect_error);
        json_response(['error' => 'Database connection failed.'], 500);
    }
    $conn->set_charset("utf8mb4");
    return $conn;
}

$db = db_connect();
$result = $db->query("SELECT 
        id, 
        IF(parent_log_id IS NULL, 'Kvíz', 'Kvíz emlékeztető') AS type,
        IF(scheduled_send_at IS NULL, sent_at, scheduled_send_at) AS scheduled_send_at,        
        CONCAT(title, CHAR(10), description) AS content, 
        success_count+failure_count AS sent_count,
        0 AS megnyitotta,
        0 AS megnyitotta_percent,
        0 AS kviz_valaszadok,
        0 as oldalmegtekintes,        
        0 as kepmegtekintes,        
        0 as atkattintas,        
        unsubscribed_count     
    FROM 
        push_notification_logs 
    ORDER BY 
        id ASC
");
$logs = [];
while ($row = $result->fetch_assoc()) {
    settype($row['id'], 'integer');

    if (strpos($row['content'], 'Új tartalmak') !== false) {
        $row['type'] = 'Tartalom';
    }

    if ($row['sent_count'] == 0) {
        $logs[] = array_values($row);
        continue;
    }

    // --- Megnyitotta (push kiküldés +4 óra, talán ez köthető legjobban a pushoz ) ---
    $sql = "SELECT DISTINCT(fbuser_id) AS fbuser_id FROM `inspiracio_fbuser_hipro_stat` WHERE  `created_at` BETWEEN '" . $row['scheduled_send_at'] . "' AND '" . date("Y-m-d H:i:s", strtotime($row['scheduled_send_at'] . ' +4 hours')) . "';";
    $res = $db->query($sql);
    $user_ids = [];
    while ($user = $res->fetch_assoc()) {
        $user_ids[] = $user['fbuser_id'];
    }
    $res->free();
    $row['megnyitotta'] = count($user_ids);
    if ($row['megnyitotta'] == 0) {
        $logs[] = array_values($row);
        continue;
    }

    // --- Megnyitotta % ---    
    $row['megnyitotta_percent'] = (int) $row['megnyitotta'] / (int) $row['sent_count'];

    // --- Kviz valaszadok, aki megnyitotta ---
    $res = $db->query("SELECT COUNT(DISTINCT(fbuser_id)) as cnt FROM `quiz_user_answers` where date(answer_date) = '" . date("Y-m-d", strtotime($row['scheduled_send_at'])) . "' AND fbuser_id IN (" . implode(',', $user_ids) . ");");
    $user = $res->fetch_assoc();
    $res->free();
    $row['kviz_valaszadok'] = $user['cnt'];

    // --- Kviz valaszadok összes eddig  ---
    $res = $db->query("SELECT COUNT(DISTINCT(fbuser_id)) as cnt FROM `quiz_user_answers` where date(answer_date) <= '" . date("Y-m-d", strtotime($row['scheduled_send_at'])) . "';");
    $user = $res->fetch_assoc();
    $res->free();
    $row['kviz_valaszadok'] .= ' (' . $user['cnt'] . ')';

    // --- Eventek ---
    $res = $db->query("SELECT `event`, COUNT(`event`) as cnt FROM `inspiracio_fbuser_hipro_stat` WHERE `created_at` BETWEEN '" . $row['scheduled_send_at'] . "' AND '" . date("Y-m-d H:i:s", strtotime($row['scheduled_send_at'] . ' +4 hours')) . "' GROUP BY `event`;");
    while ($events = $res->fetch_assoc()) {
        // --- Oldalmegtekintes ---
        if ($events['event'] == 'pageView') {
            $row['oldalmegtekintes'] = $events['cnt'];
        }
        // --- Kepmegtekintes ---
        if ($events['event'] == 'imageInViewport') {
            $row['kepmegtekintes'] = $events['cnt'];
        }
        // --- Atkattintas ---
        if ($events['event'] == 'outgoing') {
            $row['atkattintas'] = $events['cnt'];
        }
    }
    $res->free();
	
	// --- Törölte az appot ( +4 órát nem tud, ezért itt az adott napot nézzük ) ---	
	$row['deleted'] = getAppRemoveCount('443742838', date("Y-m-d", strtotime($row['scheduled_send_at'])), date("Y-m-d", strtotime($row['scheduled_send_at'] . ' +1 days')));

    $logs[] = array_values($row);
}
$result->free();

// print_r($logs);

// update the Google Sheet
$valueRange = new \Google_Service_Sheets_ValueRange();
$valueRange->setValues($logs);
$service->spreadsheets_values->update($spreadsheetId, 'PUSH (php)!A2', $valueRange, ['valueInputOption' => 'USER_ENTERED']);
