<?php 

require_once('../burkoloi-workshop/data.php');
$bwStandok = $standok;
require_once('../emw-2024/data.php');
$cegek2024 = $cegek;
require_once('../emw/data.php');
foreach ($bwCegek as $slug => $ceg) {
	if (!isset($cegek[$slug])) {
		$ceg['bw25'] = true;
		$cegek[$slug] = $ceg;
	}
}
foreach ($cegek2024 as $slug => $ceg) {
	if (!isset($cegek[$slug])) {
		$ceg['emw24'] = true;
		$cegek[$slug] = $ceg;
	}
}
ksort($cegek);

unset($cegek['metabo']);


if (empty($_GET['slug']) OR empty($cegek[$_GET['slug']]))
{	
	echo 'empty';
	exit;
}	

$slug = $_GET['slug'];
$item = $cegek[$slug];

$banner_path = '../emw/assets/';
$inc_content = '../emw/_'.$slug.'.php';

if ($item['emw24']) {
	$banner_path = '../emw-2024/assets/';
	$inc_content = '../emw-2024/_'.$slug.'.php';
}
if ($item['bw25']) {
	$banner_path = '../burkoloi-workshop/assets/';
	$inc_content = '../burkoloi-workshop/_'.$slug.'.php';
}	

ob_clean();
flush();
?>
<div class="popup__content">
	<div class="popup__content__header">
		<div class="popup__content__header__banner"><img src="<?php echo $banner_path; ?>banner-<?php echo $slug; ?>.webp" alt=""></div>
		<div class="popup__content__header__brand">
			<div class="popup__content__header__brand__logo"><img src="../cegkereso/files/logo/<?php echo $slug; ?>.png" alt=""></div>
			<h2 class="popup__content__header__brand__title"><?php echo $item['name']; ?></h2>
		</div>	
	</div>
	
	<div class="popup__content__contact">
		<div class="popup__content__contact__group">
			<?php if ( ! empty( $item['sales'])) : ?>
				<?php $item['sales'] = ( ! isset($item['sales']['name'])) ? $item['sales'] : array($item['sales']); ?>				
				<?php foreach ($item['sales'] AS $sales) : ?>			
				<div class="popup__content__contact__group__item"><i class="bi bi-person-fill"></i> <?php echo $sales['name']; ?></div>
				<div class="popup__content__contact__group__item"><i class="bi bi-telephone-forward"></i> <a href="tel:<?php echo str_replace(' ','',$sales['tel']); ?>"><?php echo $sales['tel']; ?></a></div>
				<div class="popup__content__contact__group__item"><i class="bi bi-envelope-at"></i> <a href="mailto:<?php echo $sales['email']; ?>"><?php echo $sales['email']; ?></a></div>				
				<?php endforeach; ?>
			<?php endif; ?>
			
			<?php if ( ! empty( $item['tel'])) : ?>
			<?php $item['tel'] = (is_array($item['tel'])) ? $item['tel'] : array($item['tel']); ?>
				<?php foreach ($item['tel'] AS $tel) : ?>
				<div class="popup__content__contact__group__item"><i class="bi bi-telephone-forward"></i> <a href="tel:<?php echo str_replace(' ','',$tel); ?>"><?php echo $tel; ?></a></div>
				<?php endforeach; ?>
			<?php endif; ?>		
			
			<?php if ( ! empty( $item['email'])) : ?>
			<?php $item['email'] = (is_array($item['email'])) ? $item['email'] : array($item['email']); ?>
				<?php foreach ($item['email'] AS $email) : ?>
				<div class="popup__content__contact__group__item"><i class="bi bi-envelope-at"></i> <a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></div>
				<?php endforeach; ?>
			<?php endif; ?>			
			
			<?php if ( ! empty( $item['web'])) : ?>
			<?php $item['web'] = (is_array($item['web'])) ? $item['web'] : array($item['web']); ?>
				<?php foreach ($item['web'] AS $web) : ?>
				<div class="popup__content__contact__group__item"><i class="bi bi-globe2"></i> <a href="<?php echo withUTM($web); ?>" target="_blank"><?php echo parse_url($web, PHP_URL_HOST); ?></a></div>
				<?php endforeach; ?>
			<?php endif; ?>
					
		</div>					
		<div class="popup__content__contact__group popup__content__contact__group--social">
			<?php 
				$social = array(); 
				if ( ! empty($item['facebook'])) $social['facebook'] =  $item['facebook'];
				if ( ! empty($item['instagram'])) $social['instagram'] =  $item['instagram'];
				if ( ! empty($item['linkedin'])) $social['linkedin'] =  $item['linkedin'];
				if ( ! empty($item['pinterest'])) $social['pinterest'] =  $item['pinterest'];
				if ( ! empty($item['tiktok'])) $social['tiktok'] =  $item['tiktok'];
				if ( ! empty($item['youtube'])) $social['youtube'] =  $item['youtube'];				
			?>		
			<?php if ( ! empty( $social )) : ?>				
			<?php foreach ($social AS $socialName => $socialData) : ?>
			<?php if ( ! empty( $socialData )) : ?>			
				<?php $socialData = (is_array($socialData)) ? $socialData : array($socialData); ?>
				<?php foreach ($socialData AS $val) : ?>
				<div class="popup__content__contact__group__item"><a href="<?php echo withUTM('https://www.'.$socialName.'.com/'.$val.'/'); ?>" target="_blank"><i class="bi bi-<?php echo $socialName; ?>"></i></a></div>
				<?php endforeach; ?>
			<?php endif; ?>
			<?php endforeach; ?>
			<?php endif; ?>
		</div>
	</div>
	
	
	<div class="popup__content__description">			
		<div id="partnerDescription" class="cropped"><?php include($inc_content); ?></div>
		<button type="button" class="showMoreBtn" data-show-more-id="partnerDescription"><strong>Több</strong></button>
	</div>
	
</div>