<?php
class ConfigGateway
{
    private $conn;

    public function __construct(Database $db)
    {
        $this->conn = $db->getConnection();
    }

    public function get(string $id)
    {
        $sql = "SELECT * FROM `hipro_interest` WHERE id = :id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":id", $id, PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC))
            $data = $row;

        return $data;
    }

    public function getAll()
    {
        $config = ['interests' => [], 'locations' => [], 'professions' => []];
        $queries = [
            'interests' => "SELECT * FROM `hipro_interest` ORDER BY title ASC",
            'locations' => "SELECT * FROM `hipro_location` ORDER BY title ASC",
            'professions' => "SELECT * FROM `hipro_profession` ORDER BY title ASC"
        ];

        foreach ($queries as $section => $query) {
            $stmt = $this->conn->prepare($query);
            $stmt->execute();
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $config[$section][] = $row;
            }
        }

        return $config;
    }
}
