<?php
class EventGateway
{
    private $conn;

    public function __construct(Database $db)
    {        
        $this->conn = $db->getConnection();
    }

    public function get(string $id)
    {						
        $sql = "SELECT * FROM `hipro_event` WHERE id = :id";

        $stmt = $this->conn->prepare($sql);
		
		$stmt->bindValue(":id", $id, PDO::PARAM_INT);
		
        $stmt->execute();
		
		$data = array();	
		if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
        {
            $row["online"] = (int) $row["online"];
            $row["location"] = (is_null($row["location"])) ? '' : $row["location"];
            $row["area"] = (is_null($row["area"])) ? '' : $row["area"];
            $row["organizer"] = json_decode($row["organizer"],true);
            $data = $row;
        }	
			
        return $data;
    } 

    public function getAll()
    {
        $sql = "SELECT * FROM `hipro_event` WHERE ( `ends` > NOW() OR `ends` = '0000-00-00 00:00:00') AND `enabled` = 1  ORDER BY `starts` ASC;";
       // $sql = "SELECT * FROM `hipro_event` WHERE ( `ends` > NOW() OR `ends` = '0000-00-00 00:00:00') AND `enabled` = 1  ORDER BY id DESC;";

        $stmt = $this->conn->prepare($sql);
				
        $stmt->execute();
			
		$data = array(); 		
		while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) 
        {
            $row["online"] = (int) $row["online"];
            $row["location"] = (is_null($row["location"])) ? '' : $row["location"];
            $row["area"] = (is_null($row["area"])) ? '' : $row["area"];
            $row["organizer"] = json_decode($row["organizer"],true);
            $data[] = $row;
        }		        
			           
				
        return $data;
    }   

}
