<?php
class ProductGateway
{
    private $conn;

    public function __construct(Database $db)
    {
        $this->conn = $db->getConnection();
    }

    public function get(string $id)
    {
        $sql = "SELECT * FROM `hipro_product` WHERE id = :id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":id", $id, PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC))
            $data = $row;

        return $data;
    }

    public function getAll()
    {
        $sql = "SELECT * FROM `hipro_product` WHERE enabled = 1 ORDER BY id desc";

        if (! empty($_REQUEST['limit']))
            $sql .= " LIMIT :limit";

        $stmt = $this->conn->prepare($sql);

        if (! empty($_REQUEST['limit']))
            $stmt->bindValue(":limit", $_REQUEST['limit'], PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
            $data[] = $row;

        return $data;
    }
    public function getAllPartners()
    {
        $sql = "SELECT DISTINCT(`partner`) FROM `hipro_product` WHERE enabled = 1 ";
        $stmt = $this->conn->prepare($sql);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
            $data[] = $row['partner'];

        return $data;
    }
}
