<?php
class QuizGateway
{
    private $conn;

    public function __construct(Database $db)
    {
        $this->conn = $db->getConnection();
    }

    public function getAll(string $fbuser_id)
    {
        $sql = "SELECT 
            qg.id, 
            qg.group_name AS name, 
            qg.release_date, 
            CASE 
                WHEN ua.fbuser_id IS NOT NULL THEN 1
                ELSE 0
            END AS answered
        FROM quiz_question_groups qg
        LEFT JOIN quiz_user_answers ua 
            ON ua.question_id IN (
                SELECT q.id FROM quiz_questions q WHERE q.question_group_id = qg.id
            ) 
            AND ua.fbuser_id = :fbuser_id
        WHERE qg.release_date <= NOW()
        GROUP BY qg.id, qg.group_name, qg.release_date, ua.fbuser_id
        ORDER BY qg.release_date DESC;
        ";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $fbuser_id, PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $data[] = $row;
        }

        return $data;
    }

    public function getMonth(string $fbuser_id, string $month, string $year)
    {
        $sql = "SELECT 
            qg.id, 
            qg.group_name AS name, 
            qg.release_date, 
            CASE 
                WHEN ua.fbuser_id IS NOT NULL THEN 1
                ELSE 0
            END AS answered
        FROM quiz_question_groups qg
        LEFT JOIN quiz_user_answers ua 
            ON ua.question_id IN (
                SELECT q.id FROM quiz_questions q WHERE q.question_group_id = qg.id
            ) 
            AND ua.fbuser_id = :fbuser_id
        WHERE MONTH(qg.release_date) = :month AND YEAR(qg.release_date) = :year
        GROUP BY qg.id, qg.group_name, qg.release_date, ua.fbuser_id
        ORDER BY qg.release_date DESC;
        ";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":fbuser_id", $fbuser_id, PDO::PARAM_INT);
        $stmt->bindValue(":month", $month, PDO::PARAM_INT);
        $stmt->bindValue(":year", $year, PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $data[] = $row;
        }

        return $data;
    }
}
