<?php
class VideoGateway
{
    private $conn;

    public function __construct(Database $db)
    {
        $this->conn = $db->getConnection();
    }

    public function get(string $id)
    {
        $sql = "SELECT * FROM `hipro_video` WHERE id = :id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindValue(":id", $id, PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC))
            $data = $row;

        return $data;
    }

    public function getAll()
    {
        //$sql = "SELECT * FROM `hipro_video` WHERE  enabled = 1 ORDER BY `title` ASC"; // 2024.11.08 Szandi - Ábc sorrend
        //$sql = "SELECT * FROM `hipro_video` WHERE  enabled = 1 ORDER BY  `id` DESC"; // 2024.11.29 nem látszott az uja tartalom
        $sql = "SELECT * FROM `hipro_video` WHERE  enabled = 1 ORDER BY `inorder` DESC, `id` DESC"; // 2025.04.17 Attila - csajos előre

        if (! empty($_REQUEST['limit']))
            $sql .= " LIMIT :limit";

        if (! empty($_REQUEST['offset']))
            $sql .= " OFFSET :offset";

        $stmt = $this->conn->prepare($sql);

        if (! empty($_REQUEST['limit']))
            $stmt->bindValue(":limit", $_REQUEST['limit'], PDO::PARAM_INT);

        if (! empty($_REQUEST['offset']))
            $stmt->bindValue(":offset", $_REQUEST['offset'], PDO::PARAM_INT);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
            $data[] = $row;

        return $data;
    }
    public function getAllPartners()
    {
        $sql = "SELECT DISTINCT(`partner`) FROM `hipro_video` WHERE  enabled = 1 ";
        $stmt = $this->conn->prepare($sql);

        $stmt->execute();

        $data = array();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC))
            $data[] = $row['partner'];

        return $data;
    }
}
