<?php
define('DOCUMENT_ROOT', '/home/dasl1/homeinfo.hu/public_html');

if (! class_exists('Authuser'))
	require_once(DOCUMENT_ROOT . '/assets/homeinfo2017/class.authuser.php');

require_once DOCUMENT_ROOT . '/ev-furdoszobaja/vendor/autoload.php'; // Brevo email kuldo
require_once DOCUMENT_ROOT . '/kepgaleria-otletek/scripts/class.phpmailer.php'; // Backup email
require_once DOCUMENT_ROOT . '/jegyvasarlas/phpqrcode.php'; // Névjegyhez QR code generáló

header('Content-type: application/json; charset=UTF-8');
header('X-Robots-Tag: noindex, noarchive, nosnippet', TRUE);


// error_log('_REQUEST: ' . json_encode($_REQUEST), 0);

// nevjegy QR code generáló
if (! empty($_REQUEST['generateQrCode'])) {
	$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `hashAuth` = '" . mysqli_real_escape_string(HIDB::$conn, $_REQUEST['generateQrCode']) . "';";
	$res = mysqli_query(HIDB::$conn, $sql);
	$user = mysqli_fetch_assoc($res);
	if (! $user) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}
	extendsUserWithQrCode($user);
	http_response_code(200);
	echo json_encode($user);
	exit;
}

// Auto login telepites utan
if (! empty($_REQUEST['hashAuth'])) {

	$token = "";
	if (! empty($_POST['token']))
		$token = ", `token`= '" . $_POST['token'] . "'";

	$geo = "";
	if (! empty($_POST['lat']) and ! empty($_POST['lng']))
		$geo = ", `lat`= '" . $_POST['lat'] . "', `lng`= '" . $_POST['lng'] . "' ";

	$sql = "UPDATE `inspiracio_fbuser` SET `last_login`=NOW(), `count_login`=count_login+1, `count_login_fixed`=count_login_fixed+1, `mester_app_login`=mester_app_login+1" . $token . $geo . " WHERE `hashAuth` = '" . mysqli_real_escape_string(HIDB::$conn, $_REQUEST['hashAuth']) . "';";

	if (! mysqli_query(HIDB::$conn, $sql)) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `hashAuth` = '" . mysqli_real_escape_string(HIDB::$conn, $_REQUEST['hashAuth']) . "';";
	$res = mysqli_query(HIDB::$conn, $sql);
	$user = mysqli_fetch_assoc($res);
	if (! $user) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}
	extendsUserWithQrCode($user);
	http_response_code(200);
	echo json_encode($user);
	exit;
}


if (empty($_POST['email']) and empty($_POST['apple_id'])) {
	// logout
	if (isset($_POST['logout'])) {
		http_response_code(200);
		//echo json_encode(["errors" => "Email or Apple ID required"]);		
		exit;
	}
	http_response_code(422);
	echo json_encode(["errors" => "Email or Apple ID required"]);
	error_log('Email or Apple ID required!' . 'POST:' . json_encode($_POST), 0);
	exit;
}

// Emiles megerősítés ellenőrzése
if (! empty($_POST['code'])) {

	// Mester kod  -szandi 
	if ($_POST['code'] == 1644)
		$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `mail` = '" . mysqli_real_escape_string(HIDB::$conn, filter_var($_POST['email'], FILTER_SANITIZE_EMAIL)) . "';";
	else
		$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `mail` = '" . mysqli_real_escape_string(HIDB::$conn, filter_var($_POST['email'], FILTER_SANITIZE_EMAIL)) . "' AND verification_code = " . mysqli_real_escape_string(HIDB::$conn, $_POST['code']) . ";";

	$res = mysqli_query(HIDB::$conn, $sql);
	$user = mysqli_fetch_assoc($res);
	if (! $user) {
		http_response_code(401);
		echo json_encode(["errors" => "Helytelen megerősítő kód!"]);
		error_log('Helytelen megerősítő kód! Query: ' . $sql . ' --- MySQL error: ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	// Sikeres megerősítés
	$sql = "UPDATE `inspiracio_fbuser` SET `verification_code` = NULL, `verified` = 1 WHERE `id` = " . $user['id'] . ";";
	if (! mysqli_query(HIDB::$conn, $sql)) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}
	$user['verification_code'] = NULL;
	$user['verified'] = 1;  // ez param es mezo felesleges?
	extendsUserWithQrCode($user);
	http_response_code(200);
	echo json_encode($user);
	exit;
}

// USER keresése email cím vagy apple id alapján
if (! empty($_POST['email']))
	$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `mail`='" . mysqli_real_escape_string(HIDB::$conn, filter_var($_POST['email'], FILTER_SANITIZE_EMAIL)) . "';";
else
	$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `apple_id`='" . mysqli_real_escape_string(HIDB::$conn, $_POST['apple_id']) . "';";
$res = mysqli_query(HIDB::$conn, $sql);
$user = mysqli_fetch_assoc($res);


if ($user) {
	// BELÉPTETÉS és UPDATE
	$verification = "";
	if (isset($_POST['service']) and $_POST['service'] == 'none') {
		$user['verification_code'] = generateVerificationCode();
		if ($user['id'] == 41091) // andras.mikics@botament.hu
			$user['verification_code'] = 2515;
		if ($user['id'] == 41424) // ferenclorinc@freemail.hu
			$user['verification_code'] = 3038;
		if ($user['id'] == 51500) // gyovai.endre@butorvonal.hu
			$user['verification_code'] = 1718;
		$verification = ", `verification_code`= " . $user['verification_code'] . " ";		//A verfied mezo csak egyszer 0, a regisztraciot kovetoen
	}
	if (! empty($_POST['email']) and $_POST['email'] == 'attila.lukovics@asl.hu') {
		$verification = "";
		unset($user['verification_code']);
	}

	$token = "";
	if (! empty($_POST['token']))
		$token = ", `token`= '" . $_POST['token'] . "'";

	$geo = "";
	if (! empty($_POST['lat']) and ! empty($_POST['lng']))
		$geo = ", `lat`= '" . $_POST['lat'] . "', `lng`= '" . $_POST['lng'] . "' ";

	$sql = "UPDATE `inspiracio_fbuser` SET `last_login`=NOW(), `count_login`=count_login+1, `count_login_fixed`=count_login_fixed+1, `mester_app_login`=mester_app_login+1" . $token . $geo . $verification . " WHERE `id` = " . $user['id'] . ";";

	if (! mysqli_query(HIDB::$conn, $sql)) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	// Emailes megerősítés -> az app egy megerősítő oldalra dob ekkor, az auth csak emailt kuld
	if (! empty($verification)) {
		sendVerificationEmail($user);
		http_response_code(200);
		echo json_encode($user);
		exit;
	}

	$user = logUserAppLogin($user);
} else {
	// REGISZTRÁCIÓS BELÉPTETÉS
	$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);

	if ($email === FALSE) {
		http_response_code(422);
		echo json_encode(["errors" => "Invalid email address"]);
		error_log('Invalid email address!' . 'POST:' . json_encode($_POST), 0);
		exit;
	}

	$values = array();
	$values['app_reg'] = 1;
	$values['mail'] = mysqli_real_escape_string(HIDB::$conn, $email);
	$values['hashAuth'] = hash('sha256', $email . bin2hex(random_bytes(32)));
	$values['last_login'] = date('Y-m-d H:i:s');
	$values['count_login'] = 1;
	$values['count_login_fixed'] = 1;
	$values['mester_app_login'] = 1;
	if (isset($_POST['name']))
		$values['name'] = mysqli_real_escape_string(HIDB::$conn, $_POST['name']);
	if (isset($_POST['service']) and $_POST['service'] == 'none') {
		$values['sima'] = 1;
		$values['verification_code'] = generateVerificationCode();
		$values['verified'] = 0;
	}
	if (isset($_POST['service']) and $_POST['service'] == 'google')
		$values['google'] = 1;
	if (isset($_POST['service']) and $_POST['service'] == 'apple')
		$values['apple'] = 1;
	if (isset($_POST['apple_id']))
		$values['apple_id'] = mysqli_real_escape_string(HIDB::$conn, $_POST['apple_id']); // Apple ID alapú beléptetéshez
	if (isset($_POST['lat']))
		$values['lat'] = $_POST['lat'];
	if (isset($_POST['lng']))
		$values['lng'] = $_POST['lng'];
	if (isset($_POST['token']))
		$values['token'] = $_POST['token'];  // pus értesítésekhez

	$sql = "INSERT INTO `inspiracio_fbuser` (`" . implode('`, `', array_keys($values)) . "`) VALUES ('" . implode('\',\'', $values) . "');";
	if (! mysqli_query(HIDB::$conn, $sql)) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}
	$id =  mysqli_insert_id(HIDB::$conn);
	$sql = "SELECT * FROM `inspiracio_fbuser` WHERE `id`=" . $id . ";";
	$res = mysqli_query(HIDB::$conn, $sql);
	$user = mysqli_fetch_assoc($res);

	// Emailes megerősítés -> az app egy megerősítő oldalra dob ekkor, az auth csak emailt kuld
	if (! empty($values['verification_code']) and empty($_POST['code'])) {
		sendVerificationEmail($user);
		http_response_code(200);
		echo json_encode($user);
		exit;
	}

	$user = logUserAppLogin($user);
}


extendsUserWithQrCode($user);
http_response_code(200);
echo json_encode($user);
exit;



// HELPERS 

function logUserAppLogin($user)
{
	$user['lat'] = $user['lat'] ?? 'NULL';
	$user['lng'] = $user['lng'] ?? 'NULL';
	$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';

	$sql = "INSERT INTO `inspiracio_fbuser_app` (fbuser_id, lat, lng, user_agent, app) VALUES (" . $user['id'] . "," . $user['lat'] . "," . $user['lng'] . ",'" . $user_agent . "', 'homeinfo-mester')";
	if (! mysqli_query(HIDB::$conn, $sql)) {
		http_response_code(422);
		echo json_encode(["errors" => mysqli_error(HIDB::$conn)]);
		error_log('query: ' . $sql . ' --- ' . mysqli_error(HIDB::$conn), 0);
		exit;
	}

	return $user;
}

function generateVerificationCode($digits = 4)
{
	return random_int(10 ** ($digits - 1), (10 ** $digits) - 1);
}

function sendVerificationEmail($user)
{
	$to = $user['mail'];
	$subject = "Belépés megerősítés | HOMEINFO Mester App";
	$htmlContent = createHTML(['user' => $user], 'email-verification.html');
	sendEmailBrevo($to, $subject, $htmlContent);
}


function createHTML($data, $template)
{
	ob_start();
	include(DOCUMENT_ROOT . '/vip/' . $template);
	$html = ob_get_clean();
	return $html;
}

function sendEmailBrevo($to, $subject, $htmlContent)
{
	$config = Brevo\Client\Configuration::getDefaultConfiguration()->setApiKey('api-key', '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');
	$apiInstance = new Brevo\Client\Api\TransactionalEmailsApi(new GuzzleHttp\Client(),	$config);
	$sendSmtpEmail = new \Brevo\Client\Model\SendSmtpEmail([
		'subject' => $subject,
		'sender' => ['name' => 'HOMEINFO.hu', 'email' => 'info@homeinfo.hu'],
		'replyTo' => ['name' => 'HOMEINFO.hu support', 'email' => 'fejlesztes@homeinfo.hu'],
		'to' => [['email' => $to]],
		'bcc' => [['email' => 'fejlesztes@homeinfo.hu']],
		'htmlContent' => $htmlContent
	]);

	try {
		$result = $apiInstance->sendTransacEmail($sendSmtpEmail);
	} catch (Exception $e) {
		//echo 'Az email küldés problémába ütközött. Kérjük, írjon a fejlesztes@homeinfo.hu címre.';
		mail('fejlesztes@homeinfo.hu', 'Email kuldo hiba, sendmail helyettesites | HOMEINFO Mester auth.php', $e->getMessage());

		sendEmail($to, $subject, $htmlContent);
	}
}

function sendEmail($to, $subject, $htmlContent)
{
	$mail = new PHPMailer;
	$mail->CharSet = 'UTF-8';
	$mail->setFrom('info@homeinfo.hu', 'HOMEINFO.hu');
	$mail->addReplyTo('fejlesztes@homeinfo.hu', 'HOMEINFO.hu support');

	$mail->addAddress($to);

	if ($address !== 'fejlesztes@homeinfo.hu')
		$mail->addBCC('fejlesztes@homeinfo.hu');

	$mail->isHTML(true);

	$mail->Subject = $subject;
	$mail->Body    = $htmlContent;

	return $mail->send();
}

function extendsUserWithQrCode($user)
{
	// QR code
	// 
	// Apple ID: fqfd4fs9gw@privaterelay.appleid.com -> fqfd4fs9gw-1234
	// Dot: levente.horvath.work@gmail.hu ->levente-horvath-work-1234
	// Ideal: fejlesztes@homeinfo.hu -> fejlesztes-1234
	// email nincs mindenkinek és az apple id is hasheli az emailcimeket, 
	// legyen hashauth utolso nyolc karaktere + id, pl. abcdefgh-1234 
	// https://www.homeinfo.hu/vip/abcdefgh-1234
	$slug = substr($user['hashAuth'], -8) . '-' . $user['id'];
	$link = 'https://nevjegy.homeinfo.hu/' . $slug;
	$file = DOCUMENT_ROOT . '/vip/files/nevjegy/' . $slug . '.png';
	if (! file_exists($file))
		QRcode::png($link,  $file, QR_ECLEVEL_M, 8, 0);
	$user['qrcode_src'] = 'https://www.homeinfo.hu/vip/files/nevjegy/' . $slug . '.png';
	$user['qrcode_link'] = $link;
	return $user;
}
