<?php
header('X-Robots-Tag: noindex, noarchive, nosnippet', TRUE);
require_once('../burkoloi-workshop/data.php');
$bwStandok = $standok;
require_once('../emw-2024/data.php');
$cegek2024 = $cegek;
require_once('../emw/data.php');
ob_clean();
session_cache_expire(1);
define('ASSETS_PATH', $_SERVER['DOCUMENT_ROOT'] . '/assets/homeinfo2017');
// echo __DIR__; // /home/dasl1/homeinfo.hu/public_html/vip_dev

foreach ($bwCegek as $slug => $ceg) {
	if (!isset($cegek[$slug])) {
		$ceg['bw25'] = true;
		$cegek[$slug] = $ceg;
	}
}
foreach ($cegek2024 as $slug => $ceg) {
	if (!isset($cegek[$slug])) {
		$ceg['emw24'] = true;
		$cegek[$slug] = $ceg;
	}
}
ksort($cegek);

// unset($cegek['metabo']);

// ÉMW25 STANDOK (copied from emw/index.php)
require_once('../jegyvasarlas/config.php');
$standok = array();
//$standok[] = ['standNo' => '1', 'slug' => 'tesa', 'size' => '4x4'];
$acsarnok = $wpdb->get_results("SELECT * FROM emw25_standok WHERE building = 'A'", ARRAY_A);
foreach ($acsarnok as $row) {
	if (empty($row['slug'])) { // üres stand 
		$standok[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => '', 'size' => $row['size'], 'name' => '', 'cats' => ''];
		continue;
	}
	$slugs = explode(',', $row['slug']);
	foreach ($slugs as $slug) {
		$slug = trim($slug);
		$stand = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name' => '', 'cats' => ''];

		if (empty($cegek[$slug])) // cegek közt nem talaljuk
		{
			$standok[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name' => $slug, 'cats' => ''];
			continue;
		}
		$cegek[$slug]['stand'] = ['no' => $row['standNo'], 'size' => $row['size']];	// stand atok atadasa
		$stand['name'] = $cegek[$slug]['name']; // cégnév atvetele
		if (!empty($cegek[$slug]['cats']))
			$stand['cats'] = implode(' ', $cegek[$slug]['cats']); // kategoria atvetele
		$standok[] = $stand;

		// Az 'A' csarnok cégei jelenjek meg a "Szerkezetek és építőanyagok" kategóriában
		if (is_array($cegek[$slug]['cats']))
			$cegek[$slug]['cats'][] =  "Szerkezetek és építőanyagok";
		else
			$cegek[$slug]['cats'] = ["Szerkezetek és építőanyagok"];
	}
}
// Nev szerinti sorrend
uasort($standok, function ($a, $b) {
	$nev1 = $a['name'] ?? strtolower($a['slug']);
	$nev2 = $b['name'] ?? strtolower($b['slug']);
	return $nev1 <=> $nev2;
});

$standokB = array();
//$standok[] = ['standNo' => '1', 'slug' => 'tesa', 'size' => '4x4'];
$bcsarnok = $wpdb->get_results("SELECT * FROM emw25_standok WHERE building = 'B'", ARRAY_A);
foreach ($bcsarnok as $row) {
	if (empty($row['slug'])) { // üres stand 
		$standokB[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => '', 'size' => $row['size'], 'name' => '', 'cats' => ''];
		continue;
	}
	$slugs = explode(',', $row['slug']);
	foreach ($slugs as $slug) {
		$slug = trim($slug);
		$stand = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name' => '', 'cats' => ''];

		if (empty($cegek[$slug])) // cegek közt nem talaljuk
		{
			$standokB[] = ['id' => $row['id'], 'standNo' => $row['stand'], 'slug' => $slug, 'size' => $row['size'], 'name' => $slug, 'cats' => ''];
			continue;
		}
		$cegek[$slug]['stand'] = ['no' => $row['standNo'], 'size' => $row['size']];	// stand atok atadasa
		$stand['name'] = $cegek[$slug]['name']; // cégnév atvetele
		if (!empty($cegek[$slug]['cats']))
			$stand['cats'] = implode(' ', $cegek[$slug]['cats']); // kategoria atvetele
		$standokB[] = $stand;

		// A 'B' csarnok cégei jelenjek meg a "Asztalosipar" kategóriában
		if (is_array($cegek[$slug]['cats']))
			$cegek[$slug]['cats'][] =  "Asztalosipar";
		else
			$cegek[$slug]['cats'] = ["Asztalosipar"];
	}
}
// Nev szerinti sorrend
uasort($standokB, function ($a, $b) {
	$nev1 = $a['name'] ?? strtolower($a['slug']);
	$nev2 = $b['name'] ?? strtolower($b['slug']);
	return $nev1 <=> $nev2;
});

?>
<!DOCTYPE html>
<html>

<head>
	<link rel="stylesheet" href="assets/onsenui/2.12.8/css/onsenui.min.css">
	<link rel="stylesheet" href="assets/onsenui/2.12.8/css/onsen-css-components.min.css">
	<link rel="stylesheet" href="assets/style.css?seed=5">
	<script src="assets/onsenui/2.12.8/js/onsenui.min.js"></script>
	<script src="https://www.homeinfo.hu/vip/normalizephone.js?<?php echo microtime(true); ?>"></script>


	<!-- Flickity Carousel -->
	<link rel="stylesheet" href="https://unpkg.com/flickity@2/dist/flickity.min.css">
	<script src="https://unpkg.com/flickity@2/dist/flickity.pkgd.min.js"></script>


	<!-- Lightbox 
	<link rel="stylesheet" href="assets/simplelightbox/simple-lightbox.css">
	<script src="assets/simplelightbox/simple-lightbox.js"></script>-->

	<?php $clarity = "oyu2ppn2o5"; ?>
	<?php include(ASSETS_PATH . '/homeinfo.google-analytics.php');
	?>
	<script>
		gtag('consent', 'update', {
			'ad_storage': 'granted',
			'ad_user_data': 'granted',
			'ad_personalization': 'granted',
			'analytics_storage': 'granted'
		});
	</script>
	<?php include(ASSETS_PATH . '/homeinfo.facebook-pixel.php');
	?>
	<?php include(ASSETS_PATH . '/homeinfo.tiktok-pixel.php');
	?>

</head>

<body>

	<?php function isMobileDevice()
	{
		return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
	} ?>
	<?php if (! isMobileDevice()) : ?>
		<div style="text-align:center;">
			<p style="font-size:1.2rem;line-height:1.5;font-family:sans-serif;padding:3rem;max-width:600px;margin:auto;">Az oldal mobilra optimalizált, kérjük, hogy töltse le telefonjára a HOMEINFO Mester applikációt!</p>
		</div>
	<?php else : ?>


		<ons-navigator id="navigator" page="app.html" animation="slide"></ons-navigator>

		<!-- Onboarding stepper: one input per screen -->
		<ons-modal id="onboardingModal" style="background-color: rgba(0, 0, 0, .85);">
			<ons-card style="overflow-y:auto; max-height:90vh;">
				<div class="content">
					<div class="stack" style="gap:4px; margin-bottom:8px; align-items: baseline;">
						<h4 id="obTitle" style="font-size:1rem;margin-top:0;">Mi a neved?</h4>
						<!-- <small id="obStepLabel" style="opacity:.7;white-space:nowrap;">1 / 3</small> -->
					</div>

					<div id="obFieldWrap" class="stack" style="gap:12px;">
						<!-- dynamic field goes here -->
					</div>

					<div class="stack" style="margin-top:16px; gap:8px;">
						<ons-button id="obNextBtn" style="width:100%;">Tovább</ons-button>
						<ons-button id="obSkipBtn" modifier="quiet" style="width:100%; display:none;">Kihagy</ons-button>
						<ons-button id="obBackBtn" modifier="quiet" style="width:100%; display:none;">Vissza</ons-button>
					</div>
				</div>
			</ons-card>
		</ons-modal>

		<ons-modal id="professionModal">
			<ons-card style="overflow-y: auto; max-height: 90vh;">
				<div class="content">
					<h4>Foglalkozásod?</h4>
					<ons-list></ons-list>
				</div>
			</ons-card>
		</ons-modal>

		<ons-modal id="interestsModal">
			<ons-card style="overflow-y: auto; max-height: 90vh;">
				<div class="content">
					<h4>Milyen témákban szeretnél értesítést kapni?</h4>
					<ons-list></ons-list>
					<div class="stack">
						<?php /*<ons-button modifier="quiet" onclick="interestsModal.remove();">Később</ons-button>*/ ?>
						<ons-button onclick="interestsModal.hide();" style="width:100%;">Kész</ons-button>
					</div>
				</div>
			</ons-card>
		</ons-modal>

		<ons-modal id="locationsModal">
			<ons-card style="overflow-y: auto; max-height: 90vh;">
				<div class="content">
					<h4>Az ország mely területeiről szeretnél értesítést kapni?</h4>
					<ons-list></ons-list>
					<div class="stack">
						<?php /*<ons-button modifier="quiet" onclick="interestsModal.remove();">Később</ons-button>*/ ?>
						<ons-button onclick="locationsModal.hide();" style="width:100%;">Kész</ons-button>
					</div>
				</div>
			</ons-card>
		</ons-modal>

		<ons-modal id="loadingModal">
			<ons-progress-bar indeterminate></ons-progress-bar>
		</ons-modal>

		<template id="alert-dialog.html">
			<ons-alert-dialog id="my-alert-dialog" modifier="rowfooter">
				<div class="alert-dialog-title">Tiszteletjegy</div>
				<div class="alert-dialog-content">
					<ons-input id="ticketCode" modifier="underbar" placeholder="Kód" float></ons-input>
				</div>
				<div class="alert-dialog-footer">
					<ons-alert-dialog-button onclick="hideAlertDialog()">Hozzáadás</ons-alert-dialog-button>
					<ons-alert-dialog-button onclick="hideAlertDialog()">Mégsem</ons-alert-dialog-button>
				</div>
			</ons-alert-dialog>
		</template>

		<script>
			const config = {};
			config.emw25 = userHash() === '9297e1eff360778a2e6b293fcd92c3ad2f353795ec3607b85d00d21f31e1e76d';
			config.dev = false;
			config.apiURL = 'https://www.homeinfo.hu/vip/api/v1.0/';
			config.outURL = 'https://www.homeinfo.hu/vip/out.php?url=';
			config.quizImagesURL = 'https://www.homeinfo.hu/vip/admin/uploads/';
			if (config.dev) {
				config.apiURL = 'https://www.homeinfo.hu/vip_dev/api/v1.0/';
				config.outURL = 'https://www.homeinfo.hu/vip_dev/out.php?url=';
				config.quizImagesURL = 'https://www.homeinfo.hu/vip_dev/admin/uploads/';
			}

			/* *
			 * NATIV LOGIN 
			 *	+ pro: mobilos fiokokat látja, lehet biometrikus, offline is működnek a login nélküli tartalmak
			 *	- cons: meglévő homeinfo fiókkal nem tudnak belépni (nézzük meg mennyi van, mikor léptek be?)
			 *	(ekkor a apptól kapott login hash-t küldenénk az apiknak, már amhez kell authuser)	
			 */
			function userHash() {
				const url = new URL(location.href);
				//let hash = url.searchParams.get('hashAuth') || 'd0915b79980970aff44f067d7ccb43343a56ed2611929cfa3f5a482a8460ffa0'; // teszt user webről
				let hash = url.searchParams.get('hashAuth') || '4477bd3b463a7aaac8c3fcac371ab9e0a7b104f311f6465f424c25cca69b4acf'; // en
				return hash;
			}

			// Global Objects

			async function loadConfig() {
				const response = await fetch(`${config.apiURL}config`);
				const {
					professions,
					interests,
					locations
				} = await response.json();
				config.professions = professions;
				config.interests = interests;
				config.locations = locations;
			}


			config.programok = <?php echo json_encode($programok); ?>; // emw
			config.standok = <?php echo json_encode($standok); ?>; // emw
			config.standokB = <?php echo json_encode($standokB); ?>; // emw
			config.standfilter = <?php echo json_encode($categories); ?>; // emw

			config.bwStandok = <?php echo json_encode($bwStandok); ?>;

			config.cegek = <?php echo json_encode($cegek); ?>;
			config.bwcegek = <?php echo json_encode($bwCegek); ?>;
			config.partners = [];
			Object.entries(config.cegek).forEach(([key, value], index) => {
				config.partners.push({
					id: key,
					title: value.name,
				});
			});
			config.nyeremenyek = <?php echo json_encode($bwNyeremenyek); ?>;

			let user = {};

			const bookmark = {};
			// Ajánlatok elmentése, törlése
			bookmark.updateUserOffers = async function(el, data) {
				const offer = data.data;
				const icon = el.getAttribute('icon');
				const method = (icon.includes('-outline')) ? 'POST' : 'DELETE';
				try {
					const response = await fetch(config.apiURL + 'users/' + user.id, {
						method: method,
						headers: {
							"Content-Type": "application/json"
						},
						body: JSON.stringify({
							offer_id: offer.id
						})
					});
					const result = await response.json();
					if (method === 'DELETE') {
						user.offers = user.offers.filter(obj => obj.id != offer.id);
						el.setAttribute('icon', icon + '-outline');
						await ons.notification.toast("Eltávolítva ✔️", {
							timeout: 1000
						});
					} else {
						user.offers.push(offer);
						el.setAttribute('icon', icon.replace('-outline', ''));
						await ons.notification.toast("Hozzáadva ✔️", {
							timeout: 1000
						});
					}
				} catch (error) {
					console.error("Error:", error);
				}
			}

			async function userFetch() {
				const response = await fetch(config.apiURL + 'users/' + userHash());
				const dbUser = await response.json();
				if (dbUser) {
					user = dbUser;
					user.interests = JSON.parse(user.interests);
					user.locations = JSON.parse(user.locations);
					user.offers = JSON.parse(user.offers) || [];
					user.events = JSON.parse(user.events);
					user.sorsjegy = user.sorsjegy ? JSON.parse(user.sorsjegy) : [];
					user.nevjegy = {
						qrcode: 'https://www.homeinfo.hu/vip/files/nevjegy/' + user.hashAuth.substring(user.hashAuth.length - 8) + '-' + user.id + '.png',
						link: 'https://nevjegy.homeinfo.hu/' + user.hashAuth.substring(user.hashAuth.length - 8) + '-' + user.id
					};
					// Ha még nincs beállítva preferált lokáció, akkor lekérjük az alapértelmezettet. A popupban ezt előre kiválasztjuk.
					if (!user.locations.length) {
						user.defaultLocation = null;
						if (user.lat && user.lng) {
							const response = await fetch('https://api.bigdatacloud.net/data/reverse-geocode-client?latitude=' + user.lat + '&longitude=' + user.lng + '&localityLanguage=hu');
							const result = await response.json();
							user.defaultLocation = result.principalSubdivision.split(' ')[0]; // levágjuk a 'vármegye' szót,
						}
						if (!user.defaultLocation && user.zip) {
							const response = await fetch('https://api.bigdatacloud.net/data/reverse-geocode-client?postal=' + user.zip + '&localityLanguage=hu');
							const result = await response.json();
							user.defaultLocation = result.principalSubdivision.split(' ')[0];
						}
					}
					if (user.new_ticket) {
						const tab = document.querySelector('#tabbar [page="profile-tickets.html"] .tabbar__button');
						tab.appendChild(document.createElement('div')).className = 'tabbar__badge notification';
						tab.querySelector('.tabbar__badge').textContent = user.new_ticket;
						ons.notification.alert('Keresd a "Belépőm" menüpontban!', {
							title: '<b>Új jegy hozzáadva!</b>'
						});
					}
					const response = await fetch(config.apiURL + 'users/' + user.id + '/ticket');
					const jegy = await response.json();
					if (jegy.id) {
						user.jegy = jegy;
					}

					// user ready event
					window.dispatchEvent(new CustomEvent('user-ready'));
				}
			}

			// App start

			let events = [];
			let offers = [];
			let videos = [];
			let products = [];
			let emw24Images = [];

			const appNavigator = document.querySelector('#navigator');
			const loadingModal = document.querySelector('#loadingModal');

			appNavigator.addEventListener('prepush', (e) => {
				// console.log('prepush', e);
				loadingShow();
			});

			appNavigator.addEventListener('postpush', (e) => {
				// console.log('postpush', e);
				loadingHide();
			});


			function loadingShow() {
				loadingModal.show();
			}

			function loadingHide() {
				loadingModal.hide();
			}

			function nl2br(str) {
				return (typeof str === 'undefined' || str === null) ? '' : (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1<br>$2');
			}

			async function genertateNevjegyQr() {
				const responseQr = await fetch('https://www.homeinfo.hu/vip/auth.php?generateQrCode=' + userHash());
				const res = await responseQr.json();
				// console.log(res);
			}

			// Foglalkozás modal save option
			async function selectUserProfession(item) {
				try {
					const response = await fetch(config.apiURL + 'users/' + user.id, {
						method: "PUT",
						headers: {
							"Content-Type": "application/json"
						},
						body: JSON.stringify({
							profession_id: item.id
						})
					});
					const result = await response.json();
					user.profession = item.title;

				} catch (error) {
					console.error("Error:", error);
				}

				professionModal.hide();

				if (!user.interests.length)
					interestsModal.show();
			}
			// Érdeklodes modal save, de a profilban levo is hasznalja 
			async function updateUserInterests(checked, item) {
				const method = (checked) ? 'POST' : 'DELETE';
				try {
					const response = await fetch(config.apiURL + 'users/' + user.id, {
						method: method,
						headers: {
							"Content-Type": "application/json"
						},
						body: JSON.stringify({
							interest_id: item.id
						})
					});
					const result = await response.json();
					//console.log(user);
					if (method === 'DELETE')
						user.interests = user.interests.filter(obj => obj.id != item.id);
					else
						user.interests.push(item);
				} catch (error) {
					console.error("Error:", error);
				}
			}

			// Érdeklodes terület szerint modal save, de a profilban levo is hasznalja 
			async function updateUserLocations(checked, item) {
				const method = (checked) ? 'POST' : 'DELETE';
				try {
					const response = await fetch(config.apiURL + 'users/' + user.id, {
						method: method,
						headers: {
							"Content-Type": "application/json"
						},
						body: JSON.stringify({
							location_id: item.id
						})
					});
					const result = await response.json();
					//console.log(user);
					if (method === 'DELETE')
						user.locations = user.locations.filter(obj => obj.id != item.id);
					else
						user.locations.push(item);
				} catch (error) {
					console.error("Error:", error);
				}
			}
			// ---------------- Onboarding Stepper (name → phone → company → title) ----------------
			// import {				normalizePhone			} from './normalizephone.js';

			let obState = {
				idx: 0,
				steps: [], // will be built dynamically
				name: '',
				phone: '',
				company: '',
				title: ''
			};

			function buildOnboardingQueue() {
				const mustHaveName = !(user?.name && user.name.trim().length);
				const missingPhone = !(user?.phone && String(user.phone).trim().length);
				const missingCompany = !(user?.nevjegy_cegnev && user.nevjegy_cegnev.trim().length);
				const missingTitle = !(user?.nevjegy_titulus && user.nevjegy_titulus.trim().length);

				// Pre-fill local state
				obState.name = (user?.name || '').trim();
				obState.phone = (user?.phone || '').trim();
				obState.company = (user?.nevjegy_cegnev || '').trim();
				obState.title = (user?.nevjegy_titulus || '').trim();

				const steps = [];

				// Required first (never skippable)
				if (mustHaveName) {
					steps.push({
						key: 'name',
						title: 'A névjegyedhez kérjük, add meg a neved!',
						placeholder: 'Teljes név',
						inputId: 'ob_name',
						required: true,
						skippable: false,
						persist: async (val) => {
							await persistObPartial({
								name: val
							});
						}
					});
				}

				// Optional ones — only included if empty
				if (missingPhone) {
					steps.push({
						key: 'phone',
						title: 'Mi a telefonszámod?',
						placeholder: '+36 70 123 4567',
						inputId: 'ob_phone',
						required: false,
						skippable: true,
						inputType: 'tel',
						persist: async (val) => {
							const {
								e164
							} = normalizePhone(val);
							await persistObPartial({
								phone: e164,
								phone_raw: val
							});
						}
					});
				}

				if (missingCompany) {
					steps.push({
						key: 'company',
						title: 'Hol dolgozol?',
						placeholder: 'Cégnév',
						inputId: 'ob_company',
						required: false,
						skippable: true,
						persist: async (val) => {
							await persistObPartial({
								nevjegy_cegnev: val
							});
						}
					});
				}

				if (missingTitle) {
					steps.push({
						key: 'title',
						title: 'Mi a beosztásod?',
						placeholder: 'Beosztás / titulus',
						inputId: 'ob_title',
						required: false,
						skippable: true,
						persist: async (val) => {
							await persistObPartial({
								nevjegy_titulus: val
							});
						}
					});
				}

				return steps;
			}

			function openOnboardingModal() {
				obState.steps = buildOnboardingQueue();
				obState.idx = 0;
				if (!obState.steps.length) return; // nothing to ask
				renderOnboardingStep();
				document.querySelector('#onboardingModal').show();
			}

			// Render current step (single input)
			function renderOnboardingStep() {
				const modal = document.querySelector('#onboardingModal');
				const titleEl = modal.querySelector('#obTitle');
				const fieldWrap = modal.querySelector('#obFieldWrap');

				const step = obState.steps[obState.idx];
				titleEl.textContent = step.title;

				const currentValue =
					step.key === 'name' ? obState.name :
					step.key === 'phone' ? obState.phone :
					step.key === 'company' ? obState.company :
					step.key === 'title' ? obState.title : '';

				fieldWrap.innerHTML = `
    <ons-input
      id="${step.inputId}"
      ${step.inputType ? `type="${step.inputType}"` : ''}
      modifier="underbar"
      placeholder="${step.placeholder}"
      float
      value="${escapeHtml(currentValue)}"
    ></ons-input>
  `;

				// Buttons: show/hide
				const nextBtn = modal.querySelector('#obNextBtn');
				const skipBtn = modal.querySelector('#obSkipBtn');
				const backBtn = modal.querySelector('#obBackBtn');

				backBtn.style.display = (obState.idx > 0) ? 'block' : 'none';
				skipBtn.style.display = step.skippable ? 'block' : 'none';

				// Disable Next if required and empty
				toggleNextDisabled();
				fieldWrap.querySelector('ons-input').addEventListener('input', toggleNextDisabled);
			}

			function toggleNextDisabled() {
				const modal = document.querySelector('#onboardingModal');
				const nextBtn = modal.querySelector('#obNextBtn');
				const input = modal.querySelector('#obFieldWrap ons-input');
				const step = obState.steps[obState.idx];
				if (!step) {
					nextBtn.disabled = false;
					return;
				}
				if (step.required) {
					nextBtn.disabled = !(input && input.value.trim().length);
				} else {
					nextBtn.disabled = false;
				}
			}

			// Escape utility for safe attribute injection
			function escapeHtml(str) {
				return (str || '').replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;')
					.replace(/"/g, '&quot;').replace(/'/g, '&#39;');
			}

			async function persistObPartial(fields) {
				try {
					const res = await fetch(config.apiURL + 'users/' + user.id, {
						method: "PUT",
						headers: {
							"Content-Type": "application/json"
						},
						body: JSON.stringify(fields)
					});
					await res.json();
					// sync local state -> user
					if ('name' in fields) user.name = fields.name;
					if ('phone' in fields) user.phone = fields.phone;
					if ('nevjegy_cegnev' in fields) user.nevjegy_cegnev = fields.nevjegy_cegnev;
					if ('nevjegy_titulus' in fields) user.nevjegy_titulus = fields.nevjegy_titulus;
				} catch (e) {
					console.error(e);
					ons.notification.toast('Hiba történt mentés közben.', {
						timeout: 2500
					});
				}
			}

			async function onboardingNext() {
				const modal = document.querySelector('#onboardingModal');
				const input = modal.querySelector('#obFieldWrap ons-input');
				const val = (input?.value || '').trim();
				const step = obState.steps[obState.idx];

				if (!step) return;

				if (step.required && !val) {
					ons.notification.toast('Kérjük, töltsd ki a kötelező mezőt!', {
						timeout: 2000
					});
					return;
				}

				// Update local state
				if (step.key === 'name') obState.name = val;
				if (step.key === 'phone') obState.phone = val;
				if (step.key === 'company') obState.company = val;
				if (step.key === 'title') obState.title = val;

				// Persist immediately
				await step.persist(val);

				// Advance or finish
				if (obState.idx < obState.steps.length - 1) {
					obState.idx += 1;
					renderOnboardingStep();
				} else {
					// finished → continue to profession → interests → locations
					modal.hide();
					proceedAfterOnboarding();
				}
			}

			function onboardingSkip() {
				// Skip current optional step without persisting
				if (obState.idx < obState.steps.length - 1) {
					obState.idx += 1;
					renderOnboardingStep();
				} else {
					document.querySelector('#onboardingModal').hide();
					proceedAfterOnboarding();
				}
			}

			function onboardingBack() {
				if (obState.idx === 0) return;
				obState.idx -= 1;
				renderOnboardingStep();
			}

			// Delegate buttons
			document.addEventListener('click', (e) => {
				if (e.target?.id === 'obNextBtn') onboardingNext();
				if (e.target?.id === 'obSkipBtn') onboardingSkip();
				if (e.target?.id === 'obBackBtn') onboardingBack();
			});

			function proceedAfterOnboarding() {
				// --- Profession (single-choice, required before interests) ---
				if (!user.profession) {
					const list = professionModal.querySelector('ons-list');
					list.innerHTML = '';
					config.professions.forEach(item => {
						list.appendChild(ons.createElement(`
							<ons-list-item tappable>
								<label class="left">
								<ons-radio name="profession" input-id="radio-${item.id}"
									onclick="selectUserProfession(${JSON.stringify(item).split('"').join("&quot;")});">
								</ons-radio>
								</label>
								<label class="center" for="radio-${item.id}">${item.title}</label>
							</ons-list-item>
							`));
					});
					professionModal.show();
				}

				// --- Interests (multi, after profession) ---
				if (!user.interests.length) {
					const list = interestsModal.querySelector('ons-list');
					list.innerHTML = '';
					config.interests.forEach(item => {
						list.appendChild(ons.createElement(`
							<ons-list-item>
								<div class="center">${item.title}</div>
								<div class="right">
								<ons-switch name="interests[]"
									onclick="updateUserInterests(this.checked, ${JSON.stringify(item).split('"').join("&quot;")})">
								</ons-switch>
								</div>
							</ons-list-item>
							`));
					});

					if (user.profession) interestsModal.show();

					interestsModal.addEventListener('posthide', () => {
						// keep your original behavior: if no locations yet, show locations next
						if (!user.locations.length) locationsModal.show();
					}, {
						once: true
					});
				} // --- Locations (unchanged) ---
				if (!user.locations.length) {
					const list = locationsModal.querySelector('ons-list');
					list.innerHTML = '';
					config.locations.forEach(item => {
						if (user.defaultLocation === item.title) updateUserLocations(true, item);
						list.appendChild(ons.createElement(`
								<ons-list-item>
									<div class="center">${item.title}</div>
									<div class="right">
									<ons-switch name="locations[]" ${user.defaultLocation === item.title ? 'checked' : ''}
										onclick="updateUserLocations(this.checked, ${JSON.stringify(item).split('"').join("&quot;")})">
									</ons-switch>
									</div>
								</ons-list-item>
								`));
					});

					if (user.profession && user.interests.length) locationsModal.show();
				}
			}

			async function start() {
				await loadConfig();
				await userFetch();

				const professionModal = document.querySelector('#professionModal');
				const interestsModal = document.querySelector('#interestsModal');
				const locationsModal = document.querySelector('#locationsModal');

				// Decide if we need the onboarding stepper
				const stepsToAsk = buildOnboardingQueue();
				if (stepsToAsk.length > 0) {
					openOnboardingModal();
					document.querySelector('#onboardingModal').addEventListener('posthide', () => {
						proceedAfterOnboarding();
					}, {
						once: true
					});
				} else {
					proceedAfterOnboarding();
				}

			}

			start();


			function showModal(id) {
				document
					.getElementById('modal-' + id)
					.show();
			}

			function hideModal(id) {
				document
					.getElementById(id)
					.hide();
			}

			function sendStat(data) {
				//console.log(data);
				if (config.dev) return;
				fetch(config.apiURL + 'users/' + user.id + '/stat', {
					method: 'POST',
					headers: {
						"Content-Type": "application/json"
					},
					body: JSON.stringify(data)
				});
			}

			function outgoing(url, page, itemId, redirect = true) {
				sendStat({
					event: 'outgoing',
					page: page,
					content: '[id:' + itemId + ']' + url
				});
				if (redirect)
					location.href = config.outURL + encodeURIComponent(url);
			}
			document.addEventListener('click', function(event) {
				let target = event.target;
				while (target) {
					if (target instanceof HTMLAnchorElement)
						break;
					target = target.parentNode;
				}
				if (!target || !target.dataset.hasOwnProperty('outgoing')) return;
				let redirect = false;
				let url = target.href.replace(config.outURL, '');
				let [page, itemId] = target.dataset.outgoing.split(':');
				outgoing(decodeURIComponent(url), page, itemId, redirect);
			});

			document.addEventListener('click', function(event) {
				let id = event.target.parentElement.dataset.showMoreId;
				if (!id) return;
				let el = document.getElementById(id);
				el.classList.remove('cropped');
				event.target.parentElement.remove();
			});
		</script>


	<?php endif; ?>

	<?php include(ASSETS_PATH . '/homeinfo.google-remarketing.php'); ?>
</body>

</html>