<?php

/** 2025.08.13
 * Kimeno linkek statisztikaja + utm param hozzafuzese
 * Használata: /out.php?url=https://www.google.com  
 */
header("Content-type: text/html; charset=UTF-8");
header("Expires: Thu, 19 Nov 1981 08:52:00 GMT");
header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
header("Pragma: no-cache");
header("Connection: close");
header("X-Robots-Tag: noindex, noarchive, nosnippet", TRUE);

require_once('../kepgaleria-otletek/config.db.php');
DB_connect();
$row = array();
$delay = isset($_GET['delay']) ? (int)$_GET['delay'] : 1200; // ms

// real visitor ip address - CloudFlare fix
if (! empty($_SERVER["HTTP_CF_CONNECTING_IP"]))
	$_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_CF_CONNECTING_IP"];
// Egyeb proxy fix
elseif (! empty($_SERVER["HTTP_X_FORWARDED_FOR"]))
	$_SERVER['REMOTE_ADDR'] = $_SERVER["HTTP_X_FORWARDED_FOR"];

if (!empty($_SERVER['REMOTE_ADDR']))
	$row['create_ip'] = $_SERVER['REMOTE_ADDR'];

if (!empty($_SERVER['HTTP_USER_AGENT']))
	$row['user_agent'] = $_SERVER['HTTP_USER_AGENT'];

// refererbol + UTM adatok  refererbol
$get_array = array();
if (! empty($_SESSION['HTTP_REFERER'])) {
	$row['referer'] = $_SESSION['HTTP_REFERER'];
	$get_string = explode('?', $row['referer']); //https://www.homeinfo.hu/furdoszoba-kiallitas/?utm_source=google&utm_medium=cpc&utm_campaign=Furdoszoba-Show-2020
	if (! empty($get_string[1])) {
		$get_string = $get_string[1]; //utm_source=google&utm_medium=cpc&utm_campaign=Furdoszoba-Show-2020
		parse_str($get_string, $get_array);
	}
}
if (array_key_exists('utm_source', $get_array))		$row['_utm_source'] = $get_array['utm_source'];
if (array_key_exists('utm_medium', $get_array))		$row['_utm_medium'] = $get_array['utm_medium'];
if (array_key_exists('utm_term', $get_array))		$row['_utm_term'] = $get_array['utm_term'];
if (array_key_exists('utm_content', $get_array))	$row['_utm_content'] = $get_array['utm_content'];
if (array_key_exists('utm_campaign', $get_array))	$row['_utm_campaign'] = $get_array['utm_campaign'];
// UTM adatok kozvetlen 
if (!empty($_SESSION['utm_source']))    $row['_utm_source'] = $_SESSION['utm_source'];
if (!empty($_SESSION['utm_medium']))    $row['_utm_medium'] = $_SESSION['utm_medium'];
if (!empty($_SESSION['utm_term']))      $row['_utm_term'] = $_SESSION['utm_term'];
if (!empty($_SESSION['utm_content']))   $row['_utm_content'] = $_SESSION['utm_content'];
if (!empty($_SESSION['utm_campaign'])) 	$row['_utm_campaign'] = $_SESSION['utm_campaign'];

// erkezesi oldal
if (!empty($_SESSION['landing_url'])) 	$row['landing_url']  = $_SESSION['landing_url'];

$row['kickurl'] = (! empty($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : '';

try {

	if (empty($_GET['url']))
		throw new RuntimeException('Error: empty url!');

	$url = filter_var($_GET['url'], FILTER_SANITIZE_URL);

	if (! filter_var($url, FILTER_VALIDATE_URL))
		throw new RuntimeException('Error! Url is not valid: ' . $url);

	// ha bot, nem mentjünk a CT-t csak átirányítunk
	if (is_bot($_SERVER['HTTP_USER_AGENT'])) {
		// header("Location: " . $url);
		$location = $url;
		exit;
	}

	$row['url'] = $url;

	// mentes		

	$values = array();
	foreach ($row as $key => $value)
		if ($key == 'create_ip')
			$values[] = "INET6_ATON('" . $value . "')";
		else
			$values[] = "'" . mysqli_real_escape_string(HIDB::$conn, $value) . "'";

	$sql = "INSERT INTO `hipro_outgoing` (`" . implode('`,`', array_keys($row)) . "`) VALUES (" . implode(',', $values) . ");";

	if (! $res = mysqli_query(HIDB::$conn, $sql))
		throw new RuntimeException(mysqli_error(HIDB::$conn));

	$location = $url;

	if (strpos($url, 'utm_source') === FALSE) {
		// hash string
		$hashstring = '';
		if (strpos($url, '#') !== FALSE) {
			$arr = explode('#', $url);
			$url = $arr[0];
			$hashstring = '#' . $arr[1];
			unset($arr);
		}

		// Utm param hozzafuzese		 					
		$glue = (strpos($url, '?') === FALSE) ? '?' : '&';
		$location = $url . $glue . "utm_source=homeinfo&utm_medium=application&utm_campaign=homeinfo_mester_app" . $hashstring;
	}

	// header("Location: " . $location);
} catch (RuntimeException $e) {
	//echo 'Caught exception: ',  $e->getMessage(), "\n"; exit;
	if (!empty($_SERVER['REMOTE_ADDR']))
		$ip = $_SERVER['REMOTE_ADDR'];
	if (!empty($_SERVER['HTTP_REFERER']))
		$ref = $_SERVER['HTTP_REFERER'];
	if (!empty($_SERVER['HTTP_USER_AGENT']))
		$ua = $_SERVER['HTTP_USER_AGENT'];

	mail("fejlesztes@homeinfo.hu", "outgoing.php hiba", "Exeption: " . $e->getMessage() . "\n" . '$_GET: ' . json_encode($_GET) . "\nIP: " . $ip . "\nREFERER: " . $ref . "\nUSER_AGENT: " . $ua);

	r404();
}

function is_bot($userAgent)
{
	if (empty($userAgent))
		return FALSE;

	$userAgent = strtolower($userAgent);

	//https://webmasters.stackexchange.com/questions/3738/does-the-user-agent-in-any-regular-browser-contain-bot-or-crawl

	if (strpos($userAgent, 'bot') !== FALSE)
		return TRUE;

	if (strpos($userAgent, 'crawl') !== FALSE)
		return TRUE;

	if (strpos($userAgent, 'spider') !== FALSE)
		return TRUE;

	if (strpos($userAgent, 'facebookexternalhit') !== FALSE)
		return TRUE;

	if (strpos($userAgent, 'wordpress') !== FALSE)
		return TRUE;

	if (strpos($userAgent, 'ltx71') !== FALSE)
		return TRUE;

	if (strpos($userAgent, 'um-ln') !== FALSE) //https://user-agents.net/string/mozilla-5-0-compatible-um-ln-1-0-mailto-techinfo-ubermetrics-technologies-com
		return TRUE;


	return FALSE;
}

function r404()
{
	header_remove('HTTP/1.0 200 OK');
	header_remove('HTTP/1.1 200 OK');
	header('HTTP/1.1 404 Not Found');

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, 'https://www.homeinfo.hu/404.php');
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$output = curl_exec($ch);
	curl_close($ch);
	echo $output;

	exit;
}
?>
<!doctype html>
<html lang="hu">

<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width,initial-scale=1" />
	<title>Átirányítás…</title>
	<style>
		:root {
			--bg: #efeff4;
			--fg: #000;
			--muted: #85888f;
			--accent: #03379a;
		}

		* {
			box-sizing: border-box;
		}

		html,
		body {
			height: 100%;
			margin: 0;
		}

		body {
			display: grid;
			place-items: center;
			background: linear-gradient(180deg, #efeff4 0%, #efeff4 100%);
			color: var(--fg);
			font: 16px/1.4 system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif;
		}

		.wrap {
			text-align: center;
			max-width: 420px;
			padding: 32px 24px;
		}

		.logo {
			font-weight: 700;
			letter-spacing: .2px;
			margin-bottom: 14px;
			color: var(--accent);
		}

		.spinner {
			width: 56px;
			height: 56px;
			margin: 0 auto 14px;
			border-radius: 50%;
			border: 6px solid rgba(150, 150, 150, .15);
			border-top-color: var(--accent);
			animation: spin 900ms linear infinite;
		}

		.text-lg {
			font-size: 18px;
			margin: 0 0 6px;
		}

		.muted {
			color: var(--muted);
			font-size: 14px;
			margin: 0;
		}

		@keyframes spin {
			to {
				transform: rotate(360deg);
			}
		}

		/* Elhalványítás átirányítás előtt */
		.fade-out {
			opacity: 0;
			filter: blur(2px);
			transform: translateY(4px);
		}

		/* Mozgáscsökkentés beállítás tiszteletben tartása */
		@media (prefers-reduced-motion: reduce) {
			.spinner {
				animation: none;
				border-top-color: rgba(255, 255, 255, .6);
			}

			.card {
				transition: none;
			}
		}

		/* Noscript fallback */
		noscript a {
			display: inline-block;
			margin-top: 12px;
			color: var(--accent);
			text-decoration: none;
			border-bottom: 1px dashed rgba(255, 210, 0, .6);
		}
	</style>
</head>

<body>
	<div class="wrap">
		<div class="logo">Átirányítás…</div>
		<div class="spinner" aria-hidden="true"></div>


		<noscript>
			<p class="muted">Az automatikus átirányításhoz JavaScript szükséges.</p>
			<a href="<?php echo htmlspecialchars($url, ENT_QUOTES, 'UTF-8'); ?>">Tovább a céloldalra</a>
			<meta http-equiv="refresh" content="2;url=<?php echo htmlspecialchars($url, ENT_QUOTES, 'UTF-8'); ?>">
		</noscript>
	</div>

	<script>
		(function() {
			const target = <?php echo json_encode($location, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT); ?>;
			const delay = <?php echo json_encode(max(0, $delay)); ?>; // ms


			setTimeout(() => {
				const fadeMs = window.matchMedia('(prefers-reduced-motion: reduce)').matches ? 0 : 320;


				setTimeout(() => {
					window.location.replace(target);
				}, fadeMs);
			}, delay);




		})();
	</script>
</body>

</html>